#pragma once

#include "NWriterObjects.h"

class CLoggerHelper
{
public:
	CComPtr<ILogger> m_pLogger;

	CLoggerHelper(void);
	~CLoggerHelper(void);

	void logprintf(const char* format, ...) {
		char	buf[4096];
		USES_CONVERSION;
		va_list marker;
		va_start(marker, format);
		_vsnprintf(buf, sizeof(buf), format, marker);
		m_pLogger->Log(A2OLE(buf));
	}

	void logwprintf(const wchar_t* format, ...) {
		wchar_t buf[4096];
		USES_CONVERSION;
		va_list marker;
		va_start(marker, format);
		_vsnwprintf(buf, sizeof(buf) / sizeof(wchar_t), format, marker);
		m_pLogger->Log(buf);
	}
};

#define IMPLEMENT_SETLOGGER()	STDMETHOD(SetLogger)(IUnknown * punkLogger) { return punkLogger->QueryInterface(IID_ILogger, (void **)&m_pLogger); }
#define RELEASE_LOGGER()	m_pLogger.Release()


