// ScriptUtil.cpp : Implementation of CScriptUtil

#include "stdafx.h"
#include "ScriptUtil.h"


// CScriptUtil


STDMETHODIMP CScriptUtil::Sleep(LONG msecs)
{
	::Sleep(msecs);
	return S_OK;
}

STDMETHODIMP CScriptUtil::ReadWord(IMemory* pMemory, ULONG address, LONG* pData)
{
	HRESULT r;
	BYTE	l, h;

	address *= 2;
	r = pMemory->ReadByte(address, &l);
	if (FAILED(r))
		return r;
	r = pMemory->ReadByte(address + 1, &h);
	if (FAILED(r))
		return r;
	*pData = MAKEWORD(l, h);
	return S_OK;
}

STDMETHODIMP CScriptUtil::WriteWord(IMemory* pMemory, ULONG address, LONG lData)
{
	HRESULT r;

	if (lData & 0xffff0000)
		return E_INVALIDARG;

	address *= 2;
	r = pMemory->WriteByte(address, LOBYTE(lData));
	if (FAILED(r))
		return r;
	r = pMemory->WriteByte(address + 1, HIBYTE(lData));
	if (FAILED(r))
		return r;
	return S_OK;
}

STDMETHODIMP CScriptUtil::Split(BSTR Str, BSTR Dlm, VARIANT* pResult)
{
	size_t n;
	list<wstring> tmp;
	list<wstring>::iterator it;

	while (true) {
		n = wcscspn(Str, Dlm);
		tmp.push_back(wstring(Str, n));
		Str += n;
		if (*Str == '\0')
			break;
		Str++;
	}
	pResult->vt = VT_ARRAY | VT_BSTR;
	pResult->parray = SafeArrayCreateVector(VT_BSTR, 0, (ULONG)tmp.size());
	long ind[1] = { 0 };
	for (it = tmp.begin(); it != tmp.end(); it++) {
		SafeArrayPutElement(pResult->parray, ind, (void *)it->c_str());
		ind[0]++;
	}
	return S_OK;
}

STDMETHODIMP CScriptUtil::ToInteger(BSTR Str, LONG* pResult)
{
	*pResult = wcstol(Str, NULL, 0);
	return S_OK;
}
