// Scripts.h : Declaration of the CPWScript

#pragma once
#include "resource.h"       // main symbols

#include "NWriterObjects.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif

// CPWScript

class ATL_NO_VTABLE CPWScript :
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CPWScript, &CLSID_PWScript>,
	public IPWScript,
	public IActiveScriptSite,
	public IActiveScriptSiteWindow
{
public:
	CPWScript()
	{
	}

	DECLARE_REGISTRY_RESOURCEID(IDR_SCRIPTS)


	BEGIN_COM_MAP(CPWScript)
		COM_INTERFACE_ENTRY(IPWScript)
		COM_INTERFACE_ENTRY(IActiveScriptSite)
		COM_INTERFACE_ENTRY(IActiveScriptSiteWindow)
	END_COM_MAP()



	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
#if 0
		CLSID	clsid;
		HRESULT	r;

		r = CLSIDFromProgID(L"VBScript", &clsid);
		//r = CLSIDFromProgID(L"JScript", &clsid);
		if (FAILED(r))
			return r;
		r = CoCreateInstance(clsid, NULL, CLSCTX_INPROC, IID_IActiveScript, (void **)&m_pAS.p);
		if (FAILED(r))
			return r;

		CComPtr<IActiveScriptSite> psite;
		r = QueryInterface(IID_IActiveScriptSite, (void **)&psite.p);
		if (FAILED(r))
			return r;
		r = m_pAS->SetScriptSite(psite);
		if (FAILED(r))
			return r;
#endif
		return S_OK;
	}

	typedef basic_string<wchar_t> wstring;

	class wstring_iless {
	public:
		bool operator()(const wstring& a, const wstring& b) {
			return _wcsicmp(a.c_str(), b.c_str()) < 0;
		}
	};

	typedef map<wstring, IUnknown*, wstring_iless> objmap_t;
	objmap_t m_objmap;

	void FinalRelease()
	{
		objmap_t::iterator it;
		for (it = m_objmap.begin(); it != m_objmap.end(); it++) {
			it->second->Release();
		}
		if (m_pAS)
			m_pAS.Release();
	}

public:

	CComPtr<IActiveScript>	m_pAS;

	// ISequencer Methods
public:
	STDMETHOD(AddGlobal)(BSTR Name, IUnknown* pUnk) {
		HRESULT r;

		objmap_t::iterator it;
		r = m_pAS->AddNamedItem(Name, SCRIPTITEM_ISVISIBLE);
		if (FAILED(r))
			return r;
		if ((it = m_objmap.find(Name)) != m_objmap.end()) {
			it->second->Release();
		}
		m_objmap[Name] = pUnk;
		pUnk->AddRef();
		return S_OK;	
	}
	STDMETHOD(GetIDispatch)( IDispatch * * ppDispatch)
	{
		// Add your function implementation here.
		return E_NOTIMPL;
	}
	STDMETHOD(AddScriptFile)(BSTR FileName);

	// IActiveScriptSitex Methods
public:
	STDMETHOD(GetLCID)( LCID * plcid)
	{
		return E_NOTIMPL;
	}
	STDMETHOD(GetItemInfo)( LPCOLESTR pstrName,  DWORD dwReturnMask,  IUnknown * * ppiunkItem,  ITypeInfo * * ppti)
	{
		objmap_t::iterator it;
		if ((it = m_objmap.find(pstrName)) == m_objmap.end()) {
			return TYPE_E_ELEMENTNOTFOUND;
		}
		if (ppti)
			*ppti = NULL;
		if (ppiunkItem)
			*ppiunkItem = NULL;

		if (dwReturnMask & SCRIPTINFO_IUNKNOWN) {
			*ppiunkItem = it->second;
			it->second->AddRef();
		}
		return S_OK;
	}
	STDMETHOD(GetDocVersionString)( BSTR * pbstrVersion)
	{
		// Add your function implementation here.
		return E_NOTIMPL;
	}
	STDMETHOD(OnScriptTerminate)( const VARIANT * pvarResult,  const EXCEPINFO * pexcepinfo)
	{
		// Add your function implementation here.
		return S_OK;
	}
	STDMETHOD(OnStateChange)( SCRIPTSTATE ssScriptState)
	{
		// Add your function implementation here.
		AtlTrace("Script State %d\n", ssScriptState);
		return S_OK;
	}
	STDMETHOD(OnScriptError)( IActiveScriptError * pscripterror)
	{
		HRESULT r;
		BSTR	text = NULL;
		DWORD	context;
		ULONG	linenumber;
		LONG	charpos;
		EXCEPINFO	ei;
		USES_CONVERSION;

		r = pscripterror->GetExceptionInfo(&ei);
		r = pscripterror->GetSourceLineText(&text);
		r = pscripterror->GetSourcePosition(&context, &linenumber, &charpos);

		wstring msg = L"";
		if (ei.bstrSource) {
			msg += ei.bstrSource;
			msg += L"\r\n";
		}
		if (ei.bstrDescription) {
			msg += ei.bstrDescription;
			msg += L"\r\n";
		}
		wchar_t	tmp[32];
		_snwprintf(tmp, sizeof(tmp) / 2, L"Line %d", linenumber + 1);
		msg += tmp;

		MessageBox(NULL, msg.c_str(), L"error", MB_OK);
		OutputDebugString(msg.c_str());
		OutputDebugString(L"\r\n");

		SysFreeString(text);
		return S_OK;
	}
	STDMETHOD(OnEnterScript)()
	{
		// Add your function implementation here.
		return S_OK;
	}
	STDMETHOD(OnLeaveScript)()
	{
		// Add your function implementation here.
		return S_OK;
	}
	STDMETHOD(Execute)(BSTR SubName);

	HWND	m_hWnd;

	STDMETHOD(GetWindow)(HWND* phwnd) {
		*phwnd = m_hWnd;
		return S_OK;
	}
	STDMETHOD(EnableModeless)(BOOL fEnable) {
		return S_OK;
	}
	STDMETHOD(SetSiteWindow)(long hWnd);
	STDMETHOD(AttachEngine)(IUnknown* punkActiveScript);
	STDMETHOD(InitScript)(void);
};

OBJECT_ENTRY_AUTO(__uuidof(PWScript), CPWScript)
