// WriterController.h : Declaration of the CWriterController

#pragma once
#include "resource.h"       // main symbols

#include "NWriterObjects.h"
#include "LoggerHelper.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif



// CWriterController

class ATL_NO_VTABLE CWriterController :
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CWriterController, &CLSID_WriterController>,
	public ISupportErrorInfo,
	public IDispatchImpl<IWriterController, &IID_IWriterController, &LIBID_NWriterObjectsLib, /*wMajor =*/ 1, /*wMinor =*/ 0>,
	public IDispatchImpl<ISetLogger, &__uuidof(ISetLogger), &LIBID_NWriterObjectsLib, /* wMajor = */ 1, /* wMinor = */ 0>,
	public CLoggerHelper
{
public:
	CWriterController()
	{
	}
public:
	CComPtr<IComPort>	m_PortObject;

	DECLARE_REGISTRY_RESOURCEID(IDR_WRITERCONTROLLER)


	BEGIN_COM_MAP(CWriterController)
		COM_INTERFACE_ENTRY(IWriterController)
		COM_INTERFACE_ENTRY(IDispatch)
		COM_INTERFACE_ENTRY(ISupportErrorInfo)
		COM_INTERFACE_ENTRY(ISetLogger)
	END_COM_MAP()

	// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);


	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
		m_PortObject.Release();
		RELEASE_LOGGER();
	}

public:

	STDMETHOD(AttachPort)(IComPort* PortObject);
	STDMETHOD(SerialSyncWrite)(IUnknown* punkDataBuf, SHORT nBits);
	STDMETHOD(SerialSyncRead)(IUnknown* punkDataBuf, SHORT nBits);
	STDMETHOD(PortControl)(BYTE bIO);
	STDMETHOD(LineControl)(IUnknown* punkSequence, SHORT nBits);
	HRESULT WaitAck(void);
	HRESULT PortWrite(const void * buf, size_t size);
	STDMETHOD(SerialSyncWriteRaw)( BYTE * pDataBuf, SHORT nBits);
	STDMETHOD(SerialSyncReadRaw)( BYTE * pResult,  SHORT nBits);
	STDMETHOD(LineControlRaw)( BYTE * pSequence,  SHORT nBits);
	STDMETHOD(SetSyncWait)(LONG nWait);
	STDMETHOD(SetLineWait)(LONG nWait);
	STDMETHOD(Info)(IUnknown* punkInfo);
	STDMETHOD(InfoRaw)(BYTE* InfoBytes);


	// ISetLogger Methods
public:
	IMPLEMENT_SETLOGGER()
		STDMETHOD(AnalogRead)(LONG nPort, LONG* ADValue);
};

OBJECT_ENTRY_AUTO(__uuidof(WriterController), CWriterController)
