#pragma once

class CMenuActionList : public list<CMenuItem*> {
public:
	virtual ~CMenuActionList() {
		while (size()) {
			delete front();
			pop_front();
		}
	}
};

#include "nwutil.h"


class CDeviceEntry {
public:
	wstring	m_FileName;
	wstring	m_DeviceName;
	wstring	m_DeviceSection;

	CDeviceEntry(LPCWSTR pszFileName, LPCWSTR pszDeviceSection, LPCWSTR pszDeviceName) {
		m_FileName = pszFileName;
		m_DeviceSection = pszDeviceSection;
		m_DeviceName = pszDeviceName;
	};
	template<class C>
	bool GetActions(C& coll) {
		wstring acts;
		list<wstring> ctemp;
		list<wstring>::iterator i;

		GetProfile(acts, L"Actions");
		split(ctemp, acts.c_str(), L",");
		for (i = ctemp.begin(); i != ctemp.end(); i++) {
			if (*i == L"") {
				coll.push_back(new CMenuSeparator);
			} else {
				vector<wstring> arg;
				split(arg, i->c_str(), L":");
				if (arg.size() != 2) {
					continue;
				}
				coll.push_back(new CMenuAction(this, arg[1].c_str(), arg[0].c_str()));
			}
		}
		return true;
	}
	HRESULT GetProfile(wstring& rstring, LPCWSTR entry) {
		wchar_t buf[MAX_PATH];
		wstring section;
		section = m_DeviceSection;
		map<wstring, int> used;
		rstring = L"";

		while (true) {
			GetPrivateProfileString(section.c_str(), entry, L"", buf, sizeof(buf) / sizeof(*buf), m_FileName.c_str());
			if (wcscmp(buf, L"") != 0) {
				rstring = buf;
				return S_OK;
			}
			GetPrivateProfileString(section.c_str(), L"next", L"", buf, sizeof(buf) / sizeof(*buf), m_FileName.c_str());
			if (wcscmp(buf, L"") == 0) {
				return S_OK;
			}
			section = buf;
			if (used.find(section) != used.end())
				return E_FAIL;	// zQ
			used[section] = 1;
		}
	}
};

typedef list<CDeviceEntry*>	device_entry_list_t;


class CDevices : public device_entry_list_t {
public:
	bool load();
	bool load_file(LPCWSTR filename);
	virtual ~CDevices() {
		while (!empty()) {
			delete front();
			pop_front();
		}
	}
	CDeviceEntry* find(LPCWSTR fn, LPCWSTR dn) {
		iterator it;
		for (it = begin(); it != end(); it++) {
			if ((*it)->m_FileName == fn&& (*it)->m_DeviceName == dn)
				return *it;
		}
		return NULL;
	}

};

#define PROFILEBUFSIZE 10000

