' PIC1628A
'
' HIGH VOLTAGE 
'		"VDD FIRST" 
'		10V - 13.5V
' LVP(PGM)10PIN(LVPLHVPsꍇ͗vv_E)
' 1 word ƃvO~O
' BEGIN PROGRAMMING ONLY CYCLE@ "internal timed" Ȃ̂ End Programming sv
' CHIP ERASEȂ

option Explicit

const BULK_ERASE_PROGRAM_MEMORY = &h09
const BEGIN_PROGRAMMING = &h08
const END_PROGRAMMING = &h0e

const TPROG = 2
const TERA = 10

dim memoryUsed

sub ProgramProgramMemory
end sub

sub InitVars
	memoryUsed = Profile.Int("ProgramMemorySize") - 1
	do while memoryUsed >= 0
		if Memory.GetFlags(memoryUsed * 2) and MF_FILLED then
			exit do
		end if
		memoryUsed = memoryUsed - 1
	loop
	memoryUsed = memoryUsed + 1
end sub


sub Reset_PGM
	STDPIC_Reset_HVP_VDDFIRST
end sub

sub Verify
end sub

sub Read
	
	Reset_PGM
	
	' RtBO[V[h hex  0fff Ɉʒu
	data = PICWriter.ReadDataFromProgramMemory
	Memory.WriteWord &hfff, data
	PICWriter.IncrementAddress

	' PC = 0000
	
	dim data
	dim addr
	dim size
	size = &h105
	for addr = 0 to size - 1
		data = PICWriter.ReadDataFromProgramMemory
		Memory.WriteWord addr, data
		PICWriter.IncrementAddress
	next	
	STDPIC_PowerOff
end sub

sub Program
	Reset_PGM
	
	' RtBO[V[h hex  0fff Ɉʒu
	' PC = 0fff
	
	dim data
	dim addr
	dim size

	size= Profile.Int("ProgramMemorySize")
	for addr = -1 to size - 2
		Progress.SetBar -1, size - 2, addr
		PICWriter.IncrementAddress
	next
	
	' PC = Reset Vector
	dim osccal
	dim vaddr
	
	osccal = PICWriter.ReadDataFromProgramMemory
	
	Reset_PGM

	PICWriter.Command6 BULK_ERASE_PROGRAM_MEMORY
	Util.Sleep TERA
	
	for addr = -1 to size - 1
		Progress.SetBar -1, size - 1, addr
		vaddr = addr and &hfff

		if addr = size - 1 then
			data = osccal
		else 
			data = Memory.ReadWord(vaddr)
		end if
		PICWriter.LoadDataForProgramMemory data
		PICWriter.Command6 BEGIN_PROGRAMMING
		Util.Sleep 3
		PICWriter.Command6 END_PROGRAMMING
		PICWriter.IncrementAddress
	next
	
	STDPIC_PowerOff
	msgbox hex(osccal)
end sub

sub Run
	STDPIC_Run
end sub

