#include "StdAfx.h"
#include "pww.h"
#include "VoltageCalculator.h"
#include "nwutil.h"

// dĎpvZ
// HŁAVPPpd - 22K - A/D|Cg - 6.8K - GND ŕ
//
// VPP  9V ̂Ƃꂽ|Cg 2.125V
// VPP 14V ̂Ƃꂽ|Cg 3.306V

// Vref- = GND, Vref+ = VDD = 5V, 10bit(0`1023) A/D ϊɂ
// 2.125V * 1023 / 5 = 434.8
// 3.306V * 1023 / 5 = 676.4


CVoltageCalculator::CVoltageCalculator(void)
{
}

CVoltageCalculator::~CVoltageCalculator(void)
{
}

bool CVoltageCalculator::load()
{
	CString str;
	vector<wstring> arr;

	str = AfxGetApp()->GetProfileString(szWriter, szVoltageCalibration);
	split(arr, str, L" \t\r\n");
	if (arr.size() != 4)
		goto defaultvalue;
	m_y1 = _wtof(arr[0].c_str());
	m_y2 = _wtof(arr[2].c_str());
	m_x1 = (int)_wtof(arr[1].c_str());
	m_x2 = (int)_wtof(arr[3].c_str());
	if (m_x2 == m_x1)
		goto defaultvalue;
	goto linear;
defaultvalue:
	m_y1 = 9.0;
	m_x1 = 435;
	m_y2 = 14.0;
	m_x2 = 676;
linear:
	m_a = (m_y2 - m_y1) / (m_x2 - m_x1);
	m_b = m_y1 - m_a * m_x1;
	return true;
}

double CVoltageCalculator::Convert(int AD)
{
	return m_a * (double)AD + m_b;
}
