' PIC16F87/88 ݃[`
'
' ̏ MICROCHIP  PIC16F87/88 Flash Memory Programming Specification 
' QƂċLqĂ܂
' http://ww1.microchip.com/downloads/en/DeviceDoc/39607b.pdf
'

option Explicit

dim configMemorySkip
configMemorySkip = array(&h2004, &h2005, &h2006)

const BULK_ERASE_PROGRAM_MEMORY = &h09
const BULK_ERASE_DATA_MEMORY = &h0b
const BEGIN_ERASE = &h08
const BEGIN_PROGRAMMING_ONLY = &h18
const END_PROGRAMMING = &h17
const CHIP_ERASE = &h1f
const TPROG2 = 2

dim memoryUsed

function InArray(arr, val)
	dim elm
	
	for each elm in arr
		if elm = val then
			InArray = true
			exit function
		end if
	next
	InArray = false
end function


' WIPIC̃foCXIDs
'
' v
'	[̈ꕔɃfoCXIDLĂ邱
'	[l AND }XNl = ݒl@Ō\Ȃ
'
' Kvȃvt@CGg
'	DeviceIDAddress		foCXidi[ĂAhX
'	DeviceIDMask		}XNl
'	DeviceIDValue		ݒl
'
' 
'	mem					IMemoryIuWFNg DeviceIDAddress 炩ߓǂݍ܂Ă邱
'
' ߂l
'	true				OK
'	false				NG [U[ɃG[ʒmς
'
function STDPIC_CheckDeviceID(mem)
	dim IDAddr
	dim	IDMask
	dim IDValue
	dim DeviceID
	
	STDPIC_CheckDeviceID = false
	IDAddr	= Util.ToInteger(Profile("DeviceIDAddress"))
	IDMask	= Util.ToInteger(Profile("DeviceIDMask"))
	IDValue	= Util.ToInteger(Profile("DeviceIDValue"))
	DeviceID = mem.ReadWord(IDAddr) and &h3fff
	
	if (DeviceID and IDMask) <> IDValue then
		msgbox"DeviceID missmatch. Chip DeviceID=" & hex(DeviceID) & " Expected=" & hex(IDValue) & "/" & hex(IDMask)
		exit function
	end if
	STDPIC_CheckDeviceID = true
end function

' WIPICConfiguration Bit CP/CPD s
'
' v
'	[̈ꕔɃRtBO[V[hLĂ邱
'	RtBO[V[h1 ~CP ~CPD rbg邱
'	[l AND }XNl = ݒl@Ō\Ȃ
'
' Kvȃvt@CGg
'	ConfigWordAddress		RtBO[V[h̃AhX
'	ConfigWordCP			~CP̃rbg
'	ConfigWordCPD			~CPD̃rbg
'
' 
'	mem					IMemoryIuWFNg DeviceIDAddress 炩ߓǂݍ܂Ă邱
'
' ߂l
'	true				OK
'	false				NG [U[ɃG[ʒmς
'
function STDPIC_CheckCPCPD(mem)
	dim cpd
	dim cp
	dim addr
	
	STDPIC_CheckCPCPD = false
	
	addr	= Util.ToInteger(Profile("ConfigWordAddress"))
	cpd		= Util.ToInteger(Profile("ConfigWordCPD"))
	cp		= Util.ToInteger(Profile("ConfigWordCP"))
	
	if cp <> 0 and (mem.ReadWord(addr) and cp) = 0 then
		msgbox "CONFIG[CP]=0 This chip is code protecetd. Use Chip Erase before Program."
		exit function
	end if
	
	if cpd <> 0 and (mem.ReadWord(addr) and cpd) = 0 then
		msgbox "CONFIG[CPD]=0 This chip is data code protecetd. Use Chip Erase before Program."
		exit function
	end if
	STDPIC_CheckCPCPD = true
end function

' WIPIC̃RtBO[[ǂݏo
'
' v
' LoadConfiguration ɂÂ ReadDataFromProgramMemory IncrementAddress R}h
' ǂݏoɂARtBO[V[ǂݏo邱
'
' Kvȃvt@CGg
'	ConfigMemorySize	RtBO[V[̃TCY
'	ConfigMemoryOrg		zIȃRtBO[V[̃AhX
'
' 
'	mem					i[IMemoryIuWFNg
'
' ߂l
'	Ȃ
'
sub STDPIC_ReadConfigMemory(mem)
	dim addr
	dim data
	dim vaddr
	dim size
	dim org
	
	size = Profile.Int("ConfigMemorySize")
	org = Profile.Int("ConfigMemoryOrg")
	
	Progress.ProgressText = "Reading Configuration Memory"
	Progress.NotifyText = ""
	
	PICWriter.LoadConfiguration
	for addr = 0 to size - 1
		vaddr = addr + org
		data = PICWriter.ReadDataFromProgramMemory
		mem.WriteWord vaddr, data
		PICWriter.IncrementAddress
	next
end sub

sub STDPIC_ReadDataMemory(mem)
	dim	size
	dim	org
	dim addr
	dim data
	
	size = Profile.Int("DataMemorySize")
	org = Profile.Int("DataMemoryOrg")

	Progress.ProgressText = "Reading Data Memory"
	Progress.NotifyText = ""
	
	for addr = 0 to size - 1
		data = PICWriter.ReadDataFromDataMemory
		mem.WriteWord addr + org, data and &hff
		PICWriter.IncrementAddress
		Progress.SetBar 0, size - 1, addr
	next
end sub

sub STDPIC_ReadProgramMemory(mem)
	dim addr
	dim data
	dim size
	
	size = Profile.Int("ProgramMemorySize")
	Progress.ProgressText = "Reading Program Memory"
	Progress.NotifyText = ""
	for addr = 0 to size - 1
		'msgbox "rdpm"
		data = PICWriter.ReadDataFromProgramMemory
		mem.WriteWord addr, data
		PICWriter.IncrementAddress
		Progress.SetBar 0, size - 1, addr
	next
end sub

function STDPIC_VerifyProgramMemory
	dim addr
	dim data
	dim rdata
	dim	size
	
	Memory.Mask = &h3fff
	
	Progress.ProgressText = "Verify Program Memory"
	Progress.NotifyText = ""
	size = Profile.Int("ProgramMemorySize")
	
	
	for addr = 0 to size - 1
		Progress.SetBar 0, size - 1, addr
		
		if Memory.GetFlags(addr * 2) and MF_FILLED then
			rdata = PICWriter.ReadDataFromProgramMemory
			data = Memory.ReadWord(addr)
			if data <>  rdata then
				MsgBox "Verify failed in program memory " & hex(data) & " " & hex(rdata)
				STDPIC_VerifyProgramMemory = false
				exit function
			end if
		end if
		PICWriter.IncrementAddress
	next
	STDPIC_VerifyProgramMemory = true
end function

function STDPIC_VerifyDataMemory
	dim addr
	dim data
	dim rdata
	dim	size
	dim	org
	
	size = Profile.Int("DataMemorySize")
	org = Profile.Int("DataMemoryOrg")

	Memory.Mask = &h3fff
	
	Progress.ProgressText = "Verify Data Memory"
	Progress.NotifyText = ""
	Progress.SetBar 0, size - 1, 0
	
	for addr = 0 to size - 1
		Progress.SetBar 0, size - 1, addr
		
		rdata = PICWriter.ReadDataFromDataMemory and &hff
		data = Memory.ReadWord(addr + org) and &hff
		if data <>  rdata then
			MsgBox "Verify failed in program memory " & hex(data) & " " & hex(rdata)
			STDPIC_VerifyDataMemory = false
			exit function
		end if
		PICWriter.IncrementAddress
	next
	STDPIC_VerifyDataMemory = true
end function

function STDPIC_VerifyConfigMemory
	dim addr
	dim data
	dim rdata
	dim vaddr
	dim org
	dim size
	
	dim vx
	set vx = Profile.ArrayVal("VerifyExclude", AVT_INTEGER)
		
	Memory.Mask = &h3fff
	
	org = Profile.Int("ConfigMemoryOrg")
	size = Profile.Int("ConfigMemorySize")
	
	PICWriter.LoadConfiguration
			
	Progress.ProgressText = "Verify Configuration Memory"
	Progress.NotifyText = ""
	
	for addr = 0 to size - 1
		vaddr = addr + org
		Progress.SetBar 0, size - 1, addr

		if not vx.Find(vaddr) then			
			rdata = PICWriter.ReadDataFromProgramMemory
			data = Memory.ReadWord(vaddr)
			if data <>  rdata then
				MsgBox "Verify failed in config memory address=" & hex(vaddr) & " expected=" & hex(data) & " read=" & hex(rdata)
				STDPIC_VerifyConfigMemory = false
				exit function
			end if
		end if
		PICWriter.IncrementAddress
	next
	STDPIC_VerifyConfigMemory = true
end function

class PIC16F87_88
	sub Reset_LVP()
		dim buf
		
		set buf = CreateObject("NWriterObjects.ByteBuffer")
		buf.allocate 3
		
		Controller.SetSyncWait 0
		Controller.SetLineWait &h7f
		Controller.PortControl &h01
		
		buf.Rewind
		dim elvon
		elvon = 0
		buf.Add elvon
		buf.Add elvon or PGM
		buf.Add elvon or MCLR or PGM
		Controller.LineControl buf, 3
	end sub

	sub Reset_HVP()
		dim buf
		
		set buf = CreateObject("NWriterObjects.ByteBuffer")
		buf.allocate 3
		
		Controller.SetLineWait 0
		Controller.PortControl &h01
		
		buf.Rewind
		buf.Add 0
		Controller.LineControl buf, buf.CurrentIndex
		util.Sleep 1000
		
		buf.Rewind
		buf.Add ELV
		buf.Add ELV or EHV
		Controller.LineControl buf, buf.CurrentIndex
	end sub
	
	sub Reset_PGM()
		if Profile.Int("LVP") then
			Reset_LVP
		else
			Reset_HVP
		end if
	end sub

	sub Reset_Normal()
		dim buf
		
		set buf = CreateObject("NWriterObjects.ByteBuffer")
		buf.allocate 3
		
		Controller.SetLineWait 10
		Controller.PortControl &h01
		
		buf.Rewind
		buf.Add &h00
		Controller.LineControl buf, 3
	end sub

	sub ProgramProgramMemory
		dim endaddr
		dim data
		dim addr
		dim	i
		
		progress.ProgressText = "Writing Program Memory"
		progress.NotifyText = ""
		
		endaddr = cint((memoryUsed + 31) / 32) * 32
		
		PICWriter.LoadDataForProgramMemory &h01
		addr = 0
		do while addr < endaddr
			PICWriter.command6 BEGIN_ERASE
			Util.Sleep tprog2
			PICWriter.command6 END_PROGRAMMING

			for i = 0 to 31
				data = Memory.ReadWord(addr)
				PICWriter.LoadDataForProgramMemory data
				if (i mod 4) = 3 then
					PICWriter.command6 BEGIN_PROGRAMMING_ONLY
					Util.Sleep 3
					PICWriter.command6 END_PROGRAMMING
				end if
				PICWriter.IncrementAddress
				addr = addr + 1
			next
		loop
	end sub

	sub ProgramDataMemory
		dim endaddr
		dim data
		dim addr
		dim	i
		dim org
		dim size

		progress.ProgressText = "Writing Data Memory"
		progress.NotifyText = ""
		
		org = Profile.int("DataMemoryOrg")
		size = Profile.Int("DataMemorySize")
		
		PICWriter.LoadDataForDataMemory &h01

		'
		' PC user memory ɂꍇAvO[ARtBO[V(0x2000-) ͏Ȃ
		'
		PICWriter.command6 BULK_ERASE_DATA_MEMORY
		PICWriter.command6 BEGIN_ERASE
		Util.Sleep tprog2
		PICWriter.command6 END_PROGRAMMING
		
		addr = 0
		endaddr = addr + size
		do while addr < endaddr
			Progress.SetBar 0, endaddr - 1, addr
			for i = 0 to 31
				Progress.SetBar 0, endaddr - 1, addr
				data = Memory.ReadWord(addr + org) and &hff
				PICWriter.LoadDataForDataMemory data
				PICWriter.command6 BEGIN_PROGRAMMING_ONLY
				Util.Sleep 3
				PICWriter.command6 END_PROGRAMMING
				PICWriter.IncrementAddress
				addr = addr + 1
			next
		loop
	end sub

	sub ProgramConfigMemory
		dim addr
		dim vaddr
		dim data
		dim org
		dim size
		
		dim px
		set px = Profile.ArrayVal("ProgramExclude", AVT_INTEGER)
		
		org = Profile.Int("ConfigMemoryOrg")
		size = Profile.Int("ConfigMemorySize")
		
		Progress.ProgressText = "Writing Config Memory"
		PICWriter.LoadConfiguration
		
		for addr= 0 TO size - 1
			vaddr = addr + org
			Progress.SetBar 0, size - 1, addr
			if not px.Find(vaddr) then			
				PICWriter.command6 BEGIN_ERASE
				Util.Sleep tprog2
				PICWriter.command6 END_PROGRAMMING
			
				data = memory.ReadWord(vaddr)
				
				PICWriter.LoadDataForProgramMemory Memory.ReadWord(vaddr)
				PICWriter.BeginProgrammingET
				Util.Sleep 3
				PICWriter.EndProgramming
			end if
			PICWriter.IncrementAddress
		next
	end sub

	sub InitVars
		memoryUsed = Profile.Int("ProgramMemorySize") - 1
		do while memoryUsed >= 0
			if Memory.GetFlags(memoryUsed * 2) and 1 then
				exit do
			end if
			memoryUsed = memoryUsed - 1
		loop
		memoryUsed = memoryUsed + 1
	end sub

	
	sub Verify
		Reset_PGM
		if not STDPIC_VerifyProgramMemory() then
			exit sub
		end if
		
		Reset_PGM
		if not STDPIC_VerifyDataMemory() then
			exit sub
		end if
		Reset_PGM
		if not STDPIC_VerifyConfigMemory() then
			exit sub
		end if
		
		Progress.ProgressText = "Verify Success"
		MsgBox "Verify success"
	end sub
	
	function PreProgramTest
		dim tmpmem
		
		PreProgramTest = false
		
		set tmpmem = CreateObject("NWriterObjects.HexLoader")
		tmpmem.Allocate(&h2200 * 2)
		
		pic.Reset_PGM
		STDPIC_ReadConfigMemory tmpmem

		if not STDPIC_CheckCPCPD(tmpmem) then
			exit function
		end if
				
		if not STDPIC_CheckDeviceID(tmpmem) then
			exit function
		end if
		
		PreProgramTest = true
	end function
end class


dim pic

set pic = new PIC16F87_88

sub Verify
	pic.InitVars
	pic.Verify
end sub

sub Read
	pic.InitVars

	pic.Reset_PGM
	STDPIC_ReadProgramMemory Memory
	
	pic.Reset_PGM
	STDPIC_ReadDataMemory Memory
	
	pic.Reset_PGM
	STDPIC_ReadConfigMemory Memory
end sub

sub Program
	PIC.InitVars
	
	if not PIC.PreProgramTest then
		exit sub
	end if
	
	PIC.Reset_PGM
	PIC.ProgramProgramMemory
	PIC.Reset_PGM
	PIC.ProgramDataMemory
	PIC.Reset_PGM
	PIC.ProgramConfigMemory
end sub

sub ProgramDataOnly
	pic.InitVars
	pic.Reset_PGM
	pic.ProgramDataMemory
end sub

sub ProgramConfigOnly
	pic.InitVars
	pic.ProgramConfigMemory
end sub

sub ReadDataOnly
	pic.InitVars
	pic.Reset_PGM
	STDPIC_ReadDataMemory Memory
end sub

sub ReadConfigOnly
	pic.InitVars
	pic.Reset_PGM
	STDPIC_ReadConfigMemory Memory
end sub

sub ChipErase
	pic.InitVars
	pic.Reset_PGM
	PICWriter.LoadConfiguration
	PICWriter.Command6 CHIP_ERASE
end sub

sub Run
	dim buf
	
	set buf = CreateObject("NWriterObjects.ByteBuffer")
	buf.allocate 3
	
	Controller.SetLineWait 10
	Controller.PortControl &h01
	
	Controller.PortControl NOT(ELV or EHV or MCLR or PGM) and &h7f
	
	buf.Rewind
	buf.Add &h00
	buf.Add ELV or EHV
	Controller.LineControl buf, 2
end sub

sub Off
	dim buf
	
	set buf = CreateObject("NWriterObjects.ByteBuffer")
	buf.allocate 16
	
	Controller.SetLineWait 10
	Controller.PortControl &h01
	
	buf.Rewind
	buf.Add &h00
	Controller.LineControl buf, buf.CurrentIndex
end sub
