// pww.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "pww.h"
#include "MainFrm.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif

wstring	curdir;


// Writer ZNVvt@C`
LPCWSTR szWriter = L"Writer";

	// C^[ʐM|[g
	LPCWSTR szPort = L"Port";
	LPCWSTR szPortDefault = L"COM1: baud=38400 parity=N data=8 stop=1";

	LPCWSTR szVoltageCalibration = L"VoltageCalibration";


// CpwwApp

BEGIN_MESSAGE_MAP(CpwwApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, &CpwwApp::OnAppAbout)
END_MESSAGE_MAP()


// CpwwApp construction
void _ThrowIfFail(HRESULT r)
{
	if (FAILED(r)) {
		AtlTrace("Throwing COM failure exception %08x\n", r);
		throw HRESULTEXCEPTION(r);
	}
}

CpwwApp::CpwwApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}


// The one and only CpwwApp object

CpwwApp theApp;
CComPtr<ILogger>	g_logger;
CComPtr<IPWProgressNotify> g_notify;
CComPtr<IMemory>	g_memory;
//CComPtr<IPWScript>	g_script;
HWND	g_hThreadControllingWnd;
UINT g_uMsgSetProgress;
UINT g_uMsgEndThread;

// CpwwApp initialization
void CreateInstance(REFCLSID clsid, REFIID riid, LPVOID* ppv)
{
	HRESULT r;

	r = CoCreateInstance(clsid, NULL, CLSCTX_INPROC, riid, ppv);
	ThrowIfFail(r);
	if (!g_logger.p)
		return;

	IUnknown* punk = (IUnknown *)*ppv;
	CComPtr<ISetLogger> pSetLogger;

	r = punk->QueryInterface(IID_ISetLogger, (void **)&pSetLogger.p);
	if (SUCCEEDED(r)) {
		r = pSetLogger->SetLogger(g_logger);
		if (FAILED(r))
			return;	// no set logger, failed but ok
	}
	CComPtr<IPWSetProgressNotify> pSetProgressNotify;
	r = punk->QueryInterface(IID_IPWSetProgressNotify, (void **)&pSetProgressNotify.p);
	if (SUCCEEDED(r)) {
		r = pSetProgressNotify->SetProgressNotify(g_notify);
		if (FAILED(r))
			return;	// no set logger, failed but ok
	}

	return;
}

BOOL CpwwApp::InitInstance()
{
	//_CrtSetBreakAlloc(344);

	// InitCommonControlsEx() is required on Windows XP if an application
	// manifest specifies use of ComCtl32.dll version 6 or later to enable
	// visual styles.  Otherwise, any window creation will fail.
	INITCOMMONCONTROLSEX InitCtrls;
	InitCtrls.dwSize = sizeof(InitCtrls);
	// Set this to include all the common control classes you want to use
	// in your application.
	InitCtrls.dwICC = ICC_WIN95_CLASSES;
	InitCommonControlsEx(&InitCtrls);

	CWinApp::InitInstance();

	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();
	SetRegistryKey(_T("NW"));

	HRESULT r;

	g_uMsgSetProgress = RegisterWindowMessage(L"PICWRITER_g_uMsgSetProgress");
	g_uMsgEndThread = RegisterWindowMessage(L"PICWRITER_g_uMsgEndThread");

	CComVariant v;

	r = CoCreateInstance(CLSID_Logger, NULL, CLSCTX_INPROC, IID_ILogger, (void **)&g_logger.p);
	if (FAILED(r))
		return FALSE;
	r = g_logger->Open(L"c:\\temp\\ppw.log");
	if (FAILED(r))
		return FALSE;
	r = CoCreateInstance(CLSID_ProgressNotify, NULL, CLSCTX_INPROC, IID_IUnknown, (void **)&g_notify.p);
	if (FAILED(r))
		return FALSE;
//	r = CoCreateInstance(CLSID_PWScript, NULL, CLSCTX_INPROC, IID_IPWScript, (void **)&g_script.p);
//	if (FAILED(r))
//		return FALSE;

	r = CoCreateInstance(CLSID_HexLoader, NULL, CLSCTX_INPROC, IID_IMemory, (void **)&g_memory.p);
	if (FAILED(r))
		return FALSE;
	r = g_memory->Allocate(0x10000);
	if (FAILED(r))
		return FALSE;
	r = g_memory->put_Endian(endianLittle);
	if (FAILED(r))
		return FALSE;

	// To create the main window, this code creates a new frame window
	// object and then sets it as the application's main window object
	CMainFrame* pFrame = new CMainFrame;
	if (!pFrame)
		return FALSE;
	m_pMainWnd = pFrame;
	// create and load the frame with its resources
	pFrame->LoadFrame(IDR_MAINFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL,
		NULL);

	// The one and only window has been initialized, so show and update it
	pFrame->ShowWindow(SW_SHOW);
	pFrame->UpdateWindow();
	// call DragAcceptFiles only if there's a suffix
	//  In an SDI app, this should occur after ProcessShellCommand
	return TRUE;
}


// CpwwApp message handlers




// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

// App command to run the dialog
void CpwwApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}


// CpwwApp message handlers


int CpwwApp::ExitInstance()
{
	g_memory.Release();
	g_logger.Release();
	g_notify.Release();
	return CWinApp::ExitInstance();
}
