/*:
 * @plugindesc ターゲット関連の仕様を変更します。
 詳しくはヘルプを参照してください。
 * @author 茶の助
 *
 * @help　対象が全体、使用者などでも対象選択をするようにします。
 
 敵選択ウィンドウのカーソル位置を記憶するようにします。
 
 範囲が「敵全体」のスキルのメモ欄に<indifference>と書き込むと
 効果が敵と味方の両方に適応されるようになります。
 
 範囲が「味方単体」のスキルのメモ欄に<withOutUser>と書き込むと
 効果対象から使用者が除外されます。
 */

(function() {
    
    Game_Action.prototype.isForOpponentA = function() {
        return this.checkItemScope([2, 3, 4, 5, 6]);
    };
    
    Game_Action.prototype.isForAllP = function() {
        return this.checkItemScope([8]);
    };
    
    Game_Action.prototype.isForAllR = function() {
        return this.checkItemScope([10]);
    };
	
	Game_Action.prototype.targetsForOpponents = function() {
		var targets = [];
		var unit = this.opponentsUnit();
		if (this.isForRandom()) {
			for (var i = 0; i < this.numTargets(); i++) {
				targets.push(unit.randomTarget());
			}
		} else if (this.isForOne()) {
			if (this._targetIndex < 0) {
				targets.push(unit.randomTarget());
			} else {
				targets.push(unit.smoothTarget(this._targetIndex));
			}
		} else {
			targets = unit.aliveMembers();
			//
			if (this.item().meta.indifference) {
				targets.concat(this.opponentsUnit().aliveMembers());
			}
			//
		}
		return targets;
	};
	
	Game_Action.prototype.targetsForFriends = function() {
		var targets = [];
		var unit = this.friendsUnit();
		if (this.isForUser()) {
			return [this.subject()];
		} else if (this.isForDeadFriend()) {
			if (this.isForOne()) {
				targets.push(unit.smoothDeadTarget(this._targetIndex));
			} else {
				targets = unit.deadMembers();
			}
		} else if (this.isForOne()) {
			if (this._targetIndex < 0) {
				targets.push(unit.randomTarget());
			} else {
				//
				if (this.item().meta.withOutUser) {
					unit.filter(function(target) {
						return target != this.subject();
					});
				}
				//
				targets.push(unit.smoothTarget(this._targetIndex));
			}
		} else {
			targets = unit.aliveMembers();
		}
		return targets;
	};
    
    var _Game_Party_prototype_initialize = Game_Party.prototype.initialize;
    Game_Party.prototype.initialize = function() {
        _Game_Party_prototype_initialize.call(this);
        this._allSelect = 0;
    };

    Game_Party.prototype.allSelectChange = function(type) {
        this._allSelect = type;
    };
    
    var _Game_Battler_prototype_isSelected = Game_Battler.prototype.isSelected;
    Game_Battler.prototype.isSelected = function() {
        if ($gameParty._allSelect == 1 && this.isActor() && !this.isDead()) {
			return true;
        } else if ($gameParty._allSelect == 2 && this.isActor() && this.isDead()) {
            return true;
        } else if ($gameParty._allSelect == 3 && !this.isActor() && !this.isDead()) {
			return true;
        }
        return _Game_Battler_prototype_isSelected.call(this);
    };

	var TYA_Game_Actor_initMembers = Game_Actor.prototype.initMembers;
	Game_Actor.prototype.initMembers = function() {
		TYA_Game_Actor_initMembers.call(this);
		this._lastTargetIndex = 0;
	};
	
	var TYA_Game_Battler_onBattleEnd = Game_Battler.prototype.onBattleEnd;
	Game_Actor.prototype.onBattleEnd = function() {
		TYA_Game_Battler_onBattleEnd.call(this);
		this._lastTargetIndex = 0;
	};
    
    Window_BattleActor.prototype.updateCursor = function() {
        if (this._cursorAll) {
            var allRowsHeight = this.maxRows() * this.itemHeight();
            this.setCursorRect(0, 0, this.contents.width, allRowsHeight); //
            this.setTopRow(0);
        } else if (this.isCursorVisible()) {
            var rect = this.itemRect(this.index());
            this.setCursorRect(rect.x, rect.y, rect.width, rect.height);
        } else {
            this.setCursorRect(0, 0, 0, 0);
        }
    };
    
    Window_BattleEnemy.prototype.updateCursor = function() {
        if (this._cursorAll) {
            var allRowsHeight = this.maxRows() * this.itemHeight();
            this.setCursorRect(0, 0, this.contents.width, allRowsHeight); //
            this.setTopRow(0);
        } else if (this.isCursorVisible()) {
            var rect = this.itemRect(this.index());
            this.setCursorRect(rect.x, rect.y, rect.width, rect.height);
        } else {
            this.setCursorRect(0, 0, 0, 0);
        }
    };
	
	Window_BattleEnemy.prototype.show = function() {
		this.refresh();
		// this.select(0);
		Window_Selectable.prototype.show.call(this);
	};
    
    var _Scene_Battle_prototype_changeInputWindow = Scene_Battle.prototype.changeInputWindow;
    Scene_Battle.prototype.changeInputWindow = function() {
        _Scene_Battle_prototype_changeInputWindow.call(this);
        $gameParty.allSelectChange(0);
    };
    
    Scene_Battle.prototype.commandGuard = function() {
        BattleManager.inputtingAction().setGuard();
        this.selectActorSelection(-2);
    };
    
    Scene_Battle.prototype.selectActorSelection = function(id) {
        id = id || 0;
        this._actorWindow.setCursorFixed(false);
        this._actorWindow.setCursorAll(false);
        this._actorWindow.show();
        this._actorWindow.select(id);
        if (id == -2) {
            this._actorWindow.select(BattleManager.actor().index());
            this._actorWindow.setCursorFixed(true);
        } else if (id == -1) {
            $gameParty.allSelectChange(1);
            this._actorWindow.setCursorAll(true);
        } else if (id == -3) {
            $gameParty.allSelectChange(3);
            this._actorWindow.setCursorAll(true);
        }
        this._actorWindow.refresh();
        this._actorWindow.activate();
    };
    
    Scene_Battle.prototype.selectEnemySelection = function(id) {
        this._enemyWindow.setCursorAll(false);
        this._enemyWindow.refresh();
        this._enemyWindow.show();
        id = id || 0;
        if (id == -1) {
            $gameParty.allSelectChange(3);
            this._enemyWindow.setCursorAll(true);
		} else {
			var lastID = BattleManager.actor()._lastTargetIndex;
			if (lastID > this._enemyWindow.maxItems() - 1) {
				lastID = BattleManager.actor()._lastTargetIndex = 0;
			}
			this._enemyWindow.select(lastID);
        }
        this._enemyWindow.activate();
    };
    
    var _Scene_Battle_prototype_onActorCancel = Scene_Battle.prototype.onActorCancel;
    Scene_Battle.prototype.onActorCancel = function() {
        _Scene_Battle_prototype_onActorCancel.call(this);
        $gameParty.allSelectChange(0);
    };
	
	var TYA_Scene_Battle_onEnemyOk = Scene_Battle.prototype.onEnemyOk;
	Scene_Battle.prototype.onEnemyOk = function() {
		BattleManager.actor()._lastTargetIndex = this._enemyWindow.index() == -1 ? 0 : this._enemyWindow.index();
		TYA_Scene_Battle_onEnemyOk.call(this);
	};
    
    var _Scene_Battle_prototype_onEnemyCancel = Scene_Battle.prototype.onEnemyCancel;
    Scene_Battle.prototype.onEnemyCancel = function() {
        _Scene_Battle_prototype_onEnemyCancel.call(this);
        $gameParty.allSelectChange(0);
    };
    
    Scene_Battle.prototype.onSelectAction = function() {
        var action = BattleManager.inputtingAction();
        this._skillWindow.hide();
        this._itemWindow.hide();
        if (action.isForOpponent()) {
            if (action.isForOpponentA()) {
                this.selectEnemySelection(-1);
            } else {
                this.selectEnemySelection();
            }
        } else {
            if (action.isForUser()) {
                this.selectActorSelection(-2);
            } else if (action.isForAllP()) {
                this.selectActorSelection(-1);
            } else if (action.isForAllR()) {
                this.selectActorSelection(-3);
            } else {
                this.selectActorSelection();
            }
        }
    };
    
})();