/*:
 * @plugindesc サイドビュー戦闘で、味方バトラーにも敵バトラーと同様にステートアイコンを表示します。
 * @author 茶の助
 *
 * @param statusStateIconHide
 * @desc ステータスウィンドウのステートアイコンを非表示にする
 (1:する 0:しない)
 * @default 1
 */
 
 (function() {
	
	
    var parameters = PluginManager.parameters('TYA_ActorStateIcon');
    var statusStateIconHide = Number(parameters['statusStateIconHide']) != 0;
	
	var _Sprite_Actor_prototype_initMembers = Sprite_Actor.prototype.initMembers;
	Sprite_Actor.prototype.initMembers = function() {
		_Sprite_Actor_prototype_initMembers.call(this);
		
		this.createStateIconSprite();
	};
	
	Sprite_Actor.prototype.createStateIconSprite = function() {
		this._stateIconSprite = new Sprite_StateIcon();
		this.addChild(this._stateIconSprite);
	};
	
	Sprite_Actor.prototype.update = function() {
		Sprite_Battler.prototype.update.call(this);
		this.updateShadow();
		if (this._actor) {
			this.updateMotion();
			this.updateStateIconSprite();
		}
	};
	
	Sprite_Actor.prototype.updateStateIconSprite = function() {
		this._stateIconSprite.y = -100;
	};
	
	Sprite_Actor.prototype.setBattler = function(battler) {
		Sprite_Battler.prototype.setBattler.call(this, battler);
		var changed = (battler !== this._actor);
		if (changed) {
			this._actor = battler;
			if (battler) {
				this.setActorHome(battler.index());
			}
			this.startEntryMotion();
			this._stateSprite.setup(battler);
			this._stateIconSprite.setup(battler);
		}
	};
	
	if (statusStateIconHide) {
		Window_BattleStatus.prototype.drawActorIcons = function(actor, x, y, width) {
		};
	}

})();