/*:
 * @plugindesc スキル選択中、Ｓｈｉｆｔキーを押すと選択しているスキルが変化します。
 詳しい使い方はヘルプを参照してください。
 * @author 茶の助
 *
 * @param boostName
 * @desc 変化後スキルを示す文字列
 スキル名の横にこの文字列が表示されます
 * @default BOOST
 *
 * @help スキルウィンドウにてＳｈｉｆｔキーを押すと
  選択中のスキルが別のスキルに変化するようになります。
  対象が単体と全体で切り替えられるスキルや、
  敵にも味方にも使用できるスキルなどを実装できます。
  
  変化したスキルはもう一度Ｓｈｉｆｔキーを押すか、
  カーソルを移動させることで元に戻ります。
  
  変化させたいスキルのメモ欄に<boostSkillId:n>と記入してください。
  nには変化後のスキルＩＤを入れてください。
  
  変化したスキルは、スキル名の横にboostNameで設定した文字列が表示されます。
 */
 
(function() {
	
	var parameters = PluginManager.parameters('TYA_SkillBoost');
    var boostName = parameters['boostName'];
	
	var _Window_SkillList_prototype_hide = Window_SkillList.prototype.hide;
	Window_SkillList.prototype.hide = function() {
		_Window_SkillList_prototype_hide.call(this);
		this._boostId = 0;
		this._lastIndex = 0;
	};
	
	Window_SkillList.prototype.item = function() {
		var item = null;
		if (this._data && this.index() >= 0) {
			item = this._data[this.index()];
			if (this._boostId >= 1) {
				item = $dataSkills[this._boostId];
			}
		}
		return item;
	};
	
	Window_SkillList.prototype.drawItem = function(index) {
		var skill = this._data[index];
		if (skill) {
			var costWidth = this.costWidth();
			var rect = this.itemRect(index);
			rect.width -= this.textPadding();
			this.changePaintOpacity(this.isEnabled(skill));
			if (this._boostId == skill.meta.boostSkillId && this._index == index) {
				skill = $dataSkills[skill.meta.boostSkillId];
				this.drawSkillCost2(skill, rect.x, rect.y, rect.width);
			} else {
				this.drawSkillCost(skill, rect.x, rect.y, rect.width);
			}
			this.drawItemName(skill, rect.x, rect.y, rect.width - costWidth);
			this.changePaintOpacity(1);
		}
	};
	
	Window_SkillList.prototype.drawSkillCost2 = function(skill, x, y, width) {
		this.contents.fontSize = this.standardFontSize() / 2;
		this.drawText(boostName, x, y, width - 36, 'right', true);
		this.contents.fontSize = this.standardFontSize();
		if (this._actor.skillTpCost(skill) > 0) {
			this.changeTextColor(this.tpCostColor());
			this.drawText(this._actor.skillTpCost(skill), x, y, width, 'right', true);
		} else if (this._actor.skillMpCost(skill) > 0) {
			this.changeTextColor(this.mpCostColor());
			this.drawText(this._actor.skillMpCost(skill), x, y, width, 'right', true);
		}
	};
	
	Window_SkillList.prototype.boostIdChange = function(id) {
		this._boostId = id;
		this.refresh();
		this.updateHelp();
	};
	
	var _Window_SkillList_prototype_update = Window_SkillList.prototype.update;
	Window_SkillList.prototype.update = function() {
		_Window_SkillList_prototype_update.call(this);
		
		if (this.active) {
			if (this.item() && Input.isTriggered('shift')) {
				if (this._boostId == 0 && this.item().meta.boostSkillId >= 1) {
					AudioManager.playSe((new Function("return " + '{name: "Flash1", volume: 90, pitch: 100, pan: 0}'))());
					this.boostIdChange(this.item().meta.boostSkillId);
				} else if (this._boostId >= 1) {
					SoundManager.playCancel();
					this.boostIdChange(0);
				}
			}
			if (this._index != this._lastIndex) {
				this.boostIdChange(0);
			}
			this._lastIndex = this._index;
		}
	};
	
	var _Scene_Skill_prototype_onItemCancel = Scene_Skill.prototype.onItemCancel;
	Scene_Skill.prototype.onItemCancel = function() {
		this._itemWindow.boostIdChange(0);
		
		_Scene_Skill_prototype_onItemCancel.call(this);
	};

})();