#include "def.h"
#include "prot.h"

#define ADR_BOOTINFO	0x0ff0

struct BOOTINFO *binfo = (struct BOOTINFO *)ADR_BOOTINFO;

void Main() {
	init_gdtidt();
	init_palete();
	init_screen(binfo->scrnx, binfo->scrny);

	char mcursor[256];
	int mx = (binfo->scrnx-16)/2, my = (binfo->scrny-28-16)/2;
	init_mouse_cursor(mcursor, COL_008484);
	putblock(16, 16, mx, my, mcursor, 16);

	char s[30];
	lsprintf(s, "mx = %d, my = %d", mx, my);
	vprint(s, 8, 8, COL_FFFFFF);

	while(1) { io_hlt(); }
}
