#ifndef __DEF_H__
#define __DEF_H__

// カラーナンバー
#define COLORN		16
#define COL_000000	0
#define COL_FF0000	1
#define COL_00FF00	2
#define COL_FFFF00	3
#define COL_0000FF	4
#define COL_FF00FF	5
#define COL_00FFFF	6
#define COL_FFFFFF	7
#define COL_C6C6C6	8
#define COL_840000	9
#define COL_008400	10
#define COL_848400	11
#define COL_000084	12
#define COL_840084	13
#define COL_008484	14
#define COL_848484	15

// ブート情報
struct BOOTINFO {
	char cyls, leds, vmode, reserve;
	short scrnx, scrny;
	char *vram;
};

// セグメントデスクリプタ
struct SEGMENT_DESCRIPTOR {
	short limit_low, base_low;
	char base_mid, access_right;
	char limit_high, base_high;
};

// インタラプトデスクリプタ
struct GATE_DESCRIPTOR {
	short offset_low, selector;
	char dw_count, access_right;
	short offset_high;
};

// 半角英数字(ASCII)
extern char hankaku[4096];
// ブート情報
extern struct BOOTINFO *binfo;

#endif // __DEF_H__
