#include "def.h"
#include "prot.h"

#define ADR_BOOTINFO	0x0ff0

BOOTINFO *binfo = (BOOTINFO *)ADR_BOOTINFO;

struct IDTR {
	short limit;
	int base;
}__attribute((__packed__));

void Main() {
	init_gdtidt();	// GDT/IDTの初期化
	init_pic();		// PICの初期化
	io_sti();		// 割り込み許可

	init_palete();	// パレットの初期化
	init_screen(binfo->scrnx, binfo->scrny);

	draw_mouse();

	io_out8(PIC0_IMR, 0xf9);	// PIC1とキーボードを許可(0xf9)
	io_out8(PIC1_IMR, 0xef);	// マウスを許可

	char s[30];

	while(1) {
		io_hlt();
	}
}
