#ifndef __TYPE_H__
#define __TYPE_H__

// type
typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int dword;

// ブート情報
typedef struct __BOOTINFO__ {
	char cyls, leds, vmode, reserve;
	short scrnx, scrny;
	char *vram;
} __attribute__((__packed__)) BOOTINFO;

// セグメントデスクリプタ
typedef struct __SEGMENT_DESCRIPTOR__ {
	short limit_low, base_low;
	char base_mid, access_right;
	char limit_high, base_high;
} __attribute__((__packed__)) SEGMENT_DESCRIPTOR;

// ゲートデスクリプタ
typedef struct __GATE_DESCRIPTOR__ {
	short offset_low, selector;
	char dw_count, access_right;
	short offset_high;
} __attribute__((__packed__)) GATE_DESCRIPTOR;

// FIFOバッファ
typedef struct __FIFO8__ {
	byte *buf;
	int next_w, next_r, size, free, flags;
} QUEUE;

#endif // __TYPE_H__
