#include "def.h"
#include "prot.h"

#define ADR_BOOTINFO	0x0ff0

BOOTINFO *binfo = (BOOTINFO *)ADR_BOOTINFO;

struct IDTR {
	short limit;
	int base;
}__attribute((__packed__));

void wait_KBC_sendready();
void init_keyboard();
void enable_mouse();

void Main() {
	char s[30], keyboardbuf[32], mousebuf[128];
	int i;

	init_gdtidt();	// GDT/IDTの初期化
	init_pic();		// PICの初期化
	io_sti();		// 割り込み許可

	// キーボード用QUEUEの初期化
	queue_init(&qKeyboard, 32, keyboardbuf);
	// マウス用QUEUEの初期化
	queue_init(&qMouse, 128, mousebuf);

	io_out8(PIC0_IMR, 0xf9);	// PIC1とキーボードを許可(0xf9)
	io_out8(PIC1_IMR, 0xef);	// マウスを許可

	init_keyboard();
	init_palete();	// パレットの初期化
	init_screen(binfo->scrnx, binfo->scrny);
	draw_mouse();

	enable_mouse();

	while(1) {
		io_cli();
		// キーボードとマウスの両方からデータを受け取っていない
		if(queue_status(&qKeyboard) + queue_status(&qMouse) == 0) {
			io_stihlt();
		// キーボードかマウスからデータを受け取っている
		} else {
			int x;
			// キーボードからデータを受信
			if(queue_status(&qKeyboard)) {
				i = queue_get(&qKeyboard);
				x = 0;
			// マウスかデータを受信
			} else if(queue_status(&qMouse)) {
				i = queue_get(&qMouse);
				x = 32;
			}
			io_sti();
			boxfill(COL_008484, x, 16, x + 8*2 -1, 31);
			lsprintf(s, "%X", i);
			vprint(s, x, 16, COL_FFFFFF);
		}
	}
}

// キーボードコントローラがデータ送信可能になるのを待つ
void wait_KBC_sendready() {
	for(;;) {
		if((io_in8(PORT_KEYSTA) & KEYSTA_SEND_NOTREADY) == 0) break;
	}
}

// キーボードコントローラの初期化
void init_keyboard() {
	wait_KBC_sendready();
	io_out8(PORT_KEYCMD, KEYCMD_WRITE_MODE);
	wait_KBC_sendready();
	io_out8(PORT_KEYDAT, KBC_MODE);
}

// マウスの有効化
void enable_mouse() {
	wait_KBC_sendready();
	io_out8(PORT_KEYCMD, KEYCMD_SENDTO_MOUSE);
	wait_KBC_sendready();
	io_out8(PORT_KEYDAT, MOUSECMD_ENABLE);
	// 成功すればACK(0xfa)を返却
}
