#include "def.h"
#include "prot.h"

#define ADR_BOOTINFO		0x0ff0

BOOTINFO *binfo = (BOOTINFO *)ADR_BOOTINFO;

void Main() {
	char s[30], keyboardbuf[32], mousebuf[128];
	int i;
	int mx = (binfo->scrnx-16)/2, my = (binfo->scrny-28-16)/2;
	MOUSE_DEC mdec;
	dword memtotal;
	MEMORY_MANAGE *memman = (MEMORY_MANAGE *)ADR_MEMMAN;
	SHEET_CTL *sheetctl;
	SHEET *sheet_back, *sheet_mouse;
	byte *buf_back, *buf_mouse;

	init_gdtidt();	// GDT/IDTの初期化
	init_pic();		// PICの初期化
	io_sti();		// 割り込み許可

	// キーボード用QUEUEの初期化
	queue_init(&qKeyboard, 32, keyboardbuf);
	// マウス用QUEUEの初期化
	queue_init(&qMouse, 128, mousebuf);

	io_out8(PIC0_IMR, 0xf9);	// PIC1とキーボードを許可(0xf9)
	io_out8(PIC1_IMR, 0xef);	// マウスを許可

	init_keyboard();
	enable_mouse(&mdec);
	// メモリ管理
	memtotal = memtest(0x00400000, 0xbfffffff);
	mem_init(memman);
	mem_free(memman, 0x00001000, 0x0009e000);
	mem_free(memman, 0x00400000, memtotal- 0x00400000);

	init_palete();	// パレットの初期化

	// 下敷き管理
	sheetctl = sheetctl_init(memman, binfo->vram, binfo->scrnx, binfo->scrny);
	if(!sheetctl) return;
	sheet_back	= sheet_alloc(sheetctl);
	sheet_mouse	= sheet_alloc(sheetctl);
	buf_back = (byte*)mem_alloc_4k(memman, binfo->scrnx * binfo->scrny);
	sheet_setbuf(sheet_back, buf_back, binfo->scrnx, binfo->scrny, -1);
	sheet_setbuf(sheet_mouse, buf_mouse, 16, 16, 99);

	init_screen(buf_back, binfo->scrnx, binfo->scrny);
	init_mouse_cursor(buf_mouse, 99);

	sheet_slide(sheetctl, sheet_mouse, mx, my);
	sheet_updown(sheetctl, sheet_back, 0);
	sheet_updown(sheetctl, sheet_mouse, 1);

	lsprintf(s, "memory %dMB   free : %dKB", memtotal / (1024*1024),
				mem_total(memman) / 1024);
	vprint(buf_back, s, 0, 32, COL_FFFFFF);

	sheet_refresh(sheetctl, sheet_back, 0, 32, binfo->scrnx, 48);

	while(1) {
		io_cli();
		// キーボードとマウスの両方からデータを受け取っていない
		if(queue_status(&qKeyboard) + queue_status(&qMouse) == 0) {
			io_stihlt();
		// キーボードかマウスからデータを受け取っている
		} else {
			// キーボードからデータを受信
			if(queue_status(&qKeyboard)) {
				i = queue_get(&qKeyboard);
				io_sti();
				boxfill(buf_back, COL_008484, 0, 16, 15, 31);
				lsprintf(s, "%X", i);
				vprint(buf_back, s, 0, 16, COL_FFFFFF);
				sheet_refresh(sheetctl, sheet_back, 0, 16, 16, 32);
			// マウスかデータを受信
			} else if(queue_status(&qMouse)) {
				i = queue_get(&qMouse);
				io_sti();
				// マウスデータが3バイト揃う
				if(mouse_decode(&mdec, i)) {
					// データの表示
					lsprintf(s, "[lcr] x=%d y=%d", mdec.x, mdec.y);
					if((mdec.button & 0x01) != 0) s[1] = 'L';
					if((mdec.button & 0x02) != 0) s[3] = 'R';
					if((mdec.button & 0x03) != 0) s[2] = 'C';
					boxfill(buf_back, COL_008484, 32, 16, 32+30*8-1, 31);
					vprint(buf_back, s, 32, 16, COL_FFFFFF);

					// マウスの移動
					// マウスカーソルの消去
					mx += mdec.x; my += mdec.y;
					if(mx < 0) mx = 0;
					if(my < 0) my = 0;
					if(mx > binfo->scrnx - 16) mx = binfo->scrnx - 16;
					if(my > binfo->scrny - 16) my = binfo->scrny - 16;
					sheet_refresh(sheetctl, sheet_back, 32, 16, 32+30*8, 32);
					sheet_slide(sheetctl, sheet_mouse, mx, my);
				}
			}
		}
	}
}
