#include "prot.h"
#include "def.h"

const byte table_rgb[COLORN * 3] = {
	0x00, 0x00, 0x00,	// 0: black
	0xff, 0x00, 0x00,	// 1: red
	0x00, 0xff, 0x00,	// 2: lime
	0xff, 0xff, 0x00,	// 3: yellow
	0x00, 0x00, 0xff,	// 4: blue
	0xff, 0x00, 0xff,	// 5: purple
	0x00, 0xff, 0xff,	// 6: cyan
	0xff, 0xff, 0xff,	// 7: white
	0xc6, 0xc6, 0xc6,	// 8: gray
	0x84, 0x00, 0x00, 	// 9: dark red
	0x00, 0x84, 0x00,	// 10: green
	0x84, 0x84, 0x00,	// 11: dark yellow
	0x00, 0x00, 0x84,	// 12: dark blue
	0x84, 0x00, 0x84,	// 13: dark purple
	0x00, 0x84, 0x84,	// 14: dark cyan
	0x84, 0x84, 0x84	// 15: dark gray
};

const char _cursor[16][16] = {
	"**************..",
	"*OOOOOOOOOOO*...",
	"*OOOOOOOOOO*....",
	"*OOOOOOOOO*.....",
	"*OOOOOOOO*......",
	"*OOOOOOO*.......",
	"*OOOOOOO*.......",
	"*OOOOOOOO*......",
	"*OOOO**OOO*.....",
	"*OOO*..*OOO*....",
	"*OO*....*OOO*...",
	"*O*......*OOO*..",
	"**........*OOO*.",
	"*..........*OOO*",
	"............*OO*",
	".............***",
};

void set_palete(int, int, const byte *);
void putfont(byte *, int, int, int, char, char *);

void init_palete() {
	set_palete(0, 15, table_rgb);
}

void boxfill(byte *vram, byte c, int x0, int y0, int x1, int y1) {
	int x, y;
	for( y = y0; y <= y1; y++ ) {
		for( x = x0; x <= x1; x++ ) vram[y * binfo->scrnx + x] = c;
	}
}

void init_screen(byte *vram, const int xsize, const int ysize) {
	boxfill(vram, COL_008484, 0, 0, xsize - 1, ysize - 29);
	boxfill(vram, COL_C6C6C6, 0, ysize - 28, xsize - 1, ysize - 28);
	boxfill(vram, COL_FFFFFF, 0, ysize - 27, xsize - 1, ysize - 27);
	boxfill(vram, COL_C6C6C6, 0, ysize - 26, xsize - 1, ysize - 1);

	boxfill(vram, COL_FFFFFF, 3, ysize - 24, 59, ysize - 24);
	boxfill(vram, COL_FFFFFF, 2, ysize - 24, 2, ysize - 4);
	boxfill(vram, COL_848484, 3, ysize - 4, 59, ysize - 4);
	boxfill(vram, COL_848484, 59, ysize - 23, 59, ysize - 5);
	boxfill(vram, COL_000000, 2, ysize - 3, 59, ysize - 3);
	boxfill(vram, COL_000000, 60, ysize - 24, 60, ysize - 3);

	boxfill(vram, COL_848484, xsize - 47, ysize - 24, xsize - 4, ysize - 24);
	boxfill(vram, COL_848484, xsize - 47, ysize - 23, xsize - 47, ysize - 4);
	boxfill(vram, COL_FFFFFF, xsize - 47, ysize - 3, xsize - 4, ysize - 3);
	boxfill(vram, COL_FFFFFF, xsize - 3, ysize - 24, xsize - 3, ysize - 3);
}

void vprint(byte *vram, byte *s, int x, int y, char c) {
	for(; *s != 0x00; s++ ) {
		putfont(vram, binfo->scrnx, x, y, c, hankaku + *s * 16);
		x += 8;
	}
	return;
}

void init_mouse_cursor(char *mouse, char bc) {
	int x, y;
	for( y = 0; y < 16; y++ )
	for( x = 0; x < 16; x++ ) {
		switch(_cursor[y][x]) {
		case '*':
			mouse[y*16+x] = COL_000000; break;
		case 'O':
			mouse[y*16+x] = COL_FFFFFF; break;
		case '.':
			mouse[y*16+x] = bc;			break;
		}
	}
}

void putblock(byte *vram, int vxsize, int pxsize, int pysize, int x0, int y0, const char *buf, int bxsize) {
	int x, y;
	for( y = 0; y < pysize; y++ )
	for( x = 0; x < pxsize; x++ ) {
		vram[(y0+y) * vxsize + (x0+x)] = buf[y * bxsize + x];
	}
}

void set_palete(int start, int end, const byte *rgb) {
	int i, eflags;
	eflags = io_load_eflags();
	io_cli();
	io_out8(0x03c8, start);
	for( i = start; i <= end; i++ ) {
		io_out8(0x03c9, rgb[0] / 4);
		io_out8(0x03c9, rgb[1] / 4);
		io_out8(0x03c9, rgb[2] / 4);
		rgb += 3;
	}
	io_store_eflags(eflags);
}

void putfont(byte *vram, int xsize, int x, int y, char c, char *font) {
	int i;
	char *p, d;
	for( i = 0; i < 16; i++ ) {
		p = vram + (y + i) * xsize + x;
		d = font[i];
		if((d & 0x80) != 0) { p[0] = c; }
		if((d & 0x40) != 0) { p[1] = c; }
		if((d & 0x20) != 0) { p[2] = c; }
		if((d & 0x10) != 0) { p[3] = c; }
		if((d & 0x08) != 0) { p[4] = c; }
		if((d & 0x04) != 0) { p[5] = c; }
		if((d & 0x02) != 0) { p[6] = c; }
		if((d & 0x01) != 0) { p[7] = c; }
	}
}
