#include "def.h"
#include "prot.h"

#define ADR_BOOTINFO		0x0ff0

#define WIN_XS				160
#define WIN_YS				52

BOOTINFO *binfo = (BOOTINFO *)ADR_BOOTINFO;

void make_window(byte *, int, int, char *);

void Main() {
	char s[30], keyboardbuf[32], mousebuf[128];
	char timerbuf1[8], timerbuf2[8], timerbuf3[8];
	int i;
	int mx = (binfo->scrnx-16)/2, my = (binfo->scrny-28-16)/2;
	MOUSE_DEC mdec;
	dword memtotal;
	MEMORY_MANAGE *memman = (MEMORY_MANAGE *)ADR_MEMMAN;
	SHEET_CTL *sheetctl;
	SHEET *sheet_back, *sheet_mouse, *sheet_win;
	byte *buf_back, *buf_mouse, *buf_win;
	TIMER *timer1, *timer2, *timer3;
	QUEUE qTimer1, qTimer2, qTimer3;

	init_gdtidt();	// GDT/IDTの初期化
	init_pic();		// PICの初期化
	io_sti();		// 割り込み許可

	// キーボード用QUEUEの初期化
	queue_init(&qKeyboard, 32, keyboardbuf);
	// マウス用QUEUEの初期化
	queue_init(&qMouse, 128, mousebuf);

	init_pit();		// PITの初期化

	io_out8(PIC0_IMR, 0xf8);	// PITとPIC1とキーボードを許可(0xf9)
	io_out8(PIC1_IMR, 0xef);	// マウスを許可

	// タイマ設定
	queue_init(&qTimer1, 8, timerbuf1);
	timer1 = timer_alloc();
	timer_init(timer1, &qTimer1, 1);
	timer_settime(timer1, 1000);
	queue_init(&qTimer2, 8, timerbuf2);
	timer2 = timer_alloc();
	timer_init(timer2, &qTimer2, 1);
	timer_settime(timer2, 300);
	queue_init(&qTimer3, 8, timerbuf3);
	timer3 = timer_alloc();
	timer_init(timer3, &qTimer3, 1);
	timer_settime(timer3, 50);

	init_keyboard();
	enable_mouse(&mdec);
	// メモリ管理
	memtotal = memtest(0x00400000, 0xbfffffff);
	mem_init(memman);
	mem_free(memman, 0x00001000, 0x0009e000);
	mem_free(memman, 0x00400000, memtotal- 0x00400000);

	init_palete();	// パレットの初期化

	// 下敷き管理
	sheetctl = sheetctl_init(memman, binfo->vram, binfo->scrnx, binfo->scrny);
	if(!sheetctl) return;
	sheet_back	= sheet_alloc(sheetctl);
	sheet_mouse	= sheet_alloc(sheetctl);
	sheet_win	= sheet_alloc(sheetctl);
	buf_back	= (byte*)mem_alloc_4k(memman, binfo->scrnx * binfo->scrny);
	buf_win		= (byte*)mem_alloc_4k(memman, WIN_XS * WIN_YS);
	sheet_setbuf(sheet_back, buf_back, binfo->scrnx, binfo->scrny, -1);
	sheet_setbuf(sheet_mouse, buf_mouse, 16, 16, 99);
	sheet_setbuf(sheet_win, buf_win, WIN_XS, WIN_YS, -1);

	init_screen(buf_back, binfo->scrnx, binfo->scrny);
	init_mouse_cursor(buf_mouse, 99);

	make_window(buf_win, WIN_XS, WIN_YS, "counter");

	sheet_slide(sheet_back, 0, 0);
	sheet_slide(sheet_mouse, mx, my);
	sheet_slide(sheet_win, 80, 72);	
	sheet_updown(sheet_back, 0);
	sheet_updown(sheet_win, 1);
	sheet_updown(sheet_mouse, 2);

	lsprintf(s, "memory %dMB   free : %dKB", memtotal / (1024*1024),
				mem_total(memman) / 1024);
	vprint(buf_back, s, binfo->scrnx, 0, 32, COL_FFFFFF);

	sheet_refresh(sheet_back, 0, 32, binfo->scrnx, 48);

	while(1) {
		// 時間表示
		lsprintf(s, "%d", timerctl.count);
		boxfill(buf_win, WIN_XS, COL_C6C6C6, 40, 28 ,119, 43);
		vprint(buf_win, s, WIN_XS, 40, 28, COL_000000);
		sheet_refresh(sheet_win, 40, 28, 120, 44);

		io_cli();
		// キーボードとマウスとタイマからデータを受け取っていない
		if(	queue_status(&qKeyboard)
		+	queue_status(&qMouse)
		+	queue_status(&qTimer1)
		+	queue_status(&qTimer2)
		+	queue_status(&qTimer3) == 0) {
			io_sti();
		// キーボードかマウスからデータを受け取っている
		} else {
			// キーボードからデータを受信
			if(queue_status(&qKeyboard)) {
				i = queue_get(&qKeyboard);
				io_sti();
				boxfill(buf_back, binfo->scrnx, COL_008484, 0, 16, 15, 31);
				lsprintf(s, "%X", i);
				vprint(buf_back, s, binfo->scrnx, 0, 16, COL_FFFFFF);
				sheet_refresh(sheet_back, 0, 16, 16, 32);
			// マウスかデータを受信
			} else if(queue_status(&qMouse)) {
				i = queue_get(&qMouse);
				io_sti();
				// マウスデータが3バイト揃う
				if(mouse_decode(&mdec, i)) {
					// データの表示
					lsprintf(s, "[lcr] x=%d y=%d", mdec.x, mdec.y);
					if((mdec.button & 0x01) != 0) s[1] = 'L';
					if((mdec.button & 0x02) != 0) s[3] = 'R';
					if((mdec.button & 0x03) != 0) s[2] = 'C';
					boxfill(buf_back, binfo->scrnx, COL_008484, 32, 16, 32+30*8-1, 31);
					vprint(buf_back, s, binfo->scrnx, 32, 16, COL_FFFFFF);
					sheet_refresh(sheet_back, 32, 16, 32+30*8, 32);

					// マウスの移動
					// マウスカーソルの消去
					mx += mdec.x; my += mdec.y;
					if(mx < 0) mx = 0;
					if(my < 0) my = 0;
					if(mx > binfo->scrnx - 1) mx = binfo->scrnx - 1;
					if(my > binfo->scrny - 1) my = binfo->scrny - 1;
					sheet_slide(sheet_mouse, mx, my);
				}
			} else if(queue_status(&qTimer1)) {
				i = queue_get(&qTimer1);
				io_sti();
				vprint(buf_back, "10[sec]", binfo->scrnx, 0, 64, COL_FFFFFF);
				sheet_refresh(sheet_back, 0, 64, 56, 80);
			} else if(queue_status(&qTimer2)) {
				i = queue_get(&qTimer2);
				io_sti();
				vprint(buf_back, "3[sec]", binfo->scrnx, 0, 80, COL_FFFFFF);
				sheet_refresh(sheet_back, 0, 80, 48, 96);
			} else if(queue_status(&qTimer3)) {
				i = queue_get(&qTimer3);
				io_sti();
				if(i != 0) {
					timer_init(timer3, &qTimer3, 0);
					boxfill(buf_back, binfo->scrnx, COL_FFFFFF, 8, 96, 15, 111);
				} else {
					timer_init(timer3, &qTimer3, 1);
					boxfill(buf_back, binfo->scrnx, COL_008484, 8, 96, 15, 111);
				}
				timer_settime(timer3, 50);
				sheet_refresh(sheet_back, 8, 96, 16, 112);
			}
		}
	}
}

void make_window(byte * buf, int xsize, int ysize, char *title) {
	static char closebtn[14][16] = {
		"OOOOOOOOOOOOOOO@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQ@@QQQQ@@QQ$@",
		"OQQQQ@@QQ@@QQQ$@",
		"OQQQQQ@@@@QQQQ$@",
		"OQQQQQQ@@QQQQQ$@",
		"OQQQQQ@@@@QQQQ$@",
		"OQQQQ@@QQ@@QQQ$@",
		"OQQQ@@QQQQ@@QQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"O$$$$$$$$$$$$$$@",
		"@@@@@@@@@@@@@@@@"
	};
	int x, y;
	char c;
	boxfill(buf, xsize, COL_C6C6C6, 0,		0,		xsize-1,0		);
	boxfill(buf, xsize, COL_FFFFFF, 1,		1,		xsize-2,1		);
	boxfill(buf, xsize, COL_C6C6C6, 0,		0,		0,		ysize-1	);
	boxfill(buf, xsize, COL_FFFFFF, 1,		1,		1,		ysize-2	);
	boxfill(buf, xsize, COL_848484, xsize-2,1,		xsize-2,ysize-2	);
	boxfill(buf, xsize, COL_000000, xsize-1,0,		xsize-1,ysize-1	);
	boxfill(buf, xsize, COL_C6C6C6, 2,		2,		xsize-3,ysize-3	);
	boxfill(buf, xsize, COL_000084, 3,		3,		xsize-4,20		);
	boxfill(buf, xsize, COL_848484, 1,		ysize-2,xsize-1,ysize-2	);
	boxfill(buf, xsize, COL_000000, 0,		ysize-1,xsize-1,ysize-1	);

	vprint(buf, title, xsize, 24, 4, COL_FFFFFF);

	for(y = 0; y < 14; y++)
	for(x = 0; x < 16; x++) {
		c = closebtn[y][x];
		switch(c) {
			case '@':
				c = COL_000000; break;
			case '$':
				c = COL_848484; break;
			case 'Q':
				c = COL_C6C6C6; break;
			default:
				c = COL_FFFFFF;
		}
		buf[(5+y)*xsize + (xsize-21+x)] = c;
	}
}
