#include "def.h"
#include "prot.h"

TIMER_CTL timerctl;

#define PIT_CTRL	0x0043
#define PIT_CNT0	0x0040

void init_pit() {
	int i;
	io_out8(PIT_CTRL, 0x34);
	io_out8(PIT_CNT0, 0x9c);
	io_out8(PIT_CNT0, 0x2e);
	timerctl.count = 0;
	timerctl.next = 0xffffffff;
	timerctl.used = 0;
	for(i = 0; i < MAX_TIMERS; i++) {
		timerctl.timers0[i].flags = 0;	// 未使用マーク
	}
}

#define TIMER_FLAGS_ALLOC	1	// 確保状態
#define TIMER_FLAGS_USING	2	// 動作中

void hInt20(int *esp) {
	int i, j;
	io_out8(PIC0_OCW2, 0x60);	// IRQ-00受付完了をPICに通知
	timerctl.count++;
	// まだ次の時刻になっていない
	if(timerctl.next > timerctl.count) return;

	for(i = 0; i < timerctl.used; i++) {
		if(timerctl.timers[i]->timeout > timerctl.count) {
			break;
		}
		// タイムアウト
		timerctl.timers[i]->flags = TIMER_FLAGS_ALLOC;
		queue_put(timerctl.timers[i]->queue, timerctl.timers[i]->data);
	}
	timerctl.used -= i;
	for(j = 0; j < timerctl.used; j++) {
		timerctl.timers[j] = timerctl.timers[i + j];
	}

	if(timerctl.used > 0) {
		timerctl.next = timerctl.timers[0]->timeout;
	} else {
		timerctl.next = 0xffffffff;
	}
}

TIMER *timer_alloc() {
	int i;
	for(i = 0; i < MAX_TIMERS; i++) {
		if(timerctl.timers0[i].flags == 0) {
			timerctl.timers0[i].flags = TIMER_FLAGS_ALLOC;
			return &timerctl.timers0[i];
		}
	}
	return 0;
}

void timer_free(TIMER *timer) { timer->flags = 0; }

void timer_init(TIMER *timer, QUEUE *queue, byte data) {
	timer->queue = queue;
	timer->data = data;
}

void timer_settime(TIMER *timer, dword timeout) {
	int e, i, j;

	timer->timeout = timeout + timerctl.count;
	timer->flags = TIMER_FLAGS_USING;	// 使用中マーク
	e = io_load_eflags();
	io_cli();
	// タイマを入れる場所を検索する
	for(i = 0; i < timerctl.used; i++) {
		if(timerctl.timers[i]->timeout >= timer->timeout) {
			break;
		}
	}
	timerctl.used++;

	// 後ろをずらす
	for(j = timerctl.used; j > i; j--) {
		timerctl.timers[j] = timerctl.timers[j - 1];
	}

	// 開いた隙間に入れる
	timerctl.timers[i] = timer;
	timerctl.next = timerctl.timers[0]->timeout;
	io_store_eflags(e);
}
