# NOTICE
# 'is_active_output' property doesn't seem possible to work consistently on ver2.93 or lower.
# fixed on ver3.2 or later.

import bpy
from bpy.props import (
    IntProperty,
    FloatProperty,
    FloatVectorProperty,
    EnumProperty,
    BoolProperty,
)

bl_info = {
    "name": "Material swicher",
    "author": "Kanemori Yasuda",
    "version": (0, 2),
    "blender": (3, 3, 0),
    "location": "",
    "description": "Switch OUTPUT MATERIAL nodes in all materials in the scene",
    "warning": "This add-on is test version",
    "support": "TESTING",
    "doc_url": "",
    "tracker_url": "http://kanemori.blog.shinobi.jp/",
    "category": "Material"
}

#GLOBAL
MTGT = 0 #target OUTPUT_MATERIAL row
MMAX = 1 #max OUTPUT_MATERIAL row
AOMNS = [] #Activatable OUTPUT MATERIAL nodes


def activatable_OUTPUT_MATERIAL(materialNodes):

    outputMat = []
    outputMatY = []

    # to serch OUTPUT_MATERIAL nodes
    for n in materialNodes:
        try:
            if n.type == 'OUTPUT_MATERIAL':
                outputMat.append(n)
        except:
            continue

    #to sort OUTPUT_MATERIAL nodes that location is more higher
    def coordinateY(n):        
        locY = n.location.y
        while n.parent != None:
           locY += n.parent.location.y
           n = n.parent
        return  locY

    outputMatY = sorted(outputMat,key=coordinateY,reverse=True)
    return outputMatY


#loop of material_slots each objects
def collect_OUTPUT_MATERIAL(os1):

    aomns1 = []
    aomn1_counts = [] 

    for i in os1:
        for j in i.material_slots:
            try:
                aomn1 = activatable_OUTPUT_MATERIAL(j.material.node_tree.nodes) 
            except:
                continue
                
            aomns1.append(aomn1)
            aomn1_counts.append(len(aomn1))

    aomn1_counts.append(0) #if it was no materials,Return zero
    return aomns1, max(aomn1_counts)


#to activate OUTPUT_MATERIAL nodes
def activate_OUTPUT_MATERIAL(aomns1,mtgt1):

    for i in aomns1:
        if mtgt1 < len(i):
            mrow = mtgt1
        else:
            mrow = len(i) - 1
        try:
            i[mrow].is_active_output = True
        except:
            continue

class MMR_OT_Switch(bpy.types.Operator):

    bl_idname = "object.mmr_switch"
    bl_label = "Switch Material Row"
    bl_description = "Reload number of material row"
    bl_options = {'UNDO'}

    materialRow_enum : bpy.props.EnumProperty(
        name = "",
        description = "Switch a material row",
        items = [ 
            ('0', "Material Row0", "" ),
            ('1', "Material Row1", "" ),
            ('2', "Material Row2", "" ),
            ('3', "Material Row3", "" ),
            ('4', "Material Row4", "" ),
            ('5', "Material Row5", "" ),
            ('6', "Material Row6", "" ),
            ('7', "Material Row7", "" ),
            ('8', "Material Row8", "" ),
            ('9', "Material Row9", "" ),
        ]
    )
    
    def invoke(self, context, event):
        wm = context.window_manager
        return wm.invoke_props_dialog(self)

    def draw(self, context):
        layout = self.layout
        layout.prop(self, "materialRow_enum")
    
    
    def execute(self, context):
        MTGT = int(self.materialRow_enum)        

        m = collect_OUTPUT_MATERIAL(bpy.data.objects)
        AOMNS = m[0]
        MMAX = m[1]

        if MMAX > 0:
            activate_OUTPUT_MATERIAL(AOMNS, MTGT)        

        return {'FINISHED'}


class MMR_PT_CustomPanel(bpy.types.Panel):

    bl_label = "Material Switcher"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "KYTools"

    #header
    def draw_header(self, context):
        layout = self.layout
        layout.label(text="", icon='MATERIAL_DATA')

    #menu
    def draw(self, context):
        layout = self.layout
        scene = context.scene
        
        #button
        layout.operator(MMR_OT_Switch.bl_idname, text="Switch Material Row")

    
classes = [
    MMR_OT_Switch,
    MMR_PT_CustomPanel,
]


def register():
    for c in classes:
        bpy.utils.register_class(c)

def unregister():
    for c in classes:
        bpy.utils.unregister_class(c)

if __name__ == "__main__":
    register()