
--Clothoid Maker
--by Kanemori Yasuda
--https://kanemori.blog.shinobi.jp/
--version 1.1.1 May.12.2024

macroscript KY_clothoidMaker
ButtonText:"clothoidMaker"
Category:"KYTools"

(
uni = (rootScene[#Populate].Populate.controller.internalScale)

struct clo_st
(
	R,
	T,
	Er,
	divi,
	Ltype,
	op
)

fn drawSpline v divi op =
(
	sp1 = SplineShape()
	addNewSpline sp1
	addKnot sp1 1 #smooth #curve v[1]

	for i = 1 to divi do
	(
		addKnot sp1 1 #smooth #curve v[i + 1]
		updateShape sp1
	)

	sp1.pos = op
	return sp1
)

fn drawNURBS v divi op =
(
	nset = NURBSSet () 
	npc = NURBSPointCurve numPoints:(divi + 1) 
	setPoint npc 1 (NURBSIndependentPoint v[1])

	for i = 1 to divi do
	(
		setPoint npc (i + 1) (NURBSIndependentPoint v[i + 1])
	)

	appendObject nset npc
	n1 = NURBSNode nset name:"Curve"
	n2 = copy n1
	delete n1
	n2.pos = op
	return n2
)

fn clothoid_xy0 A tau Er =
(
	c = [0,0,0]

	s = 1.0
	pk = 1.0
	k = 1.0
	xk = A * sqrt(2.0 * tau)
	xo = 0.0
	x = xk * s

	while  abs(x - xo) > Er do
	(
		xo = x
		k = k + 1
		pk = pk * (-1) / ((2 * k - 2)*(2 * k - 3)) * tau * tau
		qk = pk / (4 * k - 3)
		s = s + qk
		x = xk * s
	)
	c.x = x

	s = 1.0 / 3.0 
	pk = 1.0
	k = 1.0
	yk = A * tau * sqrt(2 * tau)
	yo = 0.0
	y = yk * s

	while  abs(y - yo) > Er do
	(
		yo = y
		k = k + 1
		pk = pk * (-1) / ((2 * k - 1)*(2 * k - 2)) * tau * tau
		qk = pk / (4 * k - 1)
		s = s + qk
		y = yk * s
	)
	c.y = y
	
	return c
)

fn makeClothoid clo_p =
(
	R = clo_p.R
	T = clo_p.T
	divi = clo_p.divi
	Er = clo_p.Er
	Ltype = clo_p.Ltype
	L = T * 2 * R
	A = sqrt(L * R)
	op = clo_p.op

	v = #()
	v[1] = [0,0,0]

	for i = 1 to divi do
	(
		Li = L / divi * i
		Ri = A * A / Li
		tau = Li / (2 * abs(Ri))
		v[i + 1] = clothoid_xy0 A tau Er
	)

	case Ltype of
	(
		1:	drawSpline v divi op
		2:	drawNURBS v divi op
	)

	return v[divi + 1]
)

fn makeCircle cir_p =
(
	R = cir_p.R
	T = cir_p.T
	divi = cir_p.divi
	Ltype = cir_p.Ltype

	v = #()
	v[1] = [R * cos T,R * sin T,0]
	op = cir_p.op - v[1]

	if divi == 0 then divi = 1

	for i = 1 to divi do
	(
		theta = T + 360.0 / divi * i
		v[i + 1] = [R * cos theta,R * sin theta,0]
	)

	case Ltype of
	(
		1:	drawSpline v divi op
		2:	drawNURBS v divi op
	)
)

fn makeLine lin_p =
(
	R = lin_p.R
	divi = lin_p.divi
	Ltype = lin_p.Ltype

	v = #()
	v[1] = [0,0,0]
	op = lin_p.op - v[1]

	if divi == 0 then divi = 1

	for i = 1 to divi do
	(
		x = - R / divi * i
		v[i + 1] = [x,0,0]
	)

	case Ltype of
	(
		1:	drawSpline v divi op
		2:	drawNURBS v divi op
	)
)

rollout clothoidUI "Clothoid Maker"
(

	label ui_L0 ""
	spinner ui_R "Target Radius:" range:[1.0,uni * 1000000,uni * 2000] type:#worldunits
	spinner ui_T "Target Angle:" range:[1.0,720.0,90.0]
	spinner ui_divi "Vertices:" range:[1,100,12] type:#integer
	spinner ui_acu "Accuracy:" range:[1,10,3] type:#integer
	label ui_L1 "Curve Type:" across:2
	radiobuttons ui_Ltype "" labels:#("Spline" , "NURBS") default:2 columns:1
	checkbox ui_cir "Continuation Circle" checked:true
	checkbox ui_lin "Continuation Line" checked:true
	button ui_draw "Draw" width:180 height:28

	on ui_draw pressed do
	(
		clo_o = [0,0,0]
		clo_p = clo_st()
		cir_p = clo_st()
		lin_p = clo_st()
		
		clo_p.R = ui_R.value
		clo_p.T = degToRad ui_T.value
		clo_p.divi = ui_divi.value
		clo_p.Er = clo_p.R / (pow 10 ui_acu.value)
		clo_p.Ltype = ui_Ltype.state
		clo_p.op = clo_o

		clo = makeClothoid clo_p

		if ui_cir.checked then
		(
			cir_p.R = ui_R.value
			cir_p.T = ui_T.value - 90.0
			cir_p.divi = (ui_divi.value / ui_T.value * 180) as Integer
			cir_p.Ltype =  ui_Ltype.state
			cir_p.op = clo_o + clo

			makeCircle cir_p
		)

		if ui_lin.checked then
		(
			lin_p.R = ui_R.value * 2.0
			lin_p.divi = (ui_divi.value / ui_T.value * 180 / pi) as Integer
			lin_p.Ltype =  ui_Ltype.state
			lin_p.op = clo_o

			makeLine lin_p
		)
	)
)

CreateDialog clothoidUI width:200 height:220

)

