--findZeroAreaPoly
--by Kanemori Yasuda September.12.2022
--version 1.1.0 April.28.2023

macroscript KY_findZeroAreaPoly
ButtonText:"findZeroAreaPoly"
Category:"KYTools"
(

fn fzap_main base_obj face_area_min =
(
local face_selection = #{}
local vertex_current = #{}
local num_faces = polyop.getNumFaces base_obj
local face_area = 0.0
local face_area_part = 0.0

for f = 1 to num_faces do
(
	face_area = 0.0
	vertex_current = polyop.getFaceVerts base_obj f
	
	for v = 1 to vertex_current.count - 2 do
	(	
		p1 = polyop.getVert base_obj vertex_current[1]
		p2 = polyop.getVert base_obj vertex_current[2]
		p3 = polyop.getVert base_obj vertex_current[3]
		
		face_area += 0.5 * length(cross (p1 - p2) (p1 - p3))
	)
--	print face_area
	if face_area < face_area_min then face_selection[f] = true		
)
polyop.setFaceSelection base_obj face_selection
max modify mode
modPanel.setCurrentObject base_obj
subobjectlevel = 4
)

rollout fzap_UI "findZeroAreaPoly"
(
	label ui_text "Select one Editable Poly then execute !"
	spinner ui_A "Smaller than SquareUnits:" range:[0.0,100.0,0.001] type:#float scale:0.001
	button ui_execute "Execute" width:136 height:20

	on ui_execute pressed do
	(
		if (selection.count == 1 and classOf selection[1].baseobject == Editable_Poly) then
		(
			fzap_main $.baseobject ui_A.value
		)
	)
)

fzap_Panel = newRolloutFloater "findZeroAreaPoly" 300 100
addRollout fzap_UI fzap_Panel

)