
--Rename Layers
--by Kanemori Yasuda
--https://kanemori.blog.shinobi.jp/
--version 1.0.1 May.11.2024
--version 1.1.0 May.12.2024

macroscript KY_renameLayers
ButtonText:"renameLayers"
Category:"KYTools"

(


fn rl_main rlParam =
(		
	layers = #()
	newLayerName = #()
	strCheck = false
	refCheck = false
	dupCheck = false
	
	items = (SceneExplorerManager.GetActiveExplorer()).SelectedItems()
	for i in items where isKindOf i Base_Layer do
	(
		append layers i
	)

	for i in layers do
	(
		tempName = i.name
		
		tempName = substituteString tempName rlParam.tgtStr rlParam.repStr
		
		if rlParam.removeFirstCheck then
		(
			tempName = substring tempName (rlParam.removeFirstDigits +1) tempName.count
		)
		
		if rlParam.removeLastCheck then
		(
			tempName = substring tempName 1 (tempName.count - rlParam.removeLastDigits) 
		)
		
		if tempName == "" then (strCheck  = true)
		if i.hasSceneXRefNodesInHierarchy() then (refCheck  = true)
		
		if rlParam.prefixCheck then
		(
			tempName = rlParam.prefixText + tempName
		)
		
		if rlParam.suffixCheck then		
		(
			tempName = tempName +  rlParam.suffixText
		)

		append newLayerName tempName
	)
	
	for j in newLayerName do
	(
		dc = 0
		for k in newLayerName do
		(
			if j == k then dc +=1
		)
		if dc > 1 then (dupCheck = true)
	)

	if strCheck then print "Digit number error"
	if refCheck then print "Some layers including reference objects are selected."
	if dupCheck then print "Duplicate layer names exist."	
	
	if not(strCheck or refCheck or dupCheck) then
	(
		for m = 1 to layers.count do
		(
--		print newLayerName[m]
--		print layers[m].name
		layers[m].setname(newLayerName[m])
		)
	)
)

	
rollout rl_UI "renameLayers"
(	

	struct renameParam
	(		
		tgtStr,
		repStr,
		
		prefixCheck,
		prefixText,
		removeFirstCheck,
		removeFirstDigits,
		
		suffixCheck,
		suffixText,
		removeLastCheck,
		removeLastDigits
	)	
	
	label ui_lab0 ""
	edittext ui_tgt_tx "Target String:"  align:#left labelOnTop:true across:2
	edittext ui_rep_tx "Replace String:" align:#left labelOnTop:true
	label ui_lab1 ""	
	checkbox ui_px_txch "Prefix:" across:2
	edittext ui_px_tx align:#left
	checkbox ui_px_nuch "Remove First:" across:2
	spinner ui_px_nu "Digits" type:#integer 
	label ui_lab2 ""
	checkbox ui_sx_txch "Suffix:" across:2
	edittext ui_sx_tx align:#left
	checkbox ui_sx_nuch "Remove Last:" across:2
	spinner ui_sx_nu "Digits" type:#integer 
	label ui_lab3 ""
	button ui_execute "Rename" width:180 height:30

	on ui_execute pressed do
	(
		
		rlParam = renameParam()
		
		rlParam.tgtStr = ui_tgt_tx.text
		rlParam.repStr = ui_rep_tx.text
		
		rlParam.prefixCheck = ui_px_txch.checked
		rlParam.prefixText = ui_px_tx.text
		
		rlParam.removeFirstCheck = ui_px_nuch.checked
		rlParam.removeFirstDigits = ui_px_nu.value
		
		rlParam.suffixCheck =  ui_sx_txch.checked
		rlParam.suffixText = ui_sx_tx.text
		
		rlParam.removeLastCheck = ui_sx_nuch.checked
		rlParam.removeLastDigits = ui_sx_nu.value
		
		rl_main rlParam
	)
)

CreateDialog rl_UI width:200 height:250

)


