﻿Public Class Form1
    Private Sub FileToolStripMenuItem_DropDownOpening(ByVal sender As Object, ByVal e As System.EventArgs) Handles FileToolStripMenuItem.DropDownOpening
        If TreeView1.SelectedNode Is Nothing Then
            'メニューを無効にする
            '上書き保存・名前を付けて保存
            SaveToolStripMenuItem.Enabled = False
            SaveAsToolStripMenuItem.Enabled = False
            CloseToolStripMenuItem.Enabled = False

        Else
            'メニューを有効にする
            '上書き保存・名前を付けて保存
            SaveToolStripMenuItem.Enabled = True
            SaveAsToolStripMenuItem.Enabled = True
            CloseToolStripMenuItem.Enabled = True

        End If

    End Sub

    Private Function AddTreeNode(ByVal _FileInfo As FileInfo, ByVal _ID3v2 As ID3v2_30.ID3v2) As TreeNode
        'ファイル
        Dim _FileInfoNode As TreeNode

        _FileInfoNode = TreeView1.Nodes.Add(_FileInfo.FullName, _FileInfo.Name)
        _FileInfoNode.Tag = _FileInfo

        'ID3v2
        Dim _TreeNode As TreeNode

        _TreeNode = _FileInfoNode.Nodes.Add(_ID3v2.GetType.Name)
        _TreeNode.Tag = _ID3v2

        '拡張ヘッダ
        Dim _ID3v2ExtendedHeaderNode As TreeNode

        If _ID3v2.IsExtendedHeader Then
            _ID3v2ExtendedHeaderNode = _TreeNode.Nodes.Add(_ID3v2.ID3v2ExtendedHeader.GetType.Name)
            _ID3v2ExtendedHeaderNode.Tag = _ID3v2.ID3v2ExtendedHeader

        End If

        'ID3v2 フレーム群
        Dim _ID3v2FramesNode As TreeNode

        _ID3v2FramesNode = _TreeNode.Nodes.Add(_ID3v2.ID3v2Frames.GetType.Name)
        _ID3v2FramesNode.Tag = _ID3v2.ID3v2Frames

        'ID3v2 フレーム
        Dim _ID3v2FrameNode As TreeNode

        For Each _ID3v2Frame As ID3v2_30.ID3v2Frame In _ID3v2.ID3v2Frames
            _ID3v2FrameNode = _ID3v2FramesNode.Nodes.Add(_ID3v2Frame.GetType.Name)
            _ID3v2FrameNode.Tag = _ID3v2Frame

        Next

        'オーディオデータ
        Dim _AudioDataNode As TreeNode

        _AudioDataNode = _TreeNode.Nodes.Add(_ID3v2.AudioData.GetType.Name)
        _AudioDataNode.Tag = _ID3v2.AudioData

        Return _FileInfoNode

    End Function

    Private Function AddTreeNode(ByVal _FileInfo As FileInfo, ByVal _ID3v2 As ID3v240.ID3v2) As TreeNode
        'ファイル
        Dim _FileInfoNode As TreeNode

        _FileInfoNode = TreeView1.Nodes.Add(_FileInfo.FullName, _FileInfo.Name)
        _FileInfoNode.Tag = _FileInfo

        'ID3v2
        Dim _TreeNode As TreeNode

        _TreeNode = _FileInfoNode.Nodes.Add(_ID3v2.GetType.Name)
        _TreeNode.Tag = _ID3v2

        '拡張ヘッダ
        Dim _ID3v2ExtendedHeaderNode As TreeNode

        If _ID3v2.IsExtendedHeader Then
            _ID3v2ExtendedHeaderNode = _TreeNode.Nodes.Add(_ID3v2.ExtendedHeader.GetType.Name)
            _ID3v2ExtendedHeaderNode.Tag = _ID3v2.ExtendedHeader

        End If

        'ID3v2 フレーム群
        Dim _ID3v2FramesNode As TreeNode

        _ID3v2FramesNode = _TreeNode.Nodes.Add(_ID3v2.ID3v2Frames.GetType.Name)
        _ID3v2FramesNode.Tag = _ID3v2.ID3v2Frames

        'ID3v2 フレーム
        Dim _ID3v2FrameNode As TreeNode

        For Each _ID3v2Frame As ID3v240.ID3v2Frame In _ID3v2.ID3v2Frames
            _ID3v2FrameNode = _ID3v2FramesNode.Nodes.Add(_ID3v2Frame.GetType.Name)
            _ID3v2FrameNode.Tag = _ID3v2Frame

        Next

        'オーディオデータ
        Dim _AudioDataNode As TreeNode

        _AudioDataNode = _TreeNode.Nodes.Add(_ID3v2.AudioData.GetType.Name)
        _AudioDataNode.Tag = _ID3v2.AudioData

        Return _FileInfoNode

    End Function

    Private Sub OpenToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OpenToolStripMenuItem.Click
        Dim _OpenFileDialog As OpenFileDialog

        _OpenFileDialog = New OpenFileDialog

        _OpenFileDialog.Filter = " (*.mp3)|*.mp3|All Files (*.*)|*.*"

        If _OpenFileDialog.ShowDialog = DialogResult.OK Then
            Dim _FileName As String

            _FileName = _OpenFileDialog.FileName

            '既存の開いたファイルかを確認する
            If TreeView1.Nodes.ContainsKey(_FileName) Then
                Exit Sub

            End If

            Dim _FileInfo As FileInfo

            _FileInfo = New FileInfo(_FileName)

            Dim _FileStream As FileStream

            _FileStream = New FileStream(_FileInfo.FullName, FileMode.Open)

            Dim _ID3v2Reader As ID3v2_30.ID3v2Reader

            _ID3v2Reader = New ID3v2_30.ID3v2Reader(_FileStream)

            Dim _ID3v2 As ID3v2_30.ID3v2

            Dim _RootNode As TreeNode

            Try
                _ID3v2 = _ID3v2Reader.Read

                'ノードを追加
                _RootNode = AddTreeNode(_FileInfo, _ID3v2)

                'ノードを選択
                TreeView1.SelectedNode = _RootNode

                'ノードを展開
                _RootNode.ExpandAll()

            Catch _ID3v2Exception As ID3v2_30.ID3v2Exception
                'MessageBox.Show(_ID3v2Exception.Message, My.Application.Info.Title, MessageBoxButtons.OK, MessageBoxIcon.Warning)

                Dim _ID3v240Reader As ID3v240.ID3v2Reader

                'ストリームの位置を初期化
                _FileStream.Seek(0, SeekOrigin.Begin)

                _ID3v240Reader = New ID3v240.ID3v2Reader(_FileStream)

                Dim _ID3v240 As ID3v240.ID3v2

                Try
                    _ID3v240 = _ID3v240Reader.Read

                    'ノードを追加
                    _RootNode = AddTreeNode(_FileInfo, _ID3v240)

                    'ノードを選択
                    TreeView1.SelectedNode = _RootNode

                    'ノードを展開
                    _RootNode.ExpandAll()

                Catch _ID3v2NotSupportedException As ID3v240.ID3v2NotSupportedException
                    MessageBox.Show(_ID3v2NotSupportedException.Message, My.Application.Info.Title, MessageBoxButtons.OK, MessageBoxIcon.Warning)

                End Try

            End Try


        End If

    End Sub

    Private Sub SaveToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveToolStripMenuItem.Click
        '選択されたノードのルートノードを取得する
        Dim _TreeNode As TreeNode

        _TreeNode = TreeView1.SelectedNode

        Dim _RootNode As TreeNode

        _RootNode = _TreeNode.RootNode()

        Dim _FileInfo As FileInfo

        _FileInfo = _RootNode.Tag

    End Sub

    Private Sub SaveAsToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveAsToolStripMenuItem.Click
        '選択されたノードのルートノードを取得する
        Dim _TreeNode As TreeNode

        _TreeNode = TreeView1.SelectedNode

        Dim _RootNode As TreeNode

        _RootNode = _TreeNode.RootNode()

        '選択されたノードのファイルノードを取得する
        Dim _FileInfo As FileInfo

        _FileInfo = _RootNode.Tag

        '選択されたノードの ID3v2 ノードを取得する
        Dim _ID3v2Node As TreeNode

        _ID3v2Node = _RootNode.Nodes.Item(0)

        'ファイル保存ダイアログ
        Dim _SaveFileDialog As SaveFileDialog

        _SaveFileDialog = New SaveFileDialog

        _SaveFileDialog.Filter = " (*.mp3)|*.mp3|All Files (*.*)|*.*"

        _SaveFileDialog.InitialDirectory = _FileInfo.DirectoryName

        _SaveFileDialog.FileName = _FileInfo.Name

        If _SaveFileDialog.ShowDialog = DialogResult.OK Then



            _FileInfo = New FileInfo(_SaveFileDialog.FileName)

            Dim _FileStream As FileStream

            _FileStream = New FileStream(_FileInfo.FullName, FileMode.Create)

            Dim _ID3v230Writer As ID3v2_30.ID3v2Writer
            Dim _ID3v240Writer As ID3v240.ID3v2Writer

            Dim _ID3v230 As ID3v2_30.ID3v2
            Dim _ID3v240 As ID3v240.ID3v2

            Select Case _ID3v2Node.Tag.GetType.ToString
                Case "ID3v2Lib.ID3v2_30.ID3v2"
                    _ID3v230Writer = New ID3v2_30.ID3v2Writer(_FileStream)
                    _ID3v230 = _ID3v2Node.Tag
                    _ID3v230Writer.Write(_ID3v230)

                Case "ID3v2Lib.ID3v240.ID3v2"
                    _ID3v240Writer = New ID3v240.ID3v2Writer(_FileStream)
                    _ID3v240 = _ID3v2Node.Tag
                    _ID3v240Writer.Write(_ID3v240)

            End Select

            '基底ノードの内容を更新する
            _RootNode.Name = _FileInfo.FullName
            _RootNode.Text = _FileInfo.Name
            _RootNode.Tag = _FileInfo

        End If

    End Sub

    Private Sub CloseToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CloseToolStripMenuItem.Click

        Dim _SelectedNode As TreeNode

        _SelectedNode = TreeView1.SelectedNode

        Dim _RootNode As TreeNode

        _RootNode = _SelectedNode.RootNode

        _RootNode.Remove()

        If TreeView1.SelectedNode Is Nothing Then
            PropertyGrid1.SelectedObject = Nothing

        End If

    End Sub

    Private Sub QuitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles QuitToolStripMenuItem.Click
        Application.Exit()

    End Sub

    Private Sub AboutToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AboutToolStripMenuItem.Click
        Dim _AssemblyInfo As AssemblyInfo

        _AssemblyInfo = My.Application.Info

        Dim _Version As Version

        _Version = My.Application.Info.Version

        MessageBox.Show(
            _AssemblyInfo.CompanyName & " " & _AssemblyInfo.ProductName & Environment.NewLine &
            "Ver. " & _Version.Major & "." & _Version.Minor & " Build " & _Version.Build & " Rev. " & _Version.Revision & Environment.NewLine &
            _AssemblyInfo.Copyright & Environment.NewLine &
            Environment.NewLine &
            _AssemblyInfo.Description,
            My.Application.Info.Title,
            MessageBoxButtons.OK,
            MessageBoxIcon.Information)

    End Sub

    Private Sub EditToolStripMenuItem_DropDownOpening(ByVal sender As Object, ByVal e As System.EventArgs) Handles EditToolStripMenuItem.DropDownOpening
        Dim _ID3v230FrameType As Type

        _ID3v230FrameType = GetType(ID3v2_30.ID3v2Frame)

        Dim _ID3v240FrameType As Type

        _ID3v240FrameType = GetType(ID3v240.ID3v2Frame)

        Dim _ID3v230FramesType As Type

        _ID3v230FramesType = GetType(ID3v2_30.ID3v2Frames)

        Dim _ID3v240FramesType As Type

        _ID3v240FramesType = GetType(ID3v240.ID3v2Frames)

        Dim _SelectedType As Type

        If TreeView1.SelectedNode Is Nothing Then
            '選択されたノードが無い時
            AddToolStripMenuItem.Enabled = False
            DeleteToolStripMenuItem.Enabled = False

        Else
            _SelectedType = TreeView1.SelectedNode.Tag.GetType

            Select Case True
                Case _SelectedType.IsSubclassOf(_ID3v230FrameType),
                     _SelectedType.IsSubclassOf(_ID3v240FrameType)
                    '選択されたノードが ID3v2 フレームの時
                    AddToolStripMenuItem.Enabled = True
                    DeleteToolStripMenuItem.Enabled = True

                Case _SelectedType = _ID3v230FramesType,
                     _SelectedType = _ID3v240FramesType
                    '選択されたノードが ID3v2 フレーム群の時
                    AddToolStripMenuItem.Enabled = True

                Case Else
                    '選択されたノードがそれ以外の時
                    AddToolStripMenuItem.Enabled = False
                    DeleteToolStripMenuItem.Enabled = False

            End Select

        End If

    End Sub

    Private Sub AddToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AddToolStripMenuItem.Click
        Select True
            Case TreeView1.SelectedNode.Tag.GetType.IsSubclassOf(GetType(ID3v2_30.ID3v2Frame))
                Form2.Mode = Form2.DialogMode.ID3v230

            Case TreeView1.SelectedNode.Tag.GetType.IsSubclassOf(GetType(ID3v2_30.ID3v2Frame))
                Form2.Mode = Form2.DialogMode.ID3v240

        End Select

        If Form2.ShowDialog = Windows.Forms.DialogResult.OK Then
            If Not Form2.TreeNode Is Nothing Then
                'ツリーノードの追加
                Dim _Index As Integer

                _Index = TreeView1.SelectedNode.Index + 1

                Dim _TreeNode As TreeNode

                _TreeNode = Form2.TreeNode

                Dim _ParentNode As TreeNode

                _ParentNode = TreeView1.SelectedNode.Parent

                _ParentNode.Nodes.Insert(_Index, _TreeNode)


                'ID3v2 フレームの追加
                Dim _ID3v230Frames As ID3v2_30.ID3v2Frames
                Dim _ID3v2Frames As ID3v240.ID3v2Frames
                Dim _SelectedID3v2FrameIndex As Integer
                Dim _NewID3v230Frame As ID3v2_30.ID3v2Frame
                Dim _NewID3v2Frame As ID3v240.ID3v2Frame



                Select Case Form2.Mode
                    Case Form2.DialogMode.ID3v230
                        _ID3v230Frames = _ParentNode.Tag

                        _SelectedID3v2FrameIndex = _ID3v230Frames.IndexOf(DirectCast(TreeView1.SelectedNode.Tag, ID3v2_30.ID3v2Frame)) + 1

                        _NewID3v230Frame = _TreeNode.Tag

                        _ID3v230Frames.Insert(_SelectedID3v2FrameIndex, _NewID3v230Frame)

                    Case Form2.DialogMode.ID3v240
                        _ID3v2Frames = _ParentNode.Tag

                        _SelectedID3v2FrameIndex = _ID3v2Frames.IndexOf(DirectCast(TreeView1.SelectedNode.Tag, ID3v240.ID3v2Frame)) + 1

                        _NewID3v2Frame = _TreeNode.Tag

                        _ID3v2Frames.Insert(_SelectedID3v2FrameIndex, _NewID3v2Frame)

                End Select


                '追加したツリーノードを選択状態にする
                TreeView1.SelectedNode = _TreeNode

            End If

        End If

    End Sub

    Private Sub DeleteToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DeleteToolStripMenuItem.Click
        Dim _SelectedNode As TreeNode

        _SelectedNode = TreeView1.SelectedNode

        Dim _SelectedType As Type

        _SelectedType = TreeView1.SelectedNode.Tag.GetType

        Dim _ID3v230FrameType As Type

        _ID3v230FrameType = GetType(ID3v2_30.ID3v2Frame)

        Dim _ID3v240FrameType As Type

        _ID3v240FrameType = GetType(ID3v240.ID3v2Frame)

        Dim _ID3v230Frame As ID3v2_30.ID3v2Frame
        Dim _ID3v240Frame As ID3v240.ID3v2Frame

        Select Case True
            Case _SelectedType.IsSubclassOf(_ID3v230FrameType)
                _ID3v230Frame = _SelectedNode.Tag
                _ID3v230Frame.Remove()

            Case _SelectedType.IsSubclassOf(_ID3v240FrameType)
                _ID3v240Frame = _SelectedNode.Tag
                _ID3v240Frame.Remove()

        End Select

        _SelectedNode.Remove()

    End Sub

    Private Sub TreeView1_BeforeSelect(ByVal sender As Object, ByVal e As System.Windows.Forms.TreeViewCancelEventArgs) Handles TreeView1.BeforeSelect

    End Sub

    Private Sub TreeView1_AfterSelect(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles TreeView1.AfterSelect
        PropertyGrid1.SelectedObject = e.Node.Tag

    End Sub

End Class
