﻿Public Class Form2

    Public Sub New()

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        Select Case _Mode
            Case DialogMode.ID3v230
                InitID3v230()

            Case DialogMode.ID3v240
                InitID3v240()

        End Select

    End Sub

    Private Sub InitID3v230()
        '孫ノードの配列を初期化
        'テキスト情報フレーム群
        Dim _TextInformationFramesTreeNodes() As TreeNode = { _
            New TreeNode("Album/Movie/Show title"),
            New TreeNode("BPM (beats per minute)"),
            New TreeNode("Composer"),
            New TreeNode("Content type"),
            New TreeNode("Copyright message"),
            New TreeNode("Date"),
            New TreeNode("Playlist delay"),
            New TreeNode("Encoded by"),
            New TreeNode("Lyricist/Text writer"),
            New TreeNode("File type"),
            New TreeNode("Time"),
            New TreeNode("Content group description"),
            New TreeNode("Title/songname/content description"),
            New TreeNode("Subtitle/Description refinement"),
            New TreeNode("Initial key"),
            New TreeNode("Language(s)"),
            New TreeNode("Length"),
            New TreeNode("Media type"),
            New TreeNode("Original album/movie/show title"),
            New TreeNode("Original filename"),
            New TreeNode("Original lyricist(s)/text writer(s)"),
            New TreeNode("Original artist(s)/performer(s)"),
            New TreeNode("Original release year"),
            New TreeNode("File owner/licensee"),
            New TreeNode("Lead performer(s)/Soloist(s)"),
            New TreeNode("Band/orchestra/accompaniment"),
            New TreeNode("Conductor/performer refinement"),
            New TreeNode("Interpreted, remixed, or otherwise modified by"),
            New TreeNode("Part of a set"),
            New TreeNode("Publisher"),
            New TreeNode("Track number/Position in set"),
            New TreeNode("Recording dates"),
            New TreeNode("Internet radio station name"),
            New TreeNode("Internet radio station owner"),
            New TreeNode("Size"),
            New TreeNode("ISRC (international standard recording code)"),
            New TreeNode("Software/Hardware and settings used for encoding"),
            New TreeNode("Year")}

        '子ノードに孫ノード配列を追加
        Dim _TextInformationFramesTreeNode As New TreeNode("Text information frames", _TextInformationFramesTreeNodes)

        '孫ノードの配列を初期化
        'URL リンクフレーム群
        Dim _URLLinkFramesTreeNodes() As TreeNode = { _
            New TreeNode("Commercial information"),
            New TreeNode("Copyright/Legal information"),
            New TreeNode("Official audio file webpage"),
            New TreeNode("Official artist/performer webpage"),
            New TreeNode("Official audio source webpage"),
            New TreeNode("Official internet radio station homepage"),
            New TreeNode("Payment"),
            New TreeNode("Publishers official webpage")}

        '子ノードに孫ノード配列を追加
        Dim _URLLinkFramesTreeNode As New TreeNode("URL link frames", _URLLinkFramesTreeNodes)

        '親ノードの配列に子ノードを追加して初期化
        Dim _ID3v2FramesTreeNodes() As TreeNode = {
            New TreeNode("Unique file identifier"),
            _TextInformationFramesTreeNode,
            New TreeNode("User defined text information frame"),
            _URLLinkFramesTreeNode,
            New TreeNode("User defined URL link frame"),
            New TreeNode("Involved people list"),
            New TreeNode("Music CD identifier"),
            New TreeNode("Event timing codes"),
            New TreeNode("MPEG location lookup table"),
            New TreeNode("Synchronized tempo codes"),
            New TreeNode("Unsychronized lyric/text transcription"),
            New TreeNode("Synchronized lyric/text"),
            New TreeNode("Comments"),
            New TreeNode("Relative volume adjustment"),
            New TreeNode("Equalization"),
            New TreeNode("Reverb"),
            New TreeNode("Attached picture"),
            New TreeNode("General encapsulated object"),
            New TreeNode("Play counter"),
            New TreeNode("Popularimeter"),
            New TreeNode("Recommended buffer size"),
            New TreeNode("Audio encryption"),
            New TreeNode("Linked information"),
            New TreeNode("Position synchronisation frame"),
            New TreeNode("Terms of use"),
            New TreeNode("Ownership frame"),
            New TreeNode("Commercial frame"),
            New TreeNode("Encryption method registration"),
            New TreeNode("Group identification registration"),
            New TreeNode("Private frame")}

        '親ノード配列をツリーノードに設定
        TreeView1.Nodes.AddRange(_ID3v2FramesTreeNodes)

    End Sub

    Private Sub InitID3v240()
        '孫ノードの配列を初期化
        Dim _IdentificationFramesTreeNodes() As TreeNode = { _
            New TreeNode("Content group description"), _
            New TreeNode("Title/songname/content description"), _
            New TreeNode("Subtitle/Description refinement"), _
            New TreeNode("Album/Movie/Show title"), _
            New TreeNode("Original album/movie/show title"), _
            New TreeNode("Track number/Position in set"), _
            New TreeNode("Part of a set"), _
            New TreeNode("Set subtitle"), _
            New TreeNode("ISRC (international standard recording code)")}

        '子ノードに孫ノード配列を追加
        Dim _IdentificationFramesTreeNode As New TreeNode("Identification frames", _IdentificationFramesTreeNodes)


        '孫ノードの配列を初期化
        Dim _InvolvedPersonsFramesTreeNodes() As TreeNode = { _
            New TreeNode("Lead performer(s)/Soloist(s)"), _
            New TreeNode("Band/orchestra/accompaniment"), _
            New TreeNode("Conductor/performer refinement"), _
            New TreeNode("Interpreted) remixed) or otherwise modified by"), _
            New TreeNode("Original artist(s)/performer(s)"), _
            New TreeNode("Lyricist/Text writer"), _
            New TreeNode("Original lyricist(s)/text writer(s)"), _
            New TreeNode("Composer"), _
            New TreeNode("Musician credits list"), _
            New TreeNode("Involved people list"), _
            New TreeNode("Encoded by")}

        '子ノードに孫ノード配列を追加
        Dim _InvolvedPersonsFramesTreeNode As New TreeNode("Involved persons frames", _InvolvedPersonsFramesTreeNodes)


        '孫ノードの配列を初期化
        Dim _DerivedAndSubjectivePropertiesFramesTreeNodes() As TreeNode = { _
            New TreeNode("BPM (beats per minute)"), _
            New TreeNode("Length"), _
            New TreeNode("Initial key"), _
            New TreeNode("Language(s)"), _
            New TreeNode("Content type"), _
            New TreeNode("File type"), _
            New TreeNode("Media type"), _
            New TreeNode("Mood")}

        '子ノードに孫ノード配列を追加
        Dim _DerivedAndSubjectivePropertiesFramesTreeNode As New TreeNode("Derived and subjective properties frames", _DerivedAndSubjectivePropertiesFramesTreeNodes)


        '孫ノードの配列を初期化
        Dim _RightsAndLicenseFramesTreeNodes() As TreeNode = { _
            New TreeNode("Copyright message"), _
            New TreeNode("Produced notice"), _
            New TreeNode("Publisher"), _
            New TreeNode("File owner/licensee"), _
            New TreeNode("Internet radio station name"), _
            New TreeNode("Internet radio station owner")}

        '子ノードに孫ノード配列を追加
        Dim _RightsAndLicenseFramesTreeNode = New TreeNode("Rights and license frames", _RightsAndLicenseFramesTreeNodes)


        '孫ノードの配列を初期化
        Dim _OtherTextFramesTreeNodes() As TreeNode = { _
            New TreeNode("Original filename"), _
            New TreeNode("Playlist delay"), _
            New TreeNode("Encoding time"), _
            New TreeNode("Original release time"), _
            New TreeNode("Recording time"), _
            New TreeNode("Release time"), _
            New TreeNode("Tagging time"), _
            New TreeNode("Software/Hardware and settings used for encoding"), _
            New TreeNode("Album sort order"), _
            New TreeNode("Performer sort order"), _
            New TreeNode("Title sort order")}

        '子ノードに孫ノード配列を追加
        Dim _OtherTextFramesTreeNode = New TreeNode("Other text frames", _OtherTextFramesTreeNodes)


        Dim _URLLinkFramesTreeNodes() As TreeNode = { _
            New TreeNode("Commercial information"), _
            New TreeNode("Copyright/Legal information"), _
            New TreeNode("Official audio file webpage"), _
            New TreeNode("Official artist/performer webpage"), _
            New TreeNode("Official audio source webpage"), _
            New TreeNode("Official Internet radio station homepage"), _
            New TreeNode("Payment"), _
            New TreeNode("Publishers official webpage")}

        '子ノードに孫ノード配列を追加
        Dim _URLLinkFramesTreeNode = New TreeNode("URL link frames", _URLLinkFramesTreeNodes)



        '親ノードの配列に子ノードを追加して初期化
        Dim _ID3v2FramesTreeNodes() As TreeNode = { _
            New TreeNode("Unique file identifier"), _
            _IdentificationFramesTreeNode, _
            _InvolvedPersonsFramesTreeNode, _
            _DerivedAndSubjectivePropertiesFramesTreeNode, _
            _RightsAndLicenseFramesTreeNode, _
            _OtherTextFramesTreeNode, _
            New TreeNode("User defined text information frame"), _
            _URLLinkFramesTreeNode, _
            New TreeNode("User defined URL link frame"), _
            New TreeNode("Music CD identifier"), _
            New TreeNode("Event timing codes"), _
            New TreeNode("MPEG location lookup table"), _
            New TreeNode("Synchronised tempo codes"), _
            New TreeNode("Unsynchronised lyric/text transcription"), _
            New TreeNode("Synchronised lyric/text"), _
            New TreeNode("Comments"), _
            New TreeNode("Relative volume adjustment (2)"), _
            New TreeNode("Equalisation (2)"), _
            New TreeNode("Reverb"), _
            New TreeNode("Attached picture"), _
            New TreeNode("General encapsulated object"), _
            New TreeNode("Play counter"), _
            New TreeNode("Popularimeter"), _
            New TreeNode("Recommended buffer size"), _
            New TreeNode("Audio encryption"), _
            New TreeNode("Linked information"), _
            New TreeNode("Position synchronisation frame"), _
            New TreeNode("Terms of use"), _
            New TreeNode("Ownership frame"), _
            New TreeNode("Commercial frame"), _
            New TreeNode("Encryption method registration"), _
            New TreeNode("Group identification registration"), _
            New TreeNode("Private frame"), _
            New TreeNode("Signature frame"), _
            New TreeNode("Seek frame"), _
            New TreeNode("Audio seek point index")}

        '親ノード配列をツリーノードに設定
        TreeView1.Nodes.AddRange(_ID3v2FramesTreeNodes)

    End Sub

    Public Enum DialogMode As Byte
        ID3v230
        ID3v240

    End Enum

    Private _Mode As DialogMode

    Public Property Mode() As DialogMode
        Get
            Return _Mode
        End Get
        Set(ByVal value As DialogMode)
            _Mode = value
        End Set
    End Property

    Private _TreeNode As TreeNode

    Public Property TreeNode() As TreeNode
        Get
            Return _TreeNode
        End Get
        Set(ByVal value As TreeNode)
            _TreeNode = value
        End Set
    End Property

    Private Sub CreateTreeNodeID3v230(ByVal _ID3v2FrameString As String)
        Dim _ID3v2Frame As ID3v2_30.ID3v2Frame

        Select _ID3v2FrameString
            Case "Unique file identifier"
                '一意的なファイル識別子
                _ID3v2Frame = New ID3v2_30.UniqueFileIdentifier

            Case "Album/Movie/Show title"
                'アルバム／映画／ショーのタイトル
                _ID3v2Frame = New ID3v2_30.AlbumOrMovieOrShowTitle

            Case "BPM (beats per minute)"
                'BPM (beats per minute：一分間の拍数)
                _ID3v2Frame = New ID3v2_30.BPM

            Case "Composer"
                '作曲者
                _ID3v2Frame = New ID3v2_30.Composers

            Case "Content type"
                '内容のタイプ
                _ID3v2Frame = New ID3v2_30.ContentTypeFrame

            Case "Copyright message"
                '著作権情報
                _ID3v2Frame = New ID3v2_30.CopyrightMessage

            Case "Date"
                '日付
                _ID3v2Frame = New ID3v2_30.DateFrame

            Case "Playlist delay"
                'プレイリスト遅延時間
                _ID3v2Frame = New ID3v2_30.PlaylistDelay

            Case "Encoded by"
                'エンコードした人
                _ID3v2Frame = New ID3v2_30.EncodedBy

            Case "Lyricist/Text writer"
                '作詞家／文書作成者
                _ID3v2Frame = New ID3v2_30.LyricistsOrTextWriters

            Case "File type"
                'ファイルタイプ
                _ID3v2Frame = New ID3v2_30.FileType

            Case "Time"
                '時間
                _ID3v2Frame = New ID3v2_30.Time

            Case "Content group description"
                '内容の属するグループの説明
                _ID3v2Frame = New ID3v2_30.ContentGroupDescription

            Case "Title/songname/content description"
                'タイトル／曲名／内容の説明
                _ID3v2Frame = New ID3v2_30.TitleOrSongnameOrContentDescription

            Case "Subtitle/Description refinement"
                'サブタイトル／説明の追加情報
                _ID3v2Frame = New ID3v2_30.SubtitleOrDescriptionRefinement

            Case "Initial key"
                '初めの調
                _ID3v2Frame = New ID3v2_30.InitialKey

            Case "Language(s)"
                '言語
                _ID3v2Frame = New ID3v2_30.Languages

            Case "Length"
                '長さ
                _ID3v2Frame = New ID3v2_30.Length

            Case "Media type"
                'メディアタイプ
                _ID3v2Frame = New ID3v2_30.MediaType

            Case "Original album/movie/show title"
                'オリジナルのアルバム／映画／ショーのタイトル
                _ID3v2Frame = New ID3v2_30.OriginalAlbumOrMovieOrShowTitle

            Case "Original filename"
                'オリジナルファイル名
                _ID3v2Frame = New ID3v2_30.OriginalFilename

            Case "Original lyricist(s)/text writer(s)"
                'オリジナルの作詞家／文書作成者
                _ID3v2Frame = New ID3v2_30.OriginalLyricistsOrTextWriters

            Case "Original artist(s)/performer(s)"
                'オリジナルアーティスト／演奏者
                _ID3v2Frame = New ID3v2_30.OriginalArtistsOrPerformers

            Case "Original release year"
                'オリジナルのリリース年
                _ID3v2Frame = New ID3v2_30.OriginalReleaseYear

            Case "File owner/licensee"
                'ファイルの所有者／ライセンシー
                _ID3v2Frame = New ID3v2_30.FileOwnerOrLicensee

            Case "Lead performer(s)/Soloist(s)"
                '主な演奏者／ソリスト
                _ID3v2Frame = New ID3v2_30.LeadArtistsOrLeadPerformersOrSoloistsOrPerformingGroup

            Case "Band/orchestra/accompaniment"
                'バンド／オーケストラ／伴奏
                _ID3v2Frame = New ID3v2_30.BandOrOrchestraOrAccompaniment

            Case "Conductor/performer refinement"
                '指揮者／演奏者詳細情報
                _ID3v2Frame = New ID3v2_30.Conductor

            Case "Interpreted, remixed, or otherwise modified by"
                '翻訳者、リミックス、その他の修正
                _ID3v2Frame = New ID3v2_30.InterpretedRemixedOrOtherwiseModifiedBy

            Case "Part of a set"
                'セット中の位置
                _ID3v2Frame = New ID3v2_30.PartOfASet

            Case "Publisher"
                '出版社
                _ID3v2Frame = New ID3v2_30.Publisher

            Case "Track number/Position in set"
                'トラックの番号／セット中の位置
                _ID3v2Frame = New ID3v2_30.TrackNumberOrPositionInSet

            Case "Recording dates"
                '録音日付
                _ID3v2Frame = New ID3v2_30.RecordingDates

            Case "Internet radio station name"
                'インターネットラジオ局の名前
                _ID3v2Frame = New ID3v2_30.InternetRadioStationName

            Case "Internet radio station owner"
                'インターネットラジオ局の所有者
                _ID3v2Frame = New ID3v2_30.InternetRadioStationOwner

            Case "Size"
                'サイズ
                _ID3v2Frame = New ID3v2_30.Size

            Case "ISRC (international standard recording code)"
                'ISRC (international standard recording code：国際標準レコーディングコード)
                _ID3v2Frame = New ID3v2_30.ISRC

            Case "Software/Hardware and settings used for encoding"
                'エンコードに使用したソフトウエア／ハードウエアとセッティング
                _ID3v2Frame = New ID3v2_30.SoftwareOrHardwareAndSettingsUsedForEncoding

            Case "Year"
                '年
                _ID3v2Frame = New ID3v2_30.Year

            Case "User defined text information frame"
                'ユーザー定義文字情報フレーム
                _ID3v2Frame = New ID3v2_30.UserDefinedTextInformationFrame

            Case "Commercial information"
                '商業上の情報
                _ID3v2Frame = New ID3v2_30.CommercialInformation

            Case "Copyright/Legal information"
                '著作権／法的情報
                _ID3v2Frame = New ID3v2_30.CopyrightOrLegalInformation

            Case "Official audio file webpage"
                'オーディオファイルの公式Ｗｅｂページ
                _ID3v2Frame = New ID3v2_30.OfficialAudioFileWebpage

            Case "Official artist/performer webpage"
                'アーティスト／演奏者の公式Ｗｅｂページ
                _ID3v2Frame = New ID3v2_30.OfficialArtistOrPerformerWebpage

            Case "Official audio source webpage"
                '音源の公式Ｗｅｂページ
                _ID3v2Frame = New ID3v2_30.OfficialAudioSourceWebpage

            Case "Official internet radio station homepage"
                'インターネットラジオ局の公式ホームページ
                _ID3v2Frame = New ID3v2_30.OfficialInternetRadioStationHomepage

            Case "Payment"
                '支払い
                _ID3v2Frame = New ID3v2_30.Payment

            Case "Publishers official webpage"
                '出版社の公式Ｗｅｂページ
                _ID3v2Frame = New ID3v2_30.PublishersOfficialWebpage

            Case "User defined URL link frame"
                'ユーザー定義ＵＲＬリンクフレーム
                _ID3v2Frame = New ID3v2_30.UserDefinedURLLinkFrame

            Case "Involved people list"
                '協力者
                _ID3v2Frame = New ID3v2_30.InvolvedPeopleList

            Case "Music CD identifier"
                '音楽ＣＤ識別子
                _ID3v2Frame = New ID3v2_30.MusicCDIdentifier

            Case "Event timing codes"
                'イベントタイムコード
                _ID3v2Frame = New ID3v2_30.EventTimingCodes

            Case "MPEG location lookup table"
                'MPEG ロケーションルックアップテーブル
                _ID3v2Frame = New ID3v2_30.MPEGLocationLookupTable

            Case "Synchronized tempo codes"
                '同期　テンポコード
                _ID3v2Frame = New ID3v2_30.SynchronisedTempoCodes

            Case "Unsychronized lyric/text transcription"
                '非同期 歌詞／文書のコピー
                _ID3v2Frame = New ID3v2_30.UnsychronisedLyricsOrTextTranscription

            Case "Synchronized lyric/text"
                '同期　歌詞／文書
                _ID3v2Frame = New ID3v2_30.SynchronisedLyricsOrText

            Case "Comments"
                'コメント
                _ID3v2Frame = New ID3v2_30.Comments

            Case "Relative volume adjustment"
                '相対的ボリューム調整
                _ID3v2Frame = New ID3v2_30.RelativeVolumeAdjustment

            Case "Equalization"
                '均一化
                _ID3v2Frame = New ID3v2_30.Equalisation

            Case "Reverb"
                'リバーブ
                _ID3v2Frame = New ID3v2_30.Reverb

            Case "Attached picture"
                '付属する画像
                _ID3v2Frame = New ID3v2_30.AttachedPicture

            Case "General encapsulated object"
                'パッケージ化された一般的なオブジェクト
                _ID3v2Frame = New ID3v2_30.GeneralEncapsulatedObject

            Case "Play counter"
                '演奏回数
                _ID3v2Frame = New ID3v2_30.PlayCounter

            Case "Popularimeter"
                '人気メーター
                _ID3v2Frame = New ID3v2_30.Popularimeter

            Case "Recommended buffer size"
                'おすすめバッファサイズ
                _ID3v2Frame = New ID3v2_30.RecommendedBufferSize

            Case "Audio encryption"
                'オーディオの暗号化
                _ID3v2Frame = New ID3v2_30.AudioEncryption

            Case "Linked information"
                'リンク情報
                _ID3v2Frame = New ID3v2_30.LinkedInformation

                'Case "Position synchronisation frame"
                '    '同期位置フレーム
                '    _ID3v2Frame = New ID3v2_30.PositionSynchronisationFrame

            Case "Terms of use"
                '使用条件
                _ID3v2Frame = New ID3v2_30.TermsOfUseFrame

            Case "Ownership frame"
                '所有権フレーム
                _ID3v2Frame = New ID3v2_30.OwnershipFrame

            Case "Commercial frame"
                'コマーシャルフレーム
                _ID3v2Frame = New ID3v2_30.CommercialFrame

            Case "Encryption method registration"
                '暗号化の手法の登録
                _ID3v2Frame = New ID3v2_30.EncryptionMethodRegistration

            Case "Group identification registration"
                'グループ識別子の登録
                _ID3v2Frame = New ID3v2_30.GroupIdentificationRegistration

            Case "Private frame"
                'プライベートフレーム
                _ID3v2Frame = New ID3v2_30.PrivateFrame

            Case Else
                _ID3v2Frame = Nothing

        End Select

        If _ID3v2Frame Is Nothing Then
            _TreeNode = Nothing

        Else
            _TreeNode = TreeView1.SelectedNode.Clone

            _TreeNode.Tag = _ID3v2Frame

        End If

    End Sub

    Private Sub CreateTreeNodeID3v240(ByVal _ID3v2FrameString As String)
        Dim _ID3v2Frame As ID3v240.ID3v2Frame

        Select Case _ID3v2FrameString
            Case "Unique file identifier"
                _ID3v2Frame = New ID3v240.UniqueFileIdentifier

            Case "Content group description"
                _ID3v2Frame = New ID3v240.ContentGroupDescription

            Case "Title/songname/content description"
                _ID3v2Frame = New ID3v240.TitleOrSongnameOrContentDescription

            Case "Subtitle/Description refinement"
                _ID3v2Frame = New ID3v240.SubtitleOrDescriptionRefinement

            Case "Album/Movie/Show title"
                _ID3v2Frame = New ID3v240.AlbumOrMovieOrShowTitle

            Case "Original album/movie/show title"
                _ID3v2Frame = New ID3v240.OriginalAlbumOrMovieOrShowTitle

            Case "Track number/Position in set"
                _ID3v2Frame = New ID3v240.TrackNumberOrPositionInSet

            Case "Part of a set"
                _ID3v2Frame = New ID3v240.PartOfASet

            Case "Set subtitle"
                _ID3v2Frame = New ID3v240.SetSubtitle

            Case "ISRC (international standard recording code)"
                _ID3v2Frame = New ID3v240.ISRC

            Case "Lead performer(s)/Soloist(s)"
                _ID3v2Frame = New ID3v240.LeadPerformersOrSoloists

            Case "Band/orchestra/accompaniment"
                _ID3v2Frame = New ID3v240.BandOrOrchestraOrAccompaniment

            Case "Conductor/performer refinement"
                _ID3v2Frame = New ID3v240.ConductorOrPerformerRefinement

            Case "Interpreted, remixed, or otherwise modified by"
                _ID3v2Frame = New ID3v240.InterpretedRemixedOrOtherwiseModifiedBy

            Case "Original artist(s)/performer(s)"
                _ID3v2Frame = New ID3v240.OriginalArtistsOrPerformers

            Case "Lyricist/Text writer"
                _ID3v2Frame = New ID3v240.LyricistOrTextWriter

            Case "Original lyricist(s)/text writer(s)"
                _ID3v2Frame = New ID3v240.OriginalLyricistsOrTextWriters

            Case "Composer"
                _ID3v2Frame = New ID3v240.Composer

            Case "Musician credits list"
                _ID3v2Frame = New ID3v240.MusicianCreditsList

            Case "Involved people list"
                _ID3v2Frame = New ID3v240.InvolvedPeopleList

            Case "Encoded by"
                _ID3v2Frame = New ID3v240.EncodedBy

            Case "BPM (beats per minute)"
                _ID3v2Frame = New ID3v240.BPM

            Case "Length"
                _ID3v2Frame = New ID3v240.Length

            Case "Initial key"
                _ID3v2Frame = New ID3v240.InitialKey

            Case "Language(s)"
                _ID3v2Frame = New ID3v240.Languages

            Case "Content type"
                _ID3v2Frame = New ID3v240.ContentType

            Case "File type"
                _ID3v2Frame = New ID3v240.FileType

            Case "Media type"
                _ID3v2Frame = New ID3v240.MediaType

            Case "Mood"
                _ID3v2Frame = New ID3v240.Mood

            Case "Copyright message"
                _ID3v2Frame = New ID3v240.CopyrightMessage

            Case "Produced notice"
                _ID3v2Frame = New ID3v240.ProducedNotice

            Case "Publisher"
                _ID3v2Frame = New ID3v240.Publisher

            Case "File owner/licensee"
                _ID3v2Frame = New ID3v240.FileOwnerOrLicensee

            Case "Internet radio station name"
                _ID3v2Frame = New ID3v240.InternetRadioStationName

            Case "Internet radio station owner"
                _ID3v2Frame = New ID3v240.InternetRadioStationOwner

            Case "Original filename"
                _ID3v2Frame = New ID3v240.OriginalFilename

            Case "Playlist delay"
                _ID3v2Frame = New ID3v240.PlaylistDelay

            Case "Encoding time"
                _ID3v2Frame = New ID3v240.EncodingTime

            Case "Original release time"
                _ID3v2Frame = New ID3v240.OriginalReleaseTime

            Case "Recording time"
                _ID3v2Frame = New ID3v240.RecordingTime

            Case "Release time"
                _ID3v2Frame = New ID3v240.ReleaseTime

            Case "Tagging time"
                _ID3v2Frame = New ID3v240.TaggingTime

            Case "Software/Hardware and settings used for encoding"
                _ID3v2Frame = New ID3v240.SoftwareOrHardwareAndSettingsUsedForEncoding

            Case "Album sort order"
                _ID3v2Frame = New ID3v240.AlbumSortOrder

            Case "Performer sort order"
                _ID3v2Frame = New ID3v240.PerformerSortOrder

            Case "Title sort order"
                _ID3v2Frame = New ID3v240.TitleSortOrder

            Case "User defined text information frame"
                _ID3v2Frame = New ID3v240.UserDefinedTextInformationFrame

            Case "Commercial information"
                _ID3v2Frame = New ID3v240.CommercialInformation

            Case "Copyright/Legal information"
                _ID3v2Frame = New ID3v240.CopyrightOrLegalInformation

            Case "Official audio file webpage"
                _ID3v2Frame = New ID3v240.OfficialAudioFileWebpage

            Case "Official artist/performer webpage"
                _ID3v2Frame = New ID3v240.OfficialArtistOrPerformerWebpage

            Case "Official audio source webpage"
                _ID3v2Frame = New ID3v240.OfficialAudioSourceWebpage

            Case "Official Internet radio station homepage"
                _ID3v2Frame = New ID3v240.OfficialInternetRadioStationHomepage

            Case "Payment"
                _ID3v2Frame = New ID3v240.Payment

            Case "Publishers official webpage"
                _ID3v2Frame = New ID3v240.PublishersOfficialWebpage

            Case "User defined URL link frame"
                _ID3v2Frame = New ID3v240.UserDefinedUrlLinkFrame

            Case "Music CD identifier"
                _ID3v2Frame = New ID3v240.MusicCDIdentifier

                'Case "Event timing codes"
                '    _ID3v2Frame = new ID3v240.EventTimingCodes

                'Case "MPEG location lookup table"
                '    _ID3v2Frame = new ID3v240.MPEGLocationLookupTable

            Case "Synchronised tempo codes"
                _ID3v2Frame = New ID3v240.SynchronisedTempoCodes

            Case "Unsynchronised lyric/text transcription"
                _ID3v2Frame = New ID3v240.UnsynchronisedLyricsOrTextTranscription

            Case "Synchronised lyric/text"
                _ID3v2Frame = New ID3v240.SynchronisedLyricsOrText

            Case "Comments"
                _ID3v2Frame = New ID3v240.Comments

                'Case "Relative volume adjustment (2)"
                '    _ID3v2Frame = new ID3v240.RelativeVolumeAdjustment2

                'Case "Equalisation (2)"
                '    _ID3v2Frame = new ID3v240.Equalisation2

            Case "Reverb"
                _ID3v2Frame = New ID3v240.Reverb

            Case "Attached picture"
                _ID3v2Frame = New ID3v240.AttachedPicture

            Case "General encapsulated object"
                _ID3v2Frame = New ID3v240.GeneralEncapsulatedObject

            Case "Play counter"
                _ID3v2Frame = New ID3v240.PlayCounter

            Case "Popularimeter"
                _ID3v2Frame = New ID3v240.Popularimeter

            Case "Recommended buffer size"
                _ID3v2Frame = New ID3v240.RecommendedBufferSize

            Case "Audio encryption"
                _ID3v2Frame = New ID3v240.AudioEncryption

            Case "Linked information"
                _ID3v2Frame = New ID3v240.LinkedInformation

                'Case "Position synchronisation frame"
                '    _ID3v2Frame = new ID3v240.PositionSynchronisationFrame

            Case "Terms of use"
                _ID3v2Frame = New ID3v240.TermsOfUseFrame

            Case "Ownership frame"
                _ID3v2Frame = New ID3v240.OwnershipFrame

            Case "Commercial frame"
                _ID3v2Frame = New ID3v240.CommercialFrame

            Case "Encryption method registration"
                _ID3v2Frame = New ID3v240.EncryptionMethodRegistration

            Case "Group identification registration"
                _ID3v2Frame = New ID3v240.GroupIdentificationRegistration

            Case "Private frame"
                _ID3v2Frame = New ID3v240.PrivateFrame

            Case "Signature frame"
                _ID3v2Frame = New ID3v240.SignatureFrame

            Case "Seek frame"
                _ID3v2Frame = New ID3v240.SeekFrame

                'Case "Audio seek point index"
                '    _ID3v2Frame = new ID3v240.AudioSeekPointIndex

            Case Else
                _ID3v2Frame = Nothing

        End Select

        If _ID3v2Frame Is Nothing Then
            _TreeNode = Nothing

        Else
            _TreeNode = TreeView1.SelectedNode.Clone

            _TreeNode.Tag = _ID3v2Frame

        End If

    End Sub

    Private Sub TreeView1_BeforeSelect(ByVal sender As Object, ByVal e As System.Windows.Forms.TreeViewCancelEventArgs) Handles TreeView1.BeforeSelect

    End Sub

    Private Sub TreeView1_AfterSelect(ByVal sender As Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles TreeView1.AfterSelect
        Select Case _Mode
            Case DialogMode.ID3v230
                CreateTreeNodeID3v230(e.Node.Text)

            Case DialogMode.ID3v240
                CreateTreeNodeID3v240(e.Node.Text)

        End Select

    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Me.DialogResult = Windows.Forms.DialogResult.OK

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel

    End Sub

End Class
