//----------------------------------------------------------------
//				EBhEbZ[W`FbNp
//		RpC VC6.0 QT4.3.4Windows OpenSource
//		(,,EDE)								Ver0.01
//----------------------------------------------------------------

#include <QString>
#include <QDebug>								// qDebugg܂B
#include <QEvent>								// QEvent̒`g߂ɕKv
#include <QPaintEvent>
#include <QRect>								// QPaintEventp
#include <QRegion>
#include <QMoveEvent>							// EBhEړ
#include <QPoint>								// pointNX@MoveEvent̍Wp
#include <QResizeEvent>							// EBhETCYύX
#include <QSize>								// TCY
#include <QShowEvent>							// \p^[
#include <QMouseEvent>							// }EXCxg
#include <QContextMenuEvent>					// ENbÑ|bvAbvj[
#include <QWheelEvent>							// }EXzC[Cxg
#include "messagechecker.h"
static QString ClassName("MessageChecker");

MessageChecker *MessageChecker::m_safe = 0;						// g̃|C^ŏ̂P̂ݐݒ肷
int	MessageChecker::m_OutputFlag = OUTPUT_ALL;

//----------------------------------------------------------------
//	RXgN^
//----------------------------------------------------------------
MessageChecker::MessageChecker(QObject *parent)
	: QObject(parent)
	, m_drawMes(1)
{
	// ŏ̂PxOBJECTݒ肷
	if(m_safe == 0){
		m_safe = this;
	}
	qDebug("MessageChecker::start");

	setObjectName(ClassName);
}

//----------------------------------------------------------------
//	CX^X̎擾@gˁB
//----------------------------------------------------------------
MessageChecker *MessageChecker::instance()
{
	return m_safe; 
}
//----------------------------------------------------------------
//		CxgtB^CXg[
//----------------------------------------------------------------
void MessageChecker::Install(QObject *obj)
{
	if(m_safe != 0){
		// ̃Cxg̃NX̃CxgtB^ɐݒ肷B
		obj->installEventFilter(m_safe);
	}
}

//----------------------------------------------------------------
//		CxgtB^
//----------------------------------------------------------------
void MessageChecker::Uninstall(QObject *obj)
{
	if(m_safe != 0){
		obj->removeEventFilter(m_safe);
	}
}

//----------------------------------------------------------------
//		CxgtB^
//----------------------------------------------------------------
/*
	QObject *obj EventsQObject
	QEvent objɑ΂Event
	߂l
	ture tB^ŃCxgubN
	false QObjectevent(QEvent *event)ɔ΂
*/
bool MessageChecker::eventFilter(QObject *obj, QEvent *event)
{
	QString strDebug;			// \f[^
	int Draw = 1;
	// IuWFNg
	if(m_OutputFlag & OUTPUT_OBJECTNAME){
		strDebug += obj->objectName() + " ";
	}
	// Cxgԍ
	if(m_OutputFlag & OUTPUT_EVENTNUM){
		strDebug += "EV:" +  QString::number(event->type()) + " ";
	}

	switch(event->type()){
	//--- }EXɊւCxg---
	case QEvent::MouseButtonPress:		// 2 }EX{^
		if(m_OutputFlag & OUTPUT_MOUSEEVENT){
			QMouseEvent *mouse = static_cast<QMouseEvent *>(event);
			Draw = 1;
			// globalX͉ʍW
			strDebug += "MousePress : GX:" + QString::number(mouse->globalX());
			strDebug += " GY:" + QString::number(mouse->globalY());
			// NCAg̈W
			strDebug += " X:" + QString::number(mouse->x());
			strDebug += " Y:" + QString::number(mouse->y());
			strDebug += " BTN:" + QString::number(mouse->button(), 16);
			strDebug += " BTNS:" + QString::number(mouse->buttons(), 16);
		}
		break;
	case QEvent::MouseButtonRelease:	// 3 }EX{^𗣂
		if(m_OutputFlag & OUTPUT_MOUSEEVENT){
			QMouseEvent *mouse = static_cast<QMouseEvent *>(event);
			Draw = 1;
			// globalX͉ʍW
			strDebug += "MouseRelease : GX:" + QString::number(mouse->globalX());
			strDebug += " GY:" + QString::number(mouse->globalY());
			// NCAg̈W
			strDebug += " X:" + QString::number(mouse->x());
			strDebug += " Y:" + QString::number(mouse->y());
			strDebug += " BTN:" + QString::number(mouse->button(), 16);
			strDebug += " BTNS:" + QString::number(mouse->buttons(), 16);
		}
		break;
	case QEvent::MouseButtonDblClick:	// 4 _uNbN
		if(m_OutputFlag & OUTPUT_MOUSEEVENT){
			QMouseEvent *mouse = static_cast<QMouseEvent *>(event);
			Draw = 1;
			// globalX͉ʍW
			strDebug += "MouseDblClick : GX:" + QString::number(mouse->globalX());
			strDebug += " GY:" + QString::number(mouse->globalY());
			// NCAg̈W
			strDebug += " X:" + QString::number(mouse->x());
			strDebug += " Y:" + QString::number(mouse->y());
			strDebug += " BTN:" + QString::number(mouse->button(), 16);
			strDebug += " BTNS:" + QString::number(mouse->buttons(), 16);
		}
		break;
	case QEvent::MouseMove:				// 5 hbOړ̂ݒʏړ͊܂܂Ȃ
		if(m_OutputFlag & OUTPUT_MOUSEEVENT){
			QMouseEvent *mouse = static_cast<QMouseEvent *>(event);
			Draw = 1;
			// globalX͉ʍW
			strDebug += "MouseMove : GX:" + QString::number(mouse->globalX());
			strDebug += " GY:" + QString::number(mouse->globalY());
			// NCAg̈W
			strDebug += " X:" + QString::number(mouse->x());
			strDebug += " Y:" + QString::number(mouse->y());
			strDebug += " BTN:" + QString::number(mouse->button(), 16);
			strDebug += " BTNS:" + QString::number(mouse->buttons(), 16);
		}
		break;
	case QEvent::Enter:			// 10 }EXQObject`ɓꍇ
		if(m_OutputFlag & OUTPUT_MOUSEEVENT){
			Draw = 1;
			strDebug += "MouseIn";
		}
		break;
	case QEvent::Leave:			// 11 }EX`Oɏoꍇ
		if(m_OutputFlag & OUTPUT_MOUSEEVENT){
			Draw = 1;
			strDebug += "MouseOut";
		}
		break;
	case QEvent::Wheel:			// 31 zC[gꍇ
		if(m_OutputFlag & OUTPUT_MOUSEEVENT){
			QWheelEvent *wheel = static_cast<QWheelEvent *>(event);
			strDebug += " GX:" + QString::number(wheel->globalX());
			strDebug += " GY:" + QString::number(wheel->globalY());
			// NCAg̈W
			strDebug += " X:" + QString::number(wheel->x());
			strDebug += " Y:" + QString::number(wheel->y());
			strDebug += " BTNS:" + QString::number(wheel->buttons(), 16);
			strDebug += " WHEEL:" + QString::number(wheel->delta());
			if(Qt::Horizontal == wheel->orientation()){
				strDebug += " YOKO";
			}else if(Qt::Vertical == wheel->orientation()){
				strDebug += " TATE";
			}
		}
		break;
	case QEvent::ContextMenu:	// 82 ENbNɂ
			// |bvAbvj[oꍇ
		if(m_OutputFlag & OUTPUT_MOUSEEVENT){
			QContextMenuEvent *mouse = static_cast<QContextMenuEvent *>(event);
			Draw = 1;
			// globalX͉ʍW
			strDebug += "PopupMenu : GX:" + QString::number(mouse->globalX());
			strDebug += " GY:" + QString::number(mouse->globalY());
			// NCAg̈W
			strDebug += " X:" + QString::number(mouse->x());
			strDebug += " Y:" + QString::number(mouse->y());
			strDebug += " REZ:" + QString::number(mouse->reason(), 16);
		}
		break;
	case QEvent::ToolTip:		// 110 c[`bv\
		break;
	case QEvent::FocusIn:		// 8 tH[JXړ
		break;
	case QEvent::Paint:			// 12 QPaintEventLXg\@\O
		if(m_OutputFlag & OUTPUT_PAINTEVENT){
			QPaintEvent *paint = static_cast<QPaintEvent *>(event);
			QRect rc = paint->rect();
			// \̈ݒ肷
			strDebug += "PAINT:top:" + QString::number(rc.top());
			strDebug += " left:" + QString::number(rc.left());
			strDebug += " bottom:" + QString::number(rc.bottom());
			strDebug += " right:" + QString::number(rc.right());
			Draw = 1;
		}
		break;
	// L[͂ɊւCxg

	// EBhEVXe
	case QEvent::WindowActivate:	// 24 ANeBuɂȂꍇ
		if(m_OutputFlag & OUTPUT_SYSEVENT){
			strDebug += "WindowActive";
		}
		// EChÊANeBuɂȂĂ悤łB
		break;
	case QEvent::Polish:			// 75 |bV񂾂H
		// {^ȂǂWidgetɂB
		if(m_OutputFlag & OUTPUT_SYSEVENT){
			strDebug += "Polish";
		}
		break;
	case QEvent::PolishRequest:		// 74 |bV̌ɃNGXg
		// Ă邩sEE
		if(m_OutputFlag & OUTPUT_SYSEVENT){
			strDebug += "PolishRequest";
		}
		break;
	case QEvent::Move:				// 13 EBhËړ
		// {^ƃEBhEŋႤ
		if(m_OutputFlag & OUTPUT_SYSEVENT){
			QMoveEvent *move = static_cast<QMoveEvent *>(event);
			strDebug += "Move Old X:" + QString::number(move->oldPos().x()) + "Y:" + QString::number(move->oldPos().y()) + " ";
			strDebug += "New X:" + QString::number(move->pos().x()) + "Y:" + QString::number(move->pos().y()) + " ";
		}
		break;
	case QEvent::Resize:			// 14 EBhETCYύX
		if(m_OutputFlag & OUTPUT_SYSEVENT){
			QResizeEvent *resize = static_cast<QResizeEvent *>(event);
			strDebug += "SizeChange Old W:" + QString::number(resize->oldSize().width()) + 
				"H:" + QString::number(resize->oldSize().height()) + " ";
			strDebug += "New W:" + QString::number(resize->size().width()) + 
				"H:" + QString::number(resize->size().height()) + " ";
		}
		break;
	case QEvent::Show:				// 17 \ꍇpaintEvent̑Oɗ͗l
		if(m_OutputFlag & OUTPUT_SYSEVENT){
			// ɌŗL̃oBȂ񂶂ႱH
//			QShowEvent *show = static_cast<QShowEvent *>(event);
			strDebug += "WindowShow";
		}
		break;
	case QEvent::ShowToParent:		// 26 eEBhE\ԂɂȂƂ
		if(m_OutputFlag & OUTPUT_SYSEVENT){
			// ɌŗL̃oBȂ񂶂ႱH
//			QShowEvent *show = static_cast<QShowEvent *>(event);
			strDebug += "ParentWindowShow";
		}

		break;
	default:					// sȂ̂͌pQObjectŏ
		// USERCxg̏ꍇ
		if(QEvent::User <= event->type()){
			strDebug += "UserEvent";
			break;
		}else{		// ȊO̓ftHg
			showDebugMessage(strDebug.toLocal8Bit());
			return QObject::eventFilter(obj, event);
		}
		break;
	}

	if(Draw){
		showDebugMessage(strDebug.toLocal8Bit());
	}
	return false;				// truȅꍇevents܂ŏ܂
}

void MessageChecker::showDebugMessage(const char *mes)
{
	if(m_drawMes){
		qDebug( mes );
	}
}
