﻿; vim: set ts=4 sw=4 sts=4 expandtab: =========================================;
;                        [ 京堂扇奈 from BigBang Beat ]                        ;
;==============================================================================;

;==============================================================================;
;                             [ コモンステート ]                               ;
;==============================================================================;
;------------------------------------------------------------------------------;
; ジャンプステート
;
; sysvar(1) : 方向
; sysvar(4) : ハイジャンプ / 小ジャンプ
;------------------------------------------------------------------------------;
[Statedef 40]
type        = S
movetype    = I
physics     = S
ctrl        = 0
sprpriority = 1

;-------[ Anim ]-------;

[State 40:          Anim, 1]
type     = ChangeAnim
trigger1 = Time = 0
value    = 40

;-------[ Vars ]-------;

[State 40:          Reset Dir]
type      = VarSet
trigger1  = Time = 0
sysvar(1) = 0

[State 40:          Reset High]
type      = VarSet
trigger1  = Time = 0
sysvar(4) = 0

[State 40:          Forward Jump]
type      = VarSet
trigger1  = command = "holdfwd" && !var(59); && !var(0)
trigger2  = (var(59)||var(0)) && PrevStateNo = 100
sysvar(1) = 1

[State 40:          Back Jump]
type      = VarSet
trigger1  = command = "holdback" && !var(59); && !var(0)

sysvar(1) = -1

[State 40:          Small Jump]
type       = VarSet
triggerall = sysvar(4) = 0
trigger1   = command != "holdup" && !var(59); && !var(0)
sysvar(4)  = -1

[State 40:          High Jump]
type       = VarSet
triggerall = sysvar(4) = 0
trigger1   = command = "longjump" && !var(59)
trigger2   = PrevStateNo = 100 && (sysvar(1) = 1||var(59)||var(0))
sysvar(4)  = 1

[State 40:          High Jump]
type       = VarSet
trigger1   = PrevStateNo = 102
sysvar(4)  = 1

;-------[ Movement ]-------;

[State 40:          Invincible for Throw]
type     = NotHitBy
trigger1 = 1
value    = SC, NT, ST, HT
time     = 1

[State 40:          Vel, Normal Jump]
type     = VelSet
trigger1 = AnimTime = 0
x        = ifelse(sysvar(1) = 0, const(velocity.jump.neu.x), ifelse(sysvar(1) = 1, const(velocity.jump.fwd.x), const(velocity.jump.back.x))) * ifelse(sysvar(4) = 0, 1.0, ifelse(sysvar(4) > 0, 1.45, 0.75))
y        = const(velocity.jump.y) * ifelse(sysvar(4) = 0, 1.0, ifelse(sysvar(4) > 0, 1.15, 0.75))

[State 40:          Vel, Dash Jump]
type     = VelSet
trigger1 = AnimTime = 0
trigger1 = PrevStateNo = 100
trigger1 = sysvar(1) = 1
x        = const(velocity.runjump.fwd.x)
y        = const(velocity.runjump.y)

[State 40:          Vel, AI Dash Jump]
type     = VelSet
trigger1 = AnimTime = 0
trigger1 = PrevStateNo = 102
x        = const(velocity.runjump.fwd.x)
y        = const(velocity.runjump.y)

;-------[ States ]-------;

[State 40:          ChangeState, Up]
type     = ChangeState
trigger1 = AnimTime = 0
value    = 50
ctrl     = 1

;------------------------------------------------------------------------------;
; ジャンプ (上昇)
;------------------------------------------------------------------------------;
[Statedef 50]
type    = A
physics = A

;-------[ Anim ]-------;

[State 50:          Anim, 1]
type     = ChangeAnim
trigger1 = Time = 0
value    = ifelse((Vel X) = 0, 41, ifelse((Vel X) > 0, 42, 43))

[State 50:          Anim, 2]
type       = ChangeAnim
trigger1   = Vel Y > -2
trigger1   = SelfAnimExist(Anim + 3)
value      = Anim + 3
persistent = 0

;-------[ Sounds ]-------;

[State 50:          SE, 1]
type     = PlaySnd
trigger1 = Time = 0
value    = 7, 5 + (sysvar(4) > 0)

;-------[ Effects ]-------;

[State 50:          AfterImage]
type        = AfterImage
trigger1    = Time = 0
trigger1    = sysvar(4) > 0
time        = 42
palbright   = 1, 1, 1
palcontrast = 128, 128, 128
paladd      = 0, 0, 0
palmul      = 0.5, 0.5, 0.5
length      = 9
trans       = Add1
timegap     = 2
framegap    = 4
persistent  = 0

;-------[ Vars ]-------;

[State 50:          Reset Dir]
type      = VarSet
trigger1  = Time = 0
sysvar(1) = 0

[State 50:          Reset High]
type      = VarSet
trigger1  = Time = 0
sysvar(4) = 0

;------------------------------------------------------------------------------;
; ジャンプ落下
;
; ※ ガード解除 (StateDef 140) からこのステートへ遷移する
;------------------------------------------------------------------------------;
[Statedef 51]
type    = A
physics = A
anim    = 51
ctrl    = 1

;-------[ Null ]-------;

[State 51:          Null, 1]
type     = Null
trigger1 = Time = 0

;------------------------------------------------------------------------------;
; ジャンプ 着地
;------------------------------------------------------------------------------;
[Statedef 52]
type    = S
physics = S
anim    = 47
ctrl    = 0

;-------[ Movement ]-------;

[State 52:          Vel, 1]
type     = VelSet
trigger1 = Time = 0
y        = 0

[State 52:          Pos, 1]
type     = PosSet
trigger1 = Time = 0
y        = 0

;-------[ Sounds ]-------;

[State 106:         SE, 1]
type     = PlaySnd
trigger1 = Time = 0
value    = 7, 3

;-------[ Effects ]-------;

[State 106:         Dust]
type        = Explod
trigger1    = Time = 0
anim        = 6201
postype     = p1
pos         = 0, 0
sprpriority = -5
scale       = 0.5 * const(size.xscale), 0.5 * const(size.yscale)
ownpal      = 1

;-------[ States ]-------;

[State 52:          ChangeState, Standing]
type     = ChangeState
trigger1 = AnimTime = 0
value    = 0
ctrl     = 1

;------------------------------------------------------------------------------;
; 前方ダッシュ (ラン)
;------------------------------------------------------------------------------;
[Statedef 100]
type        = S
movetype    = I
physics     = S
anim        = 100
ctrl        = 0
sprpriority = 1

;-------[ Movement ]-------;

[State 100:         No Walk]
type     = AssertSpecial
trigger1 = 1
flag     = NoWalk
flag2    = NoAutoTurn

[State 100:         Vel, 1]
type     = VelSet
trigger1 = 1
x        = Const(Velocity.run.fwd.x)
y        = 0

;-------[ Sounds ]-------;

[State 100:         SE, 1]
type     = PlaySnd
trigger1 = AnimElem = 2
value    = 7, 24

[State 100:         SE, 1]
type        = PlaySnd
trigger1    = AnimElemTime(3) = 1
value       = 7, 23
channel     = 7
lowpriority = 1

;-------[ States ]-------;

[State 100:         ChangeState, Stop]
type     = ChangeState
trigger1 = var(58) <= 0 && !var(0) && !var(59)
trigger1 = command != "holdfwd"
value    = 101

[State 100:         ChangeState, Jump]
type     = ChangeState
trigger1 = var(58) <= 0
trigger1 = command = "holdup"
value    = 40

;------------------------------------------------------------------------------;
; 前方ダッシュ (ラン) 停止
;------------------------------------------------------------------------------;
[Statedef 101]
type        = S
movetype    = I
physics     = S
ctrl        = 1
sprpriority = 1

;-------[ Sounds ]-------;

[State 101:         SE, 1]
type     = PlaySnd
trigger1 = Time = 0
value    = 7, 7

;-------[ Effects ]-------;

[State 101:         Dust]
type        = Explod
trigger1    = Time = 0
anim        = 6202
postype     = p1
pos         = 10, 0
sprpriority = 5
scale       = 0.5 * const(size.xscale), 0.5 * const(size.yscale)
ownpal      = 1

;-------[ States ]-------;

[State 101:         ChangeState, Standing]
type     = ChangeState
trigger1 = Time = 0
value    = 0
ctrl     = 1

;------------------------------------------------------------------------------;
; バックステップ
;------------------------------------------------------------------------------;
[Statedef 105]
type        = A
movetype    = I
physics     = A
anim        = 105
ctrl        = 0
sprpriority = 0

;-------[ Movement ]-------;

[State 105:         Vel, 1]
type     = VelSet
trigger1 = AnimElem = 2
x        = Const(velocity.run.back.x)
y        = Const(velocity.run.back.y)

;-------[ Sounds ]-------;

[State 105:         SE, 1]
type     = PlaySnd
trigger1 = Time = 0
value    = 7, 5

;-------[ States ]-------;

[State 105:         ChangeState, Landing]
type       = ChangeState
triggerall = AnimElemTime(2) > 0
trigger1   = Vel Y > 0
trigger1   = Pos Y >= 0
value      = 106
ctrl       = 0

;------------------------------------------------------------------------------;
; バックステップ 着地
;------------------------------------------------------------------------------;
[Statedef 106]
type        = S
movetype    = I
physics     = S
anim        = 106
ctrl        = 0
sprpriority = 1
velset      = 0, 0

;-------[ Movement ]-------;

[State 106:         Vel, 1, Reset]
type     = VelSet
trigger1 = Time = 0
y        = 0

[State 106:         Pos, 1, Reset]
type     = PosSet
trigger1 = Time = 0
y        = 0

;-------[ Sounds ]-------;

[State 106:         SE, 1]
type     = PlaySnd
trigger1 = Time = 0
value    = 7, 3

;-------[ Effects ]-------;

[State 106:         Dust]
type        = Explod
trigger1    = Time = 0
anim        = 6201
postype     = p1
pos         = 0, 0
sprpriority = -5
scale       = 0.5 * const(size.xscale), 0.5 * const(size.yscale)
ownpal      = 1

;-------[ States ]-------;

[State 106:         ChangeState, Standing]
type     = ChangeState
trigger1 = AnimTime = 0
value    = 0
ctrl     = 1


;===============================================================================;
; ガードステート
;===============================================================================;
; GUARD (start)
[Statedef 120]
type=U    ;Leave state type unchanged
physics=U ;Leave physics unchanged

[State 120, 1]
type=ChangeAnim
trigger1=Time=0
value=120 + (statetype=C) + (statetype=A)*2

[State 120, 2]
type=StateTypeSet
trigger1=Time=0 && statetype=S
physics=S

[State 120, 3]
type=StateTypeSet
trigger1=Time=0 && statetype=C
physics=C

[State 120, 4]
type=StateTypeSet
trigger1=Time=0 && statetype=A
physics=A

[State 120, Hi to Lo]
type=StateTypeSet
TriggerAll=Statetype=S
Trigger1=!var(59) && command="holddown"
Trigger2=var(59)
Trigger2=enemynear(var(57)),StateType!=A
Trigger2=(Random <= var(56)*50||var(59)>2)
statetype=C
physics=C

[State 120, Lo to Hi]
type=StateTypeSet
TriggerAll=Statetype=C
Trigger1=!var(59) && command="holddown"
Trigger2=var(59)
Trigger2=enemynear(var(57)),StateType=A && Random<=var(56)*50+1000*(var(59)>2)
Trigger3=var(59) && Random<=var(56)*50+1000*(var(59)>2)
statetype=S
physics=S

[State 120, 5]
type=ChangeState
trigger1=AnimTime=0
value=130 + (statetype=C) + (statetype=A)*2

[State 120, Stop Guarding]
type=ChangeState
Trigger1=!var(59) && command != "holdback"
trigger2=!inguarddist
Trigger3=var(59) && P2BodyDist X<0 && Random<=(5-var(56))*40
value=140

;---------------------------------------------------------------------------
; STAND GUARD (guarding)
[Statedef 130]
type   =S
physics=S

[State 130, 1]
type=ChangeAnim
trigger1=Anim != 130
value=130

[State 130, Hi to Lo]
type=ChangeState
TriggerAll=Statetype=S
Trigger1=!var(59)
Trigger1=command="holddown"
Trigger2=var(59)
trigger2=enemynear(var(57)),StateType!=A
Trigger2=(Random <= var(56)*50||var(59)>2)
value=131

[State 130, Stop Guarding]
type=ChangeState
Trigger1=!var(59) && command != "holdback"
trigger2=!inguarddist
Trigger3=var(59) && P2BodyDist X<0 && Random<=(5-var(56))*40
value=140

;---------------------------------------------------------------------------
; CROUCH GUARD (guarding)
[Statedef 131]
type   =C
physics=C

[State 131, 1]
type=ChangeAnim
trigger1=Anim != 131
value=131

[State 131, Lo to Hi]
type=ChangeState
TriggerAll=Statetype=C
Trigger1=!var(59) && command != "holddown"
Trigger2=var(59)
Trigger2=enemynear(var(57)),StateType=A && Random<=var(56)*50+1000*(var(59)>2)
Trigger3=var(59) && Random<=var(56)*50+1000*(var(59)>2)
value=130


[State 131, Stop Guarding]
type=ChangeState
Trigger1=!var(59) && command != "holdback"
trigger2=!inguarddist
Trigger3=var(59) && P2BodyDist X<0 && Random<=(5-var(56))*40
value=140

;---------------------------------------------------------------------------
; AIR GUARD (guarding)
[Statedef 132]
type   =A
physics=N

[State 132, 1]
type=ChangeAnim
trigger1=Anim != 132
value=132

[State 132, 2]
type=VelAdd
trigger1=1
y=Const(movement.yaccel)

[State 132, 3]
type=VarSet
trigger1=1
sysvar(0)=(pos y >= 0) && (vel y > 0)

[State 132, 4]
type=VelSet
trigger1=sysvar(0)
y=0

[State 132, 5]
type=PosSet
trigger1=sysvar(0)
y=0

[State 132, 6]
type=ChangeState
triggerall=inguarddist
triggerall=sysvar(0)
Trigger1=!var(59) && command="holdback"
Trigger2=var(59) && Random <= var(56)*200
value=130

[State 132, 7]
type=ChangeState
trigger1=sysvar(0)
value=52

[State 132, Stop Guarding]
type=ChangeState
Trigger1=!var(59) && command != "holdback"
trigger2=!inguarddist
Trigger3=var(59) && P2BodyDist X<0 && Random<=(5-var(56))*40
value=140

;---------------------------------------------------------------------------
; GUARD (end)
[Statedef 140]
type=U    ;Leave state type unchanged
physics=U ;Leave physics unchanged
ctrl=1

[State 140, 1]
type=ChangeAnim
trigger1=Time=0
value=140 + (statetype=C) + (statetype=A)*2

[State 140, 2]
type=StateTypeSet
trigger1=Time=0 && statetype=S
physics=S

[State 140, 3]
type=StateTypeSet
trigger1=Time=0 && statetype=C
physics=C

[State 140, 4]
type=StateTypeSet
trigger1=Time=0 && statetype=A
physics=A

[State 140, Hi to Lo]
type=StateTypeSet
TriggerAll=Statetype=S
Trigger1=!var(59) && command="holddown"
Trigger2=var(59)
trigger2=enemynear(var(57)),StateType!=A
Trigger2=Random <= var(56)*50||var(59)>2
statetype=C
physics=C

[State 140, Lo to Hi]
type=StateTypeSet
TriggerAll=Statetype=C
Trigger1=!var(59) && command != "holddown"
Trigger2=var(59)
Trigger2=enemynear(var(57)),StateType=A && Random<=var(56)*50+1000*(var(59)>2)
Trigger3=var(59) && Random<=var(56)*50+1000*(var(59)>2)
statetype=S
physics=S


;---------------------------------------------------------------------------
[Statedef 150]
type   =S
movetype= H
physics=N
velset=0,0


[State 150, 1]
type = ChangeAnim
trigger1 = 1
value = 150

[State 150, 2]
type = ChangeState
trigger1 = HitShakeOver
value = 151 + 2*(command = "holddown")

[State 153, Hi to Lo]
type=StateTypeSet
TriggerAll=Statetype=S
Trigger1=!var(59)
Trigger1=command="holddown"
Trigger2=var(59)
Trigger2=enemynear(var(57)),StateType!=A
Trigger2=Random <= var(56)*50||var(59)>2
statetype=C
physics=C

[State 153, Lo to Hi]
type=StateTypeSet
TriggerAll=Statetype=C
Trigger1=!var(59)
Trigger1=command != "holddown"
Trigger2=var(59)
Trigger2=enemynear(var(57)),StateType=A && Random<=var(56)*50+1000*(var(59)>2)
Trigger3=var(59) && Random<=var(56)*50+1000*(var(59)>2)
statetype=S
physics=S

[State 150, コントローラの振動] ;使えるのか不明。消しても問題ないかも
type=ForceFeedback
trigger1=time=0
waveform=square
time=3

;---------------------------------------------------------------------------
; SGUARDHIT2 (knocked back)
[Statedef 151]
type   =S
movetype= H
physics=S
anim=150

[State 151, 1]
type=HitVelSet
trigger1=Time=0
x=1

[State 151, 2]
type=VelSet
trigger1=Time=GetHitVar(slidetime)
trigger2=HitOver
x=0

[State 151, 3]
type=CtrlSet
trigger1=Time=GetHitVar(ctrltime)
value=1

[State 151, Hi to Lo]
type=StateTypeSet
TriggerAll=Statetype=S
Trigger1=!var(59)
Trigger1=command="holddown"
Trigger2=var(59)
Trigger2=enemynear(var(57)),StateType!=A
Trigger2=Random <= var(56)*50||var(59)>2
statetype=C
physics=C

[State 151, Lo to Hi]
type=StateTypeSet
TriggerAll=Statetype=C
Trigger1=!var(59)
Trigger1=command != "holddown"
Trigger2=var(59)
Trigger2=enemynear(var(57)),StateType=A && Random<=var(56)*50+1000*(var(59)>2)
Trigger3=var(59) && Random<=var(56)*50+1000*(var(59)>2)
statetype=S
physics=S

[State 151, 4]
type=ChangeState
trigger1=HitOver
value=130
ctrl=1

;---------------------------------------------------------------------------
; CGUARDHIT (shaking)
[Statedef 152]
type    = C
movetype= H
physics = N
velset = 0,0

[State 152, 1]
type = ChangeAnim
trigger1 = 1
value = 151

[State 152, 3]
type = ChangeState
trigger1 = HitShakeOver
value = 151 + 2*(command = "holddown")


[State 153, Hi to Lo]
type=StateTypeSet
TriggerAll=Statetype=S
Trigger1=!var(59)
Trigger1=command="holddown"
Trigger2=var(59)
Trigger2=enemynear(var(57)),StateType!=A
Trigger2=Random <= var(56)*50||var(59)>2
statetype=C
physics=C

[State 153, Lo to Hi]
type=StateTypeSet
TriggerAll=Statetype=C
Trigger1=!var(59)
Trigger1=command != "holddown"
Trigger2=var(59)
Trigger2=enemynear(var(57)),StateType=A && Random<=var(56)*50+1000*(var(59)>2)
Trigger3=var(59) && Random<=var(56)*50+1000*(var(59)>2)
statetype=S
physics=S

[State 152, コントローラの振動]
type=ForceFeedback
trigger1=time=0
waveform=square
time=4

;---------------------------------------------------------------------------
; CGUARDHIT2 (knocked back)
[Statedef 153]
type   =C
movetype= H
physics=C
anim=151

[State 153, 1]
type=HitVelSet
trigger1=Time=0
x=1

[State 153, 2]
type=VelSet
trigger1=Time=GetHitVar(slidetime)
trigger2=HitOver
x=0

[State 153, 3]
type=CtrlSet
trigger1=Time=GetHitVar(ctrltime)
value=1

[State 153, Hi to Lo]
type=StateTypeSet
TriggerAll=Statetype=S
Trigger1=!var(59)
Trigger1=command="holddown"
Trigger2=var(59)
Trigger2=enemynear(var(57)),StateType!=A
Trigger2=Random <= var(56)*50||var(59)>2
statetype=C
physics=C

[State 153, Lo to Hi]
type=StateTypeSet
TriggerAll=Statetype=C
Trigger1=!var(59)
Trigger1=command != "holddown"
Trigger2=var(59)
Trigger2=enemynear(var(57)),StateType=A && Random<=var(56)*50+1000*(var(59)>2)
Trigger3=var(59) && Random<=var(56)*50+1000*(var(59)>2)
statetype=S
physics=S

[State 153, 4]
type=ChangeState
trigger1=HitOver
value=131
ctrl=1

;---------------------------------------------------------------------------
; AGUARDHIT (shaking)
[Statedef 154]
type    = A
movetype= H
physics = N
velset = 0,0

[State 154, 1]
type = ChangeAnim
trigger1 = 1
value = 152

[State 154, 2]
type = ChangeState
trigger1 = HitShakeOver
value = 155 ;AGUARDHIT2

[State 154, 3]
type = ForceFeedback
trigger1 = time = 0
waveform = square
time = 4
;---------------------------------------------------------------------------
; AGUARDHIT2 (knocked away)
[Statedef 155]
type   =A
movetype= H
physics=N
anim=152

[State 155, 1]
type=HitVelSet
trigger1=Time=0
x=1
y=1

[State 155, 2]
type=VelAdd
trigger1=1
y=Const(movement.yaccel)

[State 155, 3]
type=CtrlSet
trigger1=Time=GetHitVar(ctrltime)
value=1

[State 155, 4]
type=VarSet
trigger1=1
sysvar(0)=(pos y >= 0) && (vel y > 0)

[State 155, 5]
type=VelSet
trigger1=sysvar(0)
y=0

[State 155, 6]
type=PosSet
trigger1=sysvar(0)
y=0

[State 155, 6]
type=ChangeState
trigger1=sysvar(0)
trigger1=command="holdback"
trigger1=inguarddist
value=130

[State 155, 7]
type=ChangeState
trigger1=sysvar(0)
value=52

;==============================================================================;
; 初期化
;
; ※ 全てのキャラクターは最初のこのステートを通過する
;==============================================================================;
[Statedef 5900]
type = S

;-------[ Initialize Variables ]-------;

[State 5900:            Clear All Integer Variables]
type     = VarRangeSet
trigger1 = RoundsExisted = 0
value    = 0

[State 5900:            Clear All Floating Point Variables]
type     = VarRangeSet
trigger1 = RoundsExisted = 0
fvalue   = 0

;-------[ Check Training Mode ]-------;

[State 5900:            NoKO]
type       = AssertSpecial
triggerall = !var(58)
trigger1   = RoundsExisted = 0
flag       = NoKO

[State 5900:            Set Life to Zero]
type       = LifeSet
triggerall = !var(58)
trigger1   = RoundsExisted = 0
value      = 0
absolute   = 1

[State 5900:            Check Life is Zero?]
type       = VarSet
triggerall = !var(58)
triggerall = RoundsExisted = 0
trigger1   = Life != 0
v          = 58
value      = -2

[State 5900:            Recover Life]
type       = LifeSet
triggerall = Life != LifeMax
trigger1   = RoundsExisted = 0
value      = LifeMax
absolute   = 1

;-------[ Helpers ]-------;

[State 5900:            Call Config Helper]
type          = Helper
trigger1      = Time = 0
helpertype    = Normal
name          = "Config Helper"
stateno       = 9000
id            = 9000
ownpal        = 0
keyctrl       = 0
supermovetime = 2147483647
pausemovetime = 2147483647

;-------[ States ]-------;

[State 5900:            ChangeState, Intro]
type     = ChangeState
trigger1 = RoundsExisted = 0
value    = 190


;==============================================================================;
; 削りKO
;==============================================================================;
[Statedef 5950]
type     = U
movetype = H
physics  = U
anim     = 5950
ctrl     = 0
velset   = 0, 0

;-------[ Movement ]-------;

[State 5950:            Pos]
type     = PosSet
trigger1 = Time = 0
y        = 0

;-------[ Sounds ]-------;

[State 5950:            Voice, 1]
type           = PlaySnd
trigger1       = Anim = 5950
trigger1       = AnimElem = 2
value          = 0, 59 + (Random % 2)
channel        = 0
volume         = 255
ignorehitpause = 1

[State 5950:            SE, 1]
type       = PlaySnd
triggerall = Anim = 5950
trigger1   = AnimElem = 3
trigger2   = AnimElem = 7
value      = 7, 20

;-------[ Anim ]-------;

[State 5950:            Anim, Hit]
type     = ChangeAnim
trigger1 = !HitOver
value    = ifelse(StateType = C, 5020, 5010)

[State 5950:            Anim, Hit Over]
type       = ChangeAnim
trigger1   = HitOver
value      = 5950
elem       = ifelse(StateType = C, 4, 1)
persistent = 0

;-------[ States ]-------;

[State 5950:            Lie down]
type     = ChangeState
trigger1 = AnimTime = 0
value    = 5150


;==============================================================================;
; 常時監視ステート -2
;------------------------------------------------------------------------------;
; 1. 時間停止中は実行されない
; 2. 相手にステートを奪われていても実行される
; 3. Player扱いのヘルパーが参照する
;==============================================================================;
[Statedef -2]

;==============================================================================;
; 消費ゲージ量
;==============================================================================;
[State -1:          Set Hyper Combo Gauge Value]
type     = VarSet
trigger1 = !IsHelper
v        = 1
value    = ifelse(var(20) > 0, PowerMax + 1, 1000)  ; 通常1ゲージ, MAX時使用不可

[State -1:          Set MAX Hyper Combo Gauge Value]
type     = VarSet
trigger1 = !IsHelper
v        = 2
value    = ifelse(var(20) > 0, 1000, 3000)          ; 通常3ゲージ, MAX時1ゲージ

;[State -1:          Set Guard-Cancel Moves Gauge Value]
;type     = VarSet
;trigger1 = !IsHelper
;v        = 5
;value    = ifelse(var(20) > 0, 0, 1000)             ; 通常1ゲージ, MAX時消費なし

;==============================================================================;
; 相手位置
;==============================================================================;
[State -1:          Enemy Direction]
type           = VarSet
trigger1       = !IsHelper
trigger1       = P2BodyDist X = 0
fv             = 30
value          = ifelse(P2BodyDist Y <= 0, -90.0, 90.0)
ignorehitpause = 1

[State -1:          Enemy Direction]
type           = VarSet
trigger1       = !IsHelper
trigger1       = P2BodyDist X != 0
fv             = 30
value          = (Atan((P2BodyDist Y) / (P2BodyDist X)) * 180 / PI)
ignorehitpause = 1

[State -1:          EnemyNear ID]
type           = VarSet
trigger1       = !IsHelper
trigger1       = NumEnemy
v              = 35
value          = EnemyNear((EnemyNear(0),Alive = 0) && (NumEnemy > 1)),ID
ignorehitpause = 1

;==============================================================================;
; 削りKO処理
;==============================================================================;
[State -2:          ChangeState, Cheap Down]
type           = ChangeState
triggerall     = !IsHelper
triggerall     = !Alive
triggerall     = StateNo = [5000, 5050]
triggerall     = Time = 1
trigger1       = PrevStateNo = [130, 131]
trigger2       = PrevStateNo = [150, 153]
trigger3       = StateType != A
trigger3       = StateNo = 5001
trigger4       = StateType != A
trigger4       = StateNo = 5011
value          = 5950
ignorehitpause = 1

;==============================================================================;
; サウンド
;==============================================================================;
;------------------------------------------------------------------------------;
; 食らいボイス
;------------------------------------------------------------------------------;
[State -2:          Get Hit Voice]
type           = PlaySnd
triggerall     = !IsHelper
triggerall     = Alive
triggerall     = StateNo = 5000 || StateNo = 5010 || StateNo = 5020 || StateNo = 5070 || StateNo = 5080
triggerall     = Time = 1
trigger1       = GetHitVar(AnimType) >= 2 && Random < 500
trigger2       = GetHitVar(AnimType) < 2 && Random < 300
value          = 0, 50 + 3 * (Random % 4) + (GetHitVar(AnimType) % 3)
channel        = 0
lowpriority    = 1
ignorehitpause = 1
persistent     = 0

;------------------------------------------------------------------------------;
; 復帰ボイス
;------------------------------------------------------------------------------;
[State -2:          Recovery Voice]
type        = PlaySnd
triggerall  = Alive
triggerall  = Time = 1
trigger1    = StateNo = 5201
trigger2    = StateNo = 5210
value       = 0, 110 + (Random % 4)
channel     = 0
persistent  = 0

;------------------------------------------------------------------------------;
; 納刀
;------------------------------------------------------------------------------;
[State -2:          Sheathe a sword]
type       = PlaySnd
triggerall = !IsHelper
trigger1   = Anim = 220 && AnimElem = 7
trigger2   = Anim = 230 && AnimElem = 11
trigger3   = Anim = 420 && AnimElem = 8
trigger4   = Anim = 430 && AnimElem = 10
trigger5   = Anim = 600 && AnimElem = 7
trigger6   = Anim = 620 && AnimElem = 9
trigger7   = Anim = 630 && AnimElem = 9
trigger8   = Anim = 310 && AnimElem = 12
trigger9   = Anim = 320 && AnimElem = 5
trigger10  = Anim = 1000 && AnimElem = 12
trigger11  = Anim = 1023 && AnimElem = 2
trigger12  = Anim = 1030 && AnimElem = 9
trigger13  = Anim = 1031 && AnimElem = 13
trigger14  = Anim = 1040 && AnimElem = 12
trigger15  = Anim = 1041 && AnimElem = 16
trigger16  = Anim = 1042 && AnimElem = 12
trigger17  = Anim = 1045 && AnimElem = 10
trigger18  = Anim = 1046 && AnimElem = 10
trigger19  = Anim = 1047 && AnimElem = 10
trigger20  = Anim = 1044 && AnimElem = 2
trigger21  = Anim = 2000 && AnimElem = 12
trigger22  = Anim = 2001 && AnimElem = 12
trigger23  = Anim = 2021 && AnimElem = 3
trigger24  = Anim = 2031 && AnimElem = 32
trigger25  = Anim = 2032 && AnimElem = 36
value      = 1, 10
channel    = 1

;==============================================================================;
; キャンセルフラグ
;==============================================================================;
;------------------------------------------------------------------------------;
; チェーンコンボ
;------------------------------------------------------------------------------;
[State -2:          Reset Chain-Combo Level]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo != 200
trigger1   = StateNo != 210
trigger1   = StateNo != 220
trigger1   = StateNo != 230
trigger1   = StateNo != 400
trigger1   = StateNo != 410
trigger1   = StateNo != 420
trigger1   = StateNo != 430
trigger1   = StateNo != 600
trigger1   = StateNo != 610
trigger1   = StateNo != 620
trigger1   = StateNo != 630
trigger1   = StateNo != 301
trigger1   = StateNo != 320
trigger1   = StateNo != 1026
trigger1   = StateNo != 1027
trigger2   = StateNo = 200 && (!MoveContact || AnimElemTime(2) < 0 || AnimElemTime(5) >= 0)
trigger3   = StateNo = 210 && (!MoveContact || AnimElemTime(3) < 0 || AnimElemTime(6) >= 0)
trigger4   = StateNo = 220 && (!MoveContact || AnimElemTime(3) < 0 || AnimElemTime(7) >= 0)
trigger5   = StateNo = 230 && (!MoveContact || AnimElemTime(5) < 0 || AnimElemTime(11) >= 0)
trigger6   = StateNo = 400 && (!MoveContact || AnimElemTime(3) < 0 || AnimElemTime(7) >= 0)
trigger7   = StateNo = 410 && (!MoveContact || AnimElemTime(2) < 0)
trigger8   = StateNo = 420 && (!MoveContact || AnimElemTime(3) < 0 || AnimElemTime(8) >= 0)
trigger9   = StateNo = 430 && (!MoveContact || AnimElemTime(3) < 0 || AnimElemTime(10) >= 0)
trigger10  = StateNo = 600 && (!MoveContact || AnimElemTime(3) < 0)
trigger11  = StateNo = 610 && (!MoveContact || AnimElemTime(3) < 0)
trigger12  = StateNo = 620 && (!MoveContact || AnimElemTime(3) < 0)
trigger13  = StateNo = 630 && (!MoveContact || AnimElemTime(5) < 0)
trigger14  = StateNo = 301 && (!MoveContact || AnimElemTime(2) < 0)
trigger15  = StateNo = 320 && (!MoveContact || AnimElemTIme(2) < 0)
trigger16  = StateNo = 1026 && (!MoveContact || AnimElemTime(3) < 0 || AnimElemTime(7) >= 0)
trigger17  = StateNo = 1027 && (!MoveContact || AnimElemTime(3) < 0 || AnimElemTime(10) >= 0)
v          = 10
value      = 0

[State -2:          Set Chain-Combo Level 1]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 200 && MoveContact && AnimElemTime(5) < 0
trigger2   = StateNo = 210 && MoveContact && AnimElemTime(6) < 0
trigger3   = StateNo = 400 && MoveContact && AnimElemTime(7) < 0
trigger4   = StateNo = 410 && MoveContact
trigger5   = StateNo = 600 && MoveContact
trigger6   = StateNo = 610 && MoveContact
trigger7   = StateNo = 1026 && MoveContact && AnimElemTime(7) < 0
v          = 10
value      = 1

[State -2:          Set Chain-Combo Level 2]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 220 && MoveContact && AnimElemTime(7) < 0
trigger2   = StateNo = 420 && MoveContact && AnimElemTime(8) < 0
trigger3   = StateNo = 620 && MoveContact
trigger4   = StateNo = 301 && MoveContact && AnimElemTime(6) < 0
v          = 10
value      = 2

[State -2:          Set Chain-Combo Level 3]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 230 && MoveContact && AnimElemTime(11) < 0
trigger2   = StateNo = 630 && MoveContact
v          = 10
value      = 3

[State -2:          Set Chain-Combo Level 4]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 430 && MoveContact && AnimElemTime(10) < 0
trigger2   = StateNo = 320 && MoveContact
trigger3   = StateNo = 1027 && MoveContact && AnimElemTime(10) < 0
v          = 10
value      = 4

;------------------------------------------------------------------------------;
; 必殺技 to 必殺技キャンセル
;------------------------------------------------------------------------------;
[State -2:          Reset Super-To-Super Cancel]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo != 1005
trigger1   = StateNo != 1010
trigger1   = StateNo != 1040
trigger1   = StateNo != 1041
trigger2   = StateNo = 1005 && (AnimElemTime(8) < 0 || AnimElemTime(9) >= 0)
trigger3   = StateNo = 1010 && (!MoveContact || AnimElemTime(4) < 0 || AnimElemTime(11) >= 0)
trigger4   = StateNo = 1040 && (!MoveContact || (Anim = 1040 && AnimElemTime(12) >= 0) || (Anim = 1045 && AnimElemTime(10) >= 0))
trigger5   = StateNo = 1041 && (!MoveContact || (Anim = 1041 && AnimElemTime(16) >= 0) || (Anim = 1046 && AnimElemTime(10) >= 0))
v          = 14
value      = 0

[State -2:          Set Super-To-Super Cancel (Tsubaki)]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 1005
trigger1   = AnimElemTime(8) >= 0 && AnimElemTime(9) < 0
v          = 14
value      = 1

[State -2:          Set Super-To-Super Cancel (Nagi-Kaze)]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 1010 && AnimElemTime(11) < 0
trigger1   = MoveContact
v          = 14
value      = 2

[State -2:          Set Super-To-Super Cancel (Getsuga)]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 1040 && MoveContact
trigger1   = (Anim = 1040 && AnimElemTime(12) < 0) || (Anim = 1045 && AnimElemTime(10) < 0)
trigger2   = StateNo = 1041 && MoveContact
trigger2   = (Anim = 1041 && AnimElemTime(16) < 0) || (Anim = 1046 && AnimElemTime(10) < 0)
v          = 14
value      = 3

;------------------------------------------------------------------------------;
; スーパーキャンセル
;------------------------------------------------------------------------------;
[State -2:          Reset Super Cancel]
type       = VarSet
triggerall = !IsHelper
trigger1   = !var(14)
trigger2   = StateNo != 1022
trigger2   = StateNo != 1030
trigger2   = StateNo != 1042
trigger3   = StateNo = 1022 && (!MoveContact || !(AnimElemTime(2) > 0 && AnimElemTime(8) < 0))
trigger4   = StateNo = 1030 && (!MoveContact || !(AnimElemTime(7) >= 0 && AnimElemTime(9) < 0))
trigger5   = StateNo = 1042 && !(MoveContact && (Anim = 1042 && AnimElemTime(6) > 0 && AnimElemTime(12) < 0) || (Anim = 1047 && AnimElemTime(4) > 0 && AnimElemTime(10) < 0))
v          = 11
value      = 0

[State -2:          Set Super Cancel]
type       = VarSet
triggerall = !IsHelper
trigger1   = var(14)
trigger2   = StateNo = 1022 && MoveContact && AnimElemTime(2) > 0 && AnimElemTime(8) < 0
trigger3   = StateNo = 1030 && MoveContact && AnimElemTime(7) >= 0 && AnimElemTime(9) < 0
trigger4   = StateNo = 1042 && MoveContact && (Anim = 1042 && AnimElemTime(6) > 0 && AnimElemTime(12) < 0) || (Anim = 1047 && AnimElemTime(4) > 0 && AnimElemTime(10) < 0)
v          = 11
value      = 1

;------------------------------------------------------------------------------;
; ドリームキャンセル
;------------------------------------------------------------------------------;
[State -2:          Reset Dream Cancel]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo != 2000
trigger1   = StateNo != 2020
trigger2   = StateNo = 2000 && !(MoveContact && AnimElemTime(8) > 0 && AnimElemTime(10) < 0)
trigger3   = StateNo = 2020
trigger3   = !((AnimElemTime(20) > 0 && AnimElemTime(21) < 0) || (MoveContact && NumTarget(2022) && AnimElemTime(21) < 0))
v          = 12
value      = 0

[State -2:          Set Dream Cancel]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 2000 && MoveContact && AnimElemTime(8) > 0 && AnimElemTime(10) < 0
trigger2   = StateNo = 2020 && AnimElemTime(20) > 0 && AnimElemTime(21) < 0
trigger3   = StateNo = 2020 && MoveContact && NumTarget(2022) && AnimElemTime(21) < 0
v          = 12
value      = 1

;==============================================================================;
; ジャストディフェンス
;==============================================================================;
;------------------------------------------------------------------------------;
; ジャストディフェンス受付
;------------------------------------------------------------------------------;
[State -2:          Reset Just Defence Time]
type       = VarSet
triggerall = !IsHelper
triggerall = var(19) = 0
trigger1   = command != "holdback"
v          = 19
value      = -1

[State -2:          Set Just Defence Time]
type       = VarSet
triggerall = !IsHelper
triggerall = var(19) < 0
trigger1   = StateNo = 120
v          = 19
value      = 7

[State -2:          Count Down Just Defence Time]
type       = VarAdd
triggerall = !IsHelper
trigger1   = var(19) > 0
v          = 19
value      = -1

;==============================================================================;
; 攻撃力補正計算
;==============================================================================;
;------------------------------------------------------------------------------;
; 基本1 Const(data.attack) の補正 (TargetLifeAdd用)
;------------------------------------------------------------------------------;
[State -2:          Attack Correction by data.attack]
type           = VarSet
trigger1       = !IsHelper
fv             = 0
value          = Const(data.attack) * 0.01
ignorehitpause = 1

;------------------------------------------------------------------------------;
; モードによる補正
;------------------------------------------------------------------------------;
[State -2:          Attack Correction]
type           = VarSet
triggerall     = !IsHelper
trigger1       = 1
fv             = 1
value          = 1.0
ignorehitpause = 1

;------------------------------------------------------------------------------;
; 特殊カラー補正
;------------------------------------------------------------------------------;
[State -2:          Attack Correction by Normal Color]
type           = VarSet
triggerall     = !IsHelper
trigger1       = PalNo != 12
fv             = 2
value          = 1.0
ignorehitpause = 1

[State -2:          Attack Correction by Gold Color]
type           = VarSet
triggerall     = !IsHelper
trigger1       = PalNo = 12
fv             = 2
value          = 1.50
ignorehitpause = 1

;------------------------------------------------------------------------------;
; MAX補正
;------------------------------------------------------------------------------;
[State -2:          Reset Attack Correction by MAX]
type           = VarSet
triggerall     = !IsHelper
trigger1       = var(20) <= 0
fv             = 3
value          = 1.0
ignorehitpause = 1

[State -2:          Attack Correction by MAX]
type           = VarSet
triggerall     = !IsHelper
trigger1       = var(20) > 0
fv             = 3
value          = 1.2
ignorehitpause = 1

;------------------------------------------------------------------------------;
; ライフ補正
;------------------------------------------------------------------------------;
[State -2:          Attack Correction by Life, 0]
type           = VarSet
triggerall     = !IsHelper
trigger1       = Life > Ceil(LifeMax * 0.3)
fv             = 4
value          = 1.0
ignorehitpause = 1

[State -2:          Attack Correction by Life, 1]
type           = VarSet
triggerall     = !IsHelper
trigger1       = Life <= Ceil(LifeMax * 0.3)
trigger1       = Life > Ceil(LifeMax * 0.15)
fv             = 4
value          = 1.05
ignorehitpause = 1

[State -2:          Attack Correction by Life, 2]
type           = VarSet
triggerall     = !IsHelper
trigger1       = Life <= Ceil(LifeMax * 0.15)
fv             = 4
value          = 1.1
ignorehitpause = 1

;==============================================================================;
; 防御力補正計算
;==============================================================================;
;------------------------------------------------------------------------------;
; 落下時補正
;------------------------------------------------------------------------------;
[State -2:          Defence Correction by Hit Fall]
type           = VarSet
triggerall     = !IsHelper
trigger1       = HitFall
fv             = 5
value          = Const(data.fall.defence_mul)
ignorehitpause = 1

[State -2:          Defence Correction by Not Hit Fall]
type           = VarSet
triggerall     = !IsHelper
trigger1       = !HitFall
fv             = 5
value          = 1.0
ignorehitpause = 1

;------------------------------------------------------------------------------;
; モード補正
;------------------------------------------------------------------------------;
[State -2:          Defence Correction (Default)]
type           = VarSet
triggerall     = !IsHelper
trigger1       = PalNo != 12
fv             = 6
value          = 2.667
ignorehitpause = 1

;------------------------------------------------------------------------------;
; 特殊カラー補正
;------------------------------------------------------------------------------;
[State -2:          Defence Correction (Gold)]
type           = VarSet
triggerall     = !IsHelper
trigger1       = PalNo = 12
fv             = 6
value          = 1.3335
ignorehitpause = 1

;------------------------------------------------------------------------------;
; ライフ補正
;------------------------------------------------------------------------------;
[State -2:          Defenfce Correction by Life, 0]
type           = VarSet
triggerall     = !IsHelper
trigger1       = Life > Ceil(LifeMax * 0.3)
fv             = 7
value          = 1.0
ignorehitpause = 1

[State -2:          Defenfce Correction by Life, 1]
type           = VarSet
triggerall     = !IsHelper
trigger1       = Life <= Ceil(LifeMax * 0.3)
trigger1       = Life > Ceil(LifeMax * 0.15)
fv             = 7
value          = 0.9
ignorehitpause = 1

[State -2:          Defenfce Correction by Life, 2]
type           = VarSet
triggerall     = !IsHelper
trigger1       = Life <= Ceil(LifeMax * 0.15)
fv             = 7
value          = 0.75
ignorehitpause = 1

;==============================================================================;
; 補正反映
;==============================================================================;
;------------------------------------------------------------------------------;
; 攻撃力補正
;------------------------------------------------------------------------------;
[State -2:          Attack Correction for Attack Mul]
type           = VarSet
trigger1       = !IsHelper
fv             = 10
value          = fvar(1) * fvar(2) * fvar(3) * fvar(4)
ignorehitpause = 1

[State -2:          Attack Correction]
type           = AttackMulSet
trigger1       = !IsHelper
value          = fvar(10)
ignorehitpause = 1

;------------------------------------------------------------------------------;
; TargetLifeAdd用
;------------------------------------------------------------------------------;
[State -2:          Attack Correction for LifeAdd]
type           = VarSet
trigger1       = !IsHelper
fv             = 11
value          = fvar(0) * fvar(10)
ignorehitpause = 1

;------------------------------------------------------------------------------;
; 防御力補正
;------------------------------------------------------------------------------;
[State -2:          Defence Correction for Defefnce Mul]
type           = VarSet
trigger1       = !IsHelper
fv             = 12
value          = fvar(5) * fvar(6) * fvar(7)
ignorehitpause = 1

[State -2:          Defence Correction]
type           = DefenceMulSet
trigger1       = !IsHelper
value          = fvar(12)
ignorehitpause = 1

;------------------------------------------------------------------------------;
; GetHitVar(hitcount)
;------------------------------------------------------------------------------;
[State -2:          Hit Count Reset]
type           = VarSet
triggerall     = !IsHelper
trigger1       = MoveType != H
trigger2       = StateNo = [120, 159]
v              = 33
value          = 0
ignorehitpause = 1

[State -2:          Hit Count]
type           = VarSet
triggerall     = !IsHelper
trigger1       = MoveType = H
trigger1       = StateNo != [120, 159]
v              = 33
value          = GetHitVar(HitCount)
ignorehitpause = 1

;------------------------------------------------------------------------------;
; 一撃目補正
;------------------------------------------------------------------------------;
[State -2:          Calc First Get Hit Damage]
type           = LifeAdd
triggerall     = Alive
triggerall     = var(33) = 1
triggerall     = var(31) := GetHitVar(Damage)
trigger1       = var(30) := Floor(var(31) * (1.0 - (fvar(6) * fvar(7))))
value          = var(30)
absolute       = 1
persistent     = 0
ignorehitpause = 1

;==============================================================================;
; Bストーン システム
;==============================================================================;
;[State -2:          B-Stone Generator]
;type           = Helper
;triggerall     = !IsHelper
;triggerall     = !NumHelper(8210)
;triggerall     = NumTarget
;trigger1       = Target,GetHitvar(damage)
;helpertype     = Normal
;name           = "B-Stone Generator"
;stateno        = 8210
;id             = 8210
;postype        = p2
;pos            = 0, 0
;ownpal         = 0
;size.height    = Target,GetHitVar(damage)
;ignorehitpause = 1

;==============================================================================;
; 獣を焦がす対応
;
; 常時監視ステート (-1、-2、-3のどれか) に以下の記述を追加しておくと、
; ウチの秋葉が出した獣を焦がすの設置に反応して体力・パワーが減ります。
;
; ※1 ウチの秋葉はvar(39)に獣を焦がすの設置ヘルパーの「Player ID」を
;     格納するようにしたので、そのIDを元にPlayerIDリダイレクトで場所を取得、
;     その前後85以内にいるときに処理をするようにしてください
; ※2 下の記述ではsize.xscaleによる横幅変更に対応しようとしています。
; ※3 var(39)の内容は、
;     var(39) = -1      : 設置されていない
;     var(39) >= 0      : ヘルパーの Player ID
; ※4 変化量を調整したい場合は
;     ・GameTime % 2 のトリガーを弄る (何Fおきに処理するか)
;     ・valueの値を変更する           (一度にどれだけ変化するか)
;     をすればよいです。
; ※5 とりあえず設置ヘルパーの上にいるときになんらかの処理が出来ればいいので、
;     トリガーとかは適当に調整してください。
;==============================================================================;
[State -2:          Life]
type       = LifeAdd
triggerall = !IsHelper                  ; 本体限定
triggerall = RoundState = 2 && Alive    ; 試合中 かつ 生きている
triggerall = StateType != A             ; 地上にいる
triggerall = GameTime % 3 = 0           ; 3Fおきに処理
triggerall = NumEnemy                   ; 敵がいる
trigger1   = Enemy(0),AuthorName = "chikuchikugonzalez" && Enemy(0),Name = "Tohno Akiha"        ; 1P (or 2P) が秋葉
trigger1   = Enemy(0),var(39) >= 0                                                              ; IDが格納されている (格納されていない場合は -1)
trigger1   = PlayerIDExist(Enemy(0),var(39))                                                    ; 格納IDのキャラクター or Helperが存在する
trigger1   = Abs(PlayerID(Enemy(0),var(39)),Pos X - Pos X) < (85 * PlayerID(Enemy(0),var(39)),const(size.xscale))       ; 相手の前後85以内
trigger2   = NumEnemy > 1                                                                       ; 相手がタッグ
trigger2   = Enemy(1),AuthorName = "chikuchikugonzalez" && Enemy(1),Name = "Tohno Akiha"        ; 3P (or 4P) が秋葉
trigger2   = Enemy(1),var(39) >= 0                                                              ; IDが格納されている
trigger2   = PlayerIDExist(Enemy(1),var(39))                                                    ; 格納IDのキャラクター or Helperが存在する
trigger2   = Abs(PlayerID(Enemy(1),var(39)),Pos X - Pos X) < (85 * PlayerID(Enemy(1),var(39)),const(size.xscale))       ; 相手の前後85以内
value      = -1
kill       = 0

[State -2:          Power]
type       = PowerAdd
triggerall = !IsHelper
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = GameTime % 2 = 0
triggerall = NumEnemy
trigger1   = Enemy(0),AuthorName = "chikuchikugonzalez" && Enemy(0),Name = "Tohno Akiha"
trigger1   = Enemy(0),var(39) >= 0
trigger1   = PlayerIDExist(Enemy(0),var(39))
trigger1   = Abs(PlayerID(Enemy(0),var(39)),Pos X - Pos X) < (85 * PlayerID(Enemy(0),var(39)),const(size.xscale))
trigger2   = NumEnemy > 1
trigger2   = Enemy(1),AuthorName = "chikuchikugonzalez" && Enemy(1),Name = "Tohno Akiha"
trigger2   = Enemy(1),var(39) >= 0
trigger2   = PlayerIDExist(Enemy(1),var(39))
trigger2   = Abs(PlayerID(Enemy(1),var(39)),Pos X - Pos X) < (85 * PlayerID(Enemy(1),var(39)),const(size.xscale))
value      = Floor(-1 * (PowerMax * 0.001))

;==============================================================================;
; デバッグ出力
;==============================================================================;
;------------------------------------------------------------------------------;
; AI系
;------------------------------------------------------------------------------;
[State -2:          Debug AI]
type     = null;DisplayToClipboard
trigger1 = !IsHelper
text     = "AI:%d/%d(%dP)"
params   = var(59), var(58), PalNo

;------------------------------------------------------------------------------;
; 相手位置
;------------------------------------------------------------------------------;
[State -2:          Debug P2]
type     = null;AppendToClipboard
trigger1 = !IsHelper
trigger1 = NumEnemy = 1
text     = " P2Dist:%d x %d P2Vel:%.1f x %.1f DIR:%.2f"
params   = Ceil(P2BodyDist X), Ceil(P2BodyDist Y), (EnemyNear(0),Vel X), (EnemyNear(0),Vel Y), fvar(30)

[State -2:          Debug P2]
type     = null;AppendToClipboard
trigger1 = !IsHelper
trigger1 = NumEnemy > 1
text     = " P2Dist:%d x %d P2Vel:%.1f x %.1f DIR:%.2f"
params   = Ceil(P2BodyDist X), Ceil(P2BodyDist Y), (EnemyNear(EnemyNear,Alive = 0),Vel X), (EnemyNear(EnemyNear,Alive = 0),Vel Y), fvar(30)

[State -2:          Debug P2 ID]
type     = null;AppendToClipboard
trigger1 = !IsHelper
text     = " P2ID:%d"
params   = var(35)

;------------------------------------------------------------------------------;
; フラグ系
;------------------------------------------------------------------------------;
[State -2:          Debug Flags]
type     = null;AppendToClipboard
trigger1 = !IsHelper
text     = "\nCHAIN:%d SC:%d DC:%d MC:%d STSC:%d"
params   = var(10), var(11), var(12), var(13), var(14)

;[State -2:          Debug Blocking]
;type     = AppendToClipboard
;trigger1 = !IsHelper
;text     = "\nSB:%d CB:%d AB:%d BLK:%04X"
;params   = var(16), var(17), var(18), var(15)

[State -2:          Debug Just Defence]
type     = null;AppendToClipboard
trigger1 = !IsHelper
text     = " JD:%d"
params   = var(19)






;==============================================================================;
; Last Revision : $Rev: 1352 $
; Last Modified : $Date: 2012-01-25 01:15:44 +0900 (水, 25 1 2012) $
;==============================================================================;
