# -*- coding: utf-8 -*-

import sys
import cgi

import rtctree.tree
from omniORB import CORBA, PortableServer
import RTC
import OpenRTM__POA
import OpenRTM
import SDOPackage
import OpenRTM_aist
import CosNaming
from rtctree.utils import build_attr_string, dict_to_nvlist, nvlist_to_dict


import CGITest, CGITest__POA
import CGITest_idl

 
def main():

    form = cgi.FieldStorage()
    cmd = form['cmd'].value
    
    value = ""

    
    try:
        orb = CORBA.ORB_init(sys.argv)
        poa = orb.resolve_initial_references("RootPOA")
        
        naming = OpenRTM_aist.CorbaNaming(orb, "localhost")

        
        _mycon = OpenRTM_aist.CorbaConsumer(interfaceType=CGITest.mCGITest)
        
        _cpCon = OpenRTM_aist.CorbaPort("CGITest")
        _cpCon.registerConsumer("mCGITest", "CGITest::mCGITest", _mycon)
        
        
        

        
        
        
        

        

        poa._get_the_POAManager().activate()

        tree = rtctree.tree.RTCTree(servers='localhost', orb=orb)
        rtc = tree.get_node(['/', 'localhost','CGITestProvider0.rtc'])
        
        
        
        e_port = rtc.get_port_by_name("CGITest")._obj

        
            
        conprof = RTC.ConnectorProfile("connector0", "", [e_port,_cpCon.getPortRef()], [])
        ret = e_port.connect(conprof)
        

        if cmd == "set":
            value = form['value'].value
            _mycon._ptr().set(value)
        elif cmd == "get":
            value = _mycon._ptr().get()
            
        
        

        _cpCon.disconnect_all()

        

        
        
        
        
        
        poa.deactivate_object(poa.servant_to_id(_cpCon))
        _cpCon.setPortRef(RTC.PortService._nil)
        del _cpCon

        orb.destroy()
    except:
        pass

    print "Content-type: text/html;charset=utf-8"
    print ""
    print value
    



if __name__ == '__main__':
  main()
  
  
  

  
    
  
