#include <coil/UUID.h>
#include <coil/stringutil.h>
#include <coil/OS.h>
#include <coil/Process.h>
#include <coil/File.h>
#include <coil/DynamicLib.h>


#include <iostream>
#include <fstream>

typedef int (*TestDLL)();
TestDLL InInitFunc;


int main()
{
	std::cout << "UUID.h****************************************" << std::endl;

	coil::UUID_Generator *m_uuid = new coil::UUID_Generator();
	coil::UUID* m_generateUUID = m_uuid->generateUUID(0, 0);
	
	std::string m_uuidstr = m_generateUUID->to_string();


	
	
	std::cout << "UUID̐(generateUUID)" << std::endl;
	std::cout << m_uuidstr << std::endl;

	delete m_uuid;
	delete m_generateUUID;


	std::cout << "stringutil.h*************************************" << std::endl;
	std::string teststr = "test";
	std::wstring testwstr;
	testwstr = coil::string2wstring(teststr);
	std::cout << "stringwstringɕϊ(string2wstring)" << std::endl;
	std::wcout << testwstr << std::endl;

	teststr = coil::wstring2string(testwstr);
	std::cout << "wstringstringɕϊ(wstring2string)" << std::endl;
	std::cout << teststr << std::endl;

	teststr = "test";
	coil::toUpper(teststr);

	std::cout << "啶̕ϊ(toUpper)" << std::endl;
	std::cout << teststr << std::endl;

	coil::toLower(teststr);

	std::cout << "̕ϊ(toLower)" << std::endl;
	std::cout << teststr << std::endl;

	std::ifstream ifs( "test.txt" );

	int len = coil::getlinePortable(ifs, teststr);

	std::cout << "̓Xg[1sǂݍ(getlinePortable)" << std::endl;
	std::cout << teststr << std::endl;

	len = coil::getlinePortable(ifs, teststr);
	std::cout << teststr << std::endl;

	teststr = "test\ttest";

	bool ans = coil::isEscaped(teststr, 5);

	std::cout << "w肵ʒu̕GXP[vĂ邩𔻒f(isEscaped)" << std::endl;
	std::cout << ans << std::endl;

	teststr = coil::escape(teststr);

	std::cout << "\\t,\\nGXP[vV[PXɕϊ(escape)" << std::endl;
	std::cout << teststr << std::endl;

	teststr = coil::unescape(teststr);

	std::cout << "GXP[vV[PX𕶎ɕϊ(unescape)" << std::endl;
	std::cout << teststr << std::endl;

	coil::eraseBlank(teststr);
	std::cout << "󔒕(Xy[XA^u)̍폜(eraseBlank)" << std::endl;
	std::cout << teststr << std::endl;

	teststr = "\ttest\t";
	coil::eraseBlank(teststr);

	std::cout << "擪̋󔒕폜(eraseBlank)" << std::endl;
	std::cout << teststr << std::endl;

	coil::eraseTailBlank(teststr);
	std::cout << "̋󔒕폜(eraseTailBlank)" << std::endl;
	std::cout << teststr << teststr << std::endl;

	teststr = "\ttest\t";
	coil::eraseBothEndsBlank(teststr);
	std::cout << "擪A̋󔒕̍폜(eraseBothEndsBlank)" << std::endl;
	std::cout << teststr << teststr << std::endl;

	teststr = "\tTEST\t";
	teststr = coil::normalize(teststr);
	std::cout << "𐳋K(擪A̋󔒕폜Əɕϊ)(normalize)" << std::endl;
	std::cout << teststr << std::endl;

	teststr = "C:/Test/Test";
	len = coil::replaceString(teststr, "/", "\\");
	std::cout << "̒u(replaceString)" << std::endl;
	std::cout << teststr << std::endl;

	coil::vstring va = coil::split(teststr, "\\");
	std::cout << "𕪊(split)" << std::endl;
	for(int i=0;i < va.size();i++)
	{
		std::cout << i << "\t" << va[i] << std::endl;
	}


	
	bool ba = coil::includes(va, "Test");
	std::cout << "񃊃XgɎw肵񂪑݂邩(includes)" << std::endl;
	std::cout << ba << std::endl;

	va = coil::unique_sv(va);
	std::cout << "񃊃Xgd폜(unique_sv)" << std::endl;
	for(int i=0;i < va.size();i++)
	{
		std::cout << i << "\t" << va[i] << std::endl;
	}

	
	teststr = coil::flatten(va);
	std::cout << "񃊃XgCSV(J}؂)𐶐(flatten)" << std::endl;
	std::cout << teststr << std::endl;

	char **cca = coil::toArgv(va);
	std::cout << "񃊃XgXg(char**)ɕϊ(toArgv)" << std::endl;
	for(int i=0;i < va.size();i++)
	{
		std::cout << i << "\t" << cca[i] << std::endl;
	}

	
	ba = coil::includes(va, "Test");
	std::cout << "J}؂̃XgɎw̕񂪑݂邩(includes)" << std::endl;
	std::cout << ba << std::endl;


	teststr = "True";
	ba = coil::toBool(teststr, "True", "False");
	std::cout << "boollɕϊ(toBool)" << std::endl;
	std::cout << ba << std::endl;

	

	teststr = "C:\\Test";
	ba = coil::isAbsolutePath(teststr);
	std::cout << "΃pX̔(isAbsolutePath)" << std::endl;
	std::cout << ba << std::endl;

	teststr = "http://test";
	ba = coil::isURL(teststr);
	std::cout << "URL̔(isURL)" << std::endl;
	std::cout << ba << std::endl;

	float fa = 100;
	teststr = coil::otos<float>(fa);
	std::cout << "floatstd::stringɕϊ(otos)" << std::endl;
	std::cout << teststr << std::endl;

	teststr = "120";
	ba = coil::stringTo<float>(fa, teststr.c_str());
	std::cout << "std::stringfloatɕϊ(stringTo<float>)" << std::endl;
	std::cout << fa << std::endl;

	const char *ca = "ctest";
	ba = coil::stringTo(teststr, ca);
	std::cout << "const char*std::stringɕϊ(stringTo)" << std::endl;
	std::cout << teststr << std::endl;

	teststr = coil::sprintf("test%d",1);
	std::cout << "ŗ^ꂽ̕ϊ(sprintf)" << std::endl;
	std::cout << teststr << std::endl;


	std::cout << "OS.h******************************************" << std::endl;
	coil::utsname un;
	int ret = coil::uname(&un);
	std::cout << "VXe擾(uname)" << std::endl;
	std::cout << un.sysname << std::endl;
	std::cout << un.nodename << std::endl;
	//std::cout << un.release << std::endl;
	//std::cout << un.version << std::endl;
	//std::cout << un.machine << std::endl;

	
	ret = coil::getpid();
	std::cout << "ĂяõvZXID擾(getpid)" << std::endl;
	std::cout << ret << std::endl;

	ret = coil::getppid();
	std::cout << "ĂяõvZX̐evZXID擾(getppid)" << std::endl;
	std::cout << ret << std::endl;

	char* ca2 = coil::getenv("PATH");
	std::cout << "ϐ擾(getenv)" << std::endl;
	std::cout << ca2 << std::endl;

	std::cout << "vZXN(launch_shell)" << std::endl;
	coil::launch_shell("notepad");


	std::cout << "File.h****************************************" << std::endl;
	char *ca3 = "C:/Test/Test.txt";
	teststr = coil::dirname(ca3);
	std::cout << "t@CpXfBNgpX擾(dirname)" << std::endl;
	std::cout << teststr << std::endl;

	
	teststr = coil::basename(ca3);
	std::cout << "t@CpXt@C擾(basename)" << std::endl;
	std::cout << teststr << std::endl;


	va = coil::filelist("C:/Program Files/OpenRTM-aist/1.1/coil", "File.h");
	
	std::cout << "fBNgpX̒Ŏwt@CɃ}b`郊Xg擾(filelist)" << std::endl;
	for(int i=0;i < va.size();i++)
	{
		std::cout << i << "\t" << va[i] << std::endl;
	}

	/*coil::DIR *ad = coil::opendir("C:/Program Files/OpenRTM-aist/1.1/coil");
	coil::dirent *adt = coil::readdir(ad);
	std::cout << adt->d_name << std::endl;
	coil::closedir(ad);*/
	
	std::cout << "DynamicLib.h****************************************" << std::endl;
	coil::DynamicLib *dl = new coil::DynamicLib();

	std::cout << "INCũ[h(DynamicLib::open)" << std::endl;
	ret = dl->open("TestDLL.dll");
	if(ret == 0)
	{
		std::cout << "[h" << std::endl;
	}
	else
	{
		std::cout << "[hs" << std::endl;
		return -1;
	}

	std::cout << "V{[hꂽAhX擾(DynamicLib::symbol)" << std::endl;
	InInitFunc = (TestDLL)TestDLL(dl->symbol("TestDLL"));
	if (InInitFunc == NULL) {
		std::cout << "֐܂" << std::endl;
		return -2;
	}

	std::cout << InInitFunc() << std::endl;


	std::cout << "INCũA[h(DynamicLib::close)" << std::endl;
	ret = dl->close();
	if(ret == 0)
	{
		std::cout << "A[h" << std::endl;
	}
	else
	{
		std::cout << "A[hs" << std::endl;
		return -3;
	}
	return 0;
}