// -*- C++ -*-
/*!
 * @file  Test.cpp
 * @brief Test Component
 * @date $Date$
 *
 * $Id$
 */

#include "Test.h"

// Module specification
// <rtc-template block="module_spec">
static const char* test_spec[] =
  {
    "implementation_id", "Test",
    "type_name",         "Test",
    "description",       "Test Component",
    "version",           "1.0.0",
    "vendor",            "Sample",
    "category",          "TEST",
    "activity_type",     "PERIODIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    "conf.default.test", "10",
    // Widget
    "conf.__widget__.test", "text",
    // Constraints
    ""
  };
// </rtc-template>

class MyExecutionContextActionListener
    : public RTC::ExecutionContextActionListener
{
public:
	MyExecutionContextActionListener(std::string name)
	{
		m_name = name;
	};
	void operator()(RTC::UniqueId ec_id)
	{
		std::cout << m_name << coil::otos<int>(ec_id) << std::endl;
	};
	std::string m_name;
};


class MyPostComponentActionListener
    : public RTC::PostComponentActionListener
{
public:
	MyPostComponentActionListener(std::string name)
	{
		m_name = name;
	};
	void operator()(RTC::UniqueId ec_id, ReturnCode_t ret)
	{
		std::cout << m_name << coil::otos<int>(ec_id) << ":" << coil::otos<int>(ret) << std::endl;
	};
	std::string m_name;
};

class MyPreComponentActionListener
    : public RTC::PreComponentActionListener
{
public:
	MyPreComponentActionListener(std::string name)
	{
		m_name = name;
	};
	void operator()(RTC::UniqueId ec_id)
	{
		std::cout << m_name << coil::otos<int>(ec_id) << std::endl;
	};
	std::string m_name;
};


class MyConfigurationSetListener
    : public RTC::ConfigurationSetListener
{
public:
	MyConfigurationSetListener(std::string name)
	{
		m_name = name;
	};
	void operator()(const coil::Properties& config_set)
	{
		std::cout << m_name << std::endl;
	};
	std::string m_name;
};


class MyConfigurationParamListener
    : public RTC::ConfigurationParamListener
{
public:
	MyConfigurationParamListener(std::string name)
	{
		m_name = name;
	};
	void operator()(const char *config_set_name, const char *config_param_name)
	{
		std::cout << m_name << ":" << config_set_name << ":" << config_param_name << std::endl;
	};
	std::string m_name;
};


class MyConfigurationSetNameListener
    : public RTC::ConfigurationSetNameListener
{
public:
	MyConfigurationSetNameListener(std::string name)
	{
		m_name = name;
	};
	void operator()(const char *config_set_name)
	{
		std::cout << m_name << ":" << config_set_name << std::endl;
	};
	std::string m_name;
};



/*!
 * @brief constructor
 * @param manager Maneger Object
 */
Test::Test(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager)
  //m_ValueOut("Value", m_Value)

    // </rtc-template>
{
}

/*!
 * @brief destructor
 */
Test::~Test()
{
}



RTC::ReturnCode_t Test::onInitialize()
{
	//addOutPort("Value", m_ValueOut);

	addExecutionContextActionListener(EC_ATTACHED, new MyExecutionContextActionListener("ATTACHED:"));
	addExecutionContextActionListener(EC_DETACHED, new MyExecutionContextActionListener("DETACHED:"));
  
	addPostComponentActionListener(POST_ON_INITIALIZE, new MyPostComponentActionListener(":INITIALIZE"));
	addPostComponentActionListener(POST_ON_FINALIZE, new MyPostComponentActionListener(":FINALIZE"));
	addPostComponentActionListener(POST_ON_STARTUP, new MyPostComponentActionListener(":STARTUP"));
	addPostComponentActionListener(POST_ON_SHUTDOWN, new MyPostComponentActionListener(":SHUTDOWN"));
	addPostComponentActionListener(POST_ON_ACTIVATED, new MyPostComponentActionListener(":ACTIVATED"));
	addPostComponentActionListener(POST_ON_DEACTIVATED, new MyPostComponentActionListener(":DEACTIVATED"));
	addPostComponentActionListener(POST_ON_ABORTING, new MyPostComponentActionListener(":ABORTING"));
	addPostComponentActionListener(POST_ON_ERROR, new MyPostComponentActionListener(":ERROR"));
	addPostComponentActionListener(POST_ON_RESET, new MyPostComponentActionListener(":RESET"));
	addPostComponentActionListener(POST_ON_EXECUTE, new MyPostComponentActionListener(":EXECUTE"));
	addPostComponentActionListener(POST_ON_STATE_UPDATE, new MyPostComponentActionListener(":ON_STATE_UPDATE"));
	addPostComponentActionListener(POST_ON_RATE_CHANGED, new MyPostComponentActionListener(":RATE_CHANGED"));


	addPreComponentActionListener(PRE_ON_INITIALIZE, new MyPreComponentActionListener(":INITIALIZE"));
	addPreComponentActionListener(PRE_ON_FINALIZE, new MyPreComponentActionListener(":FINALIZE"));
	addPreComponentActionListener(PRE_ON_STARTUP, new MyPreComponentActionListener(":STARTUP"));
	addPreComponentActionListener(PRE_ON_SHUTDOWN, new MyPreComponentActionListener(":SHUTDOWN"));
	addPreComponentActionListener(PRE_ON_ACTIVATED, new MyPreComponentActionListener(":ACTIVATED"));
	addPreComponentActionListener(PRE_ON_DEACTIVATED, new MyPreComponentActionListener(":DEACTIVATED"));
	addPreComponentActionListener(PRE_ON_ABORTING, new MyPreComponentActionListener(":ABORTING"));
	addPreComponentActionListener(PRE_ON_ERROR, new MyPreComponentActionListener(":ERROR"));
	addPreComponentActionListener(PRE_ON_RESET, new MyPreComponentActionListener(":RESET"));
	addPreComponentActionListener(PRE_ON_EXECUTE, new MyPreComponentActionListener(":EXECUTE"));
	addPreComponentActionListener(PRE_ON_STATE_UPDATE, new MyPreComponentActionListener(":ON_STATE_UPDATE"));
	addPreComponentActionListener(PRE_ON_RATE_CHANGED, new MyPreComponentActionListener(":RATE_CHANGED"));
	
	addConfigurationSetListener(ON_SET_CONFIG_SET, new MyConfigurationSetListener("ON_SET_CONFIG_SET:"));
	addConfigurationSetListener(ON_ADD_CONFIG_SET, new MyConfigurationSetListener("ON_ADD_CONFIG_SET:"));

	addConfigurationParamListener(ON_UPDATE_CONFIG_PARAM, new MyConfigurationParamListener("ON_UPDATE_CONFIG_PARAM:"));
	
	addConfigurationSetNameListener(ON_UPDATE_CONFIG_SET, new MyConfigurationSetNameListener("ON_UPDATE_CONFIG_SET:"));
	addConfigurationSetNameListener(ON_REMOVE_CONFIG_SET, new MyConfigurationSetNameListener("ON_REMOVE_CONFIG_SET:"));
	addConfigurationSetNameListener(ON_ACTIVATE_CONFIG_SET, new MyConfigurationSetNameListener("ON_ACTIVATE_CONFIG_SET:"));
	
	
		
	// Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  
  // Set OutPort buffer
  
  // Set service provider to Ports
  
  // Set service consumers to Ports
  
  // Set CORBA Service Ports
  
  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable
  bindParameter("test", m_test, "10");
  
  // </rtc-template>
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t Test::onFinalize()
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t Test::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t Test::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t Test::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t Test::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


RTC::ReturnCode_t Test::onExecute(RTC::UniqueId ec_id)
{
	//std::cout << m_ValueOut.connectors()[0]->getBuffer()->length() << std::endl;
	//cdrMemoryStream ans;
	//ans = m_ValueOut.connectors()[0]->getBuffer()->get();
	
	//m_ValueOut.connectors()[0]->getBuffer()->advanceRptr(1);

	//m_ValueOut.connectors()[0]->getBuffer()->read(ans);
	
	//m_ValueOut.connectors()[0]->getBuffer()->write(&m_Value);
	//m_Value.data = 10;
	//m_ValueOut.connectors()[0]->getBuffer()->put(&m_Value);
	//m_ValueOut.connectors()[0]->getBuffer()->advanceRptr(1);
	//m_ValueOut.connectors()[0]->write(&m_Value);
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t Test::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t Test::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t Test::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t Test::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t Test::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/



extern "C"
{
 
  void TestInit(RTC::Manager* manager)
  {
    coil::Properties profile(test_spec);
    manager->registerFactory(profile,
                             RTC::Create<Test>,
                             RTC::Delete<Test>);
  }
  
};


