#include <stdio.h>
#include <mraa.hpp>
#include <unistd.h>
#include <sys/time.h>
#include <stdlib.h>
#include <iostream>
#include <math.h>




int main(int argc, char *argv[])
{
	
	

	

	
	mraa::Gpio* gpio = new mraa::Gpio(4);
	mraa_result_t response = gpio->dir(mraa::DIR_OUT);
	if (response != MRAA_SUCCESS) {
        	mraa::printError(response);
        	return 1;
    	}
	gpio->write(1);
	
	mraa::Spi* spi = new mraa::Spi(0);
	

	for(int i=0;i < 1000;i++)
	{
		
		uint8_t *recv;
		
		uint8_t data[2];
		data[0] = 0x68;
		data[1] = 0x00;
		gpio->write(0);
		
		recv = spi->write(data,2);
		gpio->write(1);
		
		

		unsigned int ans = ((recv[0] << 8) + recv[1]) & 0x03FF;

		

		
		std::cout << ans << "\t" << (int)recv[0] << "\t" << (int)recv[1] << std::endl;
		
		usleep(50000);
		
		
	}

	gpio->write(0);

	delete gpio;
	delete spi;

	
    	return 0;
}
