Scriptname SL01SPSQuestScript extends Quest

ReferenceAlias[] Property aAliasSPSFollower  Auto 
ReferenceAlias[] Property aAliasSPSAnimalFollower  Auto

GlobalVariable Property SL01SPSFollowerCount Auto
GlobalVariable Property SL01SPSAnimalFollowerCount Auto

Faction Property pCurrentSPSFollower  Auto  
Faction Property pCurrentSPSAnimalFollower  Auto
Faction Property pPotentialSPSFollower  Auto
Faction Property pPotentialSPSAnimalFollower  Auto
Faction Property PlayerfollowerFaction  Auto  
Faction Property pCurrentHireling  Auto 
Faction Property pDismissFollowerFaction  Auto

;---------------- Set SPSFollower --------------------------
Function SL01SetSPSFollower(Actor FollowerRef)

	Int iAliasLength = aAliasSPSFollower.Length
	Debug.Trace("[SL01SPS:SetSPSFollower] iAliasLength is" + iAliasLength)
	Int iAliasIndex	= -1
	While iAliasLength > 0											;seek Empty Alias
		iAliasLength -= 1
		If aAliasSPSFollower[iAliasLength].GetActorReference() == NONE
			iAliasIndex = iAliasLength
		EndIf
	EndWhile
		
		aAliasSPSFollower[iAliasIndex].ForceRefTo(FollowerRef)
		;FollowerRef.RemoveFromFaction(pDismissFollowerFaction)
		Debug.Trace("[SL01SPS:SetSPSFollower] " + FollowerRef + " becomes your " + aAliasSPSFollower[iAliasIndex])
		
		FollowerRef.SetActorValue("WaitingForPlayer", 0)				;Reset Wait
			aAliasSPSFollower[iAliasIndex].UnRegisterForUpdateGameTime()
		;FollowerRef.IgnoreFriendlyHits()

		int RelationshipRank = FollowerRef.GetrelationshipRank(Game.GetPlayer())  ;make an Ally of Player 
		If RelationshipRank < 3 && RelationshipRank >= 0
			FollowerRef.SetRelationshipRank(Game.GetPlayer(),3)
		EndIf

		pCurrentSPSFollower.SetAlly(PlayerFollowerFaction)

		FollowerRef.SetPlayerTeammate(True,True)
		SL01SPSFollowerCount.Mod(1)

		FollowerRef.EvaluatePackage()

EndFunction

;---------------- Set SPSAnimalFollower --------------------------
Function SL01SetSPSAnimalFollower(Actor AnimalRef)

	Int iAliasLength = aAliasSPSAnimalFollower.Length
	Debug.Trace("[SL01SPS:SetSPSAnimalFollower] iAliasLength is" + iAliasLength)
	Int iAliasIndex	= -1
	While iAliasLength > 0											;seek Empty Alias
		iAliasLength -= 1
		If aAliasSPSAnimalFollower[iAliasLength].GetActorReference() == NONE
			iAliasIndex = iAliasLength
		EndIf
	EndWhile
		
		aAliasSPSAnimalFollower[iAliasIndex].ForceRefTo(AnimalRef)
		Debug.Trace("[SL01SPS:SetSPSAnimalFollower] " + AnimalRef + " becomes your " + aAliasSPSAnimalFollower[iAliasIndex])
		
		AnimalRef.SetActorValue("WaitingForPlayer", 0)				;Reset Wait
			aAliasSPSAnimalFollower[iAliasIndex].UnRegisterForUpdateGameTime()
		;AnimalRef.IgnoreFriendlyHits()

		AnimalRef.SetRelationshipRank(Game.GetPlayer(),3)
		pCurrentSPSAnimalFollower.SetAlly(PlayerFollowerFaction)
		AnimalRef.SetActorValue("Lockpicking", 0)		;don't allow lockpicking

		AnimalRef.SetPlayerTeammate(True,False)
		SL01SPSAnimalFollowerCount.Mod(1)

		AnimalRef.EvaluatePackage()

EndFunction

;----------------- Get My AliasRef --------------------------------
ReferenceAlias Function SL01GetMyAlias(Actor akSpeaker)

	Int iAliasLength = -1

	If akSpeaker.IsInFaction(pCurrentSPSFollower)
		iAliasLength = aAliasSPSFollower.Length	
		While iAliasLength > 0											;seek akSpeaker's Alias
			iAliasLength -= 1
			If aAliasSPSFollower[iAliasLength].GetActorReference() == akSpeaker
				Debug.Trace("[SL01SPS.GetMyAlias] My Alias is " + aAliasSPSFollower[iAliasLength] + ".")
				return aAliasSPSFollower[iAliasLength]
			EndIf
		EndWhile

	ElseIf akSpeaker.IsInFaction(pCurrentSPSAnimalFollower)
		iAliasLength = aAliasSPSAnimalFollower.Length
		While iAliasLength > 0											;seek akSpeaker's Alias
			iAliasLength -= 1
			If aAliasSPSAnimalFollower[iAliasLength].GetActorReference() == akSpeaker
				Debug.Trace("[SL01SPS.GetMyAlias] My Alias is " + aAliasSPSAnimalFollower[iAliasLength] + ".")
				return aAliasSPSAnimalFollower[iAliasLength]
			EndIf
		EndWhile

	Else
		Debug.Trace("[SL01SPS.GetMyAlias] " + akSpeaker + " is not SPSFollower. Do Nothing.")
	EndIf

EndFunction

;----------------- Wait SPSFollower ------------------------
Function SL01ToggleWait(Actor akSpeaker)

	ReferenceAlias SPSFollowerAlias = SL01GetMyAlias(akSpeaker)
		
		If akSpeaker.GetActorValue("WaitingForPlayer") == 0
			akSpeaker.SetActorValue("WaitingForPlayer", 1)
			SPSFollowerAlias.RegisterForUpdateGameTime(72)
			Debug.Trace("[SL01SPS:ToggleWait] " + akSpeaker + " goes Waiting state.")
		Else
			akSpeaker.SetActorValue("WaitingForPlayer", 0)
			SPSFollowerAlias.UnRegisterForUpdateGameTime()
			Debug.Trace("[SL01SPS:ToggleWait] " + akSpeaker + " goes Following state.")
		EndIf
		akSpeaker.EvaluatePackage()

EndFunction

;----------------- Dismiss SPSFollower ------------------------
Function SL01DismissSPSFollower(Actor akSpeaker)

	ReferenceAlias DismissFollowerAlias = SL01GetMyAlias(akSpeaker)

	akSpeaker.SetPlayerTeammate(False)
	;akSpeaker.AddToFaction(pDismissFollowerFaction)
	;akSpeaker.AddToFaction(pPotentialSPSFollower)
	akSpeaker.RemoveFromFaction(pCurrentHireling)

	akSpeaker.SetActorValue("WaitingForPlayer", 0)				;Reset Wait
		DismissFollowerAlias.UnRegisterForUpdateGameTime()
	;akSpeaker.IgnoreFriendlyHits(False)

	DismissFollowerAlias.Clear()								;Clear Alias
	Debug.Trace("[SL01SPS.DismissSPSFollower] Alias:" + DismissFollowerAlias + " left your service.")

	SL01SPSFollowerCount.Mod(-1)

EndFunction

;----------------- Dismiss SPSAnimalFollower ------------------------
Function SL01DismissSPSAnimalFollower(Actor akSpeaker)

	ReferenceAlias DismissFollowerAlias = SL01GetMyAlias(akSpeaker)

	akSpeaker.SetPlayerTeammate(False)
	;akSpeaker.AddToFaction(pPotentialSPSAnimalFollower)

	akSpeaker.SetActorValue("WaitingForPlayer", 0)				;Reset Wait
		DismissFollowerAlias.UnRegisterForUpdateGameTime()
	;akSpeaker.IgnoreFriendlyHits(False)

	DismissFollowerAlias.Clear()								;Clear Alias
	Debug.Trace("[SL01SPS.DismissSPSAnimalFollower] Alias:" + DismissFollowerAlias + " left your service.")

	SL01SPSAnimalFollowerCount.Mod(-1)

EndFunction

;----------------- Dismiss All SPSFollower ------------------------
Function SL01AllDismissSPSFollower()
	Int iAliasLength = aAliasSPSFollower.Length

	Debug.Trace("[SL01SPS.AllDismissSPSFollower] Start")
	While iAliasLength > 0
		iAliasLength -= 1
		Actor DismissFollowerActor = aAliasSPSFollower[iAliasLength].GetActorReference() as actor
		If DismissFollowerActor != NONE
			SL01DismissSPSFollower(DismissFollowerActor)
			Debug.Trace("[SL01SPS.AllDismissSPSFollower] Alias:" + aAliasSPSFollower[iAliasLength] + " is cleared.")
		Else
			Debug.Trace("[SL01SPS.AllDismissSPSFollower] Alias:" + aAliasSPSFollower[iAliasLength] + " is Empty. Do nothing.")
		EndIf
	EndWhile

	SL01SPSFollowerCount.SetValue(0)
	Debug.Trace("[SL01SPS.AllDismissSPSFollower] Fin")

EndFunction

;----------------- Dismiss All SPSAnimalFollower ------------------------
Function SL01AllDismissSPSAnimalFollower()
	Int iAliasLength = aAliasSPSAnimalFollower.Length

	Debug.Trace("[SL01SPS.AllDismissSPSAnimalFollower] Start")
	While iAliasLength > 0
		iAliasLength -= 1
		Actor DismissFollowerAnimal = aAliasSPSAnimalFollower[iAliasLength].GetActorReference() as actor
		If DismissFollowerAnimal != NONE
			SL01DismissSPSAnimalFollower(DismissFollowerAnimal)
			Debug.Trace("[SL01SPS.AllDismissSPSAnimalFollower] Alias:" + aAliasSPSAnimalFollower[iAliasLength] + " is cleared.")
		Else
			Debug.Trace("[SL01SPS.AllDismissSPSAnimalFollower] Alias:" + aAliasSPSAnimalFollower[iAliasLength] + " is Empty. Do nothing.")
		EndIf
	EndWhile

	SL01SPSAnimalFollowerCount.SetValue(0)
	Debug.Trace("[SL01SPS.AllDismissSPSAnimalFollower] Fin")

EndFunction
