<?php
	/*
		微妙に汎用的でないコントローラ
		ログイン&ログアウト、セッションとSmartyをセットして簡単に使用できるようにする
		
		使用できるもの
			
			・$this->view($template)
				テンプレを表示して終了
			
			・$this->_logout()
				呼んだ瞬間ログアウトしてログイン画面に戻って終了
			
			・$this->shitaraba
				したらば接続インスタンス
			
			・$this->data
				テンプレートから参照できる
				また、自動的に下のふたつが使用可能
				$_REQUEST	$this->data['request']	{$request}
				$_SESSION	$this->data['session']	{$session}
			
			・$this->smarty
				Smartyインスタンスだけど基本的に直接は使わない
	*/
	
//クラス
class Shitaraba_Del_Controller{
	
	//インスタンス変数
		protected $smarty=array();	//Smarty
		protected $data=array();	//Smarty::assign
		protected $shitaraba='';	//Shitaraba_Data
	
	//コンストラクタ
	public function __construct(){
		
		//title
		$this->data['title']='したらば管理ツール';
		
		//Smartyセット
		$this->_smarty_setting();
		
		//引数とセッション
		$this->_session_check();
		
		//ログイン
		$this->_login();
		
		//メモリ確保
		$this->_get_memory();
		
		//したらばインスタンス
		$this->_shitaraba_data();
	}
	
	//メモリ確保
	protected function _get_memory(){
		ini_set('memory_limit','128M');
		set_time_limit(60);
		
	}
	
	//ログアウト
	protected function _logout(){
		$_SESSION=array();
		$this->data['error']=ERR::ERR_LOGOUT;
		$this->view('login.html');
	}
	
	//ビュー
	protected function view($template_file=false){
			
		//テンプレの存在チェック
			if($template_file==false){$this->_logout();}
			if(!file_exists(SHITARABA_DEL_DIR.SHITARABA_DEL_TEMPLATE.$template_file)){
				$this->_logout();
			}
		
		//$_REQUESTはテンプレートから$data.requestで参照できる	→実は$smarty.requestで見れる
			$this->data['request']=$_REQUEST;
		//$_SESSIONはテンプレートから$data.sessionで参照できる	→実は$smarty.sessionで見れる
			$this->data['session']=$_SESSION;
		
		//変数代入
			$this->smarty->assign('data',$this->data);
		
		//表示
			$this->smarty->display($template_file);
		
		//終了
		exit;
	}
	
	//以下はコントローラ用
	//したらばインスタンス
	private function _shitaraba_data(){
		$this->shitaraba = Services_Shitaraba::factory();
		$this->shitaraba->setGerne(SHITARABA_BBS_DIR);
		$this->shitaraba->setBbsnum(SHITARABA_BBS_BBS);
		$this->shitaraba->setPw(SHITARABA_BBS_PW);
		
	}
	
	//ログイン
	private function _login(){
		
		//ログイン情報が存在すればOK
			if(isset($_SESSION['login'])){
				return true;
			}
		
		//存在しなければ、フォーム値をチェック
			if(isset($_REQUEST['login_id']) && isset($_REQUEST['login_pw'])){
				if($_REQUEST['login_id']===SHITARABA_DEL_ID && $_REQUEST['login_pw']===SHITARABA_DEL_PW){
					//合っていればOK
					$_SESSION['login']=1;
					return true;
				}else{
					//合っていなければログイン失敗
					$this->data['error']=ERR::ERR_LOGIN_FAIL;
				}
			}
		
		//駄目ならログインフォーム
			$this->data['title'] .=' - ログイン';
			$this->view('login.html');
	}
	
	//引数とセッション
	private function _session_check(){
		//セッション
			session_start();
			session_regenerate_id(true);
	}
	
	//Smartyセット
	private function _smarty_setting(){
		
		//テンプレートファイル置き場
			$smarty_templates_dir=SMARTY_TEMPLATES_DIR;
		//コンパイル済ファイル置き場
			$smarty_templates_c_dir=SMARTY_TEMPLATES_C_DIR;
		//Smartyインスタンス
			require_once(SMARTY_DIR.'Smarty.class.php');
			$this->smarty=new Smarty();
			$this->smarty->template_dir = $smarty_templates_dir;
			$this->smarty->compile_dir  = $smarty_templates_c_dir;
	}
	
	
#↓クラスのおわり
}