<?php
	
//このフォルダ
	define('SHITARABA_DEL_DIR',dirname(__FILE__).DIRECTORY_SEPARATOR);
	
//必要ファイルのinclude
	//コンフィグ
		require_once(SHITARABA_DEL_DIR.'config.php');
		require_once(SHITARABA_DEL_DIR.'shitaraba_del_controller.php');
		
	//configでインクルードパスが設定されていれば追加
		if(defined('ZEND_FRAMEWORK_PATH')){
			set_include_path(get_include_path() . PATH_SEPARATOR . ZEND_FRAMEWORK_PATH);
		}
	
	//Services_Shitaraba
		require_once('Services/Shitaraba.php');
		
	//Zend_Http_Client
		require_once('Zend/Http/Client.php');
		require_once('Zend/Http/Cookie.php');
	
//クラス
class Shitaraba_Del_Class extends Shitaraba_Del_Controller{
	
	//--------------------------------------------------------------------------------------
	//コンストラクタ
	public function __construct(){
		//親
			parent::__construct();
			
		//引数actionによって分岐
		if(isset($_REQUEST['action'])){
			//ログアウト
			if($_REQUEST['action']=='logout'){
				$this->_logout();
			//削除内容確認
			}elseif($_REQUEST['action']=='ng_confirm'){
				$this->ngconfAction();
			//削除内容確認から削除実行
			}elseif($_REQUEST['action']=='ng_comp' && isset($_REQUEST['ng_comp'])){
				$this->ngcompAction();
			//削除内容確認からキャンセル
			}elseif($_REQUEST['action']=='ng_comp' && isset($_REQUEST['ng_cancel'])){
				$this->indexAction();
			//dat落ち内容確認
			}elseif($_REQUEST['action']=='dat_confirm'){
				$this->datconfAction();
			//dat落ち内容確認から削除実行
			}elseif($_REQUEST['action']=='dat_comp' && isset($_REQUEST['dat_comp'])){
				$this->datcompAction();
			//dat落ち内容確認からキャンセル
			}elseif($_REQUEST['action']=='dat_comp' && isset($_REQUEST['dat_cancel'])){
				$this->indexAction();
			//ホスト名で削除
			}elseif($_REQUEST['action']=='ip_del_index' ){
				$this->ipDeleteIndexAction();
			//ホスト名で削除の確認画面
			}elseif($_REQUEST['action']=='ip_del_conf' ){
				$this->ipDeleteConfAction();
			//ホスト名で削除の確認画面からキャンセル
			}elseif($_REQUEST['action']=='ip_del_comp' && isset($_REQUEST['ip_del_ret'])){
				$this->ipDeleteConfRetAction();
			//ホスト名で削除の実行
			}elseif($_REQUEST['action']=='ip_del_comp' && isset($_REQUEST['ip_del_comp'])){
				$this->ipDeleteCompAction();
			}
		}
		
		//何れでもなければインデックス
		$this->indexAction();
	}
	
	//--------------------------------------------------------------------------------------
	//インデックス
	private function indexAction(){
		//特に何もしない
			$this->data['title'] .=' - インデックス';
			$this->view('index.html');
	}
	
	//--------------------------------------------------------------------------------------
	//削除内容確認
	private function ngconfAction(){
		
		//入力をセッションに
			if(isset($_REQUEST['ng_word'])){$_REQUEST['ng_word']=trim($_REQUEST['ng_word']);$_SESSION['ng_word']=$_REQUEST['ng_word'];}
			if(isset($_REQUEST['ng_host'])){$_REQUEST['ng_host']=trim($_REQUEST['ng_host']);$_SESSION['ng_host']=$_REQUEST['ng_host'];}
		
		//入力値チェック
			$errors=$this->_check_ngconf($_REQUEST);
			if(count($errors)>0){
				$this->data['errors']=$errors;
				$this->indexAction();
			}
		
		//したらばからデータを引っ張ってくる
			//$this->shitaraba->setNGWord($_SESSION['ng_word']);
			//$this->shitaraba->setNGHost($_SESSION['ng_host']);
			$shitaraba_ng=$this->shitaraba->getNGThreadData($_SESSION['ng_word']);
			if($shitaraba_ng===false){
				$this->data['errors']=ERR::ERR_NGCHECK_GET_FAIL;
				$this->indexAction();
			}elseif(!$shitaraba_ng){
				$this->data['errors']=ERR::ERR_NGCHECK_NOHIT;
				$this->indexAction();
			}
		
		//セッションに保存
			$_SESSION['shitaraba_ng']=$shitaraba_ng;
		
		//表示
			$this->data['title'] .=' - 削除内容確認';
			$this->view('del_confirm.html');
	}
	
	//--------------------------------------------------------------------------------------
	//dat落ち内容確認
	private function datconfAction(){
		
		//dat落ち対象スレッドを取得
			$shitaraba_dat=$this->shitaraba->getDatThreadList();
			if($shitaraba_dat===false){
				$this->data['errors']=ERR::ERR_NGCHECK_GET_FAIL;
				$this->indexAction();
			}elseif(!$shitaraba_dat){
				$this->data['errors']=ERR::ERR_DAT_NOHIT;
				$this->indexAction();
			}
		
		//セッションに保存
			$_SESSION['shitaraba_dat']=$shitaraba_dat;
		
		//表示
			$this->data['title'] .=' - dat落ち内容確認';
			$this->view('dat_confirm.html');
	}
	
	//--------------------------------------------------------------------------------------
	//dat落ち実行
	private function datcompAction(){
		//セッションからdat落ち該当スレ取得
			$shitaraba_dat=$_SESSION['shitaraba_dat'];
		
		//dat落ち実行
			$ret=$this->shitaraba->datThread($shitaraba_dat);
			if(!$ret){
				$this->data['errors']=ERR::ERR_DAT_COMPLETE;
				$this->indexAction();
			}
		
		//内容をどっかに保存
			if(SHITARABA_BBS_LOG===true){
				$contents=date('Y-m-d H:i:s')."\r\n".serialize($shitaraba_dat)."\r\n";
				file_put_contents(
					 SHITARABA_DEL_DIR.SHITARABA_BBS_LOG_FILE
					,$contents
					,FILE_APPEND | LOCK_EX
				);
			}
			
		//表示
			$this->data['errors']=ERR::DAT_COMPLETE;
			$this->indexAction();
			
	}
	
	//--------------------------------------------------------------------------------------
	//削除実行
	private function ngcompAction(){
		
		//セッションから削除該当スレ番、レス番取得
			$shitaraba_ng=$_SESSION['shitaraba_ng'];
		//削除実行
			$ret=$this->shitaraba->deleteNGThreadData($shitaraba_ng);
			if(!$ret){
				$this->data['errors']=ERR::ERR_DELETE_COMPLETE;
				$this->indexAction();
			}
		
		//削除内容をどっかに保存
			if(SHITARABA_BBS_LOG===true){
				$contents=date('Y-m-d H:i:s')."\r\n".serialize($shitaraba_ng)."\r\n";
				file_put_contents(
					 SHITARABA_DEL_DIR.SHITARABA_BBS_LOG_FILE
					,$contents
					,FILE_APPEND | LOCK_EX
				);
			}
			
		//表示
			$this->data['errors']=ERR::DELETE_COMPLETE;
			$this->indexAction();
	}
	
	//--------------------------------------------------------------------------------------
	//ホスト名で削除のインデックス
	private function ipDeleteIndexAction(){
		//セッション削除
			$_SESSION['shitaraba']['ngThreadArray'] = false;
		
		//スレッドのリストを取得
			$this->data['threadList'] = $this->shitaraba->getThreadList();
			//print('<html><pre>');var_dump($this->data['threadList']);print('</pre><hr>');
		
		//表示
			$this->data['title'] .=' - ホスト名で削除';
			$this->view('ipDeleteIndex.html');
		
	}
	//--------------------------------------------------------------------------------------
	//ホスト名で削除の確認画面から戻る
	private function ipDeleteConfRetAction(){
		$_REQUEST = $_SESSION['shitaraba']['ngThreadRequest'];
		unset($_SESSION['shitaraba']['ngThreadRequest']);
		return $this->ipDeleteIndexAction();
	}
	//--------------------------------------------------------------------------------------
	//ホスト名で削除の確認画面
	private function ipDeleteConfAction(){
		//引数
			$ngHostName = $_REQUEST['ngHostName'];
			$ngThreadIdArray = $_REQUEST['threadId'];
			if(!$ngHostName || !$ngThreadIdArray){
				$this->data['errors'] = array(ERR::ERR_IPDEL_NOREQUEST);
				return $this->ipDeleteIndexAction();
			}
			$_SESSION['shitaraba']['ngThreadRequest'] = $_REQUEST;
		
		//チェックしたスレッドでループ
		$ngThreadArray = array();
		foreach($ngThreadIdArray as $key=>$val){
			//スレッドの中身を取得
			$ngResArray = $this->shitaraba->getThreadAdmin($key, NULL, $ngHostName);
			if(is_array($ngResArray) && count($ngResArray)>0){
				$ngThreadArray[$key]['thread_id'] = $key;
				$ngThreadArray[$key]['data'] = $ngResArray;
			}
		}
		
		//対象がなければ戻る
			if(!$ngThreadArray){
				$this->data['errors'] = array(ERR::ERR_IPDEL_NOHIT);
				return $this->ipDeleteIndexAction();
			}
		
		//セッションに保存
			$this->data['ngThreadArray'] = $ngThreadArray;
			$_SESSION['shitaraba']['ngThreadArray'] = $ngThreadArray;
			$this->data['threadList'] = $this->shitaraba->getThreadList();
		
		//表示
			$this->data['title'] .=' - ホスト名で削除 - 確認';
			$this->view('ipDeleteConfirm.html');
		
	}
	//--------------------------------------------------------------------------------------
	//ホスト名で削除の実行
	private function ipDeleteCompAction(){
		//セッションチェック
			if(!$_SESSION['shitaraba']['ngThreadArray']){
				return $this->ipDeleteIndexAction();
			}
		
		//削除実行
			$ret=$this->shitaraba->deleteNGThreadData($_SESSION['shitaraba']['ngThreadArray']);
			if(!$ret){
				$this->data['errors']=ERR::ERR_DELETE_COMPLETE;
				$this->ipDeleteIndexAction();
			}
		
		//削除内容をどっかに保存
			if(SHITARABA_BBS_LOG===true){
				$contents=date('Y-m-d H:i:s')."\r\n".serialize($_SESSION['shitaraba']['ngThreadArray'])."\r\n";
				file_put_contents(
					 SHITARABA_DEL_DIR.SHITARABA_BBS_LOG_FILE
					,$contents
					,FILE_APPEND | LOCK_EX
				);
			}
		
		//セッション削除
			$_SESSION['shitaraba']['ngThreadArray'] = false;
			$_SESSION['shitaraba']['ngThreadRequest'] = false;
		
		//表示
			$this->data['title'] .=' - ホスト名で削除 - 完了';
			$this->data['errors'][] = ERR::DELETE_COMPLETE;
			$this->view('ipDeleteIndex.html');
	}
	
	//--------------------------------------------------------------------------------------
	//以下サブルーチン
	//--------------------------------------------------------------------------------------
	
	//--------------------------------------------------------------------------------------
	//削除内容確認画面で引数チェック
	private function _check_ngconf($request){
		$ret=array();
		//どちらも空白なら
			if(!$request['ng_word'] && !$request['ng_host']){
				$ret[]=ERR::ERR_NGCHECK_NOVALUE;
				return $ret;
			}
		//NGワード
			if(mb_strlen($request['ng_word']) < 8 ){
				$ret[]=ERR::ERR_NGCHECK_SHORTWORD;
			}
		return $ret;
	}
	
	
#↓クラスのおわり
}