//#################################################################################################
//	File:	main.cpp
//	Desc:	AvP[V Gg[|Cg
//#################################################################################################
#include "common.h"
//#include "render.h"


//Ƃ肠O[oɁ@ɃNX
LPDIRECT3D9			d3d = NULL;
LPDIRECT3DDEVICE9	d3ddev= NULL;
HRESULT	InitD3d(HWND);
void	Render();
void	ReleaseD3d();

//=================================================================================================
//	Name:	WinProc()
//	Desc:	vV[W
//=================================================================================================
LRESULT CALLBACK WinProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg) {
		case WM_CLOSE:				//EChEꂽ
			PostQuitMessage(0);		//AvP[VI
			break;
		case WM_KEYDOWN:				//L[ꂽ
			if (wParam == VK_ESCAPE) {	//ꂽ̂ESCL[
				PostQuitMessage(0);		//AvP[VI
			}
			break;
		default:
			return DefWindowProc(hwnd, msg, wParam, lParam);
	}
	return 0;
}

//=================================================================================================
//	Name:	WinMain()
//	Desc:	application's entry point
//=================================================================================================
int WINAPI _tWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPWSTR lpCmdLine, int nCmdShow)
{
	bool	winmode = true;	//tXN[tO
	HWND	hwnd = NULL;
	
	//EBhENX̏
	WNDCLASSEX	wcex = {
		sizeof(WNDCLASSEX),				//̍\̂̃TCY
		NULL,							//EChẼX^C(default)
		WinProc,						//bZ[W֐̓o^
		0,								//ʏ͎gȂ̂ŏ0
		0,								//ʏ͎gȂ̂ŏ0
		hInstance,						//CX^Xւ̃nh
		NULL,							//ACRiȂj
		LoadCursor(NULL, IDC_ARROW),	//J[\̌`
		NULL, NULL,						//wiȂAj[Ȃ
		WINDOW_NAME,				//NX̎w
		NULL							//ACRiȂj
	};
	
	//EBhENX̓o^
	if(RegisterClassEx(&wcex) == 0) return 0;
	
	//EBhE̍쐬
	if(winmode) {
		//EBhE[h
		hwnd = CreateWindow(WINDOW_NAME, WINDOW_NAME, WS_OVERLAPPEDWINDOW,
							CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
							NULL, NULL, hInstance, NULL);

		//EBhETCYĐݒ肷
		RECT rect;
		int ww, wh;
		int cw, ch;
		//NCAg̈̊O̕vZ
		GetClientRect(hwnd, &rect);		//NCAg̃TCY̎擾
		cw = rect.right - rect.left;	//NCAg̈ỎvZ
		ch = rect.bottom - rect.top;	//NCAg̈ȌcvZ

		//EChEŜ̉̕vZ
		GetWindowRect(hwnd, &rect);		//EChEŜ̃TCY擾
		ww = rect.right - rect.left;	//EChEŜ̉̕vZ
		wh = rect.bottom - rect.top;	//EChEŜ̏̕cvZ
		ww = ww - cw;					//NCAg̈ȊOɕKvȕ
		wh = wh - ch;					//NCAg̈ȊOɕKvȍ

		//EBhETCY̍ČvZ
		ww = WINDOW_WIDTH + ww;			//KvȃEChE̕
		wh = WINDOW_HEIGHT + wh;		//KvȃEChE̍

		//EChETCY̍Đݒ
		SetWindowPos(hwnd, HWND_TOP, 0, 0, ww, wh, SWP_NOMOVE);
	} else {
		//tXN[
		int sw;
		int sh;
		//ʑŜ̕ƍ擾
		sw = GetSystemMetrics(SM_CXSCREEN);
		sh = GetSystemMetrics(SM_CYSCREEN);

		hwnd = CreateWindow( 
					WINDOW_NAME, 			//o^ĂNX
					WINDOW_NAME, 			//EChE
					WS_POPUP,				//EChEX^Ci|bvAbvEChE쐬j
					0, 						//EChẺ̈ʒu
					0, 						//EChȄc̈ʒu
					WINDOW_WIDTH, 			//EChE̕
					WINDOW_HEIGHT,			//EChE̍
					NULL,					//eEChẼnhiȗj
					NULL,					//j[qEChẼnh
					hInstance, 				//AvP[VCX^X̃nh
					NULL					//EChE̍쐬f[^
				);
	}

	//EBhE̕\
    ShowWindow(hwnd, nCmdShow);

	//WM_PAINTĂ΂Ȃ悤ɂ
	ValidateRect(hwnd, 0);

	//DRD̏
	if(FAILED(InitD3d(hwnd))) return 0;

	//bZ[Wѕ`惋[v
	MSG		msg;
	ZeroMemory(&msg, sizeof(msg));
	while(msg.message != WM_QUIT) {
        if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
			//bZ[W̖|ƃfBXpb`
			TranslateMessage(&msg);
			DispatchMessage(&msg);
        } else {	//郁bZ[WƂ͕`s
			//EBhEĂ鎞`悷邽߂̏
			WINDOWPLACEMENT wndpl;
			GetWindowPlacement(hwnd, &wndpl);	//EChȄԂ擾
			if((wndpl.showCmd != SW_HIDE) && (wndpl.showCmd != SW_MINIMIZE) && 
				(wndpl.showCmd != SW_SHOWMINIMIZED) && (wndpl.showCmd != SW_SHOWMINNOACTIVE)) {

					//`
					Render();
			}
		}

		//OSɐ𖾂n߂̃X[v
		Sleep(1);
    }

	ReleaseD3d();	//J
	return (int) msg.wParam;
}

//*************************************************************************************************
//	mFp֐@ɃNX
//*************************************************************************************************

//HRESULT InitD3d(HWND hwnd)
//_CNg3D̏
HRESULT InitD3d(HWND hwnd)
{
	//uDirect3DvIuWFNg̍쐬
	if(NULL == (d3d = Direct3DCreate9(D3D_SDK_VERSION))) return E_FAIL;

	//uDIRECT3DfoCXvIuWFNg̍쐬
	D3DPRESENT_PARAMETERS d3dpp; 
	ZeroMemory(&d3dpp, sizeof(d3dpp));   
	d3dpp.BackBufferFormat = D3DFMT_UNKNOWN;
	d3dpp.BackBufferCount = 1;
	d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;	
	d3dpp.Windowed = TRUE;
	d3dpp.EnableAutoDepthStencil = TRUE;
	d3dpp.AutoDepthStencilFormat = D3DFMT_D16;
	
	if(FAILED( d3d->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hwnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3dpp, &d3ddev))) {
		if(FAILED(d3d->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hwnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &d3ddev))) {
			if(FAILED(d3d->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, hwnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3dpp, &d3ddev))) {
				if(FAILED(d3d->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, hwnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &d3ddev))) {
					return E_FAIL;
				}
			}
		}
	}
	return S_OK;
}
//VOID Render()
//_O֐
void Render()
{
	d3ddev->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,D3DCOLOR_XRGB(30,30,30), 1.0f, 0);
	if(SUCCEEDED(d3ddev->BeginScene())) {
		
		d3ddev->EndScene();
	}
	d3ddev->Present(NULL, NULL, NULL, NULL);
}

//D3DIuWFNgJ
void ReleaseD3d()
{
	//foCXIuWFNg̉
	SAFE_RELEASE(d3ddev);
	//DirectXGraphics̉
	SAFE_RELEASE(d3d);
}