#pragma once
//#################################################################################################
//	File : Draw.h
//	Desc : Direct3D
//#################################################################################################

//**********************************************************************************
//	CN[h
//**********************************************************************************
#include "Common.h"

namespace Nava
{
//**********************************************************************************
//	\
//**********************************************************************************
//===================================================================
//	_tH[}bg
//===================================================================
//2DeNX`
struct VERTEX2D
{
	float x, y, z, w;
	float u, v;
	enum{FVF = D3DFVF_XYZRHW | D3DFVF_TEX1};
};

//===================================================================
//	foCX
//===================================================================
//Direct3D֘A
struct Direct3D
{
	LPDIRECT3D9				com;	//D3DR|[lg
	D3DDISPLAYMODE			dmode;	//ʃ[h
	D3DCAPS9				caps;	//foCX̐\
	LPDIRECT3DDEVICE9		dev;	//D3DfoCX
	D3DPRESENT_PARAMETERS	pp;		//D3Dp[^

	int						fps;		//FPS

	struct Windows	//EBhE֘A
	{
		HWND	hwnd;		//nh
		int		width;		//
		int		height;		//c
		bool	is_mode;	//EBhE[htO

	} win;
};

//**********************************************************************************
//	NX
//**********************************************************************************
class Draw
{
	private:
		Direct3D	d3d;	//Direct3D\

	public:
	//===================================================================
	//	EsEJ
	//===================================================================
		//----------------------------------------------------
		//	Name	SetWindowSetting
		//	Desc	DrawNXɃEBhEݒZbg
		//
		//	Param	hwnd		[in]EBhEnh
		//			win_w		[in]EBhE
		//			win_h		[in]EBhEc
		//			win_mode	[in]EBhE[h
		//			fps			[in]wfps
		//----------------------------------------------------
		void SetWindowSetting(HWND hwnd, int win_w, int win_h, bool win_mode, int fps);

		//----------------------------------------------------
		//	Name	Initialize
		//	Desc	Direct3D
		//
		//	Return	true	
		//			false	s
		//----------------------------------------------------
		bool Initialize();

		//----------------------------------------------------
		//	Name	Finalize
		//	Desc	Direct3DJ
		//----------------------------------------------------
		void Finalize();

		//----------------------------------------------------
		//	Name	ClearScreen
		//	Desc	ʃNA
		//
		//	Param	r		[in]
		//			g		[in]
		//			b		[in]
		//----------------------------------------------------
		void ClearScreen(int r, int g, int b);
		
		//----------------------------------------------------
		//	Name	FlipScreen
		//	Desc	ʃtbv
		//
		//	Return	true	
		//			false	s
		//----------------------------------------------------
		bool FlipScreen();

		//----------------------------------------------------
		//	Name	Reset
		//	Desc	Direct3DZbg
		//
		//	Return	true	
		//			false	s
		//----------------------------------------------------
		bool Reset();

		//----------------------------------------------------
		//	Name	SetWindowMode
		//	Desc	EBhE[hZbg
		//
		//	Param	win_mode	[in]EBhE[h
		//----------------------------------------------------
		void SetWindowMode(bool win_mode);

/*	
		//----------------------------------------------------
		//	Name	loadTex
		//	Desc	eNX`ǂݍ
		//
		//	Param	src		[in]eNX`t@C
		//
		//	Return	true	
		//			false	s
		//----------------------------------------------------
		int loadTex(char* src);

		//----------------------------------------------------
		//	Name	drawTex
		//	Desc	eNX``
		//
		//	Param	x		[in]\xW
		//			y		[in]\yW
		//			no		[in]eNX`t@CԍiloadTex̖߂lj
		//
		//	Return	true	
		//			false	s
		//----------------------------------------------------
		bool drawTex(int x, int y, int no);

		//----------------------------------------------------
		//	Name	releaseTex
		//	Desc	eNX`J
		//
		//	Param	no		[in]eNX`ԍiloadTex̖߂lj
		//
		//	Return	true	
		//			false	s
		//----------------------------------------------------
		bool releaseTex(int no);

		//----------------------------------------------------
		//	Name	releaseAllTex
		//	Desc	SeNX`J
		//
		//	Return	true	
		//			false	s
		//----------------------------------------------------
		bool releaseAllTex();
	*/

	//=================================================================================================
	//	VOg
	//=================================================================================================
	private:
		static Draw* draw;
		Draw(){}
		Draw(const Draw& d){}
		virtual ~Draw(){}
	public:
		static Draw* GetInst()
		{
			if(draw == NULL) draw = new Draw();
			return draw;
		}
		static void DeleteInst()
		{
			SAFE_DELETE(draw);
		}
};
}