//#################################################################################################
//	File : draw.cpp
//	Desc : Direct3D
//#################################################################################################

//**********************************************************************************
//	CN[h
//**********************************************************************************
#include "Draw.h"
using namespace Nava;

Draw* Draw::draw = NULL;
//**********************************************************************************
//	\bh
//**********************************************************************************
//===================================================================
//	EsEJ
//===================================================================
//----------------------------------------------------
//	Name	SetWindowSetting
//	Desc	DrawNXɃEBhEݒZbg
//
//	Param	hwnd		[in]EBhEnh
//			win_w		[in]EBhE
//			win_h		[in]EBhEc
//			win_mode	[in]EBhE[h
//			fps			[in]wfps
//----------------------------------------------------
void Draw::SetWindowSetting(HWND hwnd, int win_w, int win_h, bool win_mode, int fps)
{
	//-----------------------------------------------
	//	Direxct3D\̏
	//-----------------------------------------------
	ZeroMemory(&d3d, sizeof(Direct3D));
	d3d.win.hwnd	= hwnd;
	d3d.win.width	= win_w;
	d3d.win.height	= win_h;
	d3d.win.is_mode	= win_mode;
	d3d.fps			= fps;

	return;
}
//----------------------------------------------------
//	Name	Initialize
//	Desc	Direct3D
//
//	Return	true	
//			false	s
//----------------------------------------------------
bool Draw::Initialize()
{
	//-----------------------------------------------
	//	Direxct3DR|[lg쐬
	//-----------------------------------------------
	if((d3d.com = Direct3DCreate9(D3D_SDK_VERSION)) == NULL)
	{
		MB("Direct3D̍쐬Ɏs܂");
		return false;
	}

	//-----------------------------------------------
	//	݂̉ʃ[h擾
	//-----------------------------------------------
	if(FAILED(d3d.com->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &d3d.dmode)))
	{
		MB("ʃ[h̎擾Ɏs܂");
		return false;
	}

	//-----------------------------------------------
	//	foCX̐\擾
	//-----------------------------------------------
	if(FAILED(d3d.com->GetDeviceCaps(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, &d3d.caps)))
	{
		MB("foCX\̎擾Ɏs܂");
		return false;
	}

	//-----------------------------------------------
	//	Direct3Dp[^̐ݒ
	//-----------------------------------------------
	d3d.pp.BackBufferWidth				= d3d.win.width;
	d3d.pp.BackBufferHeight				= d3d.win.height;
	d3d.pp.BackBufferFormat				= d3d.dmode.Format;
	d3d.pp.BackBufferCount				= 1;
	d3d.pp.MultiSampleType				= D3DMULTISAMPLE_NONE;
	d3d.pp.MultiSampleQuality			= 0;
	d3d.pp.SwapEffect					= D3DSWAPEFFECT_DISCARD;
	d3d.pp.hDeviceWindow				= d3d.win.hwnd;
	d3d.pp.Windowed						= d3d.win.is_mode;
	d3d.pp.EnableAutoDepthStencil		= true;
	d3d.pp.AutoDepthStencilFormat		= D3DFMT_D16;
	d3d.pp.Flags						= D3DPRESENTFLAG_LOCKABLE_BACKBUFFER;
	d3d.pp.FullScreen_RefreshRateInHz	= D3DPRESENT_RATE_DEFAULT;

	if(d3d.fps == 0)
	{
		//fps==0@ɍXV(^C}[Ő䂷)
		d3d.pp.PresentationInterval		= D3DPRESENT_INTERVAL_IMMEDIATE;
	}
	else
	{
		//fps!=0@AԊu҂
		d3d.pp.PresentationInterval		= D3DPRESENT_INTERVAL_DEFAULT;
	}

	//-----------------------------------------------
	//	Direct3DfoCX쐬
	//-----------------------------------------------
	//HAL
	if(FAILED(d3d.com->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, d3d.win.hwnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3d.pp, &d3d.dev)))
	{
		if(FAILED(d3d.com->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, d3d.win.hwnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3d.pp, &d3d.dev)))
		{
			//REF
			if(FAILED(d3d.com->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, d3d.win.hwnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3d.pp, &d3d.dev)))
			{
				if(FAILED(d3d.com->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, d3d.win.hwnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3d.pp, &d3d.dev)))
				{
					MB("foCX̍쐬Ɏs܂");
					return false;
				}
			}
		}
	}

	return true;
}

//----------------------------------------------------
//	Name	Finalize
//	Desc	Direct3DJ
//----------------------------------------------------
void Draw::Finalize()
{
	SAFE_RELEASE(d3d.dev);	//foCX
	SAFE_RELEASE(d3d.com);	//R|[lg

	return;
}

//----------------------------------------------------
//	Name	ClearScreen
//	Desc	ʃNA
//
//	Param	r		[in]
//			g		[in]
//			b		[in]
//----------------------------------------------------
void Draw::ClearScreen(int r, int g, int b)
{
	d3d.dev->Clear(0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(r, g, b), 0, 0);

	return;
}

//----------------------------------------------------
//	Name	FlipScreen
//	Desc	ʃtbv
//
//	Return	true	
//			false	s
//----------------------------------------------------
bool Draw::FlipScreen()
{
	//-----------------------------------------------
	//	tbv
	//-----------------------------------------------
	switch(d3d.dev->Present(NULL, NULL, NULL, NULL))
	{
		//hCoG[
		case D3DERR_DRIVERINTERNALERROR:
			return false;
			break;
		
		//foCXXg
		case D3DERR_DEVICELOST:
			Sleep(100);

			//foCXԃ`FbN
			switch(d3d.dev->TestCooperativeLevel())
			{
				//Zbgs\
				case D3DERR_DEVICELOST:
					Sleep(100);
					break;
				
				//Zbg\
				case D3DERR_DEVICENOTRESET:
					if(Reset() == false) return false;
					break;
			}
			break;
	}

	return true;
}

//----------------------------------------------------
//	Name	Reset
//	Desc	Direct3DZbg
//
//	Return	true	
//			false	s
//----------------------------------------------------
bool Draw::Reset()
{
	//foCXZbg
	if(FAILED(d3d.dev->Reset(&d3d.pp)))
	{
		MB("foCXZbgɎs܂B");
		return false;
	}
	
	return true;
}

//----------------------------------------------------
//	Name	SetWindowMode
//	Desc	EBhE[hZbg
//
//	Param	win_mode	[in]EBhE[h
//----------------------------------------------------
void Draw::SetWindowMode(bool win_mode)
{
	d3d.win.is_mode = win_mode;
	d3d.pp.Windowed = d3d.win.is_mode;	//p[^ɂZbg
	
	return;
}

/*
//-----------------------------------------------
//	Name	loadTex
//	Desc	eNX`ǂݍ
//
//	Param	src		[in]eNX`t@C
//
//	Return	true	
//			false	s
//-----------------------------------------------
int Draw::loadTex(char* src)
{
	LPDIRECT3DTEXTURE9	tex = NULL;
	if(FAILED(D3DXCreateTextureFromFile(d3d.dev, src, &tex)))
	{
		return -1;
	}
	d3d.comtex.push_back(tex);

	return (int)d3d.comtex.size() - 1;
}

//-----------------------------------------------
//	Name	drawTex
//	Desc	eNX``
//
//	Param	x		[in]\xW
//			y		[in]\yW
//			no		[in]eNX`t@CԍiloadTex̖߂lj
//
//	Return	true	
//			false	s
//-----------------------------------------------
bool Draw::drawTex(int x, int y, int no)
{
	//Ww
	VERTEX2D v2d[] = 
	{
		{  x,  y, 0, 1, 0.0f, 0.0f },
		{ x+256,  y, 0, 1, 1.0f, 0.0f },
		{  x, y+256, 0, 1, 0.0f, 1.0f },
		{ x+256, y+256, 0, 1, 1.0f, 1.0f },
	};

	if(SUCCEEDED(d3d.dev->BeginScene()))
	{
		//eNX`ݒ
		d3d.dev->SetTexture(0, d3d.comtex[no]);
		//_eueݒ
		d3d.dev->SetFVF(VERTEX2D::FVF);
		//|S`
		d3d.dev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, v2d, sizeof(VERTEX2D));

		d3d.dev->EndScene();
	}
	return true;
}

//-----------------------------------------------
//	Name	releaseTex
//	Desc	eNX`J
//
//	Param	no		[in]eNX`ԍiloadTex̖߂lj
//
//	Return	true	
//			false	s
//-----------------------------------------------
bool Draw::releaseTex(int no)
{
	SAFE_RELEASE(d3d.comtex[no]);
	return true;
}

//-----------------------------------------------
//	Name	releaseAllTex
//	Desc	SeNX`J
//
//	Return	true	
//			false	s
//-----------------------------------------------
bool Draw::releaseAllTex()
{
	for(int i = 0 ; i < (int)d3d.comtex.size() ; i++)
	{
		SAFE_RELEASE(d3d.comtex[i]);
	}
	d3d.comtex.clear();
	return true;
}*/