//#################################################################################################
//	File : System.cpp
//	Desc : EBhE
//#################################################################################################

//**********************************************************************************
//	CN[h
//**********************************************************************************
#include "System.h"
using namespace Nava;

Window	System::win;
Draw	*System::draw;
//**********************************************************************************
//	\bh
//**********************************************************************************
//===================================================================
//	EsEJ
//===================================================================
//----------------------------------------------------
//	Name	Initialize
//	Desc	VXe
//
//	Param	win_hinst	[in]EBhECX^X
//			win_w		[in]EBhE
//			win_h		[in]EBhEc
//			win_nm		[in]EBhE
//			win_mode	[in]EBhE[h
//			fps			[in]wfps
//
//	Return	true	
//			false	s
//----------------------------------------------------
bool System::Initialize(HINSTANCE win_hinst, int win_w, int win_h, char* win_nm, bool win_mode, int fps)
{
	//-------------------------------------
	//	EBhE\̏
	//-------------------------------------
	ZeroMemory(&win, sizeof(Window));
	win.hinst	= win_hinst;	//CX^X
	win.width	= win_w;		//EBhE
	win.height	= win_h;		//EBhEc
	win.name	= win_nm;		//EBhE^Cg
	win.is_mode = win_mode;		//EBhE[htO
	win.fps.set = fps;			//FPSZbg
	win.is_active = true;		//EBhEANeBu

	//-------------------------------------
	//	FPSv
	//-------------------------------------
	QueryPerformanceFrequency(&win.fps.freq);	//ptH[}XJE^@VXeg擾
	if(win.fps.freq.QuadPart == 0)
	{
		//ptH[}XJE^gȂ̂ŊȈՔłɂ
		win.fps.is_simple = true;
		win.fps.freq.QuadPart = 1000;	//timeGetTime̓~bP 1000ms=1s
	}
	win.fps.prev_time = GetTime();		//O̎ԂZbg
	win.fps.prev_system_time = GetTime();

	//-------------------------------------
	//	dNh~
	//-------------------------------------
	//łɋNĂ邩`FbN
	if((win.hmutex = OpenMutex(MUTEX_ALL_ACCESS, false, win.name)) != NULL)
	{
		//N
		CloseHandle(win.hmutex);
		win.hmutex = NULL;
		return false;
	}
	else
	{
		//NĂȂꍇ͍쐬
		if((win.hmutex = CreateMutex(NULL, true, win.name)) == NULL) return false;
		if(GetLastError() == ERROR_ALREADY_EXISTS) return false;
	}

	//-------------------------------------
	//	EBhENXo^
	//-------------------------------------
	win.wcex.cbSize				= sizeof(WNDCLASSEX);
	win.wcex.style				= CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	win.wcex.lpfnWndProc		= WinProc;
	win.wcex.cbClsExtra			= 0;
	win.wcex.cbWndExtra			= 0;
	win.wcex.hInstance			= win.hinst;
	win.wcex.hIcon				= NULL;
	win.wcex.hCursor			= LoadCursor(NULL, IDC_ARROW);
	win.wcex.hbrBackground		= NULL;//(HBRUSH)GetStockObject(GRAY_BRUSH);
	win.wcex.lpszMenuName		= NULL;
	win.wcex.lpszClassName		= (LPCSTR)win.name;
	win.wcex.hIconSm			= NULL;
	if(RegisterClassEx(&win.wcex) == 0)
	{
		MB("EBhE̓o^Ɏs܂");
		return false;
	}

	//-----------------------------------------
	// EBhEX^CETCY
	//-----------------------------------------
	DWORD dwStyle = NULL;
	if(win.is_mode)
	{
		//EBhE[h
		dwStyle = WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_VISIBLE;
		win.real_width = win.width + GetSystemMetrics(SM_CXEDGE) + GetSystemMetrics(SM_CXBORDER) + GetSystemMetrics(SM_CXDLGFRAME);
		win.real_height = win.height + GetSystemMetrics(SM_CYEDGE) + GetSystemMetrics(SM_CYBORDER) + GetSystemMetrics(SM_CYDLGFRAME) + GetSystemMetrics(SM_CYCAPTION);
	}
	else
	{
		//tXN[
		dwStyle = WS_POPUP | WS_VISIBLE;
		win.real_width = win.width;
		win.real_height = win.height;
	}

	//-------------------------------------
	//	EBhE쐬
	//-------------------------------------
	win.hwnd = CreateWindowEx(
					0,
					win.name,
					win.name,
					dwStyle,
					(GetSystemMetrics(SM_CXSCREEN) - win.real_width) / 2,
					(GetSystemMetrics(SM_CYSCREEN) - win.real_height) / 2,
					win.real_width,
					win.real_height,
					NULL,
					NULL,
					win.hinst,
					NULL
					);

	if(win.hwnd == NULL )
	{
		MB("EBhE̍쐬Ɏs܂");
		return false;
	}

	return true;
}

//----------------------------------------------------
//	Name	Finalize
//	Desc	VXeJ
//----------------------------------------------------
void System::Finalize()
{
	//-------------------------------------
	//	dNh~ 
	//-------------------------------------
	if(win.hmutex != NULL)
	{
		ReleaseMutex(win.hmutex);
		CloseHandle(win.hmutex);
	}

	//-------------------------------------
	//	drawJ
	//-------------------------------------
	Draw::DeleteInst();

	return;
}

//----------------------------------------------------
//	Name	Run
//	Desc	s
//
//	Return	true	s
//			false	I
//----------------------------------------------------
bool System::Run()
{
//n_
RUN_START:

	//IbZ[W`FbN
	if(win.msg.message == WM_QUIT) return false;

	//bZ[W擾
	if(PeekMessage(&win.msg, NULL, 0, 0, PM_REMOVE))
	{
		//bZ[W̖|ƃfBXpb`
		TranslateMessage(&win.msg);
		DispatchMessage(&win.msg);
	}
	else if(win.is_active)
	{
		//FPSv
		SyncFps();

		//bZ[W and ANeBu
		return true;
	}
	
	//bZ[WL or ANeBu͂ƐQČJԂ
	Sleep(10);
	goto RUN_START;
}

//----------------------------------------------------
//	Name	SyncFps
//	Desc	ݒ肳ꂽFPSɂ
//----------------------------------------------------
void System::SyncFps()
{
	win.fps.count++;
	win.fps.curr_time = GetTime();

	//1boFPSvZ
	if((win.fps.curr_time - win.fps.prev_time) >= win.fps.freq.QuadPart)
	{
		if(win.fps.is_simple)
		{
			win.fps.now = 1000.0 / ((double)win.fps.curr_time - (double)win.fps.prev_time);
			win.fps.now = (double)((double)win.fps.count * win.fps.now);
		}
		else
		{
			win.fps.now = 1.0 / ((double)win.fps.curr_time - (double)win.fps.prev_time);
			win.fps.now = (double)((double)win.fps.count * (double)win.fps.freq.QuadPart * win.fps.now);
		}

		//ɔď
		win.fps.prev_time = win.fps.curr_time;
		win.fps.count = 0;

		//EBhE^Cgɏ\
		if(win.is_drawtitleinfo)
		{
			char str[MAX_STR_BLOCKREASON] = "";
			StringCbPrintf(str, sizeof(str), "%s@FPS[%.2lf]", win.name, win.fps.now);
			SetWindowText(win.hwnd, str);
		}
	}

	//FPS 0͂ɍXV
	if(win.fps.set != 0)
	{
		//1[v̎
		double roop_time = (double)win.fps.freq.QuadPart / (double)win.fps.set;
		//݌o߂
		win.fps.curr_system_time = GetTime();
		double diff_time = (double)(win.fps.curr_system_time - win.fps.prev_system_time);
		
		//[vԂɒBĂȂΑҋ@
		if(diff_time < roop_time)
		{
			//Q鎞ԌvZ
			int sleep_time = (int)((roop_time - diff_time) * 1000 / win.fps.freq.QuadPart);
			//2msȏȂQ
			if(sleep_time > 2)
			{
				Sleep(sleep_time - 1);
			}
			//c̓[vŒׂ
			do
			{
				diff_time = (double)(GetTime() - win.fps.prev_system_time);
			}
			while(diff_time < roop_time);
		}
		//ׂ̈Ɍ݂̎Ԃۑ
		win.fps.prev_system_time = GetTime();
	}

	return;
}
//----------------------------------------------------
//	Name	SetDrawTitleInfo
//	Desc	^Cgɏ\
//
//	Param	is_drawtitleinfo	[in]^CgInfo\tO
//----------------------------------------------------
void System::SetDrawTitleInfo(bool is_drawtitleinfo)
{
	win.is_drawtitleinfo = is_drawtitleinfo;

	return;
}

//===================================================================
//	f[^n
//===================================================================
//----------------------------------------------------
//	Name	CreateDraw
//	Desc	DrawCX^X쐬
//
//	Return	*draw	DrawCX^X
//----------------------------------------------------
Draw* System::CreateDraw()
{
	draw = Draw::GetInst();	//CX^X擾
	draw->SetWindowSetting(win.hwnd, win.width, win.height, win.is_mode, win.fps.set);	//ݒZbg

	return draw;
}

//----------------------------------------------------
//	Name	GetMsg
//	Desc	EBhEbZ[W擾
//
//	Return	win.msg		EBhEbZ[W
//----------------------------------------------------
MSG	System::GetMsg()
{
	return win.msg;
}

//----------------------------------------------------
//	Name	GetTime
//	Desc	݂̎Ԃ擾
//
//	Return	LONGLONG	݂̎
//----------------------------------------------------
LONGLONG System::GetTime()
{
	LARGE_INTEGER time;

	if(win.fps.is_simple)
	{
		return timeGetTime();	//ȈՎ
	}
	else
	{
		QueryPerformanceCounter(&time);	//ڍ׎
	}
	return time.QuadPart;
}

//===================================================================
//	č\z
//===================================================================
//----------------------------------------------------
//	Name	ChangeWindowMode
//	Desc	EBhE[hύX
//----------------------------------------------------
void System::ChangeWindowMode()
{
	win.is_mode = (win.is_mode == false);
	draw->SetWindowMode(win.is_mode);
}

//----------------------------------------------------
//	Name	ReInitialize
//	Desc	VXeč쐬
//
//	Return	true	
//			false	s
//----------------------------------------------------
bool System::ReInitialize()
{
	if(win.is_mode)
	{
		//EBhE[h
		SetWindowLong(win.hwnd, GWL_STYLE, WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_VISIBLE);
		SetWindowPos(win.hwnd, HWND_NOTOPMOST, (GetSystemMetrics(SM_CXSCREEN) - win.real_width) / 2, (GetSystemMetrics(SM_CYSCREEN) - win.real_height) / 2,
			win.real_width, win.real_height, SWP_FRAMECHANGED);
	}
	else
	{
		//tXN[
		SetWindowLong(win.hwnd, GWL_STYLE, WS_POPUP | WS_VISIBLE);
		SetWindowPos(win.hwnd, HWND_NOTOPMOST, (GetSystemMetrics(SM_CXSCREEN) - win.width) / 2, (GetSystemMetrics(SM_CYSCREEN) - win.height) / 2,
			win.width, win.height, SWP_FRAMECHANGED);
	}

	return true;
}

//===================================================================
//	vV[W
//===================================================================
LRESULT CALLBACK System::WinProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	switch(msg)
	{
		//-------------------------------------------------
		// VXeR}h
		//-------------------------------------------------
		case WM_SYSCOMMAND:
			// XN[Z[o[֌W̏}
			switch(wparam)
			{
				case SC_SCREENSAVE:
				case SC_MONITORPOWER:
					break;

				default:
					return DefWindowProc(hwnd, msg, wparam, lparam);
					break;
			}
			break;

		//-------------------------------------------------
		// IME\}
		//-------------------------------------------------
		case WM_IME_SETCONTEXT:
			lparam = 0;
			break;
		case WM_IME_STARTCOMPOSITION:
		case WM_IME_ENDCOMPOSITION:
		case WM_IME_COMPOSITION:
			break;
		case WM_IME_NOTIFY:
			switch(wparam)
			{
				case IMN_OPENSTATUSWINDOW:
				case IMN_CLOSESTATUSWINDOW:
				case IMN_CHANGECANDIDATE:
				case IMN_OPENCANDIDATE:
				case IMN_CLOSECANDIDATE:
					break;
			}
			break;

		//-------------------------------------------------
		// J[\\}
		//-------------------------------------------------
		case WM_SETCURSOR:
			SetCursor(NULL);
            break;

		//-------------------------------------------------
		// ANeBu`FbN
		//-------------------------------------------------
		case WM_ACTIVATEAPP:
			if(wparam == WA_INACTIVE)
			{
				//ANeBu
				win.is_active = false;
			}
			else
			{
				//ANeBu
				win.is_active = true;
			}
			break;

		//-------------------------------------------------
		// L[
		//-------------------------------------------------
		case WM_KEYDOWN:
			switch(wparam)
			{
				case VK_ESCAPE:	//ESCŏI
					SendMessage(hwnd, WM_CLOSE, 0, 0);
					break;
			}
			break;
		case WM_SYSKEYDOWN:	//Alt + 
			switch(wparam)
			{
				case VK_RETURN:	//Enter
					//EBhE[hؑ
					ChangeWindowMode();	//EBhE[hؑ
					draw->Reset();		//foCXZbg
					ReInitialize();		//EBhEč쐬
					break;
			}
			break;
		//-------------------------------------------------
		// EBhE
		//-------------------------------------------------
		case WM_CREATE:
			timeBeginPeriod(1);	//^C}\̐xAbvJn
			break;
		//-------------------------------------------------
		// EBhEN[Y
		//-------------------------------------------------
		case WM_CLOSE:
			timeEndPeriod(1);	//^C}\̐xAbvI
			SendMessage(hwnd, WM_DESTROY, 0, 0);
			break;
		//-------------------------------------------------
		// I
		//-------------------------------------------------
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		//-------------------------------------------------
		// ftHg
		//-------------------------------------------------
		default:
			return DefWindowProc(hwnd, msg, wparam, lparam);
	}
	return 0;
}