#pragma once

enum TraningMenu
{
    THP,            // ̗͋
    TAtk,           // U͋
    TDef            // h͋
};
const char *tMenu[] = {
    "̗",
    "U",
    "h"
};

class Unit
{
    string Name;    // O
    int MaxHP;      // ̗͍ől
    int HP;         // ̗́iݒlj
    int Atp;        // U
    int Dfp;        // h
    int Money;      // AX^[͊lz
public:
    void Init(string Name, int HP,int Atp,int Dfp, int Money);
    void ShowStatus();
    int Attack();
    int Defence();
    string getName(){return(Name);}
    int Hit(int dmg);
    void HealMax(){HP = MaxHP;}         // ̗͍ő܂ŉ
    void Stay(int price);               // hɔ܂
    void AddMoney(int gd);              // zZ
    int GetMoney(){return(Money);}
    void ShowMoney();
    //void TraningHP();                   // ̗͋
    //void TraningAtp();                  // UP
    //void TraningDfp();                  // hP
    void Traning(TraningMenu tM);       // PiRj
    int  TraningCost(TraningMenu tM);   // RXg
    string getShowHP();

};

//@
void Unit::Init(string Name, int HP, int Atp, int Dfp, int Money)
{
//  cout << "Init:"<< Name << "\n";
    this->Name = Name;
    this->MaxHP = this->HP = HP;
    this->Atp = Atp;
    this->Dfp = Dfp;
    this->Money = Money;
}

// p[^[\
void Unit::ShowStatus()
{
    cout << "y" << Name << "z HP:" << HP << "  Atp:" << Atp << "  Dfp:" << Dfp << "\n";
}

// UEA^bN|Cg
int Unit::Attack()
{
    int ap = Atp+1;
    return((rand()%ap + rand()%ap + ap)/2);
}

// hEfBtFX|Cg
int Unit::Defence()
{
    int dp = Dfp + 1;
    return((rand()%dp + dp)/2);
}

int Unit::Hit(int dmg)
{
    HP -= dmg;
    if(HP <= 0) {
        HP = 0;
        return -1;
    }

    return 0;
}
void Unit::AddMoney(int Gd)
{
    Money += Gd;
    cout << Name << "́A " << Gd << "S[hɓꂽI\n";
    ShowMoney();
}

void Unit::Stay(int price)
{
    if(HP == MaxHP){
        cout << "̗͖^łB@@@" << getShowHP() << "\n"
             << "܂Kv܂B\n";
    } else if(Money >= price){
        cout << Name << "́Ahɔ܂EEE\n̗͂SB\n";
        HP = MaxHP;
        Money -= price;
    } else {
        cout << "܂I\n";
    }
}

void Unit::ShowMoney()
{
    cout << "݂̏F" << Money << "G\n";
}

void Unit::Traning(TraningMenu tM)
{
    int cost = TraningCost(tM);
    int imp = 0;
    if(Money >= cost){
        Money -= cost;
        switch(tM){
            case THP:
                imp = MaxHP/12 + 1;
                MaxHP += imp;
                break;
            case TAtk:
                imp = 1;
                Atp ++;
                break;
            case TDef:
                imp = 1;
                Dfp++;
                break;
        }
        cout << tMenu[tM] << " " << imp << "オB\n";
    } else {
        cout << "܂I\n";
    }
}

int Unit::TraningCost(TraningMenu tM)
{
    int cost = 0;
    switch(tM){
        case THP:
            cost = (MaxHP/10)*5;
            break;
        case TAtk:
            cost = Atp*5;
            break;
        case TDef:
            cost = Dfp*5;
            break;
    }
    return cost;
}

string Unit::getShowHP()
{
    stringstream sstr;
    sstr.str("");

    sstr << "(" << HP << "/" << MaxHP << ")";

    return(sstr.str());
}