#include <iostream>
#include <string>
#include <sstream>
#include <stdlib.h>     // 擾ɕKv 
#include <time.h>       // rand()̏ɕKv 
#include <windows.h>    // \̃EFCĝ߂ɁB

using namespace std;

#include "Unit.h"
#include "Player.h"
#include "Histgram.h"

enum Result
{
    NONE = 0,
                    // X؍ݎ
    DEPARTURE,      // oA
    STAY,           // hɔ܂

                    // 퓬
    WIN,            // 
    RUNAWAY,        // S
    LOSE,           // sk

                    // VXe
    ABORT,          // I
    UNKNOWN         // s
};

const int MonsterMaxNum = 5;

void InitPlayer(Player &player)
{
    string name;
    cout << "Ȃ̖OĂF";
    cin >> name;

    player.Init(name, 30, 8, 5, 6, 0);
}

void InitEnemyList(Unit (&eList)[MonsterMaxNum])
{
    eList[0].Init("Su",     12,  6,  3,  3,   5);
    eList[1].Init("SuQ",     18,  7,  4,  5,  10);
    eList[2].Init("Su叫",     24,  9,  5,  5,  30);
    eList[3].Init("m", 30, 12,  8, 12,  50);
    eList[4].Init("̂Ђ",     99, 24, 24, 50,9999);

}

int NormalAttack(Unit &lst, Unit &rst)
{
    int dmg;
    dmg = (lst.Attack() - rst.Defence());
    if(dmg <= 0) dmg = 1;

    cout << lst.getName() << "̂I\n";
    cout << rst.getName() << " " << dmg << "̃_[W^B\n";

    if(rst.Hit(dmg)){
        cout << lst.getName() << "́A" << rst.getName() << "ɂƂǂ߂I\n";
        return(-1);
    }

    return(0);
}

Result Battle(Player &player, Unit &enemy)
{
    int cnt = 1, cmd, cmdcnt;
    Result res;

    while(1){
        cmdcnt = 0;
        Sleep(200);
        cout << "\ncnt:" << cnt << "\n";
        player.ShowStatus();
        enemy.ShowStatus();
        while(1){
            cout << "ǂHi1:U@2:@9:IjF";
            if(cmdcnt){
                cin.clear();
                cin.ignore();
            }
            cmd = 0;
            cin >> cmd;
            cout << "\n";
            if(cmd == 1) break;
            if(cmd == 2) {
                cout << player.getName() << "͓oI\n";
                break;
            }
            if(cmd == 9)break;
            if((++cmdcnt)>10){cmd = 9;break;}   //[vh~
        }
        if(cmd == 9){res = ABORT;   break;}
        if(cmd == 2){res = RUNAWAY; break;}

        // sɂāAUU߂
        if(player.GetActionPoint() >= enemy.GetActionPoint()){
            if(NormalAttack(player,enemy)){res = WIN;  break;}
            if(NormalAttack(enemy,player)){res = LOSE; break;}
        } else {
            if(NormalAttack(enemy,player)){res = LOSE; break;}
            if(NormalAttack(player,enemy)){res = WIN;  break;}
        }

        if((++cnt)>100)break;       // [vȂ̂ŁA[vh~
    }

    return res;
}

Result TownEvent(Player& player)
{
    Result res;
    int cmd,cmdcnt = 0;
    static int stayPrice = 10;

    cout << "\n\nXɂ܂B\n";

    while(1){
        cmd = 0;
        res = NONE;
        player.ShowAllStatus();
        cout << "\n1:o\n"
             << "2:h(" << stayPrice << "G)      ̗ " << player.getShowHP() << "\n"
             << "3:̗͋(" << player.TrainingCost(THP) <<"G)\n"
             << "4:UP(" << player.TrainingCost(TAtk) <<"G)\n"
             << "5:hP(" << player.TrainingCost(TDef) <<"G)\n"
             << "6:f@(" << player.TrainingCost(TAgi) <<"G)\n"
             << "9:I\n"
             << "ǂH";
        if(cmdcnt){
            cin.clear();
            cin.ignore();
        }
        cin >> cmd;
        cout << "\n";
        switch(cmd){
            case 1:     // o
                res = DEPARTURE;
                break;
            case 2:     // h
                player.Stay(stayPrice);
                break;
            case 3:     // ̗͋
                player.Training(THP);
                break;
            case 4:     // UP
                player.Training(TAtk);
                break;
            case 5:     // hP
                player.Training(TDef);
                break;
            case 6:     // fP
                player.Training(TAgi);
                break;
            case 9:
                res = ABORT;
                break;
        }
        if(res!=NONE) break;
        if((++cmdcnt)>100){res = ABORT; break;}   //[vh~
    }

    return res;
}

Result Patrol(Player &player, Unit (&eList)[MonsterMaxNum])
{
    Result res;
    Unit enemy;

    cout << player.getName() << "́AXočrɌB\n";

    for(int i=0;i<MonsterMaxNum;++i)
    {
        Sleep(800);
        enemy = eList[i];
        cout << "\n" << enemy.getName() << " ꂽI\n";
        res = Battle(player,enemy);
        if(res==WIN){         // vC[
            cout << "B\n";
            player.AddMoney(enemy.GetMoney());
        } else break;
    }
    if(res==WIN){
        // 퓬ŏIĂĂƂ́A叟̗\
        cout << "\n\n{{@@@S@@@II@@{{\n";
        cout << "E " << player.getName() << " ̖iɏ̂邪悢B\n\n";
        res = ABORT;
    }
    if(res==LOSE){
        cout << player.getName() << " ͎SB\n\n|GAME OVER|\n";
        res = ABORT;
    }
    return res;
}

int main()
{
    Player player;
    Unit   eList[MonsterMaxNum];

    srand(static_cast<unsigned int>(time(NULL)));
    
    InitPlayer(player);
    InitEnemyList(eList);

    while(1){
        if(TownEvent(player)==ABORT) break;         // X
        if(Patrol(player,eList)==ABORT) break;      // 퓬
    }

    cout << "\n\nIB" << endl;
    Sleep(1500);

    return 0;
}