// Player.h

#include "Unit.h"


enum TrainingMenu
{
    THP,            // ̗͋
    TAtk,           // U͋
    TDef,           // h͋
    TAgi            // f
};
const char *tMenu[] = {
    "̗",
    "U",
    "h",
    "f"
};


class Player : public Unit
{
public:
    bool Stay();                        // hɔ܂
    void AddMoney(int gd);              // zZ
    void ShowAllStatus();
    void Training(TrainingMenu tM);       // PiRj
    int  TrainingCost(TrainingMenu tM);   // RXg
    string getShowHP();
    string GetSaveTxt();                // Z[up̕
    int GetStayPrice();                 // ȟvZ
};

void Player::ShowAllStatus()
{
    cout << "y" << Name << "z HP:" << getShowHP() << "  Atp:" << Atp << "  Dfp:" << Dfp << "  Agi:" << Agi << "\n";
    cout << "݂̏F" << Money << "G\n";
}

void Player::AddMoney(int Gd)
{
    Money += Gd;
    cout << Name << "́A " << Gd << "S[hɓꂽI\n";
    ShowAllStatus();
}

int Player::GetStayPrice()
{
    double sp;
    sp = (( MaxHP + (Atp+Dfp+Agi)*4)/10*((1000+Atp+Dfp+Agi)/1000));

    return(static_cast<int>(sp));
}

bool Player::Stay()
{
    int price = GetStayPrice();
    if(HP == MaxHP){
        cout << "̗͖^łB@@@" << getShowHP() << "\n"
             << "܂Kv܂B\n";
    } else if(Money >= price){
        cout << Name << "́Ahɔ܂EEE\n̗͂SB\n";
        HP = MaxHP;
        Money -= price;
        return true;
    } else {
        cout << "܂I\n";
    }
    return false;
}

int mImp(int a){
    double d,da = static_cast<int>(a);
    d = (da/15.0+1.0)/(da<250.0 ? 1.0 : da/250.0);
    return static_cast<int>(d);
}

int mImpHP(int a){
    double d, da = static_cast<int>(a);
    d = (da/15.0+1.0)/(da<250.0 ? 1.0 : da/250.0)*((da+1000.0)/1000.0);
    return static_cast<int>(d);
}

int GetCost(int cost)
{
    double dCost = static_cast<double>(cost);

    dCost = dCost*((500+cost)/100);
    return static_cast<int>(dCost);
}

int Player::TrainingCost(TrainingMenu tM)
{
    int cost = 0;
    switch(tM){
        case THP:
            cost = GetCost(MaxHP/5);
            break;
        case TAtk:
            cost = GetCost(Atp);
            break;
        case TDef:
            cost = GetCost(Dfp);
            break;
        case TAgi:
            cost = GetCost(Agi);
            break;
    }
    return cost;
}

void Player::Training(TrainingMenu tM)
{
    int cost = TrainingCost(tM);
    int imp;
    if(Money >= cost){
        Money -= cost;
        switch(tM){
            case THP:
                imp = mImpHP(MaxHP);
                MaxHP += imp;
                HP += imp;
                break;
            case TAtk:
                imp = mImp(Atp);
                Atp += imp;
                break;
            case TDef:
                imp = mImp(Dfp);
                Dfp += imp;
                break;
            case TAgi:
                imp = mImp(Agi);
                Agi += imp;
                break;
        }
        cout << tMenu[tM] << " " << imp << "オB\n";
    } else {
        cout << "܂I\n";
    }
}

string Player::getShowHP()
{
    stringstream sstr;
    sstr.str("");

    sstr << "(" << HP << "/" << MaxHP << ")";

    return(sstr.str());
}

string Player::GetSaveTxt()
{
    stringstream sstr;
    sstr.str("");

    sstr << Name << " " << MaxHP << " " << Atp << " " << Dfp << " " << Agi << " " << Money;

    return(sstr.str());
}