# 機体関係
# 0  AP
# 1  MAXAP
# 2  EN
# 3  MAXEN
# 4  最大火力
# 5  機動
# 6  旋回
# 7  総重量
# 8  EN回復
# 9  精度
# 10 索敵
# 11 貯水
# 12 噴霧
# 13 跳躍
# 14 ロック範囲
# 15 ブースター消費
# 16 ミサイル防御
# 17 ロック回数
# 18 格闘補正
# 19 霊障補正
# 20 物理防御
# 21 粒子防御
# 22 霊障防御
# 23 電子防御
# 24 火炎防御
# 25 飛行補正
# 26 ホイールチャージ
# 27 脚部タイプ
# 28 射撃姿勢
# 29 
# 30 動作不良誘発
# 31 制動障害誘発
# 32 出力低下誘発
# 33 索敵障害誘発
# 34 旋回障害誘発
# 35 照準障害誘発
# 36 機体炎上誘発

# OP関係
# 0  火力補正
# 1  旋回確率
# 2  跳躍確率
# 3  AP回復
# 4  電磁波増幅
# 5  霧増幅
# 6  格闘強化
# 7  異常防御
# 8  異常強化




sub machine_st{
	use utf8;
	my $eno = shift;
	my $can_print = shift;
	my $del_op = shift;
	my @st_cell = ( );
	my @ammo_cell = ( );
	my @op_cell = ( );
	my $parts_data = \@parts_list;
	my $legweigt = 0;
	my $maxweight = 0;
	my @item = @{$item_list[$eno]};
	
	if ($can_print){
		$log[$eno] .= '<div class="wrap">' . "\n" . '<div class="inner">' . "\n" . '<div class="leftWrap">' . "\n";
		$log[$eno] .= '<TABLE class="machinedata">';
		$log[$eno] .= '<CAPTION><div class="caps">機体構成</div></CAPTION>' . "\n<TBODY>\n";
	}
	
	# 培養支援初期化
	$chara_st[$eno][11] = 0;
	
	my $over = 1;
	my @assem_cell = ( );
	
	for (my $i=2; $i<20; $i++){
		if ($i < 2){next;}
		elsif($i > 12){$over = 0.5;}
		
		my $p = $machine_list[$eno][$i];
		
		#DB記憶
		my $list_p = &item_list_id($p, $eno);
		$assem_cell[$i] = $list_p;
		
		if ($p <= 0 && $i > 3){next;}
		elsif ($p <= 0 && $i == 3){
			$p = 0;
		}
		elsif ($p <= 0 && $i == 2){
			$p = 0;
		}
		
		my $place = &place_name($i);
		
		# 種類と名前をロード
		my $type = &data_o($parts_data, $p, 2);
		my $name = &data_o($parts_data, $p, 1);
		my $typetag = &typetag($type);
		if ($can_print){
			$log[$eno] .= '<TR><TH><DIV class="' . $typetag . '">' . $place . "：" . $type . '</DIV></TH><TD>' . $name . "</TD></TR>\n";
		}
		
		# 種類別強度振り分け
		if ($type eq "頭"){
			$st_cell[10] += int(&data_o($parts_data, $p, 3) * $over);
		}
		elsif ($type eq "操縦棺"){
			$st_cell[16] += &data_o($parts_data, $p, 3);
		}
		elsif ($type eq "腕"){
			$st_cell[18] += int(&data_o($parts_data, $p, 3) * $over);
			$st_cell[28] += 200;
		}
		elsif ($type eq "術導肢"){
			$st_cell[19] += int(&data_o($parts_data, $p, 3) * $over);
			$st_cell[28] += 100;
		}
		elsif ($type =~ /射撃/){
			my $atk = int(&data_o($parts_data, $p, 3) * $over);
			my $time = &data_o($parts_data, $p, 4);
			if ($time > 1){$time /= 2;}
			$st_cell[4] += $atk * $time;
		}
		elsif ($type =~ /格闘/){
			my $atk = int(&data_o($parts_data, $p, 3) * $over);;
			my $time = &data_o($parts_data, $p, 4);
			if ($time > 1){$time /= 2;}
			$st_cell[4] += $atk * $time;
		}
		elsif ($type eq "二脚"){
			$st_cell[5] += &data_o($parts_data, $p, 3);
			$st_cell[13] += &data_o($parts_data, $p, 4);
			$st_cell[27] = $type;
			$legweight = &data_o($parts_data, $p, 9);
			$maxweight = &data_o($parts_data, $p, 17);
		}
		elsif ($type eq "逆関節"){
			$st_cell[5] += &data_o($parts_data, $p, 3);
			$st_cell[13] += &data_o($parts_data, $p, 4);
			$st_cell[27] = $type;
			$legweight = &data_o($parts_data, $p, 9);
			$maxweight = &data_o($parts_data, $p, 17);
		}
		elsif ($type eq "多脚"){
			$st_cell[5] += &data_o($parts_data, $p, 3);
			$st_cell[13] += &data_o($parts_data, $p, 4);
			$st_cell[28] += 500;
			$st_cell[27] = $type;
			$legweight = &data_o($parts_data, $p, 9);
			$maxweight = &data_o($parts_data, $p, 17);
		}
		elsif ($type eq "タンク"){
			$st_cell[5] += &data_o($parts_data, $p, 3);
			$st_cell[14] += 300;
			$st_cell[27] = $type;
			$legweight = &data_o($parts_data, $p, 9);
			$maxweight = &data_o($parts_data, $p, 17);
		}
		elsif ($type eq "車輪"){
			$st_cell[5] += &data_o($parts_data, $p, 3);
			$st_cell[26] += &data_o($parts_data, $p, 3);
			$st_cell[27] = $type;
			$legweight = &data_o($parts_data, $p, 9);
			$maxweight = &data_o($parts_data, $p, 17);
		}
		elsif ($type eq "FCS"){
			$st_cell[14] += int(&data_o($parts_data, $p, 3) * $over);
			$st_cell[17] += &data_o($parts_data, $p, 4);
		}
		elsif ($type =~ /エンジン/){
			$st_cell[3] += int(&data_o($parts_data, $p, 3) * $over);
			$st_cell[8] += int(&data_o($parts_data, $p, 3) * $over);
		}
		elsif ($type eq "レーダー"){
			$st_cell[10] += int(&data_o($parts_data, $p, 3) * $over);
		}
		elsif ($type eq "ブースター"){
			$st_cell[5] += int(&data_o($parts_data, $p, 3) * $over);
			$st_cell[13] += int(&data_o($parts_data, $p, 4) * $over);
			$st_cell[15] += int(&data_o($parts_data, $p, 6) * $over);
		}
		elsif ($type eq "補助輪"){
			$st_cell[5] += int(&data_o($parts_data, $p, 3) * $over);
			$st_cell[26] += int(&data_o($parts_data, $p, 3) * $over);
		}
		elsif ($type eq "飛行補助"){
			$st_cell[25] += &data_o($parts_data, $p, 3);
		}
		elsif ($type eq "培養装置"){
			my $level = &data_o($parts_data, $p, 3);
			&money($level, $eno, "培養支援");
		}
		elsif ($type eq "動作不良誘発"){
			$st_cell[30] += &data_o($parts_data, $p, 3);
		}
		elsif ($type eq "制動障害誘発"){
			$st_cell[31] += &data_o($parts_data, $p, 3);
		}
		elsif ($type eq "出力低下誘発"){
			$st_cell[32] += &data_o($parts_data, $p, 3);
		}
		elsif ($type eq "索敵障害誘発"){
			$st_cell[33] += &data_o($parts_data, $p, 3);
		}
		elsif ($type eq "旋回障害誘発"){
			$st_cell[34] += &data_o($parts_data, $p, 3);
		}
		elsif ($type eq "照準障害誘発"){
			$st_cell[35] += &data_o($parts_data, $p, 3);
		}
		elsif ($type eq "機体炎上誘発"){
			$st_cell[36] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /火力/){
			$op_cell[0] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /旋回/){
			$op_cell[1] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /跳躍/){
			$op_cell[2] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /回復/){
			$op_cell[3] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /電磁波/){
			$op_cell[4] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /霧/){
			$op_cell[5] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /飛行補助/){
			$st_cell[25] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /索敵/){
			$st_cell[10] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /迎撃/){
			$st_cell[16] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /卵/){
			my $level = &data_o($parts_data, $p, 3);
			&money($level, $eno, "培養支援");
		}
		elsif ($type =~ /OP/ && $type =~ /動作不良/){
			$st_cell[30] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /制動障害/){
			$st_cell[31] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /出力低下/){
			$st_cell[32] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /索敵障害/){
			$st_cell[33] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /旋回障害/){
			$st_cell[34] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /照準障害/){
			$st_cell[35] += &data_o($parts_data, $p, 3);
		}
		elsif ($type =~ /OP/ && $type =~ /機体炎上/){
			$st_cell[36] += &data_o($parts_data, $p, 3);
		}
		
		
		# 各種ステータス
		if ($type =~ /OP/){
			$st_cell[1] += &data_o($parts_data, $p, 5);
			$st_cell[6] += &data_o($parts_data, $p, 10);
			$st_cell[7] += &data_o($parts_data, $p, 9);
			$st_cell[8] -= &data_o($parts_data, $p, 6);
			$st_cell[9] += &data_o($parts_data, $p, 13);
			$st_cell[11] += &data_o($parts_data, $p, 14);
			$st_cell[12] += &data_o($parts_data, $p, 15);
		}
		else{
			$st_cell[1] += int(&data_o($parts_data, $p, 5) * $over);
			$st_cell[6] += int(&data_o($parts_data, $p, 10) * $over);
			$st_cell[7] += int(&data_o($parts_data, $p, 9) * $over);
			unless ($type =~ /射撃/ || $type =~ /格闘/){
				$st_cell[8] -= int(&data_o($parts_data, $p, 6) * $over);
			}
			$st_cell[9] += int(&data_o($parts_data, $p, 13) * $over);
			$st_cell[11] += int(&data_o($parts_data, $p, 14) * $over);
			$st_cell[12] += int(&data_o($parts_data, $p, 15) * $over);
		}
		
		
		# 弾数
		$ammo_cell[$i] =  &data_o($parts_data, $p, 16);
		
		# 各種耐性
		my $def_val = 0;
		my $def = &data_o($parts_data, $p, 11);
		if ($type =~ /OP/){
			$def_val = &data_o($parts_data, $p, 12);
		}
		else{
			$def_val = int(&data_o($parts_data, $p, 12) * $over);
		}
		if ($def eq "物理"){$st_cell[20] += $def_val;}
		elsif ($def eq "粒子"){$st_cell[21] += $def_val;}
		elsif ($def eq "霊障"){$st_cell[22] += $def_val;}
		elsif ($def eq "電子"){$st_cell[23] += $def_val;}
		elsif ($def eq "火炎"){$st_cell[24] += $def_val;}
		
	}
	if ($can_print){
		$log[$eno] .= "</TBODY>\n</TABLE>\n";
		$log[$eno] .= '</div><!-- /leftWrap -->' . "\n";
	}
	
	my $ex_message = "";
	
	# 機動力補正
	my $spd = int($st_cell[7] / -40);
	$spd += 200;
	my $circ = 100;
	
	# 積載量
	my $partsweight = $st_cell[7] - $legweight;
	if ($partsweight > $maxweight){
		$ex_message .= "重量過多　";
		$spd -= int(($partsweight - $maxweight) / 10);
		$circ -= int(($partsweight - $maxweight) / 20);
	}
	
	# EN回復最低値
	if ($st_cell[8] < 1){
		$ex_message .= "出力不足　";
		$st_cell[8] = 1;
	}
	if ($st_cell[3] < 100){
		$ex_message .= "動力機関欠如　";
		$st_cell[3] = 100;
	}
	
	# 最大火力
	$st_cell[4] = int($st_cell[4] / 2);
	
	if($spd < 1){$spd = 1;}
	
	# 機動
	$st_cell[5] *= $spd;
	$st_cell[5] /= 100;
	if($st_cell[5] < 1){$st_cell[5] = 1;}
	$st_cell[5] = int($st_cell[5]);
	
	# 旋回
	$st_cell[6] *= $circ;
	$st_cell[6] /= 100;
	if($st_cell[6] < 1){$st_cell[6] = 1;}
	$st_cell[6] = int($st_cell[6]);
	
	# ジャンプ
	$st_cell[13] *= $spd;
	$st_cell[13] /= 100;
	if($st_cell[13] < 0){$st_cell[13] = 0;}
	$st_cell[13] = int($st_cell[13]);
	
	# 耐性補正
	# 物理
	my $butu = int($st_cell[7] / 40);
	if($butu < 10){$butu = 10;}
	elsif($butu > 100){
		$butu -= 100;
		$butu = int($butu / 10);
		$butu += 100;
	}
	$st_cell[20] *= $butu;
	$st_cell[20] = int($st_cell[20] / 100);
	
	# 粒子
	my $en = int($st_cell[8] / 8);
	if($en < 10){$en = 10;}
	$st_cell[21] *= $en;
	$st_cell[21] = int($st_cell[21] / 100);
	
	# 霊障
	if($spd < 10){$spd = 10;}
	$st_cell[22] *= $spd;
	$st_cell[22] = int($st_cell[22] / 100);
	
	# 電子
	my $elec = int($st_cell[12] / -6);
	$elec += 200;
	if($elec < 10){$elec = 10;}
	$st_cell[23] *= $elec;
	$st_cell[23] = int($st_cell[23] / 100);
	
	# 火炎
	my $fire = int($st_cell[8] / -8);
	$fire += 200;
	if($fire < 10){$fire = 10;}
	$st_cell[24] *= $fire;
	$st_cell[24] = int($st_cell[24] / 100);
	
	if ($ex_message eq ""){$ex_message = "良好";}
	
	# 機体ステ表示
	if ($can_print){
		$log[$eno] .= '<div class="rightWrap">' . "\n";
		$log[$eno] .= '<TABLE class="specdata">';
		$log[$eno] .= '<CAPTION><div class="caps">機体データ</div></CAPTION>' . "\n<TBODY>\n";
	}
	
	$st_cell[0] = $st_cell[1];
	if ($can_print){
		$log[$eno] .= '<TR><TH>AP</TH><TD colspan="3">';
		$log[$eno] .= $st_cell[1] . "</TD></TR>\n";
	}
	$st_cell[2] = $st_cell[3];
	if ($can_print){
		$log[$eno] .= '<TR><TH>EN</TH><TD colspan="3">';
		$log[$eno] .= $st_cell[3] . "</TD></TR>\n";
		
		$log[$eno] .= '<TR><TH>最大火力</TH><TD>';
		$log[$eno] .= $st_cell[4] . '</TD>';
		$log[$eno] .= '<TH>機動力</TH><TD>';
		$log[$eno] .= $st_cell[5] . "</TD></TR>\n";
		
		$log[$eno] .= '<TR><TH>旋回速度</TH><TD>';
		$log[$eno] .= $st_cell[6] . '</TD>';
		$log[$eno] .= '<TH>総重量</TH><TD>';
		$log[$eno] .= $st_cell[7] . "</TD></TR>\n";
		
		$log[$eno] .= '<TR><TH>EN回復量</TH><TD>';
		$log[$eno] .= $st_cell[8] . '</TD>';
		$log[$eno] .= '<TH>命中精度</TH><TD>';
		$log[$eno] .= $st_cell[9] . "</TD></TR>\n";
		
		$log[$eno] .= '<TR><TH>索敵範囲</TH><TD>';
		$log[$eno] .= $st_cell[10] . '</TD>';
		$log[$eno] .= '<TH>跳躍力</TH><TD>';
		$log[$eno] .= $st_cell[13] . "</TD></TR>\n";
		
		$log[$eno] .= '<TR><TH>貯水量</TH><TD>';
		$log[$eno] .= $st_cell[11] . '</TD>';
		$log[$eno] .= '<TH>噴霧量</TH><TD>';
		$log[$eno] .= $st_cell[12] . "</TD></TR>\n";
		
		$log[$eno] .= '<TR><TH>物理防御</TH><TD><DIV class="butu_kaku">';
		$log[$eno] .= $st_cell[20] . '</DIV></TD>';
		$log[$eno] .= '<TH>粒子防御</TH><TD><DIV class="en_kaku">';
		$log[$eno] .= $st_cell[21] . "</DIV></TD></TR>\n";
		
		$log[$eno] .= '<TR><TH>霊障防御</TH><TD><DIV class="ghost_kaku">';
		$log[$eno] .= $st_cell[22] . '</DIV></TD>';
		$log[$eno] .= '<TH>電子防御</TH><TD><DIV class="elec_kaku">';
		$log[$eno] .= $st_cell[23] . "</DIV></TD></TR>\n";
		
		$log[$eno] .= '<TR><TH>火炎防御</TH><TD colspan="3"><DIV class="fire_kaku">';
		$log[$eno] .= $st_cell[24] . "</DIV></TD></TR>\n";
		
		$log[$eno] .= '<TR><TH>積載量</TH><TD colspan="3">';
		$log[$eno] .= $partsweight . "/" . $maxweight . "</TD></TR>\n";
		$log[$eno] .= '<TR><TH>機体状況</TH><TD colspan="3">';
		$log[$eno] .= $ex_message . "</TD></TR>\n";
		
		$log[$eno] .= "</TBODY>\n</TABLE>\n";
		
		$log[$eno] .= "</div><!-- /rightWrap -->" . '<div class="clear"><hr /></div>' . "\n</div><!-- /inner -->\n</div><!-- /wrap -->\n<BR>\n<BR>\n";
	}
	
	my $assem_str = "";
	for (my $i=2; $i<13; $i++){
		if ($i>2){$assem_str .= "：";}
		my $a = $assem_cell[$i];
		$assem_str .= "$a";
	}
	
	$keizoku_db[$eno][10] = $assem_str;
	$machine[$eno] = \@st_cell;
	$ammo[$eno] = \@ammo_cell;
	$op_list[$eno] = \@op_cell;
	
	# 特殊ステータス付加の発動
	
	my $fuka_log = "";
	for (my $i=2; $i<20; $i++){
		if ($i < 2){next;}
		
		my $p = $machine_list[$eno][$i];
		my $fuka_a = &data_o($parts_data, $p, 29);
		my $fuka_b = &data_o($parts_data, $p, 30);
		$fuka_log .= &fuka_run($p, $fuka_a, $eno, $can_print);
		$fuka_log .= &fuka_run($p, $fuka_b, $eno, $can_print);
		
	}
	
	if ($can_print && $fuka_log && $del_op == 0){
		$log[$eno] .= '<br><table align="center" class="maintable">' . "<tr><td>\n";
		$log[$eno] .= "<B>付加発動！！</B><BR>\n";
		$log[$eno] .= $fuka_log;
		$log[$eno] .= "<BR></td></tr></table><br>\n";
	}
	
	# オーバーロード破棄
	if ($del_op){
		for (my $i=2; $i<12; $i++){
			my $p = $machine_list[$eno][$i];
			my $type = &data_o($parts_data, $p, 2);
			if ($type eq "素材"){
				&item_del($p, $eno);
			}
		}
		for (my $i=13; $i<20; $i++){
			my $p = $machine_list[$eno][$i];
			&item_del($p, $eno);
		}
	}
	
	$machine[$eno][0] = $machine[$eno][1];
	
}

sub place_name{
	use utf8;
	my $num = shift;
	my $ans = "";
	if ($num == 2){$ans = "脚部";}
	elsif($num == 3){$ans = "操縦棺";}
	elsif($num > 12){$ans = "OP";}
	else{$ans = $num - 3;}
	return $ans;
}

sub typetag{
	use utf8;
	my $type = shift;
	my $ans = ( );
	
	if ($type eq "操縦棺"){
		$ans = "core";
	} elsif ($type eq "二脚"){
		$ans = "leg";
	}elsif ($type eq "逆関節"){
		$ans = "leg";
	} elsif ($type eq "多脚"){
		$ans = "leg";
	} elsif ($type eq "タンク"){
		$ans = "leg";
	} elsif ($type eq "車輪"){
		$ans = "leg";
	} elsif ($type eq "頭"){
		$ans = "head";
	} elsif ($type eq "腕"){
		$ans = "arm";
	} elsif ($type eq "術導肢"){
		$ans = "marm";
	} elsif ($type eq "FCS"){
		$ans = "fcs";
	} elsif ($type eq "砲塔"){
		$ans = "tower";
	} elsif ($type eq "ミストエンジン"){
		$ans = "mist";
	} elsif ($type eq "ブースター"){
		$ans = "booster";
	} elsif ($type eq "補助輪"){
		$ans = "subwheel";
	} elsif ($type eq "レーダー"){
		$ans = "lader";
	} elsif ($type eq "装甲"){
		$ans = "armor";
	} elsif ($type eq "噴霧機"){
		$ans = "extra";
	} elsif ($type eq "物理射撃"){
		$ans = "butu_shoot";
	} elsif ($type eq "粒子射撃"){
		$ans = "en_shoot";
	} elsif ($type eq "電子射撃"){
		$ans = "elec_shoot";
	} elsif ($type eq "火炎射撃"){
		$ans = "fire_shoot";
	} elsif ($type eq "物理格闘"){
		$ans = "butu_kaku";
	} elsif ($type eq "粒子格闘"){
		$ans = "en_kaku";
	} elsif ($type eq "電子格闘"){
		$ans = "elec_kaku";
	} elsif ($type eq "火炎格闘"){
		$ans = "fire_kaku";
	}else{
		$ans = "other";
	}
	return $ans;
}

sub type_atk_name{
	use utf8;
	my $type = shift;
	my @ans = ("特殊A", "特殊B");
	
	if ($type eq "頭"){
		$ans[0] = "索敵";
	} elsif ($type eq "操縦棺"){
		$ans[0] = "迎撃";
	} elsif ($type eq "腕"){
		$ans[0] = "格闘補正";
	} elsif ($type eq "術導肢"){
		$ans[0] = "霊障補正";
	} elsif ($type =~ /射撃/){
		$ans[0] = "火力";
		$ans[1] = "発射数";
	} elsif ($type =~ /格闘/){
		$ans[0] = "火力";
		$ans[1] = "連撃数";
	} elsif ($type eq "二脚"){
		$ans[0] = "機動";
		$ans[1] = "跳躍";
	} elsif ($type eq "逆関節"){
		$ans[0] = "機動";
		$ans[1] = "跳躍";
	} elsif ($type eq "多脚"){
		$ans[0] = "機動";
		$ans[1] = "跳躍";
	} elsif ($type eq "タンク"){
		$ans[0] = "機動";
	} elsif ($type eq "車輪"){
		$ans[0] = "機動";
	} elsif ($type eq "FCS"){
		$ans[0] = "射撃補正";
		$ans[1] = "ロック数";
	} elsif ($type =~ /エンジン/){
		$ans[0] = "出力";
	} elsif ($type eq "レーダー"){
		$ans[0] = "索敵";
	} elsif ($type eq "ブースター"){
		$ans[0] = "機動";
		$ans[1] = "跳躍";
	} elsif ($type eq "補助輪"){
		$ans[0] = "機動";
	} elsif ($type eq "飛行補助"){
		$ans[0] = "飛行";
	} elsif ($type eq "培養装置"){
		$ans[0] = "培養";
	} elsif ($type eq "動作不良誘発"){
		$ans[0] = "動作不良誘発";
	} elsif ($type eq "制動障害誘発"){
		$ans[0] = "制動障害誘発";
	} elsif ($type eq "出力低下誘発"){
		$ans[0] = "出力低下誘発";
	} elsif ($type eq "索敵障害誘発"){
		$ans[0] = "索敵障害誘発";
	} elsif ($type eq "旋回障害誘発"){
		$ans[0] = "旋回障害誘発";
	} elsif ($type eq "照準障害誘発"){
		$ans[0] = "照準障害誘発";
	} elsif ($type eq "機体炎上誘発"){
		$ans[0] = "機体炎上誘発";
	} elsif ($type =~ /OP/ && $type =~ /火力/){
		$ans[0] = "火力";
	} elsif ($type =~ /OP/ && $type =~ /旋回/){
		$ans[0] = "旋回";
	} elsif ($type =~ /OP/ && $type =~ /跳躍/){
		$ans[0] = "跳躍";
	} elsif ($type =~ /OP/ && $type =~ /回復/){
		$ans[0] = "AP回復";
	} elsif ($type =~ /OP/ && $type =~ /電磁波/){
		
	} elsif ($type =~ /OP/ && $type =~ /霧/){
		
	} elsif ($type =~ /OP/ && $type =~ /飛行補助/){
		$ans[0] = "飛行";
	} elsif ($type =~ /OP/ && $type =~ /索敵/){
		$ans[0] = "索敵";
	} elsif ($type =~ /OP/ && $type =~ /迎撃/){
		$ans[0] = "迎撃";
	} elsif ($type =~ /OP/ && $type =~ /卵/){
		$ans[0] = "培養";
	} elsif ($type =~ /OP/ && $type =~ /動作不良/){
		$ans[0] = "動作不良誘発";
	} elsif ($type =~ /OP/ && $type =~ /制動障害/){
		$ans[0] = "制動障害誘発";
	} elsif ($type =~ /OP/ && $type =~ /出力低下/){
		$ans[0] = "出力低下誘発";
	} elsif ($type =~ /OP/ && $type =~ /索敵障害/){
		$ans[0] = "索敵障害誘発";
	} elsif ($type =~ /OP/ && $type =~ /旋回障害/){
		$ans[0] = "旋回障害誘発";
	} elsif ($type =~ /OP/ && $type =~ /照準障害/){
		$ans[0] = "照準障害誘発";
	} elsif ($type =~ /OP/ && $type =~ /機体炎上/){
		$ans[0] = "機体炎上誘発";
	}
	
	return @ans;
}

sub parts_palam{
	use utf8;
	my $p = shift;
	my $parts_data = \@parts_list;
	my $parts_palam = \@parts_palam_list;
	my $option_data = \@option_data_list;
	
	my $lv = &data_o($parts_data, $p, 20);
	my $shoot = &data_o($parts_data, $p, 21);
	my $blade = &data_o($parts_data, $p, 22);
	my $dodge = &data_o($parts_data, $p, 23);
	my $drive = &data_o($parts_data, $p, 24);
	my $mech = &data_o($parts_data, $p, 25);
	my $magus = &data_o($parts_data, $p, 26);
	my $palam = &data_o($parts_data, $p, 27);
	my $w_bonus = &data_o($parts_data, $p, 33);
	
	$shoot = ($shoot * 0.075) + 90;
	$blade = ($blade * 0.075) + 90;
	$dodge = ($dodge * 0.075) + 90;
	$drive = ($drive * 0.075) + 90;
	$mech = ($mech * 0.075) + 90;
	$magus = ($magus * 0.075) + 90;
	
	unless($palam){
		return 0;
	}
	
	my $type = &data_o($parts_palam, $palam, 2);
	my $atk = &data_o($parts_palam, $palam, 3);
	my $subatk = &data_o($parts_palam, $palam, 4);
	my $ap = &data_o($parts_palam, $palam, 5);
	my $en = &data_o($parts_palam, $palam, 6);
	my $price = &data_o($parts_palam, $palam, 7);
	my $ammo_price = &data_o($parts_palam, $palam, 8);
	my $weight = &data_o($parts_palam, $palam, 9);
	my $circle = &data_o($parts_palam, $palam, 10);
	my $def_type = &data_o($parts_palam, $palam, 11);
	my $def_lv = &data_o($parts_palam, $palam, 12);
	my $hit = &data_o($parts_palam, $palam, 13);
	my $tank = &data_o($parts_palam, $palam, 14);
	my $mist = &data_o($parts_palam, $palam, 15);
	my $ammo_num = &data_o($parts_palam, $palam, 16);
	my $loading = &data_o($parts_palam, $palam, 17);
	my $atk_type = &data_o($parts_palam, $palam, 18);
	my $atk_add = &data_o($parts_palam, $palam, 19);
	
	$price = 20;
	
	$lv += $w_bonus + 30;
	$lv *= 0.3;
	
	
	$atk = int($atk * $lv);
	$ap = int($ap * $lv);
	$en = int($en * $lv);
	$price = int($price * $lv);
	$circle = int($circle * $lv);
	$def_lv = int($def_lv * $lv);
	$hit = int($hit * $lv);
	$tank = int($tank * $lv);
	$mist = int($mist * $lv);
	$weight = int($weight * $w_bonus);
	# $price *= $w_bonus / 10;
	# $price = int($price);
	
	my $atk_per = 200;
	
	if ($type =~ /射撃/){
		$atk *= $shoot / $atk_per;
		unless($subatk){$subatk=1;}
		$en = int($en / $subatk);
	}
	elsif ($type =~ /格闘/){
		$atk *= $blade / $atk_per;
		unless($subatk){$subatk=1;}
		$en = int($en / $subatk);
	}
	elsif ($type eq "頭"){
		$atk *= $drive / $atk_per;
	}
	elsif ($type eq "操縦棺"){
		
	}
	elsif ($type eq "腕"){
		$atk *= $blade / $atk_per;
	}
	elsif ($type eq "術導肢"){
		$atk *= $magus / $atk_per;
	}
	elsif ($type eq "二脚"){
		$atk *= $drive / $atk_per;
		$atk *= $blade / $atk_per;
		$subatk *= $lv;
		$subatk *= $dodge / $atk_per;
	}
	elsif ($type eq "逆関節"){
		$atk *= $drive / $atk_per;
		$atk *= $blade / $atk_per;
		$subatk *= $lv;
		$subatk *= $dodge / $atk_per;
	}
	elsif ($type eq "多脚"){
		$atk *= $drive / $atk_per;
		$atk *= $blade / $atk_per;
		$subatk *= $lv;
		$subatk *= $dodge / $atk_per;
	}
	elsif ($type eq "タンク"){
		$atk *= $drive / $atk_per;
		$atk *= $blade / $atk_per;
		$subatk *= $lv;
		$subatk *= $dodge / $atk_per;
	}
	elsif ($type eq "車輪"){
		$atk *= $drive / $atk_per;
		$atk *= $blade / $atk_per;
		$subatk *= $lv;
		$subatk *= $dodge / $atk_per;
	}
	elsif ($type eq "FCS"){
		$atk *= $shoot / $atk_per;
	}
	elsif ($type =~ /エンジン/){
		$atk *= $mech / $atk_per;
	}
	elsif ($type eq "レーダー"){
		$atk *= $drive / $atk_per;
	}
	elsif ($type eq "ブースター"){
		$atk *= $drive / $atk_per;
		$atk *= $blade / $atk_per;
		$subatk *= $lv;
		$subatk *= $dodge / $atk_per;
	}
	elsif ($type eq "補助輪"){
		$atk *= $drive / $atk_per;
		$atk *= $blade / $atk_per;
	}
	elsif ($type eq "飛行補助"){
		$atk *= $drive / $atk_per;
	}
	elsif ($type eq "培養装置"){
		$atk *= $mech / $atk_per;
	}
	elsif ($type eq "動作不良誘発"){
		$atk *= $magus / $atk_per;
	}
	elsif ($type eq "制動障害誘発"){
		$atk *= $magus / $atk_per;
	}
	elsif ($type eq "出力低下誘発"){
		$atk *= $magus / $atk_per;
	}
	elsif ($type eq "索敵障害誘発"){
		$atk *= $magus / $atk_per;
	}
	elsif ($type eq "旋回障害誘発"){
		$atk *= $magus / $atk_per;
	}
	elsif ($type eq "照準障害誘発"){
		$atk *= $magus / $atk_per;
	}
	elsif ($type eq "機体炎上誘発"){
		$atk *= $magus / $atk_per;
	}
	
	unless($en){$en = 1;}
	
	$atk = int($atk);
	$subatk = int($subatk);
	
	$hit *= $shoot / $atk_per;
	$hit = int($hit);
	
	$circle *= $dodge / $atk_per;
	$circle = int($circle);
	
	$ap *= $mech / $atk_per;
	$ap = int($ap);
	
	$tank *= $mech / $atk_per;
	$tank = int($tank);
	
	$mist *= $magus / $atk_per;
	$mist = int($mist);
	
	&data_i($parts_data, $p, 2, $type);
	&data_i($parts_data, $p, 3, $atk);
	&data_i($parts_data, $p, 4, $subatk);
	&data_i($parts_data, $p, 5, $ap);
	&data_i($parts_data, $p, 6, $en);
	&data_i($parts_data, $p, 7, $price);
	&data_i($parts_data, $p, 8, $ammo_price);
	&data_i($parts_data, $p, 9, $weight);
	&data_i($parts_data, $p, 10, $circle);
	&data_i($parts_data, $p, 11, $def_type);
	&data_i($parts_data, $p, 12, $def_lv);
	&data_i($parts_data, $p, 13, $hit);
	&data_i($parts_data, $p, 14, $tank);
	&data_i($parts_data, $p, 15, $mist);
	&data_i($parts_data, $p, 16, $ammo_num);
	&data_i($parts_data, $p, 17, $loading);
	&data_i($parts_data, $p, 18, $atk_type);
	&data_i($parts_data, $p, 19, $atk_add);
	
	return 0;
	
}

# パラメータ変動系付加

sub parts_fuka{
	use utf8;
	my $p = shift;
	my $fuka = shift;
	my $eno = shift;
	my $messe = shift;
	my $parts_data = \@parts_list;
	my $option_base = \@option_base_list;
	
	unless($fuka){return 0;}
	
	my $lv = &data_o($parts_data, $p, 20);
	
	my $palam_name = &data_name($option_base, $fuka, 1);
	my $palam_id = &data_name($option_base, $fuka, 2);
	my $palam_per = &data_name($option_base, $fuka, 3);
	my $palam_extra = &data_name($option_base, $fuka, 4);
	
	if ($palam_id == 3){
		return 1;
	}
	
	$lv = int($lv * $palam_per / 100);
	
	
	
	if ($palam_extra =~ /耐/ ){
		# 耐性の変化
		$palam_extra =~ s/耐//;
		&data_i($parts_data, $p, 11, $palam_extra);
		if($messe){
			$log[$eno] .= '<div class="goodeffect">作成時発動！　' . $palam_name . "!!　";
			$log[$eno] .= "防御属性が " . $palam_extra . " に変化!!</div>";
		}
	}
	elsif ($palam_extra =~ /重量/ ){
		&data_p($parts_data, $p, $palam_id, $lv);
		if($messe){
			$log[$eno] .= '<div class="goodeffect">作成時発動！　' . $palam_name . "!!　";
			$log[$eno] .= "パーツ重量を " . $lv . " 修正!!</div>";
		}
	}
	
	# if ($palam_id != 3){
	#	&data_p($parts_data, $p, $palam_id, $lv);
	# }
	
	# $log[$eno] .= $palam_extra . "強化！</div><BR>\n";
	
	return 1;
	
}

# 付加効果発揮
# 初期化した後に加算するので
# 必ずmachine_stの後に発動させること

sub fuka_run{
	use utf8;
	my $p = shift;
	my $fuka = shift;
	my $eno = shift;
	my $can_print = shift;
	my $log_fuka = "";
	
	my $parts_data = \@parts_list;
	my $option_base = \@option_base_list;
	
	unless($fuka){return $log_fuka;}
	
	my $lv = &data_o($parts_data, $p, 20);
	
	my $palam_name = &data_name($option_base, $fuka, 1);
	my $palam_id = &data_name($option_base, $fuka, 2);
	my $palam_per = &data_name($option_base, $fuka, 3);
	my $palam_extra = &data_name($option_base, $fuka, 4);
	my $palam_st = &data_name($option_base, $fuka, 5);
	
	$lv = int($lv * $palam_per / 100);
	
	if ($palam_id == 9){
		return $log_fuka;
	}
	
	# 3番は特殊パラメータ
	
	if ($can_print){
		$log_fuka .=  '<div class="goodeffect">' . $palam_name . "!!　";
	}
	
	if ($palam_extra eq "出力"){
		$machine[$eno][2] += $lv;
		if($machine[$eno][8] > 1){
			$machine[$eno][8] += $lv;
		}
	}
	elsif ($palam_extra eq "回復"){
		$op_list[$eno][3] += $lv;
	}
	elsif ($palam_extra eq "装甲"){
		$machine[$eno][0] += $lv;
	}
	elsif ($palam_extra eq "格闘ダメージ強化"){
		$op_list[$eno][6] += $lv;
	}
	elsif ($palam_extra eq "異常防御"){
		$op_list[$eno][7] += $lv;
	}
	elsif ($palam_extra eq "異常強化"){
		$op_list[$eno][8] += $lv;
	}
	
	if ($palam_st){
		$machine[$eno][$palam_st] += $lv;
	}
	
	if ($can_print){
		$log_fuka .= $palam_extra . "を" . $lv . "強化！</div><BR>\n";
	}
	
	return $log_fuka;
}

1;

