#!C:/Perl64/bin/perl

use strict;
use warnings;
use utf8;
use Devel::Peek;
use Encode;
binmode STDIN,  ":utf8";
binmode STDOUT, ":utf8";

require 'file.pl';
require 'data_io.pl';
require 'entry.pl';
require 'load_save.pl';
require 'result_output.pl';
require 'print_data.pl';
require 'data_format.pl';
require 'machine_st.pl';
require 'action.pl';
require 'afterday.pl';
require 'afterday_sub.pl';
require 'battle_attack.pl';
require 'battle_main.pl';
require 'battle_sub.pl';
require 'word.pl';
require 'catalog_data_sort.pl';

$| = 1;

print "Content-type: text/html\n\n";
print "<html><head>\n";
print '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">';
print "\n";
print "<title>Perl Test</title>\n";
print "</head><body>\n";
print "<p>Hello M_o_W!</p>\n";

# 初期化
our $event = 0;
# イベント１…最終回　イベント２…対人戦
# イベント３…予告前夜　４…２期最終回予告　

# 結果ログ
our @log = ( );
# 戦闘ログ
our @log_b = ( );
# 行動指定
our @action = ( );
# 機体ステータス
our @machine = ( );
our @ammo = ( );
# 装備中チェック
our @equip = ( );
# キャラステータス
our @chara_st = ( );
our $player_num = 0;
our $player_max = 0;
# メッセ送信ログ
our @log_to = ( );
# 送品ログ
our @log_gift = ( );
# 入手アイテム
our @get_gift = ( );

# 継続データ
our @keizoku_list = ( );
our @sinki_list = ( );
our @messe_list = ( );
our @setting_list = ( );
our @battle_list = ( );

#DB

our @keizoku_db = ( );

# パーツリスト読み込み
our @parts_list = ( );
our @enemy_parts_list = ( );
our @catalog_parts_list = ( );
# 新規パーツリスト読み込み
our @new_parts_list = ( );

our @option_list = ( );
our @option_data_list = ( );
our @option_base_list = ( );

# キャラデータ読み込み
our @chara_list = ( );

# ゲームデータ読み込み
our @game_data = ( );

# 機体データ読み込み
our @machine_list = ( );

# 機体補正
our @op_list = ( );

# サブクエスト
our @sub_quest = ( );

# 所持品データ読み込み
our @item_list = ( );

# 装備チェック読み込み
our @equip_list = ( );

# マッチング
our @matching = ( );
# ミッション
our @mission_list = ( );

# 敵NPC
our @enemy_list = ( );

# 敵NPCセリフ
our @npc_word_list = ( );

our @messe = ( );
our @icon_list = ( );
our @seting = ( );

our @battle_action = ( );

# カタログ
our @catalog_list = ( );
our $catalog_max = 0;

# システム変数
our $garage_max = 31;
our $mission_order = 1;

print "format end<br>\n";

# データ読み込み
&load_data;
print "load data end<br>\n";

# デバッグ用
# &matching;

# 行動読み込み・パスチェック
&load_action;
print "load action end<br>\n";

&player_num;
print "player_num end<br>\n";

# 設定
for(my $eno=0; $eno<10000; $eno++) {
	
	my $name = $chara_list[$eno][1];
	unless ($name){next;}
	
	# 詫びNP
	#$chara_list[$eno][23] += 1;
	
	&setting_set($eno);
    
    
}
print "setting_prosess end<br>\n";


my @sakujo = ( );
my @mass_messe = "";

# メインループ
my $sleep = 0;
for(my $act=1; $act<19; $act++) {
	
	for (my $eno=1; $eno<10000; $eno++){
		my $name = $chara_list[$eno][1];
		unless($name){next;}
		
		if($act == 1){
			$log[$eno] .= '<br><table align="center" class="maintable"><tr><td>' . "\n";
			
			my $day = $chara_list[$eno][10];
			$log[$eno] .= '<DIV align="right"><I><A href="http://blacktea.sakura.ne.jp/AOAICGI/LOGIN/login.cgi" Target="_blank">>>継続登録はこちら</A></DIV>';
			$log[$eno] .= '<A name="top">◆</A>tag_hasamimasu' . "<BR>\n";
			$log[$eno] .= "<BR>\n";
			$log[$eno] .= "<H1><I>第" . $day . "日目</I></H1>\n<BR>\n";
			$log[$eno] .= "<I>Eno." . "$eno $name" . "の一日</I><BR><BR>\n";
			
			my $mist = $game_data[1][2];
			my $rad = $game_data[2][2];
			
			$log[$eno] .= "<I>霧濃度" . $mist . "％</I>\n<BR>\n";
			$log[$eno] .= "<I>電磁波" . $rad . "％</I>\n<BR><BR>\n";
			
			
			$log[$eno] .= '<font color="teal">' . "<I>";
			&news($eno);
			$log[$eno] .= "</I></font><BR>";
			
			$log[$eno] .= "<BR>\n";
			
			next;
		}
		
		if($act == 11){
			# オプション
			# 初期化
			for (my $i=13; $i<19; $i++){
				$machine_list[$eno][$i] = -1;
			}
		}
		
		my $act_spe = $action[$eno][$act];
		
		if($act == 2){
			# 日記
			$log[$eno] .= "<BR>\n";
			$log[$eno] .= "日記<BR>\n";
			my $act_pct = $action[$eno][14];
			&diary($act_spe, $eno, $act_pct);
		}
		
		unless($act_spe){
			next;
		}
		my $str = $act_spe;
		$str =~ s/：//g;
		$str =~ s/to//g;
		unless($str){
			next;
		}
		
		if($act == 3){
			# 訓練
			$log[$eno] .= "<BR>\n";
			$log[$eno] .= "◆訓練<BR>\n";
			&train($act_spe, $eno);
		}elsif($act == 4){
			# 送品
			$log[$eno] .= "<BR>\n";
			$log[$eno] .= "◆送品<BR>\n";
			&send_item($act_spe, $eno);
		}elsif($act == 5){
			# 送金
			$log[$eno] .= "<BR>\n";
			$log[$eno] .= "◆送金<BR>\n";
			&send_money($act_spe, $eno);
		}elsif($act == 6){
			# 売却
			$log[$eno] .= "<BR>\n";
			$log[$eno] .= "◆売却<BR>\n";
			&sell($act_spe, $eno);
		}elsif($act == 7){
			# 購入
			$log[$eno] .= "<BR>\n";
			$log[$eno] .= "◆購入<BR>\n";
			&buy($act_spe, $eno);
		}elsif($act == 8){
			# 作製
			my @assem = split(/：/, $act_spe);
			if ($assem[4]){
				$log[$eno] .= "<BR>\n";
				$log[$eno] .= "◆作製<BR>\n";
			}
			my $act_spe_messe = $action[$eno][9];
			&partsbuild($act_spe, $act_spe_messe, $eno);
		}
		elsif($act == 9){
			# 欠番
		}
		elsif($act == 10){
			# アセンブル
			$log[$eno] .= "<BR>\n";
			$log[$eno] .= "◆アセンブル<BR>\n";
			&assemble($act_spe, $eno);
		}elsif($act == 11){
			# オプション
			$log[$eno] .= "<BR>\n";
			$log[$eno] .= "◆オプション<BR>\n";
			&asse_op($act_spe, $eno);
		}
		
		elsif($act == 12){
			# NPC指定
			# unless($act_spe){next;}
			$log[$eno] .= "<BR>\n";
			$log[$eno] .= "◆結成<BR>\n";
			$act_spe += 0;
			if($act_spe >= 10000 && $act_spe < 10005){
				my $order = 10033;
				if($act_spe == 10004){$order = 10037;}
				elsif($act_spe == 10001){$order = 10034;}
				elsif($act_spe == 10002){$order = 10035;}
				elsif($act_spe == 10003){$order = 10036;}
				else{$order = 10033;}
				$log[$eno] .= "NPCとパーティーを組む要請をしました<BR>\n";
				$chara_list[$eno][21] = $order;
			}
			elsif($act_spe < 1){
				next;
			}
			else{
				my $name = $chara_list[$act_spe][1];
				unless($name){next;}
				$log[$eno] .= $name . "とパーティーを組む要請をしました<BR>\n";
				$chara_list[$eno][21] = $act_spe;
			}
		}
		elsif($act == 13){
			# 危険度
			$chara_list[$eno][22] = $act_spe;
		}
		elsif($act == 15){
			# 広域メッセ
			$mass_messe[$eno] = $act_spe;
		}
		elsif($act == 16){
			# 改名
			$log[$eno] .= "<BR>\n";
			$log[$eno] .= "◆アイテム改名<BR>\n";
			my $limit = $chara_list[$eno][23];
			if($limit < 2){
				$log[$eno] .= "NPがありません<BR>\n";
				next;
			}
			
			my $loss_np = &parts_rename($act_spe, $eno);
			if($loss_np){
				$chara_list[$eno][23] -= 2;
			}
			
		}
		elsif($act_spe eq "sakujo"){
			$sakujo[$eno] += 1;
		}
	}
	
	sleep 1;
    
	print "act" . $act . " end<br>\n";
	
}

# 新規登録
&new_entry;

# マッチング
&matching;
print "matching end<br>\n";

# 対人マッチング
&man_matching;
print "man_matching end<br>\n";

# ゲームデータ
&game_data(\@mass_messe);
print "game data end<br>\n";

# カタログ処理
print "<p>catalog start</p>";

&data_sort;
print "<p>data sort end</p>";
sleep 1;

&page_output_all;
print "<p>output end</p>";
&tsv_output;
print "<p>tsv end</p>";

print "<p>PROSESS-IS-OVER</p>";
print "<br><br><br>\n";
print "<br><br><br>\n";
print "<br><br><br>\n";
print "</body></html>\n";

exit 0;
