# tsvデータを扱う
# 新規登録者データはnew_entryにて
# 継続データはload_actionにて


sub load_data{
	use utf8;
	# 継続データ読み込み
	@keizoku_list = &load( "../log_keizoku.cgi" );
	@sinki_list = &load( "../log_sinki.cgi" );
	
	# パーツリスト読み込み
	@parts_list = &load( "../SYS_DATA/PARTS_DATA.tsv");
	@parts_palam_list = &load( "../SYS_DATA/PARTS_BASE.tsv");
	@enemy_parts_list = &load( "../SYS_DATA/PARTS_ENEMY.tsv");
	@catalog_parts_list = &load( "../SYS_DATA/CATALOG_DATA.tsv");
	
	# 素材パーツ読み込み
	# &get_optinlist;
	@option_data_list = &load( "../SYS_DATA/OPTION_DATA.tsv");
	@option_base_list = &load( "../SYS_DATA/OPTION_BASE.tsv");
	
	# キャラデータ読み込み
	@chara_list = &load( "../SYS_DATA/CHARA_DATA.tsv");
	
	# ゲームデータ読み込み
	@game_data = &load( "../SYS_DATA/GAME_DATA.tsv");
	
	# 機体データ読み込み
	@machine_list = &load( "../SYS_DATA/MACHINE_DATA.tsv");
	
	# 所持品データ読み込み
	@item_list = &load( "../SYS_DATA/ITEM_DATA.tsv");
	
	# 装備チェック読み込み
	@equip_list = &load( "../SYS_DATA/EQUIP_CHECK.tsv");
	
	# マッチング
	@matching = &load( "../SYS_DATA/MATCHING.tsv");
	@man_matching = &load( "../SYS_DATA/MAN_MATCHING.tsv");
	
	# ミッション
	@mission_list = &load( "../SYS_DATA/MISSION.tsv");
	
	# 敵NPC
	@enemy_list = &load( "../SYS_DATA/ENEMY_DATA.tsv");
	
	# 敵NPCセリフ
	@npc_word_list = &load( "../SYS_DATA/ENEMY_WORD.tsv");
	
	# PCセリフ
	@word_list = &load( "../SYS_DATA/CHARA_WORD.tsv");
	
	# PCアイコン
	@icon_list = &load( "../SYS_DATA/ICON_DATA.tsv");
	
	# メッセ
	@messe_list = &load( "../log_messe.cgi");
	
	# 設定
	@setting_list =  &load( "../log_setting.cgi");
	@setting_man_list =  &load( "../log_setting_man.cgi");
	
	# 戦闘設定
	@battle_list = &load( "../log_battle.cgi");
	
}

sub save_data{
	use utf8;
	&save( '../SYS_RESULT/CHARA_DATA.tsv', @chara_list );
	&save( '../SYS_RESULT/GAME_DATA.tsv', @game_data );
	&save( '../SYS_RESULT/MACHINE_DATA.tsv', @machine_list );
	&save( '../SYS_RESULT/ITEM_DATA.tsv', @item_list );
	&save( '../SYS_RESULT/EQUIP_CHECK.tsv', @equip_list );
	&save( '../SYS_RESULT/MATCHING.tsv', @matching );
	&save( '../SYS_RESULT/MAN_MATCHING.tsv', @man_matching );
	&save( '../SYS_RESULT/CHARA_WORD.tsv', @word_list );
	&save( '../SYS_RESULT/ICON_DATA.tsv', @icon_list );
	&save( '../SYS_RESULT/MISSION.tsv', @mission_list );
	&save( '../SYS_RESULT/log_keizoku.cgi', @keizoku_db );
	&save( '../SYS_RESULT/PARTS_DATA.tsv',@parts_list );
	&save( '../SYS_RESULT/CATALOG_DATA.tsv', @new_parts_list );
}

sub load_action{
	use utf8;
	for my $ref( @keizoku_list ){
		my @keizoku = @{$ref};
		
		# パスチェック
		my $eno = &pass_check( @keizoku );
		if ($eno <= -1){next;}
		
		$action[$eno] = $ref;
		
	}
	
	# メッセ読み込み
	for my $ref( @messe_list ){
		my @m = @{$ref};
		
		# パスチェック
		my $eno = &pass_check( @m );
		if ($eno <= -1){next;}
		
		$messe[$eno] = $ref;
		
	}
	
	# 設定読み込み
	for my $ref( @setting_list ){
		my @s = @{$ref};
		
		# パスチェック
		my $eno = &pass_check( @s );
		if ($eno <= -1){next;}
		
		$setting[$eno] = $ref;
		
	}
	
	# 対人セリフ読み込み
	for my $ref( @setting_man_list ){
		my @s = @{$ref};
		
		# パスチェック
		my $eno = &pass_check( @s );
		if ($eno <= -1){next;}
		
		$setting_man[$eno] = $ref;
		
	}
	
	# 戦闘設定読み込み
	for my $ref( @battle_list ){
		my @b = @{$ref};
		
		# パスチェック
		my $eno = &pass_check( @b );
		if ($eno <= -1){next;}
		
		$battle_action[$eno] = $ref;
	}
	
}

sub pass_check{
	use utf8;
	my $ans = -1;
	my $pass = $_[1];
	my $eno = $_[0] + 0;
	
	my $data_pass = ${$chara_list[$eno]}[20];
	
	if ($pass eq $data_pass){
		$ans = $eno;
	}
	
	return $ans;
}

sub get_optinlist{
	use utf8;
	my $id = 0;
	
	for (my $i=0; $i<1000; $i++){
		my $type = $parts_list[$i][2];
		if ($type =~ /OP/){
			$option_list[$id] = $parts_list[$i];
			$id++;
		}
	}
	
}



1;
