# メッセ・セリフ関連

sub words{
	use utf8;
	my $type = shift;
	my $talker = shift;
	my $eno = shift;
	my $pvp = shift;
	
	my $id = -1;
	if ($type eq "開始時"){
		$id = 0;
	} elsif ($type eq "終了時"){
		$id = 1;
	} elsif ($type eq "敵撃墜時"){
		$id = 2;
	} elsif ($type eq "被撃墜時"){
		$id = 3;
	} elsif ($type =~ /パーツ/){
		if ($type =~ /1/){$id = 4;}
		elsif ($type =~ /2/){$id = 5;}
		elsif ($type =~ /3/){$id = 6;}
		elsif ($type =~ /4/){$id = 7;}
		elsif ($type =~ /5/){$id = 8;}
		elsif ($type =~ /6/){$id = 9;}
		elsif ($type =~ /7/){$id = 10;}
		elsif ($type =~ /8/){$id = 11;}
		elsif ($type =~ /9/){$id = 12;}
		elsif ($type =~ /X/){$id = 13;}
		else {$id = 13;}
	} elsif ($type =~ /最大火力/){
		$id = 14;
	} elsif ($type eq "指定"){
		$id = 15;
	} elsif ($type eq "旋回"){
		my $dice = int(rand 3);
		if ($dice > 0){return 0;}
		$id = 16;
	} elsif ($type eq "跳躍"){
		my $dice = int(rand 3);
		if ($dice > 0){return 0;}
		$id = 17;
	} elsif ($type eq "霧"){
		$id = 18;
	} elsif ($type eq "索敵失敗"){
		my $dice = int(rand 3);
		if ($dice > 0){return 0;}
		$id = 19;
	} elsif ($type eq "援護行動"){
		my $dice = int(rand 3);
		###if ($dice > 0){return 0;}
		$id = 20;
	} elsif ($type eq "通信行動"){
		my $dice = int(rand 3);
		### if ($dice > 0){return 0;}
		$id = 21;
	}
	
	if ($id < 0){return 0;}
	
	if ($talker >= 10000){
		my $npc = $talker - 10000;
		my $word = $npc_word_list[$npc][$id];
		unless($word){return 0;}
		my $icon = $enemy_list[$npc][26];
		my $name = $enemy_list[$npc][1];
		unless($icon){$icon = "../Pic/noimgicon.jpg";}
		$log_b[$eno] .= '<p><img src="' . $icon . '" align="left">' . $name . "「" . $word . "」</p><BR><BR>\n";
		return 1;
	} elsif ($talker > 0){
		my $word = ();
		unless ($pvp){
			$word = $word_list[$talker][$id];
		}else{
			$word = $word_man_list[$talker][$id];
		}
		unless($word){return 0;}
		if ($word =~ /###/){
			my @temp_word = split(/###/, $word);
			my $num = @temp_word;
			$num = int(rand $num);
			$word = $temp_word[$num];
		}
		$str = &icon_set($word, $talker);
		$log_b[$eno] .= $str;
		return 1;
	}
	
	
}


# メッセ

sub messe {
	use utf8;
	my $eno = shift;
	my $messe_now = -1;
	
	for (my $i=2; $i<32; $i++){
		
		my $str = $messe[$eno][$i];
		
		unless($str){next;}
		
		my $word = $str;
		
		if ($word =~ /(.+?：)/){
			my $delto = $1;
			
			my $to = $1 + 0;
			
			if ($to != $messe_now){
				
				my $a = int($eno / 1000);
				my $b = $eno % 1000;
				my $c = int($b / 100);
				my $d = $b % 100;
				my $e = int($d / 10);
				my $f = $d % 10;
				
				
				$log[$to] .= '<A href="c' . "$a$c$e$f" . '.html">' . 'ENo.'. $eno . 'からのメッセージ>>' . "</A><BR>\n";
				
				$a = int($to / 1000);
				$b = $to % 1000;
				$c = int($b / 100);
				$d = $b % 100;
				$e = int($d / 10);
				$f = $d % 10;
				
				$log_to[$eno] .= '<A href="c' . "$a$c$e$f" . '.html">' . '>>Eno.' . $to . "</A>　";
				
				$messe_now = $to;
			}
			
			$str =~ s/$delto//;
			
			
			$str = &icon_set($str, $eno);
			
			$log[$to] .= $str;
			
		}
		
	}
	
}

# 設定

sub setting_set {
	use utf8;
	
	my $eno = shift;
	
	
	for (my $i=2; $i<35; $i++){
		
		my $str = $setting[$eno][$i];
		my $str_man = $setting_man[$eno][$i];
		
		unless($str){next;}
		
		my $word = $str;
		
		if ($i < 24){
			my $id = $i - 2;
			if ($str eq "sakujo"){
				$word_list[$eno][$id] = "";
				next;
			}
			
			$word_list[$eno][$id] = $str;
			
			if ($str_man eq "sakujo"){
				$word_man_list[$eno][$id] = "";
				next;
			}
			
			$word_man_list[$eno][$id] = $str_man;
			
		}
		elsif ($i == 24){
			if ($str eq "sakujo"){
				$chara_list[$eno][8] = "";
				next;
			}
			
			$chara_list[$eno][8] = $str;
		}
		elsif ($i == 25){
			my @icon = split(/：/, $str);
			
			for (my $id=0; $id<12; $id++){
				
				unless ($icon[$id]){next;}
				
				if ($icon[$id] eq "sakujo"){
					$icon_list[$eno][$id] = "";
				}
				
				$icon_list[$eno][$id] = $icon[$id];
			}
			
		}
		elsif ($i == 26){
			my $a = length( $str );
			if (30 < $a){
				$str = substr($str, 0, 30);
			}
			$chara_list[$eno][2] = $str;
		}
		elsif ($i == 27){
			my $a = length( $str );
			if (30 < $a){
				$str = substr($str, 0, 30);
			}
			$machine_list[$eno][1] = $str;
		}
		elsif ($i == 28){
			my $a = length( $str );
			if (1000 < $a){
				$str = substr($str, 0, 1000);
			}
			$str = &tagdell($str);
			$chara_list[$eno][5] = $str;
		}
		elsif ($i == 29){
			$chara_list[$eno][6] = $str;
		}
		elsif ($i == 30){
			$chara_list[$eno][7] = $str;
		}
		elsif ($i == 31){
			my $a = length( $str );
			if (30 < $a){
				$str = substr($str, 0, 30);
			}
			$chara_list[$eno][20] = $str;
		}
		elsif ($i == 32){
			my $a = length( $str );
			if (30 < $a){
				$str = substr($str, 0, 30);
			}
			$chara_list[$eno][3] = $str;
		}
		elsif ($i == 33){
			my $a = length( $str );
			if (30 < $a){
				$str = substr($str, 0, 30);
			}
			$chara_list[$eno][4] = $str;
		}
		elsif ($i == 34){
			$chara_list[$eno][24] = $str;
		}
	}
	
}



# アイコン
sub icon_set {
	use utf8;
	
	my $str = shift;
	my $eno = shift;
	
	my $icon = $chara_list[$eno][8];
	my $name = $chara_list[$eno][2];
	unless($icon){$icon = "../Pic/noimgicon.jpg";}
	
	
	my $icon = $chara_list[$eno][8];
	my $name = $chara_list[$eno][2];
	my $word = $str;
	my $only_str = 0;
	
	if ($word =~ /^@@@/){
		$str =~ s/^@@@//;
		$word =~ s/^@@@//;
		$name = "";
		$only_str = 1;
	}
	elsif ($word =~ /^@/){
		my @temp_word = split(/@/, $str);
		my $name_temp = $temp_word[1];
		$name_temp =~ s/\?/？/g;
		my $temp_del = "@" . $name_temp . "@";
		if ($word =~ /^$temp_del/){
			# print "$temp_del temp_del";
			$str =~ s/$temp_del//;
			$word =~ s/$temp_del//;
			$name = $name_temp;
		}
	}
	
	for (my $i=0; $i<12; $i++){
		my $set = "/$i/";
		if ($word =~ /^$set/){
			
			$str =~ s/^$set//;
			
			$icon = $icon_list[$eno][$i];
			unless($icon){$icon = "../Pic/noimgicon.jpg";}
			
			last;
		}
	}
	
	unless($icon){$icon = "../Pic/noimgicon.jpg";}
	
	$name = '<SPAN class="messe"><img src="' . $icon . '" align="left" width="60" height="60">' . $name;
	
	$str = &tagdell($str);
	
	unless ($only_str){
		$str = $name . "「"  . $str . "」</SPAN><BR CLEAR=ALL>\n";
	}
	else{
		$str = $name . $str . "</SPAN><BR CLEAR=ALL>\n";
	}
	return $str;
	
}

# リストアイコン
sub list_icon_set {
	use utf8;
	
	my $str = shift;
	my $eno = shift;
	
	my $icon = $chara_list[$eno][8];
	my $name = $chara_list[$eno][2];
	unless($icon){$icon = "Pic/noimgicon.jpg";}
	
	
	my $icon = $chara_list[$eno][8];
	my $name = $chara_list[$eno][2];
	my $word = $str;
	my $only_str = 0;
	
	if ($word =~ /^@@@/){
		$str =~ s/^@@@//;
		$word =~ s/^@@@//;
		$name = "";
		$only_str = 1;
	}
	elsif ($word =~ /^@/){
		my @temp_word = split(/@/, $str);
		my $name_temp = $temp_word[1];
		$name_temp =~ s/\?/？/g;
		$temp_del = "@" . $name_temp . "@";
		if ($word =~ /^$temp_del/){
			# print "$temp_del temp_del";
			$str =~ s/$temp_del//;
			$word =~ s/$temp_del//;
			$name = $name_temp;
		}
	}
	
	for (my $i=0; $i<12; $i++){
		my $set = "/$i/";
		if ($word =~ /^$set/){
			
			$str =~ s/^$set//;
			
			$icon = $icon_list[$eno][$i];
			unless($icon){$icon = "Pic/noimgicon.jpg";}
			
			last;
		}
	
	}
	
	unless($icon){$icon = "Pic/noimgicon.jpg";}
	
	$name = '<SPAN class="messe"><img src="' . $icon . '" align="left" width="60" height="60">' . $name;
	
	$str = &tagdell($str);
	
	unless ($only_str){
		$str = $name . "「"  . $str . "」</SPAN><BR CLEAR=ALL>\n";
	}
	else{
		$str = $name . $str . "</SPAN><BR CLEAR=ALL>\n";
	}
	return $str;
	
}

sub mission_word{
	use utf8;
	
	my $eno = shift;
	my $tell = shift;
	my $mission = shift;
	my $order = shift;
	my $op_set = shift;
	
	my $icon = "../Pic/noimgicon.jpg";
	if($op_set == 0){
		$icon = "../Pic/op_icon02.jpg";
	} elsif($op_set == 1){
		$icon = "../Pic/op_icon00.jpg";
	} elsif($op_set == 2){
		$icon = "../Pic/op_icon03.png";
	} elsif($op_set == 3){
		$icon = "../Pic/op_icon04.png";
	} elsif($op_set == 4){
		$icon = "../Pic/op_icon13.jpg";
	} elsif($op_set == 5){
		$icon = "../Pic/op_icon06.jpg";
	} elsif($op_set == 6){
		$icon = "../Pic/op_icon11.jpg";
	} elsif($op_set == 7){
		$icon = "../Pic/op_icon10.jpg";
	} elsif($op_set == 8){
		$icon = "../Pic/op_icon15.jpg";
	} elsif($op_set == 9){
		$icon = "../Pic/op_icon16.png";
	} elsif($op_set == 10){
		$icon = "../Pic/op_icon18.png";
	}
	
	if($tell == 5){
		$icon = "../Pic/op_icon09.jpg";
	}
	elsif($tell == 6){
		$icon = "../Pic/op_icon14.jpg";
	}
	
	if($order eq "目標"){
		if($mission == 1){
			if($tell == 0){
				$log[$eno] .= "不法武装組織排除<BR>\n";
			}
			elsif($tell == 1){
				$log[$eno] .= "テロリスト殲滅<BR>\n";
			}
			elsif($tell == 2){
				$log[$eno] .= "敵対組織攻撃<BR>\n";
			}
			elsif($tell == 3){
				$log[$eno] .= "紛争地帯派遣<BR>\n";
			}
			elsif($tell == 4){
				$log[$eno] .= "反乱組織鎮圧<BR>\n";
			}
			elsif($tell == 5){
				$log[$eno] .= "警備部隊排除<BR>\n";
			}
			elsif($tell == 6){
				$log[$eno] .= "バイオ兵器殲滅<BR>\n";
			}
		}
		elsif($mission == 2){
			if($tell == 0){
				$log[$eno] .= "戦略的地形調査<BR>\n";
			}
			elsif($tell == 1){
				$log[$eno] .= "武装サーバーハッキング<BR>\n";
			}
			elsif($tell == 2){
				$log[$eno] .= "敵情勢調査<BR>\n";
			}
			elsif($tell == 3){
				$log[$eno] .= "敵内部侵入<BR>\n";
			}
			elsif($tell == 4){
				$log[$eno] .= "威力偵察<BR>\n";
			}
			elsif($tell == 5){
				$log[$eno] .= "研究データ強奪<BR>\n";
			}
			elsif($tell == 6){
				$log[$eno] .= "バイオ兵器調査<BR>\n";
			}
		}
		elsif($mission == 3){
			if($tell == 0){
				$log[$eno] .= "高射砲塔破壊<BR>\n";
			}
			elsif($tell == 1){
				$log[$eno] .= "要塞破壊<BR>\n";
			}
			elsif($tell == 2){
				$log[$eno] .= "ミサイル基地破壊<BR>\n";
			}
			elsif($tell == 3){
				$log[$eno] .= "輸送船破壊<BR>\n";
			}
			elsif($tell == 4){
				$log[$eno] .= "軍需工場破壊<BR>\n";
			}
			elsif($tell == 5){
				$log[$eno] .= "培養槽破壊<BR>\n";
			}
			elsif($tell == 6){
				$log[$eno] .= "巨大卵破壊<BR>\n";
			}
		}
		elsif($mission == 4){
			if($tell == 0){
				$log[$eno] .= "高射砲塔防衛<BR>\n";
			}
			elsif($tell == 1){
				$log[$eno] .= "要塞防衛<BR>\n";
			}
			elsif($tell == 2){
				$log[$eno] .= "ミサイル基地防衛<BR>\n";
			}
			elsif($tell == 3){
				$log[$eno] .= "輸送船護衛<BR>\n";
			}
			elsif($tell == 4){
				$log[$eno] .= "軍需工場防衛<BR>\n";
			}
			elsif($tell == 5){
				$log[$eno] .= "工作部隊撤退援護<BR>\n";
			}
			elsif($tell == 6){
				$log[$eno] .= "市街地防衛<BR>\n";
			}
		}
		elsif($mission == 5){
			if($tell == 0){
				$log[$eno] .= "市街地強襲<BR>\n";
			}
			elsif($tell == 1){
				$log[$eno] .= "補給基地強襲<BR>\n";
			}
			elsif($tell == 2){
				$log[$eno] .= "基地建設妨害<BR>\n";
			}
			elsif($tell == 3){
				$log[$eno] .= "補給線強襲<BR>\n";
			}
			elsif($tell == 4){
				$log[$eno] .= "軍需工場強襲<BR>\n";
			}
			elsif($tell == 5){
				$log[$eno] .= "研究施設強襲<BR>\n";
			}
			elsif($tell == 6){
				$log[$eno] .= "バイオ卵破壊<BR>\n";
			}
		}
	}
	elsif($order eq "作戦開始"){
		my $name = '<p class="messe"><img src="' . $icon . '" align="left" width="60" height="60">オペレーター';
		my $str = "";
		if($mission == 1){
			if($tell == 0){
				if($op_set == 0){
					$str .= "不法武装組織排除です。余計な力を持って……いけませんね";
				} elsif($op_set == 1){
					$str .= "不法武装組織排除だ。兵器の横流しが多々あるのはなんとかならないものか。パワーバランスが壊れないよう適度に痛めつけてやれ";
				} elsif($op_set == 2){
					$str .= "ブソウ　ソシキ　ハイジョ　ハイジョ";
				} elsif($op_set == 3){
					$str .= "不法武装組織排除だぜ。全員に鉛玉のプレゼントだ！";
				} elsif($op_set == 4){
					$str .= "武装組織が秘密裏に結成されているようです。これを殲滅してください";
				} elsif($op_set == 5){
					$str .= "不法武装組織を排除してください。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワンワワンワン！　バウッ！　バウッ！";
				} elsif($op_set == 7){
					$str .= "生意気な奴らがたむろしてるの！　懲らしめてやってよね！";
				} elsif($op_set == 8){
					$str .= "不信心者たちを打ちのめしてください。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "不法武装組織排除よ。敵を全滅させること。以上";
				} elsif($op_set == 10){
					$str .= "フッフゥ～生意気な奴らを殲滅だよぉ～";
				}
			}
			
			elsif($tell == 1){
				if($op_set == 0){
					$str .= "テロリスト殲滅です。御武運を";
				} elsif($op_set == 1){
					$str .= "テロリスト殲滅だ。気をつけろよ";
				} elsif($op_set == 2){
					$str .= "テロリスト　センメツ　センメツ";
				} elsif($op_set == 3){
					$str .= "テロリスト殲滅だ。パーティの始まりだぜ";
				} elsif($op_set == 4){
					$str .= "テロリストの所在が掴めました。武装しているとのことです";
				} elsif($op_set == 5){
					$str .= "テロリストを撃滅してください。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワン！　ワンワワン！";
				} elsif($op_set == 7){
					$str .= "テロリストのアジトの座標を送るわ！！　褒めなさいよね！！";
				} elsif($op_set == 8){
					$str .= "テロ組織の殲滅を行います。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "テロリスト無力化よ。敵を全滅させること。以上";
				} elsif($op_set == 10){
					$str .= "ハァ～テロリストがいっぱいいるねぇ～";
				}
			}
			elsif($tell == 2){
				if($op_set == 0){
					$str .= "敵対組織攻撃です。よくある組織同士の小競り合いですね。お金の元です";
				} elsif($op_set == 1){
					$str .= "敵対組織攻撃だ。組織の抗争はいい収入源だ";
				} elsif($op_set == 2){
					$str .= "テキ　ソシキ　コウゲキ";
				} elsif($op_set == 3){
					$str .= "敵対組織の小競り合いだ。小遣い稼ぎに丁度いいぜ";
				} elsif($op_set == 4){
					$str .= "敵対組織を攻撃してください。パワーバランスの均衡が取れるように……";
				} elsif($op_set == 5){
					$str .= "組織抗争に介入します。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ガルルルルル";
				} elsif($op_set == 7){
					$str .= "組織同士の代理戦争よ！！　何も考えず戦えばいいのよ！！";
				} elsif($op_set == 8){
					$str .= "敵対組織に攻撃をします。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "組織同士の前哨戦ね。敵を全滅させること。以上";
				} elsif($op_set == 10){
					$str .= "フッフゥ～組織同士の武力衝突だよぉ。頑張って敵を倒してねェ";
				}
			}
			elsif($tell == 3){
				if($op_set == 0){
					$str .= "紛争地帯派遣です。争いは尽きぬもの……静かになってもらいましょうか";
				} elsif($op_set == 1){
					$str .= "紛争地帯派遣だ。余計な介入かもしれんがな。しばらく黙ってもらおう";
				} elsif($op_set == 2){
					$str .= "フンソウ　チンアツ";
				} elsif($op_set == 3){
					$str .= "ここらはホットな場所でな……フィーバーしようぜ";
				} elsif($op_set == 4){
					$str .= "紛争地帯に介入します。流れ弾に注意してくださいね";
				} elsif($op_set == 5){
					$str .= "紛争地帯にあなたを派遣します。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワワンワン！　ワンワン！";
				} elsif($op_set == 7){
					$str .= "紛争地帯に武力介入よ！！　ボコボコにしてきなさい！！";
				} elsif($op_set == 8){
					$str .= "紛争地帯の争いを止めさせます。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "紛争地帯の兵器を無力化させてね。敵を全滅させること。以上";
				} elsif($op_set == 10){
					$str .= "フォゥ～紛争地帯はドンパチが尽きないねェ～";
				}
			}
			elsif($tell == 4){
				if($op_set == 0){
					$str .= "反体制組織鎮圧です。力を持つと余計なことを考えたりするものですね。片づけちゃいましょう";
				} elsif($op_set == 1){
					$str .= "反体制組織鎮圧だ。敵はそれなりに武装している。気をつけろよ";
				} elsif($op_set == 2){
					$str .= "コロセ　コロセ";
				} elsif($op_set == 3){
					$str .= "反体制組織がいきがってるようだぜ。おもてなししてあげな！";
				} elsif($op_set == 4){
					$str .= "反体制組織に打撃を与えます。この駐屯地を攻撃してください";
				} elsif($op_set == 5){
					$str .= "反体制組織を鎮圧します。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "クゥ～ン、クゥ～ン";
				} elsif($op_set == 7){
					$str .= "反体制組織が結集しているわ！！　全力で攻撃しなさいよね！！";
				} elsif($op_set == 8){
					$str .= "反体制組織を粛清します。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "反体制組織のアジトを発見したわ。敵を全滅させること。以上";
				} elsif($op_set == 10){
					$str .= "ホッホ！こんなところに隠れていたんだねぇ～";
				}
			}
			elsif($tell == 5){
				$str .= "研究施設の警備部隊を全機破壊し、作戦を優位に進めてください";
			}
			elsif($tell == 6){
				$str .= "バイオ兵器の群れが発見されました。すべて破壊してください";
			}
		}
		elsif($mission == 2){
			if($tell == 0){
				if($op_set == 0){
					$str .= "戦略的地形調査です。この残像領域はまだまだ調査が終わっていないんです";
				} elsif($op_set == 1){
					$str .= "戦略的地形調査だ。この残像領域はまだ全容が解明していない。どこまで広いのか、何があるのか……";
				} elsif($op_set == 2){
					$str .= "チケイ　チョウサ　ヨロシク";
				} elsif($op_set == 3){
					$str .= "地形調査を行うぜ。この地域の謎を解かないとな";
				} elsif($op_set == 4){
					$str .= "地形調査を行ってください。レーダーは積んできたでしょうね？";
				} elsif($op_set == 5){
					$str .= "地形調査を行います。レーダーの準備はいいですか？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワン！　ワンワン！";
				} elsif($op_set == 7){
					$str .= "未踏破地域の調査を行うわ！！　邪魔者は殺していいわよ！！";
				} elsif($op_set == 8){
					$str .= "地形調査を行います。邪魔者は排除してかまいません。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "複数の企業が邪魔をしてもかまいません。レーダーで地形を調査して。以上";
				} elsif($op_set == 10){
					$str .= "ピクニックだよぉ～。山へ登ってランチをたべようねぇ～";
				}
			}
			elsif($tell == 1){
				if($op_set == 0){
					$str .= "武装サーバーハッキングです。よほど重要なデータがあるんでしょうね。我々は手伝いをするだけですが";
				} elsif($op_set == 1){
					$str .= "武装サーバーハッキングだ。護衛の者は排除して構わん";
				} elsif($op_set == 2){
					$str .= "ハッキング　カイシ　カイシ";
				} elsif($op_set == 3){
					$str .= "恥ずかしいデータを頂戴してやろうぜ";
				} elsif($op_set == 4){
					$str .= "攻撃と同時にハッキングを行います。死なないでくださいね";
				} elsif($op_set == 5){
					$str .= "戦闘の混乱に乗じて電波ジャックを行います。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワオーン";
				} elsif($op_set == 7){
					$str .= "サーバーハッキングよ！！　護衛部隊にやられたら許さないわ！！";
				} elsif($op_set == 8){
					$str .= "ハッキングで情報を奪います。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "武装サーバーハッキングよ。必要な情報を収集すること。以上";
				} elsif($op_set == 10){
					$str .= "ハッキングはこちらで行うよぉ。回線の支配権を奪ってねェ～";
				}
			}
			elsif($tell == 2){
				if($op_set == 0){
					$str .= "敵情勢調査です。ま、敵が邪魔だったら消していいですよ";
				} elsif($op_set == 1){
					$str .= "敵情勢調査だ。見つかったら鉛弾で応えてやれ";
				} elsif($op_set == 2){
					$str .= "テキ　チョウサ　カイシ　カイシ";
				} elsif($op_set == 3){
					$str .= "さぁ、御挨拶だ！";
				} elsif($op_set == 4){
					$str .= "敵の情勢を調査します。見つかったら消してもかまいません";
				} elsif($op_set == 5){
					$str .= "敵情勢を調査してください。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワッフゥ";
				} elsif($op_set == 7){
					$str .= "敵対組織の情報を入手するわ！！　ついでに敵を倒してくれたらボーナスよ！！";
				} elsif($op_set == 8){
					$str .= "敵対組織の情報を収集してください。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "敵情勢調査よ。必要な情報を収集すること。以上";
				} elsif($op_set == 10){
					$str .= "ヘッヘ、敵組織をちょっと覗いてくるだけさぁ";
				}
			}
			elsif($tell == 3){
				if($op_set == 0){
					$str .= "敵内部侵入です。組織同士探りあいの蛇の巣ですねぇ";
				} elsif($op_set == 1){
					$str .= "敵内部侵入だ。護衛の敵に注意しろ";
				} elsif($op_set == 2){
					$str .= "シンニュウ　サクセン　カイシ";
				} elsif($op_set == 3){
					$str .= "敵内部侵入だ。女の寝室に入るより簡単だぜ";
				} elsif($op_set == 4){
					$str .= "敵内部に侵入します。それなりの戦いも起こるでしょう。注意してください";
				} elsif($op_set == 5){
					$str .= "敵内部に侵入し情報を確保します。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワワワン！　ワンワン！　ワン！";
				} elsif($op_set == 7){
					$str .= "基地に侵入するわ！！　護衛に注意して！！";
				} elsif($op_set == 8){
					$str .= "敵基地に潜入します。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "敵内部侵入よ。必要な情報を収集すること。以上";
				} elsif($op_set == 10){
					$str .= "見つかったら……殺すんだよぉ";
				}
			}
			elsif($tell == 4){
				if($op_set == 0){
					$str .= "威力偵察です。倒した分はボーナスになるので頑張ってくださいね";
				} elsif($op_set == 1){
					$str .= "威力偵察だな。倒した分はボーナスだ。頑張れよ";
				} elsif($op_set == 2){
					$str .= "テイサツ　カイシ　カイシ";
				} elsif($op_set == 3){
					$str .= "偵察？　全部倒せばいいのさ";
				} elsif($op_set == 4){
					$str .= "目的は偵察です。敵を倒せばいいお小遣いですね";
				} elsif($op_set == 5){
					$str .= "偵察を行います。簡単な仕事ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワン！　ワワン！　ワワワン！";
				} elsif($op_set == 7){
					$str .= "基地に強襲をかけて情報を得るわ！！　負けないでね！！";
				} elsif($op_set == 8){
					$str .= "軍事境界線でゲリラ戦を仕掛けます。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "威力偵察よ。必要な情報を収集すること。以上";
				} elsif($op_set == 10){
					$str .= "ファア、敵の様子を……チラッと、チラッと見るんだ";
				}
			}
			elsif($tell == 5){
				$str .= "施設に侵入して研究データを強奪してください。敵勢力の抵抗に注意です";
			}
			elsif($tell == 6){
				$str .= "バイオ兵器のデータを収集してください。彼らは驚異的なスピードで進化し始めています";
			}
		}
		elsif($mission == 3){
			if($tell == 0){
				if($op_set == 0){
					$str .= "高射砲塔破壊です。この地域の制空権の防衛ラインですね。ボコボコにしちゃいましょう";
				} elsif($op_set == 1){
					$str .= "高射砲塔破壊だ。航空機の進入ラインを確保してくれ";
				} elsif($op_set == 2){
					$str .= "ホウトウ　ハカイ　ハカイ";
				} elsif($op_set == 3){
					$str .= "パーティーの始まりだ！";
				} elsif($op_set == 4){
					$str .= "高射砲塔を破壊してください";
				} elsif($op_set == 5){
					$str .= "高射砲塔を破壊します。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワフォォーン";
				} elsif($op_set == 7){
					$str .= "高射砲塔が航空機の運航を妨げているわ！！　破壊して！！";
				} elsif($op_set == 8){
					$str .= "前線基地の高射砲塔を破壊し航空機の進入路を確保してください。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "高射砲塔破壊よ。目標のみを破壊すること。以上";
				} elsif($op_set == 10){
					$str .= "ヘッヘェ～フゥ～";
				}
			}
			elsif($tell == 1){
				if($op_set == 0){
					$str .= "要塞破壊です。地上の守りもWHの手にかかればどうでしょう？";
				} elsif($op_set == 1){
					$str .= "要塞破壊だ。守りは硬いが……お前ならばどうだろうな？";
				} elsif($op_set == 2){
					$str .= "ヨウサイ　ハカイ　ヨロシク";
				} elsif($op_set == 3){
					$str .= "お堅い野郎は嫌われるぜ？　ハハッ";
				} elsif($op_set == 4){
					$str .= "敵要塞を無力化します。かなり硬いので注意を";
				} elsif($op_set == 5){
					$str .= "要塞を攻略します。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "Zzzz……";
				} elsif($op_set == 7){
					$str .= "要塞に守られた基地への攻撃よ！！　がんばって！！";
				} elsif($op_set == 8){
					$str .= "要塞の防壁を破壊して地上部隊の侵入をサポートしてください。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "要塞破壊よ。目標のみを破壊すること。以上";
				} elsif($op_set == 10){
					$str .= "ヘッヘェ～要塞を～なんだっけナァ～";
				}
			}
			elsif($tell == 2){
				if($op_set == 0){
					$str .= "ミサイル基地破壊です。昔の物なので使えるかどうか分かりませんが、仕事ですので";
				} elsif($op_set == 1){
					$str .= "ミサイル基地破壊だ。昔のものだ、動くかは分からんが……無い方がいい";
				} elsif($op_set == 2){
					$str .= "ミサイル　キチ　ハカイ";
				} elsif($op_set == 3){
					$str .= "自慢のミサイルをへし折ってやれ！";
				} elsif($op_set == 4){
					$str .= "ミサイル基地を破壊します。誘爆の心配はありません";
				} elsif($op_set == 5){
					$str .= "ミサイル基地に打撃を与えます。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ハッハッハッハッ";
				} elsif($op_set == 7){
					$str .= "大型ミサイルを基地を破壊して！！　こんな基地がまだいっぱいあるのよ！！";
				} elsif($op_set == 8){
					$str .= "ミサイル基地の進路を確保しました。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "ミサイル基地を無力化して。目標のみを破壊すること。以上";
				} elsif($op_set == 10){
					$str .= "ハァン、ミサイルを壊すんだ。爆薬を忘れるなぁヨ";
				}
			}
			elsif($tell == 3){
				if($op_set == 0){
					$str .= "輸送船破壊です。いわゆる大型浮遊輸送艦ですね。残骸は他の者が担当するので気にしないで結構";
				} elsif($op_set == 1){
					$str .= "輸送船破壊だ。大型浮遊輸送艦をマークした。残骸はこちらで回収する";
				} elsif($op_set == 2){
					$str .= "ユソウセン　ハカイ　……シネ！";
				} elsif($op_set == 3){
					$str .= "大型浮遊輸送艦だ。鉛玉も運んでもらおうぜ";
				} elsif($op_set == 4){
					$str .= "大型浮遊輸送艦を破壊してください。いけないものを運んでますので";
				} elsif($op_set == 5){
					$str .= "大型浮遊輸送艦をマークしました。目標を破壊してください。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "Bow　Wow";
				} elsif($op_set == 7){
					$str .= "輸送船を襲撃して！！　積み荷は地上部隊が回収するわ！！";
				} elsif($op_set == 8){
					$str .= "大型浮遊輸送艦のエンジンを破壊してください。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "大型浮遊輸送艦を破壊して。目標のみを破壊すること。以上";
				} elsif($op_set == 10){
					$str .= "浮遊輸送艦は近寄ると風で飛ばされるんだ。死角や射撃を上手く使えよぉ～";
				}
			}
			elsif($tell == 4){
				if($op_set == 0){
					$str .= "軍需工場破壊です。ぽちぽち潰したところでタケノコのように湧いてくるんですが……ね";
				} elsif($op_set == 1){
					$str .= "軍需工場破壊だ。壊しても壊してもまたどこかで見つかるがな";
				} elsif($op_set == 2){
					$str .= "コウジョウ　ハカイ　ハカイ";
				} elsif($op_set == 3){
					$str .= "壊しちまおうぜ、派手にな！";
				} elsif($op_set == 4){
					$str .= "軍需工場を破壊します。必ず灰にしてきてくださいね";
				} elsif($op_set == 5){
					$str .= "軍需工場を破壊してください。今月のノルマがあるので。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワォーン！　ワンワン！";
				} elsif($op_set == 7){
					$str .= "地下軍需工場が見つかったわ！！　破壊して！！";
				} elsif($op_set == 8){
					$str .= "地下軍需工場へのルートを確保しました。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "軍需工場破壊よ。大型ジェネレータのみを破壊すること。以上";
				} elsif($op_set == 10){
					$str .= "軍需工場の大型ジェネレータを破壊するんだよぉ、爆発に巻き込まれないようになぁ、へっフゥ";
				}
			}
			elsif($tell == 5){
				$str .= "大型培養槽を破壊してください。溶液は危険ですので破壊後は速やかに撤退を";
			}
			elsif($tell == 6){
				$str .= "バイオクイーンの卵が発見されました。孵化すると爆発的に増殖します。必ず破壊を";
			}
		}
		elsif($mission == 4){
			if($tell == 0){
				if($op_set == 0){
					$str .= "高射砲塔防衛です。この地域の制空権の防衛ラインですね。侵入を妨害してください";
				} elsif($op_set == 1){
					$str .= "高射砲塔防衛だ。防衛ラインを死守しろ";
				} elsif($op_set == 2){
					$str .= "キョテン　ボウエイ";
				} elsif($op_set == 3){
					$str .= "砲台ちゃんが援護してくれてるうちに倒すんだ";
				} elsif($op_set == 4){
					$str .= "高射砲塔防衛です。いくつかの砲台が稼働しています";
				} elsif($op_set == 5){
					$str .= "高射砲塔を防衛して空襲を防いでください。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワワワン！　ワンワン！　ワォーン！";
				} elsif($op_set == 7){
					$str .= "高射砲塔を防衛するわ！！　砲台が援護するから守りきって！！";
				} elsif($op_set == 8){
					$str .= "最後まで防衛ラインを死守してください。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "高射砲塔防衛よ。防衛ラインを死守すること。以上";
				} elsif($op_set == 10){
					$str .= "逃げるなよぉ～逃げるなよぉ～";
				}
			}
			elsif($tell == 1){
				if($op_set == 0){
					$str .= "要塞防衛です。ネズミ一匹通してはいけませんよ";
				} elsif($op_set == 1){
					$str .= "要塞防衛だ。誰ひとり通してはいけないぞ";
				} elsif($op_set == 2){
					$str .= "ヨウサイ　ボウエイ";
				} elsif($op_set == 3){
					$str .= "敵は強いぞ、油断するな！";
				} elsif($op_set == 4){
					$str .= "要塞防衛です。ささやかながら支援があります";
				} elsif($op_set == 5){
					$str .= "要塞を防衛してください。砲台の支援があります。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "バフゥ、ワッフォ、ワン！";
				} elsif($op_set == 7){
					$str .= "要塞を防衛するわ！！　防衛設備があなたを援護するわ！！";
				} elsif($op_set == 8){
					$str .= "要塞の隔壁を死守してください。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "要塞防衛よ。防衛ラインを死守すること。以上";
				} elsif($op_set == 10){
					$str .= "砲台ちゃんはかわいいなぁ～";
				}
			}
			elsif($tell == 2){
				if($op_set == 0){
					$str .= "ミサイル基地防衛です。過去の遺産ってやつです。後生大事にしちゃって……あ、依頼主には秘密ですよ";
				} elsif($op_set == 1){
					$str .= "ミサイル基地防衛だ。戦略的に意味があるかは分からんが……もう随分昔のものだ";
				} elsif($op_set == 2){
					$str .= "ミサイル　ボウエイ";
				} elsif($op_set == 3){
					$str .= "大事なもんらしいがな、仕事は仕事だ！";
				} elsif($op_set == 4){
					$str .= "ミサイル基地防衛です。誰も通してはいけません";
				} elsif($op_set == 5){
					$str .= "ミサイル基地を防衛してください。爆発の心配はありませんが負けてはいけませんよ？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワワン！";
				} elsif($op_set == 7){
					$str .= "ミサイル基地を防衛するわ！！　エレベーターに敵を近づけないで！！";
				} elsif($op_set == 8){
					$str .= "敵の侵入を防いでください。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "敵本隊接近。防衛ラインを死守すること。以上";
				} elsif($op_set == 10){
					$str .= "地下ミサイル格納庫への隔壁は3つだよぉ、守りきれよぉ";
				}
			}
			elsif($tell == 3){
				if($op_set == 0){
					$str .= "輸送船護衛です。いわゆる大型浮遊輸送艦ですね。あなたたちが最終防衛ラインです";
				} elsif($op_set == 1){
					$str .= "輸送船護衛だ。大型浮遊輸送艦を死守してくれ";
				} elsif($op_set == 2){
					$str .= "ユソウセン　ゴエイ";
				} elsif($op_set == 3){
					$str .= "恋人だと思ってエスコートしてやろうぜ";
				} elsif($op_set == 4){
					$str .= "輸送船護衛です。あなたは戦っているだけでいいです";
				} elsif($op_set == 5){
					$str .= "大型浮遊輸送船の護衛です。輸送船の防衛砲台が援護射撃を行います。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "クゥ～ン、クゥ～ン";
				} elsif($op_set == 7){
					$str .= "輸送船を防衛するわ！！　船が離脱するまで敵を引きつけて！！";
				} elsif($op_set == 8){
					$str .= "大型浮遊輸送艦の離脱まで時間を稼いでください。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "輸送船護衛よ。防衛ラインを死守すること。以上";
				} elsif($op_set == 10){
					$str .= "輸送船の給油完了まで30分だよぉ～敵を引きつけておくんだよぉ～";
				}
			}
			elsif($tell == 4){
				if($op_set == 0){
					$str .= "軍需工場防衛です。何やら怪しい兵器を作ってるとの噂ですが……触らぬ神にたたりなし";
				} elsif($op_set == 1){
					$str .= "軍需工場防衛だ。中で何を作っているかは気にするな。お前は守っていればいい";
				} elsif($op_set == 2){
					$str .= "コウジョウ　ボウエイ";
				} elsif($op_set == 3){
					$str .= "このラインを守り切れば俺らの勝利だ";
				} elsif($op_set == 4){
					$str .= "軍需工場を防衛してください。防衛設備が一応稼働しています";
				} elsif($op_set == 5){
					$str .= "工場の防衛です。軍需工場らしいです。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "クンクン、クゥ～ン";
				} elsif($op_set == 7){
					$str .= "軍需工場を防衛するわ！！　隔壁が破られないよう最後まで立っているのよ！！";
				} elsif($op_set == 8){
					$str .= "軍需工場の進入路を塞いでいてください。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "軍需工場防衛よ。防衛ラインを死守すること。以上";
				} elsif($op_set == 10){
					$str .= "地下軍需工場のエレベーターを防衛するんだゼぇ～楽しみだなぁ～ハッハァ～";
				}
			}
			elsif($tell == 5){
				$str .= "工作チームの撤退を援護してください。追撃部隊がいます";
			}
			elsif($tell == 6){
				$str .= "市街地がバイオ兵器に襲われる危険があります。侵入を阻止してください";
			}
		}
		elsif($mission == 5){
			if($tell == 0){
				if($op_set == 0){
					$str .= "市街地強襲です。我々は力を持っているのです。見せつけてやりましょう";
				} elsif($op_set == 1){
					$str .= "市街地強襲だ。気は進まんが……仕事だ。インフラを破壊してくれ";
				} elsif($op_set == 2){
					$str .= "アバレ　ルンダ";
				} elsif($op_set == 3){
					$str .= "大暴れしてやろうぜ";
				} elsif($op_set == 4){
					$str .= "市街地を襲撃してください。防衛隊は破壊してもかまいません";
				} elsif($op_set == 5){
					$str .= "市街地を襲撃します。避難？　何のことでしょう。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "グルルルルル、ウーッ！";
				} elsif($op_set == 7){
					$str .= "市街地を強襲するわ！！　逃げる市民は無視して！！";
				} elsif($op_set == 8){
					$str .= "神の御加護があらんことを……神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "市街地強襲よ。目標をすべて破壊すること。以上";
				} elsif($op_set == 10){
					$str .= "鉄道や幹線道路を重点的に破壊してくれよぉ～ハッフフ";
				}
			}
			elsif($tell == 1){
				if($op_set == 0){
					$str .= "補給基地強襲です。補給物資がいっぱいあるので全部破壊してくださいね";
				} elsif($op_set == 1){
					$str .= "補給基地強襲だ。マークした補給物資を一つ残らず破壊するんだ";
				} elsif($op_set == 2){
					$str .= "ホキュウキチ　ハカイ";
				} elsif($op_set == 3){
					$str .= "大事なもんがいっぱいころがってるじゃねぇか……！";
				} elsif($op_set == 4){
					$str .= "補給基地を強襲してください。補給物資の破壊が最優先です";
				} elsif($op_set == 5){
					$str .= "補給基地を襲撃します。補給物資をマークしました。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ガオーン！";
				} elsif($op_set == 7){
					$str .= "補給物資をマークしたわ！！　補給基地を完全に破壊して！！";
				} elsif($op_set == 8){
					$str .= "補給基地の物資を全て破壊してください。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "補給基地強襲よ。目標をすべて破壊すること。以上";
				} elsif($op_set == 10){
					$str .= "燃料タンクが見えるなぁ、アレを全部破壊するよぉ～爆発に注意してねぇ～";
				}
			}
			elsif($tell == 2){
				if($op_set == 0){
					$str .= "基地建設妨害です。建設資材や重機をめちゃくちゃにしてください";
				} elsif($op_set == 1){
					$str .= "基地建設妨害だ。マークした資材や重機を重点的に破壊してくれ";
				} elsif($op_set == 2){
					$str .= "ケンセツ　ボウガイ";
				} elsif($op_set == 3){
					$str .= "資材や重機を重点的に破壊してやれ";
				} elsif($op_set == 4){
					$str .= "基地建設の妨害を行います。資材や重機を破壊するのが目的です";
				} elsif($op_set == 5){
					$str .= "基地建設を妨害します。護衛は破壊して構いません。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワンワン！　ワン！";
				} elsif($op_set == 7){
					$str .= "基地の建設を妨害するわ！！　重機や資材をめちゃくちゃにするのよ！！";
				} elsif($op_set == 8){
					$str .= "建設中の基地に襲撃をして作業を妨害してください。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "基地建設妨害よ。目標をすべて破壊すること。以上";
				} elsif($op_set == 10){
					$str .= "護衛がきやがったねェ、敵の攻撃に注意して重機を破壊するんだヨ";
				}
			}
			elsif($tell == 3){
				if($op_set == 0){
					$str .= "補給線強襲です。補給トラックをマークしました。全て破壊してください";
				} elsif($op_set == 1){
					$str .= "補給線強襲だ。補給トラックをマークした。あれを全て破壊するんだ";
				} elsif($op_set == 2){
					$str .= "ホキュウ　スンダン";
				} elsif($op_set == 3){
					$str .= "大事なもん運んでるじゃねぇか……あいつらを全部破壊するんだ";
				} elsif($op_set == 4){
					$str .= "補給線強襲です。護衛も破壊してかまいません";
				} elsif($op_set == 5){
					$str .= "補給線を分断してください。輸送車両をマークしました。簡単ですね？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワフーン！";
				} elsif($op_set == 7){
					$str .= "補給線を分断するわ！！　橋や道路をマークしたからすべて破壊して！！";
				} elsif($op_set == 8){
					$str .= "補給トラックを破壊します。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "補給線強襲よ。目標のトラックをすべて破壊すること。以上";
				} elsif($op_set == 10){
					$str .= "ハッハァ、動きののろまなトラックがいっぱいいるゼぇ";
				}
			}
			elsif($tell == 4){
				if($op_set == 0){
					$str .= "軍需工場強襲です。生産ラインをすべて破壊してください";
				} elsif($op_set == 1){
					$str .= "軍需工場強襲だ。生産能力を完全に破壊してくれ";
				} elsif($op_set == 2){
					$str .= "コウジョウ　キョウシュウ";
				} elsif($op_set == 3){
					$str .= "生産ラインをすべてマークした。残らず塵に変えてやんな";
				} elsif($op_set == 4){
					$str .= "軍需工場強襲です。生産ラインの破壊を最優先してください";
				} elsif($op_set == 5){
					$str .= "軍需工場の生産設備をすべて破壊してください。あ、護衛がいますね。簡単でしょう？　御武運を";
				} elsif($op_set == 6){
					$str .= "ワンワン！　ワン！";
				} elsif($op_set == 7){
					$str .= "軍需工場を破壊するわ！！　出荷前の兵器をみな破壊して！！";
				} elsif($op_set == 8){
					$str .= "軍需工場の燃料タンクをすべて破壊して機能を停止させます。神の御加護があらんことを";
				} elsif($op_set == 9){
					$str .= "軍需工場強襲よ。目標の製品をすべて破壊すること。以上";
				} elsif($op_set == 10){
					$str .= "フゥー、軍需工場の隔壁を全て破壊してくれ。後は地上部隊がなだれ込むはずさ";
				}
			}
			elsif($tell == 5){
				$str .= "研究設備をすべて破壊してください。いくつか護衛の存在が確認されています";
			}
			elsif($tell == 6){
				$str .= "孵化寸前の卵が大量に確認されました。すべて破壊してください";
			}
		}
		$log_b[$eno] .= $name . "「"  . $str . "」</p><BR><BR>\n";
		if($tell == 5){
			$str = "徘徊している新型バイオ兵器はいまのところこちらのコントロール下にあります";
			$log_b[$eno] .= $name . "「"  . $str . "」</p><BR><BR>\n";
		}
	}
	
	return 0;
}


1;

