# 戦闘で使うサブルーチン

# EN増減
sub en_sup{
	use utf8;
	my $eno = shift;
	my $value = shift;
	
	if($eno < 0 || $eno > 10000){return 0;}
	
	$machine[$eno][2] += $value;
	
	my $en = $machine[$eno][2];
	my $men = $machine[$eno][3];
	
	if($en <= 0){
		$machine[$eno][2] = 0;
		return 1;
	}
	elsif($en > $men){
		$machine[$eno][2] = $men;
	}
	
	return 0;
}

# EN増減(npc)
sub en_sup_npc{
	use utf8;
	my $id = shift;
	my $value = shift;
	my $ref_life_list = shift;
	my @life_list = @$ref_life_list;
	
	if($id < 0 || $id > 100){return 0;}
	
	$life_list[$id][16] += $value;
	
	my $en = $life_list[$id][16];
	my $men = $life_list[$id][17];
	
	if($en <= 0){
		$life_list[$id][16] = 0;
		return 1;
	}
	elsif($en > $men){
		$life_list[$id][16] = $men;
	}
	
	return 0;
}


# AP増減
sub ap_sup{
	use utf8;
	my $eno = shift;
	my $value = shift;
	my $logeno = shift;
	
	if($eno < 0 || $eno > 10000){return 0;}
	
	$machine[$eno][0] += $value;
	
	my $ap = $machine[$eno][0];
	my $map = $machine[$eno][1];
	
	if ($value > 0){
		my $name = $machine_list[$eno][1];
		$log_b[$logeno] .= '<div class="goodeffect">' . $name . "はAP" . $value . "回復した</div><BR>\n";
	}
	
	if($ap <= 0){
		$machine[$eno][0] = 0;
		return 1;
	}
	elsif($ap > $map){
		$machine[$eno][0] = $map;
	}
	
	return 0;
}

# 戦闘ログ
sub blog{
	use utf8;
	my $str = shift;
	my $eno = shift;
	
	$log_b[$eno] .= $str . "<BR>\n";
}


# 霧処理
sub mist{
	use utf8;
	my $eno = shift;
	my $value = 0;
	
	my $water = $machine[$eno][11];
	my $mist = $machine[$eno][12];
	
	# 補正
	if ($mist > 0){
		$mist = int((sqrt $mist)*10);
	}
	
	if ($water <= $mist){
		$mist = $water;
		$machine[$eno][11] = 0;
	}
	else{
		$machine[$eno][11] -= $mist;
	}
	
	$value = $mist * 2;
	if ($value > 0){
		$value *= ($game_data[1][2] + $op_list[$eno][5]);
		$value = int($value / 100);
	}
	
	return $value;
}

# ライフ表示
sub lifelist{
	use utf8;
	my $ref_list = shift;
	my @list = @$ref_list;
	my $ref_life_list = shift;
	my @life_list = @$ref_life_list;
	my $eno = shift;
	my $alive = 0;
	
	$log_b[$eno] .= '<table border="1" align="center" class="lifelist">' . "\n";
	
	
	for (my $i=0; $i<100; $i++){
		
		if ($i == 50){
			if ($alive == 0){return 0;}
			$log_b[$eno] .= '<tr><th colspan="2">--------------------vs-------------------</th></tr>' . "\n";
			$alive = 0;
		}
		
		if ($list[$i] >= 10000){
			# NPC
			my $t_npc = $list[$i];
			my $enpc = $list[$i] - 10000;
			my $e_name = &npc_name($t_npc, \@list, $i);
			my $icon = $enemy_list[$enpc][26];
			
			my $ap = $life_list[$i][0];
			my $map = $life_list[$i][1];
			
			my $en = $life_list[$i][16];
			my $men = $life_list[$i][17];
			
			unless($icon){$icon = "../Pic/noimgicon.jpg";}
			
			if ($e_name){
				$e_name = '<img src="' . $icon . '" align="middle">' . $e_name;
			}
			
			
			if ($ap > 0){
				my $life = int($ap / $map * 120);
				my $red_life = 120 - $life;
				$log_b[$eno] .= "<tr><td><b>" . $e_name . "</b></td>";
				$log_b[$eno] .= "<td>【AP】";
				$log_b[$eno] .= '<img src="../Pic/BAR.png" alt="残存AP" width="' . $life . '" height="3">';
				$log_b[$eno] .= '<img src="../Pic/REDBAR.png" alt="ダメージ" width="' . $red_life . '" height="3">';
				$log_b[$eno] .= "【" . $ap . "/" . $map . "】<br>\n";
				my $engy = int($en / $men * 120);
				my $red_engy = 120 - $engy;
				$log_b[$eno] .= "【EN】";
				$log_b[$eno] .= '<img src="../Pic/BLUEBAR.png" alt="残存EN" width="' . $engy . '" height="3">';
				$log_b[$eno] .= '<img src="../Pic/REDBAR.png" alt="EN消費量" width="' . $red_engy . '" height="3">';
				$log_b[$eno] .= "【" . $en . "/" . $men . "】\n";
				$log_b[$eno] .= "</td></tr>\n";
				$alive += 1;
			}
			
		}
		elsif ($list[$i] >= 0){
			# プレイヤー
			my $e_eno = $list[$i];
			my $e_name = $machine_list[$e_eno][1];
			my $p_name = $chara_list[$e_eno][2];
			my $icon = $chara_list[$e_eno][8];
			unless($icon){$icon = "../Pic/noimgicon.jpg";}
			
			my $ap = $machine[$e_eno][0];
			my $map = $machine[$e_eno][1];
			my $en = $machine[$e_eno][2];
			my $men = $machine[$e_eno][3];
			my $water = $machine[$e_eno][11];
			
			unless($map){$map = 1;}
			unless($men){$men = 1;}
			
			my $a = int($e_eno / 1000);
			my $b = $e_eno % 1000;
			my $c = int($b / 100);
			my $d = $b % 100;
			my $e = int($d / 10);
			my $f = $d % 10;
			if ($e_name){
				$e_name = '<img src="' . $icon . '" align="left" width="60" height="60">' . $e_name . "<br>" . $p_name;
				$e_name = '<A href="c' . "$a$c$e$f" . '.html">' . "$e_name" . "</A>";
			}
			if ($ap > 0){
				my $life = int($ap / $map * 120);
				my $red_life = 120 - $life;
				$log_b[$eno] .= "<tr><td><b>" . $e_name . "</b></td>";
				$log_b[$eno] .= "<td>【AP】";
				$log_b[$eno] .= '<img src="../Pic/BAR.png" alt="残存AP" width="' . $life . '" height="3">';
				$log_b[$eno] .= '<img src="../Pic/REDBAR.png" alt="ダメージ" width="' . $red_life . '" height="3">';
				$log_b[$eno] .= "【" . $ap . "/" . $map . "】<br>\n";
				my $engy = int($en / $men * 120);
				my $red_engy = 120 - $engy;
				$log_b[$eno] .= "【EN】";
				$log_b[$eno] .= '<img src="../Pic/BLUEBAR.png" alt="残存EN" width="' . $engy . '" height="3">';
				$log_b[$eno] .= '<img src="../Pic/REDBAR.png" alt="EN消費量" width="' . $red_engy . '" height="3">';
				$log_b[$eno] .= "【" . $en . "/" . $men . "】<br>\n";
				$log_b[$eno] .= "水【" . $water . "】</td></tr>\n";
				$alive += 1;
			}
		}
	}
	$log_b[$eno] .= "</table>\n";
	return $alive;
}

# 対象物破壊
sub target_down{
	use utf8;
	my $ref_list = shift;
	my @list = @$ref_list;
	my $ref_life_list = shift;
	my @life_list = @$ref_life_list;
	my $eno = shift;
	my $alive = 0;
	
	for (my $i=50; $i<100; $i++){
		
		
		
		if ($list[$i] >= 10000){
			# NPC
			my $t_npc = $list[$i];
			my $enpc = $list[$i] - 10000;
			
			my $ap = $life_list[$i][0];
			
			if ($ap > 0 && $enpc == 40){
				$alive += 1;
			}
			
		}
	}
		
	return $alive;
}

# 敵存在チェック
sub enemy_down{
	use utf8;
	my $ref_list = shift;
	my @list = @$ref_list;
	my $ref_life_list = shift;
	my @life_list = @$ref_life_list;
	my $eno = shift;
	my $alive = 0;
	
	for (my $i=50; $i<100; $i++){
		
		
		
		if ($list[$i] >= 10000){
			# NPC
			my $t_npc = $list[$i];
			my $enpc = $list[$i] - 10000;
			
			my $ap = $life_list[$i][0];
			
			if ($ap > 0){
				$alive += 1;
			}
			
		}
	}
		
	return $alive;
}

# 対象選択
sub select_target{
	use utf8;
	my $atker_id = shift;
	my $ref_list = shift;
	my @list = @$ref_list;
	my $ref_life_list = shift;
	my @life_list = @$ref_life_list;
	my $target = -1;
	my @target_list = ( );
	my $id = 0;
	
	for (my $i=0; $i<100; $i++){
		my $chara = $list[$i];
		if ($chara >= 10000){
			my $ap = $life_list[$i][0];
			if ($ap <= 0){next;}
		}
		elsif ($chara >= 0){
			my $ap = $machine[$chara][0];
			if ($ap <= 0){next;}
		}
		else{next;}
		
		if ($atker_id < 50 && $i >= 50){
			$target_list[$id] = $i;
			$id += 1;
		}
		elsif ($atker_id >= 50 && $i < 50){
			$target_list[$id] = $i;
			$id += 1;
		}
	}
	
	if ($id == 0){return -1;}
	
	my $num = @target_list;
	$id = int(rand $num);
	$target = $target_list[$id];
	
	if ($mission_order == 3 && $target >= 50){$target = 50;}
	
	return $target;
}

# 死亡チェック
sub death_ck{
	use utf8;
	my $eno = shift;
	my $ref_list = shift;
	my @list = @$ref_list;
	my $ref_life_list = shift;
	my @life_list = @$ref_life_list;
	my $ref_death_list = shift;
	my @death_list = @$ref_death_list;
	my $ans = 0;
	
	for (my $i=0; $i<100; $i++){
		my $chara = $list[$i];
		if ($chara >= 10000){
			my $ap = $life_list[$i][0];
			my $death = $death_list[$i];
			if ($ap <= 0 && $death == 0){
				$death_list[$i] = 1;
				
				&words("被撃墜時", $list[$i], $eno);
				
				my $npc = $list[$i];
				my $name = $enemy_list[$npc][1];
				my $name = &npc_name($npc, \@list, $i);
				$log_b[$eno] .= "<BR><I>" . $name . "は撃墜された！！</I><BR><BR>\n";
			
			}
		}
		elsif ($chara >= 0){
			my $ap = $machine[$chara][0];
			my $death = $death_list[$i];
			if ($ap <= 0 && $death == 0){
				$death_list[$i] = 1;
				
				&words("被撃墜時", $chara, $eno);
				
				my $name = $machine_list[$chara][1];
				$log_b[$eno] .= "<BR><I>" . $name . "は撃墜された！！</I><BR><BR>\n";
			}
		}
		else{next;}
		
	}
	
	return @death_list;
}

sub npc_name{
	use utf8;
	my $npc = shift;
	my $ref_list = shift;
	my $id = shift;
	my @list = @$ref_list;
	my $t_npc = $npc - 10000;
	
	my $name =  $enemy_list[$t_npc][1];
	
	my $check = 1;
	
	for(my $i=0; $i<100; $i++){
		if($i == $id){last;}
		my $list_id = $list[$i];
		if($list_id == $npc){$check++;}
	}
	
	if($check > 1){
		$name .= "[$check]";
	}
	
	return $name;
}

# 行動指定

sub atk_menu{
	use utf8;
	my $eno = shift;
	my $turn = shift;
	my $lef_life_list = shift;
	my @life_list = @$ref_life_list;
	my $ans = 0;
	my $limit = 0;
	
	if($eno >= 10000){return 0;}
	
	for (my $i=2; $i<11; $i++){
		my $menu = $battle_action[$eno][$i];
		unless($menu){next;}
		if($limit >= 3){last;}
		
		my @order = split(/：/, $menu);
		
		unless($order[0]){next;}
		
		if($order[1] eq "通常時"){
			my $dice = int(rand 3);
			if($dice == 0){
				$ans = $order[0];
				last;
			}
			$limit++;
		}
		elsif($order[1] eq "第{x}行動時"){
			if($turn == $order[2]){
				$ans = $order[0];
				last;
			}
		}
		elsif($order[1] eq "残りAP{x}%以下"){
			my $border = $order[2];
			if($border > 50){$border = 50;}
			my $ap = $machine[$eno][0];
			my $maxap = $machine[$eno][1];
			$ap = $ap / $maxap * 100;
			if($ap <= $border){
				$ans = $order[0];
				last;
			}
		}
		elsif($order[1] eq "残りEN{x}%以下"){
			my $border = $order[2];
			if($border > 50){$border = 50;}
			my $en = $machine[$eno][2];
			my $maxen = $machine[$eno][3];
			$en = $en / $maxen * 100;
			if($en <= $border){
				$ans = $order[0];
				last;
			}
		}
		elsif($order[1] eq "自分が{x}状態時"){
			my $izyou = $order[2];
			my $level = 0;
			if($izyou eq "動作不良"){
				$level = $life_list[$eno][2];
			}
			elsif($izyou eq "制動障害"){
				$level = $life_list[$eno][3];
			}
			elsif($izyou eq "出力低下"){
				$level = $life_list[$eno][4];
			}
			elsif($izyou eq "索敵障害"){
				$level = $life_list[$eno][5];
			}
			elsif($izyou eq "旋回障害"){
				$level = $life_list[$eno][6];
			}
			elsif($izyou eq "照準障害"){
				$level = $life_list[$eno][7];
			}
			elsif($izyou eq "機体炎上"){
				$level = $life_list[$eno][8];
			}
			
			if($level > 0){
				$ans = $order[0];
				last;
			}
		}
		
	}
	
	
	return $ans;
}









1;

