# 行動全般

# アセンブル
sub assemble {
	use utf8;
	my $order = shift;
	my $eno = shift;
	
	my @assem = split(/：/, $order);
	my $slot == "";
	my @machine_ = @{$machine_list[$eno]};
	my $parts_data = \@parts_list;
	
	
	for (my $i=0; $i<11; $i++){
		
		unless($assem[$i]){next;}
		if($i==0){$slot = "脚部";
		}elsif($i==1){$slot = "操縦棺";
		}else{$slot = "スロット";}
		my $a = $i + 2;
		my $change_parts = $machine_[$a];
		if ($assem[$i] > 0){
			my $p = &equ_can($assem[$i], $eno, $slot);
			if ($p < 0){next;}
		}
		&data_i($parts_data, $change_parts, 28, 0);
		$machine_[$a] = -1;
	}
	
	for (my $i=0; $i<11; $i++){
		
		unless($assem[$i]){next;}
		
		if($assem[$i] > $garage_max){
			$log[$eno] .= '<DIV class="fail">' . "そのパーツ指定は大きすぎる</DIV>\n";
			next;
		}
		
		# 部位
		if ($i == 0){$slot = "脚部";}
		elsif ($i == 1){$slot = "操縦棺";}
		elsif ($i > 11){$slot = "オプション";}
		else {$slot = "スロット";}
		
		# 装備中パーツをロード
		my $a = $i + 2;
		my $parts_now = $machine_[$a];
		
		# 指定パーツが装備できるかチェック
		# 成功した場合、指定パーツが返ってくる
		my $p = &equ_can($assem[$i], $eno, $slot);
		if($p < 1){next;}
		
		# ID28、装備チェックスペースに装備部位をリセット
		# if ($parts_now > 0){
		#	&data_i($parts_data, $parts_now, 28, 0);
		#	$machine_[$a] = -1;
		# }
		
		my $b = &data_o($parts_data, $p, 28);
		if($b > 0){
			$log[$eno] .= '<DIV class="fail">' . "そのパーツは装備中だ</DIV>\n";
			next;
		}
		
		#解除
		if($assem[$i] < 0 && $i > 1){
			$machine_[$a] = -1;
			$log[$eno] .= '<DIV class="success">' . $slot . "の装備を解除した</DIV>\n";
			next;
		}
		
		# 装備
		# ID28、装備チェックスペースに装備部位を入力
		if ($p >= 0){
			&data_i($parts_data, $p, 28, $a);
		}
		else{next;}
		
		
		
		$machine_[$a] = $p;
		my $name = &data_o($parts_data, $p, 1);
		$log[$eno] .= '<DIV class="success">' . $slot . "に" . $name . "を装備した</DIV>\n";
		
		
	}
	
	@machine_list[$eno] = \@machine_;
	
}

# OPアセンブル
sub asse_op {
	use utf8;
	my $order = shift;
	my $eno = shift;
	
	my @assem = split(/：/, $order);
	my $slot == "";
	my @machine_ = @{$machine_list[$eno]};
	my $parts_data = \@parts_list;
	
	# 初期化
	for (my $i=13; $i<19; $i++){
		$machine_[$i] = -1;
	}
	
	for (my $i=0; $i<6; $i++){
		
		unless($assem[$i]){next;}
		
		# 部位
		$slot = "オプション";
		
		# 指定パーツが装備できるかチェック
		# 成功した場合、指定パーツが返ってくる
		my $p = &equ_can($assem[$i], $eno, $slot);
		
		if ($p >= 0){
			# 旧処理
			# my $a = $assem[$i];
			# my $b = $equip_list[$eno][$a];
			
			# ID28、装備チェックスペースを確認
			my $b = &data_o($parts_data, $p, 28);
			if($b > 0){
				$log[$eno] .= '<DIV class="fail">' . "そのパーツは装備中だ</DIV>\n";
				next;
			}
			# 旧処理
			# $item_list[$eno][$a] = -1;
			# $equip_list[$eno][$a] = 0;
			
		}
		my $name = &data_o($parts_data, $p, 1);
		
		unless($name){next;}
		
		# ID28、装備チェックスペースに装備部位を入力
		# オプション部位が入力されたパーツは最後に消去
		# ここでデータを消すとステータスに反映できないので
		
		my $a = $i + 13;
		$machine_[$a] = $p;
		&data_i($parts_data, $p, 28, $a);
		
		$log[$eno] .= '<DIV class="success">' . $slot . "に" . $name . "を装備した</DIV>\n";
		
		
	}
	
	@machine_list[$eno] = \@machine_;
	
}

# 装備中かチェック
sub equ_now {
	use utf8;
	my $p = shift;
	my $eno = shift;
	my $type = shift;
	
	# 絶対座標
	
	my $parts_data = \@parts_list;
	
	my $ans = 0;
	
	my $equip_id = &data_o($parts_data, $p, 28);
	
	if ($equip_id){$ans = 1;}
	
	return $ans;
}

# 装備中の検索
sub equ_seach {
	use utf8;
	my $p = shift;
	my $ref = shift;
	my @machine_ = @$ref;
	
	my $ans = 0;
	
	for (my $i=4; $i<13; $i++){
		my $a = $machine_[$i];
		if ($a == $p){
			$ans = $i;
			last;
		}
	}
	
	
	return $ans;
}


# 装備可？
sub equ_can {
	use utf8;
	my $ans = -1;
	my $item = shift;
	my $eno = shift;
	my $slot = shift;
	
	my $parts_data = \@parts_list;
	
	my $p = &item_id($item, $eno);
	
	unless ($p){return $ans;}
	
	my $name = &data_o($parts_data, $p, 1);
	unless ($name){return $ans;}
	
	my $type = &data_o($parts_data, $p, 2);
	
	# 種類別振り分け
	if ($type eq "操縦棺"){
		if ($slot eq "操縦棺"){$ans = $p;}
	}
	elsif ($type eq "二脚"){
		if ($slot eq "脚部"){$ans = $p;}
	}
	elsif ($type eq "逆関節"){
		if ($slot eq "脚部"){$ans = $p;}
	}
	elsif ($type eq "多脚"){
		if ($slot eq "脚部"){$ans = $p;}
	}
	elsif ($type eq "タンク"){
		if ($slot eq "脚部"){$ans = $p;}
	}
	elsif ($type eq "車輪"){
		if ($slot eq "脚部"){$ans = $p;}
	}
	elsif ($type =~ /素材/){
		if ($slot eq "オプション"){$ans = $p;}
	}
	else{
		if ($slot eq "スロット"){$ans = $p;}
		if ($slot eq "オプション"){$ans = $p;}
	}
	
	
	return $ans;
}

# 購入
sub buy {
	use utf8;
	my $order = shift;
	my $eno = shift;
	my $parts_data = \@parts_list;
	my $catalog_parts_data = \@catalog_parts_list;
	my $chara_data = \@chara_list;
	
	
	my @buy = split(/：/, $order);
	for (my $i=0; $i<3; $i++){
		unless($buy[$i]){next;}
		my $item = $buy[$i];
		my $money = $chara_list[$eno][9];
		my @list = @{$matching[$eno]};
		if ($item >= 1000){
			$log[$eno] .= '<DIV class="fail">' . "そのアイテムは存在しない</DIV>\n";
			next;
		}
		elsif ($item == -1){
			$log[$eno] .= '<DIV class="success">' . "機械工作をしました</DIV>\n";
			
			my $cost = 500;
			if ($money >= $cost){
				$cost *= -1;
				&money($cost, $eno, "経費支出");
				
				$log[$eno] .= '<FONT class="postsuccess"><I>' . "*成功*</I></FONT><BR>\n";
				
				&money(1, $eno, "機械入手");
				
			}
			else{
				$log[$eno] .= '<DIV class="fail">' . "<I>資金が足りない</I></DIV>\n";
			}
			next;
		}
		elsif ($item == -2){
			$log[$eno] .= '<DIV class="success">' . "航空支援を要請しました</DIV>\n";
			
			my $cost = 1000;
			if ($list[50] > 0){
				$log[$eno] .= '<DIV class="fail">' . "<I>*却下*</I></DIV>\n";
			}
			elsif ($money >= $cost){
				$cost *= -1;
				&money($cost, $eno, "経費支出");
				
				$log[$eno] .= '<FONT class="postsuccess"><I>' . "*受理*</I></FONT><BR>\n";
				
				&money(1, $eno, "航空支援");
				
			}
			else{
				$log[$eno] .= '<DIV class="fail">' . "<I>資金が足りない</I></DIV>\n";
			}
			next;
		}
		elsif ($item == -3){
			$log[$eno] .= '<DIV class="success">' . "補給支援を要請しました</DIV>\n";
			
			my $cost = 1000;
			if ($list[50] > 0){
				$log[$eno] .= '<DIV class="fail">' . "<I>*却下*</I></DIV>\n";
			}
			elsif ($money >= $cost){
				$cost *= -1;
				&money($cost, $eno, "経費支出");
				
				$log[$eno] .= '<FONT class="postsuccess"><I>' . "*受理*</I></FONT><BR>\n";
				
				&money(1, $eno, "補給支援");
				
			}
			else{
				$log[$eno] .= '<DIV class="fail">' . "<I>資金が足りない</I></DIV>\n";
			}
			next;
		}
		
		my $name = &data_o($catalog_parts_data, $item, 1);
		unless ($name){
			$log[$eno] .= '<DIV class="fail">' . "そのアイテムは存在しない</DIV>\n";
			next;
		}
		
		
		my $cost = &data_o($catalog_parts_data, $item, 7);
		if ($money < $cost){
			my $a = $money + $chara_st[$eno][2];
			if ($a < $cost){
				$log[$eno] .= '<DIV class="fail">' . "資金が足りない！！</DIV>\n";
				next;
			}
		}
		
		&data_c($catalog_parts_data, $parts_data, $item, 0);
		
		# パラメータ適用
		&parts_palam(0);
		
		my $fuka_a =  &data_o($parts_data, 0, 29);
		my $fuka_b =  &data_o($parts_data, 0, 30);
		
		# ステ増加系付加の適用
		&parts_fuka(0, $fuka_a, $eno, 0);
		&parts_fuka(0, $fuka_b, $eno, 0);
		
		my $ans = &item_add(0, $eno);
		if ($ans > 0){
			$cost *= -1;
			&money($cost, $eno, "経費支出");
			
			my $buy_eno = &data_o($catalog_parts_data, $item, 31);
			my $buy_money = int($cost / -20);
			if ($buy_money < 20){$buy_money = 20;}
			&money($buy_money, $buy_eno, "ライセンス料");
			&money(1, $buy_eno, "パーツ販売数");
			
			my $name_c = $chara_list[$eno][2];
			$log[$eno] .= '<DIV class="success"><I>' . $name_c ."は" . $name ."を購入した！</I></DIV>\n";
			
		}
		else {
			$log[$eno] .= '<DIV class="fail">' . "<I>ガレージがいっぱいだ！</I></DIV>\n";
			return -1;
		}
	}
	
	
	return 1;
}

# 売却
sub sell {
	use utf8;
	my $order = shift;
	my $eno = shift;
	my $parts_data = \@parts_list;
	my $chara_data = \@chara_list;
	
	
	
	my @sell = split(/：/, $order);
	for (my $i=0; $i<3; $i++){
		unless($sell[$i]){next;}
		my $item = $sell[$i];
		if ($item >= $garage_max || $item < 0){
			$log[$eno] .= '<DIV class="fail">' . "そのアイテムは存在しない</DIV>\n";
			next;
		}
		
		my $p = &item_id($item, $eno);
		
		if ($p <= 0){
			$log[$eno] .= '<DIV class="fail">' . "そのアイテムは存在しない<DIV>\n";
			next;
		}
		
		my $equip_item = &data_o($parts_data, $p, 28);
		if ( $equip_item > 0 ){
			$log[$eno] .= '<DIV class="fail">' . "対象のパーツは装備中だ</DIV>\n";
			next;
		}
		
		my $name = &data_o($parts_data, $p, 1);
		unless ($name){
			$log[$eno] .= '<DIV class="fail">' . "そのアイテムは存在しない</DIV>\n";
			next;
		}
		
		&data_i($parts_data, $p, 1, "");
		$equip_list[$eno][$item] = 0;
		my $cost = &data_o($parts_data, $p, 7);
		&money($cost, $eno, "経費収入");
		my $name_c = $chara_list[$eno][2];
		$log[$eno] .= '<DIV class="success"><I>' . $name_c ."は" . $name ."を売却した！</I></DIV>\n";
	}
	return 1;
}

# 訓練

sub train {
	use utf8;
	my $order = shift;
	my $eno = shift;
	my $chara_data = \@chara_list;
	
	my @cell = split(/：/, $order);
	for(my $i=0; $i<6; $i++){
		my $train = $cell[$i];
		
		$train =~ s/\+BR\+//g;
		
		my $menu = 0;
		if ($train eq "射撃"){$menu = 14;}
		elsif ($train eq "格闘"){$menu = 15;}
		elsif ($train eq "反応"){$menu = 16;}
		elsif ($train eq "制御"){$menu = 17;}
		elsif ($train eq "整備"){$menu = 18;}
		elsif ($train eq "適性"){$menu = 19;}
		elsif ($train eq "機械作製"){$menu = 1;}
		elsif ($train eq "射撃+BR+"){$menu = 14;}
		elsif ($train eq "格闘+BR+"){$menu = 15;}
		elsif ($train eq "反応+BR+"){$menu = 16;}
		elsif ($train eq "制御+BR+"){$menu = 17;}
		elsif ($train eq "整備+BR+"){$menu = 18;}
		elsif ($train eq "適性+BR+"){$menu = 19;}
		else {next;}
		
		if($menu == 1){
			# 機械作製
			my $exp = $chara_list[$eno][11];
			
			$log[$eno] .= "機械工作をしました<BR>\n";
			
			my $cost = 1;
			if ($exp >= $cost){
				$cost *= -1;
				$chara_list[$eno][11] += $cost;
				
				$log[$eno] .= '<DIV class="tsuccess"><I>' . "*成功*</I></DIV>\n";
				
				&money(1, $eno, "機械入手");
				
			}
			else{
				$log[$eno] .= '<DIV class="fail">' . "<I>経験値が足りない</I></DIV>\n";
			}
		}
		else{
			my $exp = $chara_list[$eno][11];
			my $abl = $chara_list[$eno][$menu];
			
			$log[$eno] .= $train . "の訓練をしました<BR>\n";
			
			my $cost = int($abl / 10);
			if ($exp >= $cost){
				$chara_list[$eno][$menu] += $cost;
				$cost *= -1;
				$chara_list[$eno][11] += $cost;
				
				$cost *= -1;
				$log[$eno] .= '<DIV class="tsuccess"><I>' . $train . "が" . $cost . "上昇した</I></DIV>\n";
			}
			else{
				$log[$eno] .= '<DIV class="fail">' . "<I>経験値が足りない</I></DIV>\n";
			}
		}
	}
}


# 日記

sub diary {
	use utf8;
	my $order = shift;
	my $eno = shift;
	my $pict = shift;
	
	if ($pict){
		my $np = $chara_list[$eno][23];
		if ($np >= 5){
			$log[$eno] .= '<hr class="hr-main">';
			$log[$eno] .= '<p><img src="' . $pict . '" alt="日記画像"></p>' . "\n";
		}
	}
	
	# $order = &str_leng($order, 2000);
	
	my $str = &tagdell($order);
	$log[$eno] .= '<hr class="hr-main">';
	$log[$eno] .= '<DIV class="nikki">' . $str . "</DIV><BR>\n";
	$log[$eno] .= '<hr class="hr-main">';
	
}

# 送品

sub send_item {
	use utf8;
	my $order = shift;
	my $eno = shift;
	my $parts_data = \@parts_list;
	my $chara_data = \@chara_list;
	
	
	
	my @send = split(/：/, $order);
	for (my $i=0; $i<6; $i++){
		if($send[$i] eq "to"){next;}
		my ($item, $to) = split(/to/, $send[$i]);
		if ($item >= $garage_max || $item < 0){
			$log[$eno] .= '<DIV class="fail">' . "そのアイテムは存在しません</DIV>\n";
			next;
		}
		
		my $p = &item_id($item, $eno);
		my $equip_item = &data_o($parts_data, $p, 28);
		if ( $equip_item > 0 ){
			$log[$eno] .= '<DIV class="fail">' . "対象のパーツは装備中です</DIV>\n";
			next;
		}
		
		if ($to < 1){
			# $log[$eno] .= '<DIV class="fail">' . "対象のキャラが未入力です</DIV>\n";
			next;
		}
		
		my $name_to = $chara_list[$to][1];
		unless($name_to){
			$log[$eno] .= '<DIV class="fail">' . "対象のキャラは存在しませｎ</DIV>\n";
			next;
		}
		
		if ($p < 0){
			$log[$eno] .= '<DIV class="fail">' . "そのアイテムは存在しません</DIV>\n";
			next;
		}
		
		my $name = &data_o($parts_data, $p, 1);
		unless ($name){
			$log[$eno] .= '<DIV class="fail">' . "指定したアイテムは存在しません</DIV>\n";
			next;
		}
		
		&data_c($parts_data, $parts_data, $p, 0);
		my $ans = &item_del($p, $eno);
		if ($ans == 1){
			my $ans = &item_add(0, $to);
			if ($ans >= 1){
				my $name_c = $chara_list[$eno][2];
				$log[$eno] .= '<DIV class="postsuccess"><I>' . $name_c ."は" . $name_to ."に" . $name . "を送品した</I></DIV>\n";
				
				my $a = int($eno / 1000);
				my $b = $eno % 1000;
				my $c = int($b / 100);
				my $d = $b % 100;
				my $e = int($d / 10);
				my $f = $d % 10;
				
				$log_gift[$to] .= '<A href="c' . "$a$c$e$f" . '.html">' . $name_c ."</A>から" . $name . "が届いた</i><br>\n";
				
			}
			else {
				$log[$eno] .= '<DIV class="fail">' . "<I>ガレージがいっぱいだ！</I></DIV>\n";
				&item_add(0, $eno);
			}
			
		}
		else {
			$log[$eno] .= '<DIV class="fail">' . "<I>それは所持していない！</I></DIV>\n";
			next;
		}
	}
	return 1;
}

# 送金

sub send_money {
	use utf8;
	my $order = shift;
	my $eno = shift;
	my $parts_data = \@parts_list;
	my $chara_data = \@chara_list;
	
	
	
	my @send = split(/：/, $order);
	for (my $i=0; $i<6; $i++){
		if($send[$i] eq "to"){next;}
		my ($money, $to) = split(/to/, $send[$i]);
		if ($money < 1){next;}
		if ($money > $chara_list[$eno][9]){
			$log[$eno] .= '<DIV class="fail">' . "資金が足りません</DIV>\n";
			next;
		}
		
		if ($to < 1){
			$log[$eno] .= '<DIV class="fail">' . "対象のキャラは存在しない</DIV>\n";
			next;
		}
		elsif ($to == $eno){
			$log[$eno] .= '<DIV class="fail">' . "自分には送金できません</DIV>\n";
			next;
		}
		
		my $name_to = $chara_list[$to][1];
		unless($name_to){
			$log[$eno] .= '<DIV class="fail">' . "対象のキャラは存在しない</DIV>\n";
			next;
		}
		
		#if ($money > 1000){
		#	$log[$eno] .= '<DIV class="fail">' . "振り込み詐欺防止のため送金が1000cに制限されました</DIV>\n";
		#	$money = 1000;
		#}
		
		my $name_c = $chara_list[$eno][2];
		$log[$eno] .= '<DIV class="postsuccess"><I>' . $name_c ."は" . $name_to ."に" . $money . "c送金した</I></DIV>\n";
		
		my $a = int($eno / 1000);
		my $b = $eno % 1000;
		my $c = int($b / 100);
		my $d = $b % 100;
		my $e = int($d / 10);
		my $f = $d % 10;
		
		$log_gift[$to] .=  '<A href="c' . "$a$c$e$f" . '.html">' . $name_c ."</A>から" . $money . "cが送金された</i><br>\n";
		&money($money, $to, "経費収入");
		$money *= -1;
		&money($money, $eno, "経費支出");
		
		
	}
	return 1;
}

# パーツ作製
sub partsbuild{
	use utf8;
	my $order = shift;
	my $order_messe = shift;
	my $eno = shift;
	
	# 仕様
	# アイテムA：アイテムB：種類：重量拡張：名前
	
	my @assem = split(/：/, $order, 5);
	my $parts_data = \@parts_list;
	my $chara_data = \@chara_list;
	my $parts_base = \@parts_palam_list;
	
	$assem[2] =~ s/\+BR\+//g;
	$assem[2] =~ s/\[物理\]//g;
	$assem[2] =~ s/\[粒子\]//g;
	$assem[2] =~ s/\[霊障\]//g;
	$assem[2] =~ s/\[電子\]//g;
	$assem[2] =~ s/\[火炎\]//g;
	
	# 名前なしの場合未入力
	unless($assem[4]){
		# $log[$eno] .= '<DIV class="fail">' . "作製しようとしたが名前がない</DIV>\n";
		return 0;
	}
	
	# アイテムAなしの場合失敗
	if ($assem[0] < 1){
		$log[$eno] .= '<DIV class="fail">' . "作製しようとしたがパーツAがない</DIV>\n";
		return 0;
	}
	
	if ($assem[0] >= $garage_max){
		$log[$eno] .= '<DIV class="fail">' . "作製しようとしたがパーツAが不正だ</DIV>\n";
		return 0;
	}
	
	
	# アイテムBなしの場合失敗
	if($assem[1] < 1){
		$log[$eno] .= '<DIV class="fail">' . "作製しようとしたがパーツBがない</DIV>\n";
		return 0;
	}
	
	if ($assem[1] >= $garage_max){
		$log[$eno] .= '<DIV class="fail">' . "作製しようとしたがパーツBが不正だ</DIV>\n";
		return 0;
	}
	
	
	
	# 名前一致でパーツIDを求める 
	my $p_id = &data_name($parts_base, $assem[2], 0);
	
	# IDなしの場合失敗
	unless($p_id){
		$log[$eno] .= '<DIV class="fail">' . "作製しようとしたが作製種類が不正だ</DIV>\n";
		return 0;
	}
	
	# my $del_a = $assem[0];
	# my $del_b = $assem[1];
	
	# アイテムABを所持座標から実在座標に変換させる
	$assem[0] = &item_id($assem[0], $eno);
	$assem[1] = &item_id($assem[1], $eno);
	
	my $equip_item = &data_o($parts_data, $assem[0], 28);
	if ( $equip_item > 0 ){
		$log[$eno] .= '<DIV class="fail">' . "対象のパーツAは装備中です</DIV>\n";
		return 0;
	}
	
	$equip_item = &data_o($parts_data, $assem[1], 28);
	if ( $equip_item > 0 ){
		$log[$eno] .= '<DIV class="fail">' . "対象のパーツBは装備中です</DIV>\n";
		return 0;
	}
	
	my $name_item_a = &data_o($parts_data, $assem[0], 1);
	unless ( $name_item_a ){
		$log[$eno] .= '<DIV class="fail">' . "対象のパーツAは存在しません</DIV>\n";
		return 0;
	}
	
	my $name_item_b = &data_o($parts_data, $assem[1], 1);
	unless ( $name_item_b ){
		$log[$eno] .= '<DIV class="fail">' . "対象のパーツBは存在しません</DIV>\n";
		return 0;
	}
	
	# アイテムABの合成によって強度を求める
	my $lv_a =  &data_o($parts_data, $assem[0], 20);
	my $lv_b =  &data_o($parts_data, $assem[1], 20);
	# my $lv = $lv_a + int($lv_b / 3);
	my $lv = int(($lv_a + $lv_b) / 2);
	
	# 付加継承。Aのみ継承
	my $fuka_a =  &data_o($parts_data, $assem[0], 29);
	my $fuka_b =  &data_o($parts_data, $assem[1], 29);
	
	# パーツリスト0番で新規アイテムを生成し、
	# 0番を指定の位置やカタログにコピーしていく
	
	&data_i($parts_data, 0, 20, $lv);
	&data_i($parts_data, 0, 29, $fuka_a);
	&data_i($parts_data, 0, 30, $fuka_b);
	&data_i($parts_data, 0, 27, $p_id);
	&data_i($parts_data, 0, 1, $assem[4]);
	&data_i($parts_data, 0, 31, $eno);
	&data_i($parts_data, 0, 32, $order_messe);
	&data_i($parts_data, 0, 33, $assem[3]);
	
	# ステータス移行
	for (my $menu=14;$menu<20;$menu++){
		my $abl = $chara_list[$eno][$menu];
		my $p_menu = $menu + 7;
		&data_i($parts_data, 0, $p_menu, $abl);
	}
	
	# アイテム消去
	&item_del($assem[0], $eno);
	&item_del($assem[1], $eno);
	
	# パラメータ適用
	&parts_palam(0);
	
	# ステ増加系付加の適用
	&parts_fuka(0, $fuka_a, $eno, 1);
	&parts_fuka(0, $fuka_b, $eno, 1);
	
	# アイテム追加
	my $value = &item_add(0, $eno);
	# カタログに追加
	&catalog_add;
	
	my $name = &data_o($parts_data, $value, 1);
	
	if ($name eq ""){$name += $value;}
	
	$log[$eno] .= '<DIV class="success"><I>' . $name_item_a . 'と' . $name_item_b . 'を素材にして' . $name . "を作製した！</I></DIV><BR>\n";
	
	# $get_gift[$eno][1] = $value;
	
	return 1;
	
}

# 初期パーツ作製
sub biginer_partsbuild{
	use utf8;
	my $order = shift;
	my $eno = shift;
	my $catalog_out = shift;
	
	# 仕様
	# 付加A：付加B：種類：重量拡張：名前
	
	my @assem = split(/：/, $order, 5);
	my $parts_data = \@parts_list;
	my $chara_data = \@chara_list;
	my $parts_base = \@parts_palam_list;
	
	$assem[2] =~ s/\+BR\+//g;
	$assem[2] =~ s/\[物理\]//g;
	$assem[2] =~ s/\[粒子\]//g;
	$assem[2] =~ s/\[霊障\]//g;
	$assem[2] =~ s/\[電子\]//g;
	$assem[2] =~ s/\[火炎\]//g;
	
	# 名前なしの場合失敗
	unless($assem[4]){
		$assem[4] .= "仮設";
		$assem[4] .= $assem[2];
		$assem[4] .= "-";
		$assem[4] .= $assem[3];
		# NP
		$chara_list[$eno][23] += 2;
		
	}
	
	# 名前一致でパーツIDを求める 
	my $p_id = &data_name($parts_base, $assem[2], 0);
	
	# IDなしの場合失敗
	unless($p_id){
		$log[$eno] .= '<DIV class="fail">' . "作製しようとしたが作製種類が不正だ</DIV>\n";
		return 0;
	}
	
	my $fuka_a = $assem[0];
	my $fuka_b = $assem[1];
	
	# パーツリスト0番で新規アイテムを生成し、
	# 0番を指定の位置やカタログにコピーしていく
	
	# 初期強度は20
	&data_i($parts_data, 0, 20, 20);
	&data_i($parts_data, 0, 29, $fuka_a);
	&data_i($parts_data, 0, 30, $fuka_b);
	&data_i($parts_data, 0, 27, $p_id);
	&data_i($parts_data, 0, 1, $assem[4]);
	&data_i($parts_data, 0, 31, $eno);
	&data_i($parts_data, 0, 32, $order_messe);
	&data_i($parts_data, 0, 33, $assem[3]);
	
	# ステータス移行
	for (my $menu=14;$menu<20;$menu++){
		my $abl = $chara_list[$eno][$menu];
		my $p_menu = $menu + 7;
		&data_i($parts_data, 0, $p_menu, $abl);
	}
	
	# パラメータ適用
	&parts_palam(0);
	
	# ステ増加系付加の適用
	&parts_fuka(0, $fuka_a, 1);
	&parts_fuka(0, $fuka_b, 1);
	
	# アイテム追加
	my $value = &item_add(0, $eno);
	
	my $name = &data_o($parts_data, $value, 1);
	
	if ($name eq ""){$name += $value;}
	
	$log[$eno] .= '<DIV class="success"><I>' . $name . "を作製した！</I></DIV><BR>\n";
	
	if ($catalog_out){&catalog_add;}
	
	return $value;
	
}

# 官製パーツ作製
sub official_partsbuild{
	use utf8;
	
	my $parts_data = \@parts_list;
	my $chara_data = \@chara_list;
	my $parts_base = \@parts_palam_list;
	
	my @assem = ( );
	my $base_num = @parts_palam_list;
	$base_num -= 1;
	my $op_num = @option_data_list;
	$op_num -= 1;
	
	my $base_id = 1;
	for (my $i=0; $i<1000;$i++){
		$base_id = int(rand $base_num);
		if ($parts_palam_list[$base_id][1] eq "名前"){next;}
		last;
	}
	
	my $base_name = $parts_palam_list[$base_id][1];
	
	# 名前一致でパーツIDを求める 
	my $p_id = &data_name($parts_base, $base_name, 0);
	
	my $get_op = int(rand $op_num);
	$get_op += 1;
	
	
	my $fuka = $option_data_list[$get_op][2];
	
	# パーツリスト0番で新規アイテムを生成し、
	# 0番を指定の位置やカタログにコピーしていく
	
	my $day = $game_data[0][2] + 2;	
	
	my $lv = $day * 5;
	my $weight = int(rand 10) + 5;
	my $name = "官製" . $fuka . $base_name . "-" . $weight;
	
	&data_i($parts_data, 0, 20, $lv);
	&data_i($parts_data, 0, 29, $fuka);
	&data_i($parts_data, 0, 30, "");
	&data_i($parts_data, 0, 27, $p_id);
	&data_i($parts_data, 0, 1, $name);
	&data_i($parts_data, 0, 31, 0);
	&data_i($parts_data, 0, 32, "");
	&data_i($parts_data, 0, 33, $weight);
	
	# ステータス移行
	for (my $menu=14;$menu<20;$menu++){
		my $abl = 100 + ($day * 5);
		my $p_menu = $menu + 7;
		&data_i($parts_data, 0, $p_menu, $abl);
	}
	
	# パラメータ適用
	&parts_palam(0);
	
	# ステ増加系付加の適用
	&parts_fuka(0, $fuka, 0);
	
	# アイテム追加
	&catalog_add;
	
	return 1;
	
}


# パーツ合成
sub partsmake {
	use utf8;
	my $order = shift;
	my $eno = shift;
	
	my @assem = split(/：/, $order);
	my $parts_data = \@parts_list;
	my $value = 0;
	
	for (my $i=0; $i<3; $i++){
		unless($assem[$i]){return 0;}
		my $item = $assem[$i];
		if ($item >= $garage_max || $item < 0){
			$log[$eno] .= '<DIV class="fail">' . "そのアイテムは存在しない</DIV>\n";
			return 0;
		}
		
		if ( $equip_list[$eno][$item] ){
			$log[$eno] .= '<DIV class="fail">' . "対象のパーツは装備中だ</DIV>\n";
			return 0;
		}
		
		my $p = ${$item_list[$eno]}[$item];
		
		if ($p <= 0){
			$log[$eno] .= '<DIV class="fail">' . "そのアイテムは存在しない</DIV>\n";
			return 0;
		}
		
		my $name = &data_o($parts_data, $p, 1);
		unless ($name){
			$log[$eno] .= '<DIV class="fail">' . "そのアイテムは存在しない</DIV>\n";
			return 0;
		}
		
	}
	
	for (my $i=0; $i<3; $i++){
		
		unless($assem[$i]){return 0;}
		
		my $item_p = $assem[$i];
		if($item_p < 1){return 0;}
		
		my $p = $item_list[$eno][$item_p];
		
		$value += &data_o($parts_data, $p, 17);
		
		
	}
	
	my $lost_name = "";
	
	for (my $i=0; $i<3; $i++){
		unless($assem[$i]){next;}
		my $item = $assem[$i];
		
		my $p = ${$item_list[$eno]}[$item];
		
		my $name = &data_o($parts_data, $p, 1);
		
		$item_list[$eno][$item] = -1;
		$equip_list[$eno][$item] = 0;
		$lost_name .= $name . "　";
	}
	
	# 成功判定
	my $skill = $chara_list[$eno][18];
	$skill -= 90;
	if ($skill > 100){$skill = 100;}
	
	my $border = int(rand 100);
	
	if($border > $skill){
		$log[$eno] .= '<DIV class="success"><I>合成は失敗し' . $lost_name . "は失われた[成功率：" . $skill . "％]<BR>\n";
		return 0;
	}
	
	$log[$eno] .= '<DIV class="success"><I>' . $lost_name . "を合成して";
	
	$value = int($value / 10);
	$value += 1700;
	
	my $name = &data_o($parts_data, $value, 1);
	
	if ($name eq ""){$name += $value;}
	
	$log[$eno] .= $name . "を作製した！[成功率：" . $skill . "％]</I></DIV><BR>\n";
	
	$get_gift[$eno][1] = $value;
	
	return 1;
	
}

sub str_leng {
	use utf8;
	
	my $str = shift;
	my $order_leng = shift;
	
	my $len = length($str);
	if ($len > $order_leng){
		$str = substr($str, 0, $order_leng);
	}
	
	return $str;
}

# パーツ改名
sub parts_rename{
	use utf8;
	my $order = shift;
	my $eno = shift;
	my $parts_data = \@parts_list;
	
	# 仕様
	# アイテム：名前
	my $str = $order;
	my $old_name = "がらくた";
	
	if ($order =~ /(.+?：)/){
		my $delto = $1;
		
		my $to = $1 + 0;
		
		# アイテムIDなしの場合失敗
		if ($to <= 0 || $to >= $garage_max){
			$log[$eno] .= '<DIV class="fail">' . "改名しようとしたがアイテムIDが不正だ</DIV>\n";
			return 0;
		}
		$str =~ s/$delto//;
		
		# 名前なしの場合失敗
		unless($str){
			$log[$eno] .= '<DIV class="fail">' . "改名しようとしたが名前がない</DIV>\n";
			return 0;
		}
		
		# アイテムIDを所持座標から実在座標に変換させる
		$to = &item_id($to, $eno);
		
		$old_name =  &data_o($parts_data, $to, 1);
		&data_i($parts_data, $to, 1, $str);
		
	}
	else{return 0;}
	
	$log[$eno] .= '<DIV class="success"><I>' . $old_name . "を" . $str . "に改名した！</I></DIV><BR>\n";
	
	return 1;
	
}


# 文章成型

sub tagdell {
	use utf8;
	my $str = shift;
	# $str =~ s/&/&amp;/mg;
	$str =~ s/</&lt;/mg;
	$str =~ s/>/&gt;/mg;
	$str =~ s/"/&quot;/mg;
	$str =~ s/'/&apos;/mg;
	$str =~ s/\+BR\+/<BR>/mg;
	return $str;
}


# 変更

sub change {
	use utf8;
	my $order = shift;
	my $eno = shift;
	my $chara_data = \@chara_list;
	
	my $type = substr($order, 0, 2);
	my $value = substr($order, 2);
	my $id = 0;
	my $len = 0;
	
	unless ($order) {return 0;}
	
	# 2文字指定
	if ($type eq "暗号"){
		$id = 20;
		$len = 30;
	}
	elsif ($type eq "経歴"){
		$value = &tagdell($value);
		$id = 5;
		$len = 1000;
	}
	elsif ($type eq "年齢"){
		$id = 3;
		$len = 30;
	}
	elsif ($type eq "性別"){
		$id = 4;
		$len = 30;
	}
	elsif ($type eq "愛称"){
		$id = 2;
		$len = 30;
	}
	else {
		my $type = substr($order, 0, 3);
		my $value = substr($order, 3);
	}
	
	# 3文字指定
	if ($type eq "プロフ絵"){
		$id = 6;
		$len = 1000;
	}
	elsif ($type eq "機体絵"){
		$id = 7;
		$len = 1000;
	}
	else {
		my $type = substr($order, 0, 4);
		my $value = substr($order, 4);
	}
	
	# 4文字指定
	if ($type eq "アイコン"){
		$id = 8;
		$len = 1000;
	}
	
	if ($id == 0){return -1;}
	
	my $a = length( $value );
	if ($len < $a){
		$value = substr($value, 0, $len);
	}
	
	$log[$eno] .= $type . "を変更しました<BR>\n";
	
	$chara_list[$eno][$id] = $value;
}


# 破棄
sub destroy {
	use utf8;
	my $order_list = shift;
	my $eno = shift;
	my $parts_data = \@parts_list;
	my $chara_data = \@chara_list;
	
	$log[$eno] = $log[$eno] . "パーツを処分した<BR>\n";
	
	my @order = split(/:/, $order_list);
	
	foreach my $i (@order){
		if ($order[i] >= $garage_max || $order[i] < 0){
			$log[$eno] = $log[$eno] . "そのアイテムは存在しない<BR>\n";
			next;
		}
		
		my $name = &data_o($parts_data, $order[i], 1);
		unless ($name){
			$log[$eno] = $log[$eno] . "そのアイテムは存在しない<BR>\n";
			next;
			}
		
		my $p = ${$item_list[$eno]}[$order[i]];
		
		if ($p >= 1000 || $p < 0){
			$log[$eno] = $log[$eno] . "そのアイテムは存在しない<BR>\n";
			next;
		}
		
		my $ans = &item_dell($p, $eno);
		if ($ans == 1){
			my $name_c = &data_o($chara_data, $eno, 2);
			$log[$eno] = $log[$eno] . '<FONT color="grey"><I>' . $name_c ."は" . $name ."を処分した！</I></FONT><BR>\n";
			
		}
		else {
			$log[$eno] = $log[$eno] . "<I>それは所持していない！</I><BR>\n";
			next;
		}
	}
	return 1;
}




1;

