# 戦闘メインループ


#  life_list
#  0…現在AP
#  1…MAXAP
#  2…【動作不良】…ダメージが減少
#  3…【制動障害】…機動力補正が低下しジャンプ確率が減少する
#  4…【出力低下】…ENが減少していく（NPCの場合ダメージ）
#  5…【索敵障害】…索敵失敗の確率増加
#  6…【旋回障害】…旋回確率が減少し旋回補正が低下する
#  7…【照準障害】…命中率が減少
#  8…【機体炎上】…APが減少していく
#  9…通信補正
# 10…物理耐性
# 11…粒子耐性
# 12…霊障耐性
# 13…電子耐性
# 14…火炎耐性
# 15…行動予約
# 16…現在EN
# 17…MAXEN
# 18…高度
# 19…行動補正
# 20…射撃補正
# 21…回避補正
# 22…撃墜者
# 23…エネルギーチャージ

sub battle_main {
	use utf8;
	my $eno = shift;
	my $battle_style = shift;
	
	if ($log_b[$eno]){return 0;}
	
	$mission_order = 1;
	my $mission_income = 0;
	my $mission_tell = 0;
	
	if ($battle_style == 1){
		# 対人戦
		@list = @{$man_matching[$eno]};
	} else{
		# 通常戦
		@list = @{$matching[$eno]};
	}
	
	
	my $dang = 1;
	my $man_matching = 0;
	
	if ($list[50] <= 0){
		$dang = $chara_list[$eno][22];
		my $ptm = $list[1];
		if($ptm <= 0){$ptm = 10033;}
		elsif ($ptm < 10000){
			my $dang_ptm = $chara_list[$ptm][22];
			if ($dang_ptm > 0 && $dang > 0){
				my $dice = int(rand 2);
				if($dice){$dang = $dang_ptm;}
			} elsif ($dang <= 0){
				$dang = $dang_ptm;
			}
		}
		
		if ($dang < 1 || $dang > 6){$dang = 1;}
		
		
		
		@list = @{$mission_list[$dang]};
		
		$mission_order = $list[1];
		$mission_income = $list[2];
		$mission_tell = $list[3];
		$mission_op = $list[4];
		$list[0] = $eno;
		$list[1] = $ptm;
		for (my $i=2; $i<50; $i++){
			$list[$i] = -1;
		}
		
		# サブクエ・NPCと出撃
		if ($ptm >= 10000){
			&quest($eno , "NPC出撃");
		}
	}
	else {
		$man_matching = 1;
		for (my $i=2; $i<50; $i++){
			$list[$i] = -1;
		}
		for (my $i=52; $i<100; $i++){
			$list[$i] = -1;
		}
		
		# サブクエ・NPCと出撃
		my $p_eno = $list[0];
		my $p_ptm = $list[1];
		if ($p_eno < 10000 && $p_ptm >= 10000){
			&quest($p_eno , "NPC出撃");
		}
		
		# 消滅チェック
		if($p_eno < 10000 && $chara_list[$p_eno][1] eq ""){$list[0] = 10000;}
		if($p_ptm < 10000 && $chara_list[$p_ptm][1] eq ""){$list[1] = 10000;}
		
		$p_eno = $list[50];
		$p_ptm = $list[51];
		if ($p_eno < 10000 && $p_ptm >= 10000){
			&quest($p_eno , "NPC出撃");
		}
		
		if($p_eno < 10000 && $chara_list[$p_eno][1] eq ""){$list[50] = 10000;}
		if($p_ptm < 10000 && $chara_list[$p_ptm][1] eq ""){$list[51] = 10000;}
		
	}
	
	# 増援
	my $ex_mem_a = 2;
	my $ex_mem_b = 52;
	
	# デート
	if ($battle_style == 0 && $event == 4){
		$list[$ex_mem_a] = 10053;
		$ex_mem_a++;
	}
	
	# 航空支援
	my $assi_value = $chara_st[$eno][9];
	my $ptm = $list[1];
	if($ptm < 10000){$assi_value += $chara_st[$ptm][9];}
	if ($battle_style == 1){$assi_value = 0;}
	for (my $assi=$ex_mem_a; $assi<50; $assi++){
		if($assi_value > 0){
			$list[$assi] = 10001;
		}
		else{last;}
		$assi_value -= 1;
		$ex_mem_a++;
	}
	$assi_value = 0;
	my $enemy = $list[50];
	if($enemy < 10000){$assi_value += $chara_st[$enemy][9];}
	my $enemy_ptm = $list[51];
	if($enemy_ptm < 10000){$assi_value += $chara_st[$enemy_ptm][9];}
	if ($battle_style == 1){$assi_value = 0;}
	for (my $assi=$ex_mem_b; $assi<100; $assi++){
		if($assi_value > 0){
			$list[$assi] = 10001;
		}
		else{last;}
		$assi_value -= 1;
		$ex_mem_b++;
	}
	
	# 培養支援
	$assi_value = 0;
	my $atk_side = $list[0];
	if($atk_side < 10000 && $machine[$atk_side][8] > 1){
		$assi_value += $chara_st[$atk_side][11];
	} elsif($atk_side < 10000 && $machine[$atk_side][8] <= 1 && $chara_st[$atk_side][11]){
		$log_b[$eno] .= '<div class="ecmeffect">' . "ENが枯渇してバイオ兵器を生産できない！！</DIV>\n";
	}
	my $ptm = $list[1];
	if($ptm < 10000 && $machine[$ptm][8] > 1){
		$assi_value += $chara_st[$ptm][11];
	} elsif($ptm < 10000 && $machine[$ptm][8] <= 1 && $chara_st[$ptm][11]){
		$log_b[$eno] .= '<div class="ecmeffect">' . "ENが枯渇してバイオ兵器を生産できない！！</DIV>\n";
	}
	if ($assi_value){$assi_value = int($assi_value / 15) + 1;}
	for (my $assi=$ex_mem_a; $assi<50; $assi++){
		if($assi_value > 0){
			$list[$assi] = 10041;
		}
		else{last;}
		$assi_value -= 1;
		$ex_mem_a++;
	}
	
	$assi_value = 0;
	my $enemy = $list[50];
	if($enemy < 10000 && $machine[$enemy][8] > 1){
		$assi_value += $chara_st[$enemy][11];
	} elsif($enemy < 10000 && $machine[$enemy][8] <= 1 && $chara_st[$enemy][11]){
		$log_b[$eno] .= '<div class="ecmeffect">' . "ENが枯渇してバイオ兵器を生産できない！！</DIV>\n";
	}
	my $enemy_ptm = $list[51];
	if($enemy_ptm < 10000 && $machine[$enemy_ptm][8] > 1){
		$assi_value += $chara_st[$enemy_ptm][11];
	} elsif($enemy_ptm < 10000 && $machine[$enemy_ptm][8] <= 1 && $chara_st[$enemy_ptm][11]){
		$log_b[$eno] .= '<div class="ecmeffect">' . "ENが枯渇してバイオ兵器を生産できない！！</DIV>\n";
	}
	if ($assi_value){$assi_value = int($assi_value / 15) + 1;}
	for (my $assi=$ex_mem_b; $assi<100; $assi++){
		if($assi_value > 0){
			$list[$assi] = 10041;
		}
		else{last;}
		$assi_value -= 1;
		$ex_mem_b++;
	}
	
	# 防衛支援
	$assi_value = 3;
	for (my $assi=$ex_mem_a; $assi<50; $assi++){
		unless ($mission_order == 4){last;}
		if($assi_value > 0){
			$list[$assi] = 10009;
		}
		else{last;}
		$assi_value -= 1;
		$ex_mem_a++;
	}
	# 目標破壊支援
	$assi_value = 3;
	for (my $assi=$ex_mem_a; $assi<50; $assi++){
		unless ($mission_order == 3){last;}
		if($assi_value > 0){
			$list[$assi] = 10005;
		}
		else{last;}
		$assi_value -= 1;
		$ex_mem_a++;
	}
	
	# バイオ支援
	#$assi_value = 3;
	#for (my $assi=$ex_mem_a; $assi<50; $assi++){
	#	unless ($event == 4){last;}
	#	my $baio = int(rand 5) + 10047;
	#	if($assi_value > 0){
	#		$list[$assi] = $baio;
	#	}
	#	else{last;}
	#	$assi_value -= 1;
	#	$ex_mem_a++;
	#}
	
	
	$log_b[$eno] .= '<br><table align="center" class="maintable">' . "<tr><td><CENTER><H1><I>戦闘モード　起動</I></H1></CENTER>\n<BR>\n<BR>\n";
	
	# ミッション説明
	
	if ($man_matching){
		$log_b[$eno] .="一般公開演習を行います<BR>\n";
		# $log_b[$eno] .="演習ですが倒せば報酬が支払われます<BR>\n";
	}
	else{
		$log_b[$eno] .="作戦内容：";
		if ($mission_order == 2){$log_b[$eno] .="データ回収";}
		elsif ($mission_order == 3){$log_b[$eno] .="目標破壊";}
		elsif ($mission_order == 4){$log_b[$eno] .="防衛";}
		elsif ($mission_order == 5){$log_b[$eno] .="破壊工作";}
		else {$log_b[$eno] .="殲滅";}
		$log_b[$eno] .="<BR>\n";
		
		$log_b[$eno] .="危険度　：";
		my $dang_count = $dang;
		while ($dang_count > 0){
			$log_b[$eno] .="★";
			$dang_count--;
		}
		$log_b[$eno] .="<BR>\n";
		
		&mission_word($eno, $mission_tell, $mission_order,  "作戦開始", $mission_op);
	}
	
	$log_b[$eno] .="<BR>\n";
	
	# 初期化
	# 機動行動力
	my @acp = (0x100);
	$acp[0] = 0;
	
	# 旋回行動力
	my @cacp = (0x100);
	$cacp[0] = 0;
	
	# 攻撃回数
	my @atk = (0x100);
	$atk[0] = 0;
	
	# 行動回数
	my @atk_turn = (0x100);
	$atk_turn[0] = 0;
	
	my @life_list = ( );
	my $team = 0;
	my $def_butu = 0;
	my $def_en = 0;
	my $def_ghost = 0;
	my $def_elec = 0;
	my $def_fire = 0;
	my $ap_stac = $dang * 1500 + 500;
	# 変動ステータスフォーマット。セリフ
	for (my $i=0; $i<100; $i++){
		if ($i == 50){$team = 0;}
		my $id = $list[$i];
		if ($id >= 10000){
			my $npc = $id - 10000;
			$def_butu = $enemy_list[$npc][20];
			$def_en = $enemy_list[$npc][21];
			$def_ghost = $enemy_list[$npc][22];
			$def_elec = $enemy_list[$npc][23];
			$def_fire = $enemy_list[$npc][24];
			my $boost = 0;
			my $ap = $enemy_list[$npc][3];
			my $en = $enemy_list[$npc][18];
			if($npc == 39){
				$ap = $ap_stac;
				$boost = 200 * $dang;
			}
			# if($team){$ap += 3000;}
			if($mission_order == 2 || $mission_order == 4 || $mission_order == 6){
				unless($team){
					$ap = int($ap * 1.5);
				}
			}
			
			my @ref_life = (0x21);
			$ref_life[0] = $ap;
			$ref_life[1] = $ap;
			
			$ref_life[16] = $en;
			$ref_life[17] = $en;
			
			$ref_life[10] = $def_butu + $boost;
			$ref_life[11] = $def_en + $boost;
			$ref_life[12] = $def_ghost + $boost;
			$ref_life[13] = $def_elec + $boost;
			$ref_life[14] = $def_fire + $boost;
			$life_list[$i] = \@ref_life;
		}
		else{
			$def_butu = $machine[$id][20];
			$def_en = $machine[$id][21];
			$def_ghost = $machine[$id][22];
			$def_elec = $machine[$id][23];
			$def_fire = $machine[$id][24];
			my @ref_life = (0x21);
			$ref_life[10] = $def_butu;
			$ref_life[11] = $def_en;
			$ref_life[12] = $def_ghost;
			$ref_life[13] = $def_elec;
			$ref_life[14] = $def_fire;
			$life_list[$i] = \@ref_life;
			$team++;
		}
		
		if ($id >= 0){
			&words("開始時", $id, $eno, $man_matching);
		}
		
	}
	my @death_list = ( );
	for (my $i=0; $i<100; $i++){
		$death_list[$i] = 0;
	}
	
	
	# 引き分けフラグ
	my $draw = 0;
	my $win = 0;
	my $end_turn = 0;
	
	# 戦闘ループ
	for (my $turn=0; $turn<31; $turn++){
		$end_turn = $turn;
		my $a = $turn % 5;
		if ($a == 0){
			$log_b[$eno] .= "</td></tr></table><br>\n";
			# ステータス
			my $ref_list = \@list;
			my $ref_life_list = \@life_list;
			my $alive = &lifelist($ref_list, $ref_life_list, $eno);
			if ($alive <= 0){
				$log_b[$eno] .= '<br><table align="center" class="maintable">' . "<tr><td>\n";
				$log_b[$eno] .= "<I>戦場に静けさが戻った……</I><BR>\n";
				$win = 1;
				last;
			}
			$log_b[$eno] .= '<br><table align="center" class="maintable">' . "<tr><td>\n";
			if($mission_order == 2){
				my $border = 50 * $dang;
				my $level = $border - $life_list[0][9];
				my $level2 = $border - $life_list[1][9];
				if($level > $level2){$level = $level2;}
				$log_b[$eno] .= "<I>目標通信レベルまで　残り（$level）</I><BR>\n";
				
			}
		}
		$log_b[$eno] .= "<I>第" . $turn . "ターン</I><BR>\n";
		
		
		
		# 作戦目標達成
		if ($mission_order == 2){
			# データ回収
			my $border = 50 * $dang;
			if ($life_list[0][9] >= $border || $life_list[1][9] >= $border){
				$log_b[$eno] .= "</td></tr></table><br>\n";
				$log_b[$eno] .= '<br><table align="center" class="maintable">' . "<tr><td>\n";
				$log_b[$eno] .= "<I>必要なデータを入手し作戦を成功させた！！</I><BR>\n";
				$win = 1;
				last;
			}
		}
		elsif ($mission_order == 3){
			# 目標破壊
			my $death = $death_list[50];
			if ($death){
				$log_b[$eno] .= "</td></tr></table><br>\n";
				$log_b[$eno] .= '<br><table align="center" class="maintable">' . "<tr><td>\n";
				$log_b[$eno] .= "<I>作戦目標を破壊し作戦を成功させた！！</I><BR>\n";
				$win = 1;
				last;
			}
		}
		elsif ($mission_order == 5){
			my $ref_list = \@list;
			my $ref_life_list = \@life_list;
			my $alive = &target_down($ref_list, $ref_life_list, $eno);
			unless ($alive){
				$log_b[$eno] .= "</td></tr></table><br>\n";
				$log_b[$eno] .= '<br><table align="center" class="maintable">' . "<tr><td>\n";
				$log_b[$eno] .= "<I>作戦目標を全て破壊し作戦を成功させた！！</I><BR>\n";
				$win = 1;
				last;
			}
		}
		
		if ($man_matching == 0){
			my $ref_list = \@list;
			my $ref_life_list = \@life_list;
			my $alive = &enemy_down($ref_list, $ref_life_list, $eno);
			unless ($alive){
				$log_b[$eno] .= "</td></tr></table><br>\n";
				$log_b[$eno] .= '<br><table align="center" class="maintable">' . "<tr><td>\n";
				$log_b[$eno] .= "<I>敵を全て破壊し作戦を成功させた！！</I><BR>\n";
				$win = 1;
				last;
			}
		}
		
		if ($turn >= 30){
			$draw = 1;
			$log_b[$eno] .= "<BR><I>両陣営は作戦領域を離脱した……</I><BR><BR>\n";
			if ($mission_order == 4){
				$log_b[$eno] .= "</td></tr></table><br>\n";
				$log_b[$eno] .= '<br><table align="center" class="maintable">' . "<tr><td>\n";
				$log_b[$eno] .= "<I>防衛作戦を成功させた！！</I><BR>\n";
				$win = 1;
			}
			else{$mission_income = 0;}
			last;
		}
		
		for (my $id=0; $id<100; $id++){
			
			my $target = &select_target($id, $ref_list, $ref_life_list);
			if($target <= -1){last;}
			
			my $atker = $list[$id];
			my $name;
			my $spd;
			my $circ;
			my $wheel;
			my $leg_type;
			
			if ($atker <= -1){
				next;
			}
			elsif ($atker >= 10000){
				my $ap = $life_list[$id][0];
				if ($ap <= 0){next;}
				my $npc = $atker - 10000;
				$name = $enemy_list[$npc][1];
				$spd = $enemy_list[$npc][5];
				$circ = $enemy_list[$npc][6];
				$wheel = $enemy_list[$npc][29];
			}
			else{
				my $ap = $machine[$atker][0];
				if ($ap <= 0){next;}
				$name = $chara_list[$atker][2];
				$spd = $machine[$atker][5];
				$spd += $chara_list[$atker][17];
				$circ = $machine[$atker][6];
				$wheel = $machine[$atker][26];
				$leg_type = $machine[$atker][27];
			}
			
			# カウンター減衰
			
			for (my $i=2; $i<9; $i++){
				my $lev = $life_list[$id][$i];
				if($lev > 0){
					$life_list[$id][$i] -= 1;
				}
			}
			
			#my $lev = $life_list[$id][9];
			#if($lev > 0){
			#	$life_list[$id][9] = int($lev * 0.9);
			#}
			
			my $lev = $life_list[$id][18];
			if($lev > 0){
				$life_list[$id][18] = int($lev * 0.3);
			}
			
			$lev = $life_list[$id][21];
			if($lev != 0){
				$life_list[$id][21] = int($lev * 0.9);
			}
			
			# AP回復/炎上
			if ($atker < 10000){
				my $sup = $op_list[$atker][3];
				# $sup = int($sup * 0.5);
				my $dmg = 0;
				#lev = 炎上
				my $lev = $life_list[$id][8];
				if ($lev > 0){
					my $loss = 3 + $lev / 10;
					my $ap = $machine[$atker][1];
					$dmg += 50 + int($ap * $loss / 100);
					
					my $dmg_less = $life_list[$id][14];
					if ($dmg_less){
						if ($dmg_less > 700){
							$dmg_less -= 700;
							$dmg_less /= 3;
							$dmg_less += 700;
						}
						$dmg_less /= 1500;
						$dmg -= int($dmg * $dmg_less);
					}
					$dmg *= -1;
					if ($dmg > 0){$dmg = 0;}
					$log_b[$eno] .= '<div class="ecmeffect">' . $name . "は炎上している！！（" . $dmg . "）</div><BR>\n";
				}
				$sup += $dmg;
				if ($sup != 0){&ap_sup($atker, $sup, $eno);}
			} else{
				my $dmg = 0;
				my $lev = $life_list[$id][8];
				if ($lev > 0){
					my $loss = 3 + $lev / 10;
					my $ap = $life_list[$id][1];
					$dmg += 50 + int($ap * $loss / 100);
					my $dmg_less = $life_list[$id][14];
					if ($dmg_less){
						if ($dmg_less > 700){
							$dmg_less -= 700;
							$dmg_less /= 3;
							$dmg_less += 700;
						}
						$dmg_less /= 1500;
						$dmg -= int($dmg * $dmg_less);
					}
					$dmg *= -1;
					if ($dmg > 0){$dmg = 0;}
					$log_b[$eno] .= '<div class="ecmeffect">' . $name . "は炎上している！！（" . $dmg . "）</div><BR>\n";
				}
				$life_list[$id][0] += $dmg;
			}
			
			# EN回復/出力低下
			if ($atker < 10000){
				my $sup = $machine[$atker][8];
				my $en = $machine[$atker][3];
				my $dmg = 0;
				my $lev = $life_list[$id][4];
				if ($lev > 0){
					my $loss = 20 + $lev / 10;
					$dmg += 10 + int($en * $loss / 100);
					my $dmg_less = $life_list[$id][11];
					if ($dmg_less){
						if ($dmg_less > 700){
							$dmg_less -= 700;
							$dmg_less /= 3;
							$dmg_less += 700;
						}
						$dmg_less /= 1000;
						$dmg -= int($dmg * $dmg_less);
					}
					$dmg *= -1;
					if ($dmg > 0){$dmg = 0;}
					$log_b[$eno] .= '<div class="ecmeffect">' . $name . "は出力低下している！！（" . $dmg . "）</div><BR>\n";
				}
				$sup += $dmg;
				if ($sup != 0){&en_sup($atker, $sup);}
			} else{
				my $npc = $atker - 10000;
				my $sup = $enemy_list[$npc][8];
				my $en = $life_list[$id][17];
				my $dmg = 0;
				my $lev = $life_list[$id][4];
				if ($lev > 0){
					my $loss = 20 + $lev / 10;
					$dmg += 10 + int($en * $loss / 100);
					my $dmg_less = $life_list[$id][11];
					if ($dmg_less){
						if ($dmg_less > 700){
							$dmg_less -= 700;
							$dmg_less /= 3;
							$dmg_less += 700;
						}
						$dmg_less /= 1000;
						$dmg -= int($dmg * $dmg_less);
					}
					$dmg *= -1;
					if ($dmg > 0){$dmg = 0;}
					$log_b[$eno] .= '<div class="ecmeffect">' . $name . "は出力低下している！！（" . $dmg . "）</div><BR>\n";
				}
				$sup += $dmg;
				my $ref_life_list = \@life_list;
				if ($sup != 0){&en_sup_npc($id, $sup, $ref_life_list);}
			}
			
			# 高度上昇
			if ($atker < 10000 && $machine[$atker][8] > 1){
				my $high = $machine[$atker][25];
				# if($high){$high = int( $high / 10 ) + 1}
				$life_list[$id][18] += $high;
			} elsif($atker >= 10000){
				my $npc = $atker - 10000;
				my $high = $enemy_list[$npc][28];
				$life_list[$id][18] += $high;
			}
			
			# 高度限界
			if ($life_list[$id][18] > 400){$life_list[$id][18] = 400;}
			
			# 補給支援
			if ($atker < 10000 && $battle_style == 0){
				my $assi = $chara_st[$atker][10];
				my $ap = int($machine[$atker][0] / $machine[$atker][1] * 100);
				if ($assi > 0 && $ap < 30){
					$log_b[$eno] .= '<div class="goodeffect">' . $name . "は補給を受けAPとENを回復した</div><BR>\n";
					my $sup_ap = int($machine[$atker][1] * 0.3);
					&ap_sup($atker, $sup_ap, $eno);
					$machine[$atker][2] = $machine[$atker][3];
					$chara_st[$atker][10] -= 1;
				}
			}
			
			# 援護行動
			if ($atker < 10000){
				my $ap_my = $machine[$atker][0];
				my $ap_ptm = 0;
				my $id_ptm = $id;
				
				if ($id == 0){$id_ptm = 1;}
				elsif ($id == 1){$id_ptm = 0;}
				elsif ($id == 50){$id_ptm = 51;}
				elsif ($id == 51){$id_ptm = 50;}
				
				my $ptm = $list[$id_ptm];
				$name_ptm = "僚機";
				if ($ptm < 10000){
					$ap_ptm = $machine[$ptm][0];
					$name_ptm = $chara_list[$ptm][2];
				}
				else{
					$ap_ptm = $life_list[$id_ptm][1];
				}
				my $dice = 0;
				my $dice_2 = 0;
				if ($ap_ptm > 0 && $life_list[$id][21] > -100){
					# APの差が多いほど確率が上がる
					my $border = $ap_my - $ap_ptm;
					if ($border > 5000){
						$dice = 80;
					}
					elsif ($border > 4000){
						$dice = 60;
					}
					elsif ($border > 3000){
						$dice = 40;
					}
					elsif ($border > 2000){
						$dice = 20;
					}
					elsif ($border > 1000){
						$dice = 10;
					}
					$dice_2 = int(rand 100);
				}
				if ($dice > $dice_2){
					&words("援護行動", $atker, $eno, $man_matching);
					$log_b[$eno] .= '<div class="goodeffect">' . $name . "は" . $name_ptm .  "の援護に回った！</div><BR>\n";
					$life_list[$id][21] -= 20;
					$life_list[$id_ptm][21] += 40;
					if ($man_matching == 0){
						&quest($atker , "僚機援護");
					}
				}
			}
			
			# 旋回
			my $border = 60;
			if($atker < 10000){
				$border -= $op_list[$atker][1] * 10;
			}
			
			# 旋回障害
			if ($life_list[$id][6] > 0){
				my $loss = 15 + $life_list[$id][6] / 5;
				$border += $loss;
				$circ -= int($circ * $loss / 100);
			}
			
			# タンクは旋回頻度が高い
			if ($leg_type eq "タンク"){
				$border -= 20;
			}
			
			if($border < 20){$border = 20;}
			my $dice = int(rand $border);
			if($dice < 10){
				&words("旋回", $atker, $eno, $man_matching);
				$log_b[$eno] .= '<div class="goodeffect">' . $name . "は旋回して敵を迎え撃つ！！</div><BR>\n";
				$spd += $circ;
				$circ += $circ;
			}
			
			# ホイールチャージ
			$border = 120;
			$border -= int($wheel / 50);
			if($border < 20){$border = 20;}
			$dice = int(rand $border);
			if($dice < 10 && $wheel > 0){
				# &words("旋回", $atker, $eno, $man_matching);
				$log_b[$eno] .= '<div class="goodeffect">ホイールチャージ！！　' . $name . "は車輪を高速回転させ突撃する！！</div><BR>\n";
				$spd += $wheel;
			}
			
			# 制動障害
			if ($life_list[$id][3] > 0){
				my $loss = 10 + $life_list[$id][3] / 10;
				$spd -= ($spd * $loss / 100);
			}
			
			# 行動補正
			if ($life_list[$id][19] != 0){
				$spd += $life_list[$id][19];
				$life_list[$id][19] = 0;
			}
			
			if ($spd < 100){$spd = 100;}
			if ($circ < 100){$circ = 100;}
			
			$spd = int((sqrt $spd)*30);
			$circ = int((sqrt $circ)*30);
			
			$acp[$id] += $spd;
			
			$cacp[$id] += $circ;
			
		}
		
		
		for (my $i=0; $i<100; $i++){
			
			my $max = 0;
			my $id = 0;
			
			for (my $ii=0; $ii<100; $ii++){
				my $a_id = $list[$ii];
				
				if ($a_id <= -1){next;}
				
				my $b_acp = $acp[$ii];
				
				if ($max < $b_acp){
					$max = $b_acp;
					$id = $ii;
				}
			}
			
			
			my $atker = $list[$id];
			my $name;
			my $spd;
			my $circ;
			
			if ($atker <= -1){
				next;
			}
			elsif ($atker >= 10000){
				my $ap = $life_list[$id][0];
				if ($ap <= 0){next;}
			}
			else{
				my $ap = $machine[$atker][0];
				if ($ap <= 0){next;}
			}
			
			# 機動による攻撃行動
			if($acp[$id] >= 3000){
				$atk[$id] += 1;
				$atk_turn[$id] += 1;
				$acp[$id] %= 3000;
				$cacp[$id] %= 3000;
				
				my $ref_life_list = \@life_list;
				my $t = $atk_turn[$id];
				$life_list[$id][15] = &atk_menu($atker, $t, $ref_life_list);
				
				my $ref_list = \@list;
				$ref_life_list = \@life_list;
				
				my $result = &attack($id, $ref_list , $eno, $ref_life_list , $man_matching);
				if ($result <= -1){last;}
				
				$log_b[$eno] .= "<BR>\n";
				
				
			}
			
			for (my $ii=0; $ii<100; $ii++){
				my $a_id = $list[$ii];
				
				if ($a_id <= -1){next;}
				
				my $b_acp = $cacp[$ii];
				
				if ($max < $b_acp){
					$max = $b_acp;
					$id = $ii;
				}
			}
			
			
			my $atker = $list[$id];
			my $name;
			my $spd;
			my $circ;
			
			if ($atker <= -1){
				next;
			}
			elsif ($atker >= 10000){
				my $ap = $life_list[$id][0];
				if ($ap <= 0){next;}
			}
			else{
				my $ap = $machine[$atker][0];
				if ($ap <= 0){next;}
			}
			
			# 旋回による攻撃行動
			if($cacp[$id] >= 3000){
				$atk[$id] += 1;
				$atk_turn[$id] += 1;
				$acp[$id] %= 3000;
				$cacp[$id] %= 3000;
				
				my $ref_life_list = \@life_list;
				my $t = $atk_turn[$id];
				$life_list[$id][15] = &atk_menu($atker, $t, $ref_life_list);
				
				my $ref_list = \@list;
				$ref_life_list = \@life_list;
				
				my $result = &attack($id, $ref_list , $eno, $ref_life_list , $man_matching);
				if ($result <= -1){last;}
				
				$log_b[$eno] .= "<BR>\n";
				
				
			}
			
			
		}
		
		
		for (my $id=0; $id<100; $id++){
			
			my $target = &select_target($id, $ref_list, $ref_life_list);
			if($target <= -1){last;}
			
			my $atker = $list[$id];
			my $name;
			my $spd;
			my $circ;
			
			if ($atker <= -1){
				next;
			}
			elsif ($atker >= 10000){
				my $ap = $life_list[$id][0];
				if ($ap <= 0){next;}
			}
			else{
				my $ap = $machine[$atker][0];
				if ($ap <= 0){next;}
			}
			
			my $a = $turn % 5;
			if ($a == 4){
				if ($atk[$id] < 1){
					$atk_turn[$id] += 1;
					my $ref_life_list = \@life_list;
					my $t = $atk_turn[$id];
					$life_list[$id][15] = &atk_menu($atker, $t, $ref_life_list);
					
					my $ref_list = \@list;
					$ref_life_list = \@life_list;
					
					my $result = &attack($id, $ref_list , $eno, $ref_life_list , $man_matching);
					if ($result <= -1){last;}
					
					$log_b[$eno] .= "<BR>\n";
				}
				$atk[$id] = 0;
			}
			
		}
		$ref_list = \@list;
		$ref_life_list = \@life_list;
		$ref_death_list = \@death_list;
		@death_list = &death_ck($eno, $ref_list, $ref_life_list, $ref_death_list);
		
	}
	
	# 報酬算出。生還セリフ
	
	my $money = 0;
	my $e_money = 0;
	my $honor = 0;
	my $e_honor = 0;
	my $exp = 0;
	my $e_exp = 0;
	my $down = 0;
	my $e_down = 0;
	my $loser = 0;
	my $e_loser = 0;
	my @gift_list = ( );
	
	# 自軍生存？
	my $p_alive = 0;
	for(my $i=0; $i<50; $i++){
		if ($list[$i] >= 10000){
			# NPC
			my $t_npc = $list[$i];
			my $enpc = $list[$i] - 10000;
			
			my $ap = $life_list[$i][0];
			if ($ap > 0){
				$p_alive++;
			}
		}
		elsif ($list[$i] >= 0){
			# プレイヤー
			my $e_eno = $list[$i];
			my $ap = $machine[$e_eno][0];
			if($battle_style == 0){
				&money($ap, $e_eno, "AP記憶");
			}
			if ($ap > 0){
				$p_alive++;
				# サブクエ・対人生存
				if ($battle_style == 1){
					&quest($e_eno , "対人生存");
				}
			}
		}
	}
	
	# サブクエ・対人勝利
	if ($battle_style == 1 && $win == 1 && $p_alive){
		my $main_eno = $list[0];
		if ($main_eno < 10000){
			&quest($main_eno , "対人勝利");
		}
		my $ptm = $list[1];
		if ($ptm < 10000){
			&quest($ptm , "対人勝利");
		}
	}
	
	# サブクエ・15ターン以内
	if ($end_turn <= 15 && $win == 1 && $p_alive){
		my $main_eno = $list[0];
		if ($main_eno < 10000){
			&quest($main_eno , "15ターン");
		}
		my $ptm = $list[1];
		if ($ptm < 10000){
			&quest($ptm , "15ターン");
		}
	}
	
	# 敵軍生存？
	my $e_alive = 0;
	for(my $i=50; $i<100; $i++){
		if ($list[$i] >= 10000){
			# NPC
			my $t_npc = $list[$i];
			my $enpc = $list[$i] - 10000;
			
			my $ap = $life_list[$i][0];
			if ($ap > 0){
				$e_alive++;
			}
		}
		elsif ($list[$i] >= 0){
			# プレイヤー
			my $e_eno = $list[$i];
			my $ap = $machine[$e_eno][0];
			if ($ap > 0){
				$e_alive++;
				# サブクエ・対人生存
				if ($battle_style == 1){
					&quest($e_eno , "対人生存");
				}
			}
		}
	}
	
	# 敵サブクエ・対人勝利
	if ($battle_style == 1 && $win == 1 && $e_alive){
		my $main_eno = $list[50];
		if ($main_eno < 10000){
			&quest($main_eno , "対人勝利");
		}
		my $ptm = $list[51];
		if ($ptm < 10000){
			&quest($ptm , "対人勝利");
		}
	}
	
	# 敵サブクエ・15ターン以内
	if ($battle_style == 1 && $end_turn <= 15 && $win == 1 && $e_alive){
		my $main_eno = $list[50];
		if ($main_eno < 10000){
			&quest($main_eno , "15ターン");
		}
		my $ptm = $list[51];
		if ($ptm < 10000){
			&quest($ptm , "15ターン");
		}
	}
	
	
	# 対人免除
	# my $man_matching = 0;
	# my $chara = $list[50];
	# if($chara < 10000){$man_matching = 1;}
	
	for (my $i=0; $i<100; $i++){
		my $chara = $list[$i];
		my $death = $death_list[$i];
		if ($chara >= 10000 && $death == 1 && $i < 50){
			my $npc = $chara - 10000;
			my $get = $enemy_list[$npc][25];
			$e_honor += int($get / 200);
			$e_money += $get;
			$e_exp += int($get / 70);
			$e_down += 1;
			my $killer = $life_list[$i][22];
			if ($killer < 10000 && $battle_style == 0){$chara_st[$killer][5] += 1;}
		}
		elsif ($chara >= 10000 && $death == 1 && $i >= 50){
			my $npc = $chara - 10000;
			my $get = $enemy_list[$npc][25];
			$honor += int($get / 200);
			my $fire = $enemy_list[$npc][2];
			$gift_list[$i] = $fire;
			$money += $get;
			$exp += int($get / 70);
			$down += 1;
			my $killer = $life_list[$i][22];
			if ($killer < 10000 && $battle_style == 0){$chara_st[$killer][5] += 1;}
		}
		elsif ($chara >= 0 && $death == 1 && $i < 50){
			my $honor_bounus = $chara_list[$chara][13];
			$e_honor += 10 + int($honor_bounus / 8);
			$e_money += ($honor_bounus * 15) + 2500;
			$e_exp += 30 + int($honor_bounus / 9);
			$e_down += 1;
			my $killer = $life_list[$i][22];
			if ($killer < 10000 && $battle_style == 0){$chara_st[$killer][5] += 1;}
		}
		elsif ($chara >= 0 && $death == 1 && $i >= 50){
			my $honor_bounus = $chara_list[$chara][13];
			$honor += 10 + int($honor_bounus / 8);
			$money += ($honor_bounus * 15) + 2500;
			$exp += 30 + int($honor_bounus / 9);
			$down += 1;
			my $killer = $life_list[$i][22];
			if ($killer < 10000 && $battle_style == 0){$chara_st[$killer][5] += 1;}
		}
		elsif ($chara >= 0 && $death == 0 && $draw == 0){
			if ($chara < 10000){
				&words("終了時", $chara, $eno, $man_matching);
			}
			elsif ($win == 0){
				&words("終了時", $chara, $eno, $man_matching);
			}
			if($i < 50){$e_loser++;}
			else{$loser++;}
		}
		elsif($chara >= 0 && $death == 0 && $draw == 1){
			if($i < 50){$e_loser++;}
			else{$loser++;}
		}
	}
	
	$log_b[$eno] .= "</td></tr></table><br>\n";
	
	if ($battle_style == 1){
		$exp = 0;
		$e_exp = 0;
	}
	
	my $gift = 0;
	
	# ドロップ
	for(my $i=50; $i<100; $i++){
		if($gift_list[$i]>1000){$gift = $gift_list[$i];}
	}
	
	
	
	# ミッション減額
	if ($mission_order == 2 || $mission_order == 4){
		$honor = int($honor / 10);
		$money = int($money / 10);
		$exp = int($exp / 10);
	}elsif ($mission_order == 5){
		$honor = int($honor / 2);
		$money = int($money / 2);
		$exp = int($exp / 2);
	}
	
	
	# ミッション報酬
	if($mission_order > 1 && $win == 1 && $p_alive){
		my $get = $mission_income;
		$honor += int($get / 200);
		$money += $get;
		$exp += int($get / 70);
		
	}
	
	# 清算・ログ共有
	
	my $str = $log_b[$eno];
	
	
	
	for(my $i=0; $i<100; $i++){
		my $chara = $list[$i];
		if ($chara >= 0 && $chara < 10000 && $i < 50){
			# $chara_st[$chara][5] += $down;
			# $get_gift[$chara][0] = $gift;
			
			if($battle_style == 1){
				&money(0, $chara, "整備免除");
			} else{
				$chara_st[$chara][4] += $honor;
				$chara_st[$chara][6] += $exp;
				&money($money, $chara, "戦闘収入");
			}
			$log_b[$chara] = $str;
			$log[$chara] .= $str;
		}
		elsif ($chara >= 0 && $chara < 10000 && $i >= 50){
			
			# $chara_st[$chara][5] += $e_down;
			
			if($battle_style == 1){
				&money(0, $chara, "整備免除");
			} else{
				$chara_st[$chara][4] += $e_honor;
				$chara_st[$chara][6] += $e_exp;
				&money($e_money, $chara, "戦闘収入");
			}
			$log_b[$chara] = $str;
			$log[$chara] .= $str;
		}
	}
	
	
	return 1;
}






































1;

